/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.field.SalesInquiryItemPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.link.SalesInquiryItemPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.selectable.SalesInquiryItemPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesInquiryItemPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesInquiryItemPartner extends VdmEntity<SalesInquiryItemPartner>
{

    /**
     * Selector for all available fields of SalesInquiryItemPartner.
     *
     */
    public final static SalesInquiryItemPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiry</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @Key
    @SerializedName( "SalesInquiry" )
    @JsonProperty( "SalesInquiry" )
    @Nullable
    @ODataField( odataName = "SalesInquiry" )
    private String salesInquiry;
    /**
     * Use with available fluent helpers to apply the <b>SalesInquiry</b> field to query operations.
     *
     */
    public final static SalesInquiryItemPartnerField<String> SALES_INQUIRY =
        new SalesInquiryItemPartnerField<String>("SalesInquiry");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiryItem</b>
     * </p>
     *
     * @return Item number of the SD document
     */
    @Key
    @SerializedName( "SalesInquiryItem" )
    @JsonProperty( "SalesInquiryItem" )
    @Nullable
    @ODataField( odataName = "SalesInquiryItem" )
    private String salesInquiryItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesInquiryItem</b> field to query operations.
     *
     */
    public final static SalesInquiryItemPartnerField<String> SALES_INQUIRY_ITEM =
        new SalesInquiryItemPartnerField<String>("SalesInquiryItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static SalesInquiryItemPartnerField<String> PARTNER_FUNCTION =
        new SalesInquiryItemPartnerField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static SalesInquiryItemPartnerField<String> CUSTOMER =
        new SalesInquiryItemPartnerField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SalesInquiryItemPartnerField<String> SUPPLIER =
        new SalesInquiryItemPartnerField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static SalesInquiryItemPartnerField<String> PERSONNEL =
        new SalesInquiryItemPartnerField<String>("Personnel");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Number of Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static SalesInquiryItemPartnerField<String> CONTACT_PERSON =
        new SalesInquiryItemPartnerField<String>("ContactPerson");
    /**
     * Navigation property <b>to_SalesInquiry</b> for <b>SalesInquiryItemPartner</b> to single <b>SalesInquiry</b>.
     *
     */
    @SerializedName( "to_SalesInquiry" )
    @JsonProperty( "to_SalesInquiry" )
    @ODataField( odataName = "to_SalesInquiry" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesInquiry toSalesInquiry;
    /**
     * Navigation property <b>to_SalesInquiryItem</b> for <b>SalesInquiryItemPartner</b> to single
     * <b>SalesInquiryItem</b>.
     *
     */
    @SerializedName( "to_SalesInquiryItem" )
    @JsonProperty( "to_SalesInquiryItem" )
    @ODataField( odataName = "to_SalesInquiryItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesInquiryItem toSalesInquiryItem;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesInquiry</b> navigation property to query operations.
     *
     */
    public final static SalesInquiryItemPartnerOneToOneLink<SalesInquiry> TO_SALES_INQUIRY =
        new SalesInquiryItemPartnerOneToOneLink<SalesInquiry>("to_SalesInquiry");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesInquiryItem</b> navigation property to query
     * operations.
     *
     */
    public final static SalesInquiryItemPartnerOneToOneLink<SalesInquiryItem> TO_SALES_INQUIRY_ITEM =
        new SalesInquiryItemPartnerOneToOneLink<SalesInquiryItem>("to_SalesInquiryItem");

    @Nonnull
    @Override
    public Class<SalesInquiryItemPartner> getType()
    {
        return SalesInquiryItemPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiry</b>
     * </p>
     *
     * @param salesInquiry
     *            Sales and Distribution Document Number
     */
    public void setSalesInquiry( @Nullable final String salesInquiry )
    {
        rememberChangedField("SalesInquiry", this.salesInquiry);
        this.salesInquiry = salesInquiry;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesInquiryItem</b>
     * </p>
     *
     * @param salesInquiryItem
     *            Item number of the SD document
     */
    public void setSalesInquiryItem( @Nullable final String salesInquiryItem )
    {
        rememberChangedField("SalesInquiryItem", this.salesInquiryItem);
        this.salesInquiryItem = salesInquiryItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel Number
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Number of Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesInquiryItemPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesInquiry", getSalesInquiry());
        result.put("SalesInquiryItem", getSalesInquiryItem());
        result.put("PartnerFunction", getPartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesInquiry", getSalesInquiry());
        values.put("SalesInquiryItem", getSalesInquiryItem());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("Customer", getCustomer());
        values.put("Supplier", getSupplier());
        values.put("Personnel", getPersonnel());
        values.put("ContactPerson", getContactPerson());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesInquiry") ) {
                final Object value = values.remove("SalesInquiry");
                if( (value == null) || (!value.equals(getSalesInquiry())) ) {
                    setSalesInquiry(((String) value));
                }
            }
            if( values.containsKey("SalesInquiryItem") ) {
                final Object value = values.remove("SalesInquiryItem");
                if( (value == null) || (!value.equals(getSalesInquiryItem())) ) {
                    setSalesInquiryItem(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesInquiry") ) {
                final Object value = (values).remove("to_SalesInquiry");
                if( value instanceof Map ) {
                    if( toSalesInquiry == null ) {
                        toSalesInquiry = new SalesInquiry();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesInquiry.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesInquiryItem") ) {
                final Object value = (values).remove("to_SalesInquiryItem");
                if( value instanceof Map ) {
                    if( toSalesInquiryItem == null ) {
                        toSalesInquiryItem = new SalesInquiryItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesInquiryItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesInquiryItemPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesInquiryItemPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesInquiryItemPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesInquiryItemPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesInquiryService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesInquiry != null ) {
            (values).put("to_SalesInquiry", toSalesInquiry);
        }
        if( toSalesInquiryItem != null ) {
            (values).put("to_SalesInquiryItem", toSalesInquiryItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesInquiry</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesInquiry</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesInquiry</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesInquiry fetchSalesInquiry()
    {
        return fetchFieldAsSingle("to_SalesInquiry", SalesInquiry.class);
    }

    /**
     * Retrieval of associated <b>SalesInquiry</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesInquiry</b>.
     * <p>
     * If the navigation property <b>to_SalesInquiry</b> of a queried <b>SalesInquiryItemPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesInquiry</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesInquiry getSalesInquiryOrFetch()
    {
        if( toSalesInquiry == null ) {
            toSalesInquiry = fetchSalesInquiry();
        }
        return toSalesInquiry;
    }

    /**
     * Retrieval of associated <b>SalesInquiry</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesInquiry</b>.
     * <p>
     * If the navigation property for an entity <b>SalesInquiryItemPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesInquiry</b> is already loaded, the result will
     *         contain the <b>SalesInquiry</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesInquiry> getSalesInquiryIfPresent()
    {
        return Option.of(toSalesInquiry);
    }

    /**
     * Overwrites the associated <b>SalesInquiry</b> entity for the loaded navigation property <b>to_SalesInquiry</b>.
     *
     * @param value
     *            New <b>SalesInquiry</b> entity.
     */
    public void setSalesInquiry( final SalesInquiry value )
    {
        toSalesInquiry = value;
    }

    /**
     * Fetches the <b>SalesInquiryItem</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesInquiryItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesInquiryItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesInquiryItem fetchSalesInquiryItem()
    {
        return fetchFieldAsSingle("to_SalesInquiryItem", SalesInquiryItem.class);
    }

    /**
     * Retrieval of associated <b>SalesInquiryItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesInquiryItem</b>.
     * <p>
     * If the navigation property <b>to_SalesInquiryItem</b> of a queried <b>SalesInquiryItemPartner</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesInquiryItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesInquiryItem getSalesInquiryItemOrFetch()
    {
        if( toSalesInquiryItem == null ) {
            toSalesInquiryItem = fetchSalesInquiryItem();
        }
        return toSalesInquiryItem;
    }

    /**
     * Retrieval of associated <b>SalesInquiryItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesInquiryItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesInquiryItemPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesInquiryItem</b> is already loaded, the result will
     *         contain the <b>SalesInquiryItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesInquiryItem> getSalesInquiryItemIfPresent()
    {
        return Option.of(toSalesInquiryItem);
    }

    /**
     * Overwrites the associated <b>SalesInquiryItem</b> entity for the loaded navigation property
     * <b>to_SalesInquiryItem</b>.
     *
     * @param value
     *            New <b>SalesInquiryItem</b> entity.
     */
    public void setSalesInquiryItem( final SalesInquiryItem value )
    {
        toSalesInquiryItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesInquiryItemPartner instances.
     *
     */
    public final static class SalesInquiryItemPartnerBuilder
    {

        private SalesInquiry toSalesInquiry;
        private String salesInquiry = null;
        private SalesInquiryItem toSalesInquiryItem;
        private String salesInquiryItem = null;

        private SalesInquiryItemPartner.SalesInquiryItemPartnerBuilder toSalesInquiry( final SalesInquiry value )
        {
            toSalesInquiry = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesInquiry</b> for <b>SalesInquiryItemPartner</b> to single <b>SalesInquiry</b>.
         *
         * @param value
         *            The SalesInquiry to build this SalesInquiryItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesInquiryItemPartner.SalesInquiryItemPartnerBuilder salesInquiry( final SalesInquiry value )
        {
            return toSalesInquiry(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesInquiry</b>
         * </p>
         *
         * @param value
         *            The salesInquiry to build this SalesInquiryItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesInquiryItemPartner.SalesInquiryItemPartnerBuilder salesInquiry( final String value )
        {
            salesInquiry = value;
            return this;
        }

        private SalesInquiryItemPartner.SalesInquiryItemPartnerBuilder toSalesInquiryItem(
            final SalesInquiryItem value )
        {
            toSalesInquiryItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesInquiryItem</b> for <b>SalesInquiryItemPartner</b> to single
         * <b>SalesInquiryItem</b>.
         *
         * @param value
         *            The SalesInquiryItem to build this SalesInquiryItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesInquiryItemPartner.SalesInquiryItemPartnerBuilder salesInquiryItem( final SalesInquiryItem value )
        {
            return toSalesInquiryItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>SalesInquiryItem</b>
         * </p>
         *
         * @param value
         *            The salesInquiryItem to build this SalesInquiryItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesInquiryItemPartner.SalesInquiryItemPartnerBuilder salesInquiryItem( final String value )
        {
            salesInquiryItem = value;
            return this;
        }

    }

}
