/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SalesInquiryServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesInquiryService SalesInquiryService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSalesInquiryServiceBatch
    extends
    BatchFluentHelperBasic<SalesInquiryServiceBatch, SalesInquiryServiceBatchChangeSet>
    implements
    SalesInquiryServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesInquiryService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSalesInquiryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesInquiryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesInquiryService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesInquiryService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSalesInquiryServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesInquiryServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesInquiryService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSalesInquiryServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesInquiryServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSalesInquiryServiceBatchChangeSet(this, service);
    }

}
