/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link SalesInquiryServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesInquiryService SalesInquiryService}.
 *
 */
public class DefaultSalesInquiryServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesInquiryServiceBatch, SalesInquiryServiceBatchChangeSet>
    implements
    SalesInquiryServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesInquiryService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesInquiryServiceBatchChangeSet(
        @Nonnull final DefaultSalesInquiryServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesInquiryService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesInquiryServiceBatchChangeSet getThis()
    {
        return this;
    }

}
