/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner
 * SalesInquiryItemPartner}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.field.SalesInquiryItemPartnerField
 * SalesInquiryItemPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.link.SalesInquiryItemPartnerLink
 * SalesInquiryItemPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner#SALES_INQUIRY
 * SALES_INQUIRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner#SALES_INQUIRY_ITEM
 * SALES_INQUIRY_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner#TO_SALES_INQUIRY
 * TO_SALES_INQUIRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItemPartner#TO_SALES_INQUIRY_ITEM
 * TO_SALES_INQUIRY_ITEM}</li>
 * </ul>
 *
 */
public interface SalesInquiryItemPartnerSelectable extends EntitySelectable<SalesInquiryItemPartner>
{

}
