/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem SalesInquiryItem}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.field.SalesInquiryItemField
 * SalesInquiryItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.link.SalesInquiryItemLink
 * SalesInquiryItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#SALES_INQUIRY
 * SALES_INQUIRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#SALES_INQUIRY_ITEM
 * SALES_INQUIRY_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#HIGHER_LEVEL_ITEM
 * HIGHER_LEVEL_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#SALES_INQUIRY_ITEM_CATEGORY
 * SALES_INQUIRY_ITEM_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#SALES_INQUIRY_ITEM_TEXT
 * SALES_INQUIRY_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#PURCHASE_ORDER_BY_CUSTOMER
 * PURCHASE_ORDER_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#MATERIAL MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#MATERIAL_BY_CUSTOMER
 * MATERIAL_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#REQUESTED_QUANTITY
 * REQUESTED_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#REQUESTED_QUANTITY_UNIT
 * REQUESTED_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#ITEM_ORDER_PROBABILITY_IN_PERCENT
 * ITEM_ORDER_PROBABILITY_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#ALTERNATIVE_TO_ITEM
 * ALTERNATIVE_TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#ITEM_GROSS_WEIGHT
 * ITEM_GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#ITEM_NET_WEIGHT
 * ITEM_NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#ITEM_WEIGHT_UNIT
 * ITEM_WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#ITEM_VOLUME
 * ITEM_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#ITEM_VOLUME_UNIT
 * ITEM_VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#NET_AMOUNT
 * NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#MATERIAL_GROUP
 * MATERIAL_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#BATCH BATCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#CUSTOMER_PAYMENT_TERMS
 * CUSTOMER_PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#SALES_DOCUMENT_RJCN_REASON
 * SALES_DOCUMENT_RJCN_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#WBS_ELEMENT
 * WBS_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#SD_PROCESS_STATUS
 * SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryItem#TO_SALES_INQUIRY
 * TO_SALES_INQUIRY}</li>
 * </ul>
 *
 */
public interface SalesInquiryItemSelectable extends EntitySelectable<SalesInquiryItem>
{

}
