/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartner;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartner SalesInquiryPartner}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.field.SalesInquiryPartnerField
 * SalesInquiryPartnerField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.link.SalesInquiryPartnerLink
 * SalesInquiryPartnerLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartner#SALES_INQUIRY
 * SALES_INQUIRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartner#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartner#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartner#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartner#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartner#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiryPartner#TO_SALES_INQUIRY
 * TO_SALES_INQUIRY}</li>
 * </ul>
 *
 */
public interface SalesInquiryPartnerSelectable extends EntitySelectable<SalesInquiryPartner>
{

}
