/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry SalesInquiry}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.field.SalesInquiryField
 * SalesInquiryField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.link.SalesInquiryLink
 * SalesInquiryLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#SALES_INQUIRY
 * SALES_INQUIRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#SALES_INQUIRY_TYPE
 * SALES_INQUIRY_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#SALES_ORGANIZATION
 * SALES_ORGANIZATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#ORGANIZATION_DIVISION
 * ORGANIZATION_DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#SALES_GROUP
 * SALES_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#SALES_OFFICE
 * SALES_OFFICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#SALES_DISTRICT
 * SALES_DISTRICT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#SOLD_TO_PARTY
 * SOLD_TO_PARTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#PURCHASE_ORDER_BY_CUSTOMER
 * PURCHASE_ORDER_BY_CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#CUSTOMER_PURCHASE_ORDER_TYPE
 * CUSTOMER_PURCHASE_ORDER_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#CUSTOMER_PURCHASE_ORDER_DATE
 * CUSTOMER_PURCHASE_ORDER_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#SALES_INQUIRY_DATE
 * SALES_INQUIRY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#TOTAL_NET_AMOUNT
 * TOTAL_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#SD_DOCUMENT_REASON
 * SD_DOCUMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#PRICING_DATE
 * PRICING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#HEADER_BILLING_BLOCK_REASON
 * HEADER_BILLING_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#BINDING_PERIOD_VALIDITY_START_DATE
 * BINDING_PERIOD_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#BINDING_PERIOD_VALIDITY_END_DATE
 * BINDING_PERIOD_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#HDR_ORDER_PROBABILITY_IN_PERCENT
 * HDR_ORDER_PROBABILITY_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#EXPECTED_ORDER_NET_AMOUNT
 * EXPECTED_ORDER_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#INCOTERMS_CLASSIFICATION
 * INCOTERMS_CLASSIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#INCOTERMS_TRANSFER_LOCATION
 * INCOTERMS_TRANSFER_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#INCOTERMS_LOCATION1
 * INCOTERMS_LOCATION1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#INCOTERMS_LOCATION2
 * INCOTERMS_LOCATION2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#INCOTERMS_VERSION
 * INCOTERMS_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#CUSTOMER_PAYMENT_TERMS
 * CUSTOMER_PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#PAYMENT_METHOD
 * PAYMENT_METHOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#OVERALL_SD_PROCESS_STATUS
 * OVERALL_SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#TOTAL_CREDIT_CHECK_STATUS
 * TOTAL_CREDIT_CHECK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#OVERALL_SD_DOCUMENT_REJECTION_STS
 * OVERALL_SD_DOCUMENT_REJECTION_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#TO_ITEM TO_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#TO_PARTNER TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesinquiry.SalesInquiry#TO_PRICING_ELEMENT
 * TO_PRICING_ELEMENT}</li>
 * </ul>
 *
 */
public interface SalesInquirySelectable extends EntitySelectable<SalesInquiry>
{

}
