/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SalesOrderSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Order Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrder extends VdmEntity<SalesOrder>
{

    /**
     * Selector for all available fields of SalesOrder.
     *
     */
    public final static SalesOrderSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SALES_ORDER = new SalesOrderField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderType</b>
     * </p>
     *
     * @return Sales Order Type
     */
    @SerializedName( "SalesOrderType" )
    @JsonProperty( "SalesOrderType" )
    @Nullable
    @ODataField( odataName = "SalesOrderType" )
    private String salesOrderType;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderType</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SALES_ORDER_TYPE = new SalesOrderField<String>("SalesOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SALES_ORGANIZATION = new SalesOrderField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> DISTRIBUTION_CHANNEL =
        new SalesOrderField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> ORGANIZATION_DIVISION =
        new SalesOrderField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SALES_GROUP = new SalesOrderField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SALES_OFFICE = new SalesOrderField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SALES_DISTRICT = new SalesOrderField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SOLD_TO_PARTY = new SalesOrderField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SalesOrderField<LocalDateTime> CREATION_DATE =
        new SalesOrderField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CREATED_BY_USER = new SalesOrderField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static SalesOrderField<LocalDateTime> LAST_CHANGE_DATE =
        new SalesOrderField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SenderBusinessSystemName</b>
     * </p>
     *
     * @return External Business System ID
     */
    @SerializedName( "SenderBusinessSystemName" )
    @JsonProperty( "SenderBusinessSystemName" )
    @Nullable
    @ODataField( odataName = "SenderBusinessSystemName" )
    private String senderBusinessSystemName;
    /**
     * Use with available fluent helpers to apply the <b>SenderBusinessSystemName</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SENDER_BUSINESS_SYSTEM_NAME =
        new SalesOrderField<String>("SenderBusinessSystemName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocumentID</b>
     * </p>
     *
     * @return External Document ID
     */
    @SerializedName( "ExternalDocumentID" )
    @JsonProperty( "ExternalDocumentID" )
    @Nullable
    @ODataField( odataName = "ExternalDocumentID" )
    private String externalDocumentID;
    /**
     * Use with available fluent helpers to apply the <b>ExternalDocumentID</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> EXTERNAL_DOCUMENT_ID =
        new SalesOrderField<String>("ExternalDocumentID");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static SalesOrderField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new SalesOrderField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocLastChangeDateTime</b>
     * </p>
     *
     * @return Timestamp for Revision of External Calls
     */
    @SerializedName( "ExternalDocLastChangeDateTime" )
    @JsonProperty( "ExternalDocLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ExternalDocLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime externalDocLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ExternalDocLastChangeDateTime</b> field to query operations.
     *
     */
    public final static SalesOrderField<ZonedDateTime> EXTERNAL_DOC_LAST_CHANGE_DATE_TIME =
        new SalesOrderField<ZonedDateTime>("ExternalDocLastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new SalesOrderField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByShipToParty</b>
     * </p>
     *
     * @return Ship-to Party's Customer Reference
     */
    @SerializedName( "PurchaseOrderByShipToParty" )
    @JsonProperty( "PurchaseOrderByShipToParty" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByShipToParty" )
    private String purchaseOrderByShipToParty;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByShipToParty</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> PURCHASE_ORDER_BY_SHIP_TO_PARTY =
        new SalesOrderField<String>("PurchaseOrderByShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderType</b>
     * </p>
     *
     * @return Customer Purchase Order Type
     */
    @SerializedName( "CustomerPurchaseOrderType" )
    @JsonProperty( "CustomerPurchaseOrderType" )
    @Nullable
    @ODataField( odataName = "CustomerPurchaseOrderType" )
    private String customerPurchaseOrderType;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderType</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_PURCHASE_ORDER_TYPE =
        new SalesOrderField<String>("CustomerPurchaseOrderType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @return Customer Reference Date
     */
    @SerializedName( "CustomerPurchaseOrderDate" )
    @JsonProperty( "CustomerPurchaseOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CustomerPurchaseOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime customerPurchaseOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderDate</b> field to query operations.
     *
     */
    public final static SalesOrderField<LocalDateTime> CUSTOMER_PURCHASE_ORDER_DATE =
        new SalesOrderField<LocalDateTime>("CustomerPurchaseOrderDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderDate</b>
     * </p>
     *
     * @return Document Date (Date Received/Sent)
     */
    @SerializedName( "SalesOrderDate" )
    @JsonProperty( "SalesOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SalesOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime salesOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderDate</b> field to query operations.
     *
     */
    public final static SalesOrderField<LocalDateTime> SALES_ORDER_DATE =
        new SalesOrderField<LocalDateTime>("SalesOrderDate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @return Net Value of the Sales Order in Document Currency
     */
    @SerializedName( "TotalNetAmount" )
    @JsonProperty( "TotalNetAmount" )
    @Nullable
    @ODataField( odataName = "TotalNetAmount" )
    private BigDecimal totalNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalNetAmount</b> field to query operations.
     *
     */
    public final static SalesOrderField<BigDecimal> TOTAL_NET_AMOUNT =
        new SalesOrderField<BigDecimal>("TotalNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallDeliveryStatus</b>
     * </p>
     *
     * @return Delivery Status (All Items)
     */
    @SerializedName( "OverallDeliveryStatus" )
    @JsonProperty( "OverallDeliveryStatus" )
    @Nullable
    @ODataField( odataName = "OverallDeliveryStatus" )
    private String overallDeliveryStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallDeliveryStatus</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> OVERALL_DELIVERY_STATUS =
        new SalesOrderField<String>("OverallDeliveryStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalBlockStatus</b>
     * </p>
     *
     * @return Overall Block Status (Header)
     */
    @SerializedName( "TotalBlockStatus" )
    @JsonProperty( "TotalBlockStatus" )
    @Nullable
    @ODataField( odataName = "TotalBlockStatus" )
    private String totalBlockStatus;
    /**
     * Use with available fluent helpers to apply the <b>TotalBlockStatus</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> TOTAL_BLOCK_STATUS = new SalesOrderField<String>("TotalBlockStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallOrdReltdBillgStatus</b>
     * </p>
     *
     * @return Order-Related Billing Status (All Items)
     */
    @SerializedName( "OverallOrdReltdBillgStatus" )
    @JsonProperty( "OverallOrdReltdBillgStatus" )
    @Nullable
    @ODataField( odataName = "OverallOrdReltdBillgStatus" )
    private String overallOrdReltdBillgStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallOrdReltdBillgStatus</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> OVERALL_ORD_RELTD_BILLG_STATUS =
        new SalesOrderField<String>("OverallOrdReltdBillgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDDocReferenceStatus</b>
     * </p>
     *
     * @return Reference Status (All Items)
     */
    @SerializedName( "OverallSDDocReferenceStatus" )
    @JsonProperty( "OverallSDDocReferenceStatus" )
    @Nullable
    @ODataField( odataName = "OverallSDDocReferenceStatus" )
    private String overallSDDocReferenceStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDDocReferenceStatus</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> OVERALL_SD_DOC_REFERENCE_STATUS =
        new SalesOrderField<String>("OverallSDDocReferenceStatus");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> TRANSACTION_CURRENCY =
        new SalesOrderField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @return Order Reason (Reason for the Business Transaction)
     */
    @SerializedName( "SDDocumentReason" )
    @JsonProperty( "SDDocumentReason" )
    @Nullable
    @ODataField( odataName = "SDDocumentReason" )
    private String sDDocumentReason;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentReason</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SD_DOCUMENT_REASON = new SalesOrderField<String>("SDDocumentReason");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Date for Pricing and Exchange Rate
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static SalesOrderField<LocalDateTime> PRICING_DATE = new SalesOrderField<LocalDateTime>("PricingDate");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>PriceDetnExchangeRate</b>
     * </p>
     *
     * @return Exchange Rate for Price Determination
     */
    @SerializedName( "PriceDetnExchangeRate" )
    @JsonProperty( "PriceDetnExchangeRate" )
    @Nullable
    @ODataField( odataName = "PriceDetnExchangeRate" )
    private BigDecimal priceDetnExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>PriceDetnExchangeRate</b> field to query operations.
     *
     */
    public final static SalesOrderField<BigDecimal> PRICE_DETN_EXCHANGE_RATE =
        new SalesOrderField<BigDecimal>("PriceDetnExchangeRate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @return Billing Plan Number / Invoicing Plan Number
     */
    @SerializedName( "BillingPlan" )
    @JsonProperty( "BillingPlan" )
    @Nullable
    @ODataField( odataName = "BillingPlan" )
    private String billingPlan;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlan</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> BILLING_PLAN = new SalesOrderField<String>("BillingPlan");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @return Requested Delivery Date
     */
    @SerializedName( "RequestedDeliveryDate" )
    @JsonProperty( "RequestedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requestedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryDate</b> field to query operations.
     *
     */
    public final static SalesOrderField<LocalDateTime> REQUESTED_DELIVERY_DATE =
        new SalesOrderField<LocalDateTime>("RequestedDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SHIPPING_CONDITION = new SalesOrderField<String>("ShippingCondition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompleteDeliveryIsDefined</b>
     * </p>
     *
     * @return Complete Delivery Defined for Each Sales Order?
     */
    @SerializedName( "CompleteDeliveryIsDefined" )
    @JsonProperty( "CompleteDeliveryIsDefined" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CompleteDeliveryIsDefined" )
    private Boolean completeDeliveryIsDefined;
    /**
     * Use with available fluent helpers to apply the <b>CompleteDeliveryIsDefined</b> field to query operations.
     *
     */
    public final static SalesOrderField<Boolean> COMPLETE_DELIVERY_IS_DEFINED =
        new SalesOrderField<Boolean>("CompleteDeliveryIsDefined");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SHIPPING_TYPE = new SalesOrderField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block in SD Document
     */
    @SerializedName( "HeaderBillingBlockReason" )
    @JsonProperty( "HeaderBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "HeaderBillingBlockReason" )
    private String headerBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>HeaderBillingBlockReason</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> HEADER_BILLING_BLOCK_REASON =
        new SalesOrderField<String>("HeaderBillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryBlockReason</b>
     * </p>
     *
     * @return Delivery Block (Document Header)
     */
    @SerializedName( "DeliveryBlockReason" )
    @JsonProperty( "DeliveryBlockReason" )
    @Nullable
    @ODataField( odataName = "DeliveryBlockReason" )
    private String deliveryBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryBlockReason</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> DELIVERY_BLOCK_REASON =
        new SalesOrderField<String>("DeliveryBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDateTypeRule</b>
     * </p>
     *
     * @return Delivery Date Rule
     */
    @SerializedName( "DeliveryDateTypeRule" )
    @JsonProperty( "DeliveryDateTypeRule" )
    @Nullable
    @ODataField( odataName = "DeliveryDateTypeRule" )
    private String deliveryDateTypeRule;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDateTypeRule</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> DELIVERY_DATE_TYPE_RULE =
        new SalesOrderField<String>("DeliveryDateTypeRule");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> INCOTERMS_CLASSIFICATION =
        new SalesOrderField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> INCOTERMS_TRANSFER_LOCATION =
        new SalesOrderField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> INCOTERMS_LOCATION1 = new SalesOrderField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> INCOTERMS_LOCATION2 = new SalesOrderField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> INCOTERMS_VERSION = new SalesOrderField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPriceGroup</b>
     * </p>
     *
     * @return Customer Price Group
     */
    @SerializedName( "CustomerPriceGroup" )
    @JsonProperty( "CustomerPriceGroup" )
    @Nullable
    @ODataField( odataName = "CustomerPriceGroup" )
    private String customerPriceGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPriceGroup</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_PRICE_GROUP =
        new SalesOrderField<String>("CustomerPriceGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceListType</b>
     * </p>
     *
     * @return Price List Type
     */
    @SerializedName( "PriceListType" )
    @JsonProperty( "PriceListType" )
    @Nullable
    @ODataField( odataName = "PriceListType" )
    private String priceListType;
    /**
     * Use with available fluent helpers to apply the <b>PriceListType</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> PRICE_LIST_TYPE = new SalesOrderField<String>("PriceListType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_PAYMENT_TERMS =
        new SalesOrderField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> PAYMENT_METHOD = new SalesOrderField<String>("PaymentMethod");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @return Fixed Value Date
     */
    @SerializedName( "FixedValueDate" )
    @JsonProperty( "FixedValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FixedValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime fixedValueDate;
    /**
     * Use with available fluent helpers to apply the <b>FixedValueDate</b> field to query operations.
     *
     */
    public final static SalesOrderField<LocalDateTime> FIXED_VALUE_DATE =
        new SalesOrderField<LocalDateTime>("FixedValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @return Assignment Number
     */
    @SerializedName( "AssignmentReference" )
    @JsonProperty( "AssignmentReference" )
    @Nullable
    @ODataField( odataName = "AssignmentReference" )
    private String assignmentReference;
    /**
     * Use with available fluent helpers to apply the <b>AssignmentReference</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> ASSIGNMENT_REFERENCE =
        new SalesOrderField<String>("AssignmentReference");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> REFERENCE_SD_DOCUMENT =
        new SalesOrderField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @return Document Category of Preceding SD Document
     */
    @SerializedName( "ReferenceSDDocumentCategory" )
    @JsonProperty( "ReferenceSDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentCategory" )
    private String referenceSDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentCategory</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> REFERENCE_SD_DOCUMENT_CATEGORY =
        new SalesOrderField<String>("ReferenceSDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocExternalReference</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "AccountingDocExternalReference" )
    @JsonProperty( "AccountingDocExternalReference" )
    @Nullable
    @ODataField( odataName = "AccountingDocExternalReference" )
    private String accountingDocExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocExternalReference</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> ACCOUNTING_DOC_EXTERNAL_REFERENCE =
        new SalesOrderField<String>("AccountingDocExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerAccountAssignmentGroup</b>
     * </p>
     *
     * @return Account Assignment Group for Customer
     */
    @SerializedName( "CustomerAccountAssignmentGroup" )
    @JsonProperty( "CustomerAccountAssignmentGroup" )
    @Nullable
    @ODataField( odataName = "CustomerAccountAssignmentGroup" )
    private String customerAccountAssignmentGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerAccountAssignmentGroup</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_ACCOUNT_ASSIGNMENT_GROUP =
        new SalesOrderField<String>("CustomerAccountAssignmentGroup");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AccountingExchangeRate</b>
     * </p>
     *
     * @return Exchange Rate for Postings to Financial Accounting
     */
    @SerializedName( "AccountingExchangeRate" )
    @JsonProperty( "AccountingExchangeRate" )
    @Nullable
    @ODataField( odataName = "AccountingExchangeRate" )
    private BigDecimal accountingExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>AccountingExchangeRate</b> field to query operations.
     *
     */
    public final static SalesOrderField<BigDecimal> ACCOUNTING_EXCHANGE_RATE =
        new SalesOrderField<BigDecimal>("AccountingExchangeRate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_GROUP = new SalesOrderField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup1</b>
     * </p>
     *
     * @return Customer Group 1
     */
    @SerializedName( "AdditionalCustomerGroup1" )
    @JsonProperty( "AdditionalCustomerGroup1" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup1" )
    private String additionalCustomerGroup1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup1</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> ADDITIONAL_CUSTOMER_GROUP1 =
        new SalesOrderField<String>("AdditionalCustomerGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup2</b>
     * </p>
     *
     * @return Customer Group 2
     */
    @SerializedName( "AdditionalCustomerGroup2" )
    @JsonProperty( "AdditionalCustomerGroup2" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup2" )
    private String additionalCustomerGroup2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup2</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> ADDITIONAL_CUSTOMER_GROUP2 =
        new SalesOrderField<String>("AdditionalCustomerGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup3</b>
     * </p>
     *
     * @return Customer Group 3
     */
    @SerializedName( "AdditionalCustomerGroup3" )
    @JsonProperty( "AdditionalCustomerGroup3" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup3" )
    private String additionalCustomerGroup3;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup3</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> ADDITIONAL_CUSTOMER_GROUP3 =
        new SalesOrderField<String>("AdditionalCustomerGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup4</b>
     * </p>
     *
     * @return Customer Group 4
     */
    @SerializedName( "AdditionalCustomerGroup4" )
    @JsonProperty( "AdditionalCustomerGroup4" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup4" )
    private String additionalCustomerGroup4;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup4</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> ADDITIONAL_CUSTOMER_GROUP4 =
        new SalesOrderField<String>("AdditionalCustomerGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup5</b>
     * </p>
     *
     * @return Customer Group 5
     */
    @SerializedName( "AdditionalCustomerGroup5" )
    @JsonProperty( "AdditionalCustomerGroup5" )
    @Nullable
    @ODataField( odataName = "AdditionalCustomerGroup5" )
    private String additionalCustomerGroup5;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalCustomerGroup5</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> ADDITIONAL_CUSTOMER_GROUP5 =
        new SalesOrderField<String>("AdditionalCustomerGroup5");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SlsDocIsRlvtForProofOfDeliv</b>
     * </p>
     *
     * @return Relevant for POD processing
     */
    @SerializedName( "SlsDocIsRlvtForProofOfDeliv" )
    @JsonProperty( "SlsDocIsRlvtForProofOfDeliv" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SlsDocIsRlvtForProofOfDeliv" )
    private Boolean slsDocIsRlvtForProofOfDeliv;
    /**
     * Use with available fluent helpers to apply the <b>SlsDocIsRlvtForProofOfDeliv</b> field to query operations.
     *
     */
    public final static SalesOrderField<Boolean> SLS_DOC_IS_RLVT_FOR_PROOF_OF_DELIV =
        new SalesOrderField<Boolean>("SlsDocIsRlvtForProofOfDeliv");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification1</b>
     * </p>
     *
     * @return Alternative Tax Classification
     */
    @SerializedName( "CustomerTaxClassification1" )
    @JsonProperty( "CustomerTaxClassification1" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification1" )
    private String customerTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification1</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_TAX_CLASSIFICATION1 =
        new SalesOrderField<String>("CustomerTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification 2 for Customer
     */
    @SerializedName( "CustomerTaxClassification2" )
    @JsonProperty( "CustomerTaxClassification2" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification2" )
    private String customerTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification2</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_TAX_CLASSIFICATION2 =
        new SalesOrderField<String>("CustomerTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification 3 for Customer
     */
    @SerializedName( "CustomerTaxClassification3" )
    @JsonProperty( "CustomerTaxClassification3" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification3" )
    private String customerTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification3</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_TAX_CLASSIFICATION3 =
        new SalesOrderField<String>("CustomerTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification 4 for Customer
     */
    @SerializedName( "CustomerTaxClassification4" )
    @JsonProperty( "CustomerTaxClassification4" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification4" )
    private String customerTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification4</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_TAX_CLASSIFICATION4 =
        new SalesOrderField<String>("CustomerTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification 5 for Customer
     */
    @SerializedName( "CustomerTaxClassification5" )
    @JsonProperty( "CustomerTaxClassification5" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification5" )
    private String customerTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification5</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_TAX_CLASSIFICATION5 =
        new SalesOrderField<String>("CustomerTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification 6 for Customer
     */
    @SerializedName( "CustomerTaxClassification6" )
    @JsonProperty( "CustomerTaxClassification6" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification6" )
    private String customerTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification6</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_TAX_CLASSIFICATION6 =
        new SalesOrderField<String>("CustomerTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification 7 for Customer
     */
    @SerializedName( "CustomerTaxClassification7" )
    @JsonProperty( "CustomerTaxClassification7" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification7" )
    private String customerTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification7</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_TAX_CLASSIFICATION7 =
        new SalesOrderField<String>("CustomerTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification 8 for Customer
     */
    @SerializedName( "CustomerTaxClassification8" )
    @JsonProperty( "CustomerTaxClassification8" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification8" )
    private String customerTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification8</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_TAX_CLASSIFICATION8 =
        new SalesOrderField<String>("CustomerTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification 9 for Customer
     */
    @SerializedName( "CustomerTaxClassification9" )
    @JsonProperty( "CustomerTaxClassification9" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification9" )
    private String customerTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification9</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_TAX_CLASSIFICATION9 =
        new SalesOrderField<String>("CustomerTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxDepartureCountry</b>
     * </p>
     *
     * @return Tax Departure Country/Region
     */
    @SerializedName( "TaxDepartureCountry" )
    @JsonProperty( "TaxDepartureCountry" )
    @Nullable
    @ODataField( odataName = "TaxDepartureCountry" )
    private String taxDepartureCountry;
    /**
     * Use with available fluent helpers to apply the <b>TaxDepartureCountry</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> TAX_DEPARTURE_COUNTRY =
        new SalesOrderField<String>("TaxDepartureCountry");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistrationCountry</b>
     * </p>
     *
     * @return Tax Destination Country/Region
     */
    @SerializedName( "VATRegistrationCountry" )
    @JsonProperty( "VATRegistrationCountry" )
    @Nullable
    @ODataField( odataName = "VATRegistrationCountry" )
    private String vATRegistrationCountry;
    /**
     * Use with available fluent helpers to apply the <b>VATRegistrationCountry</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> VAT_REGISTRATION_COUNTRY =
        new SalesOrderField<String>("VATRegistrationCountry");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderApprovalReason</b>
     * </p>
     *
     * @return Approval Request Reason ID
     */
    @SerializedName( "SalesOrderApprovalReason" )
    @JsonProperty( "SalesOrderApprovalReason" )
    @Nullable
    @ODataField( odataName = "SalesOrderApprovalReason" )
    private String salesOrderApprovalReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderApprovalReason</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SALES_ORDER_APPROVAL_REASON =
        new SalesOrderField<String>("SalesOrderApprovalReason");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocApprovalStatus</b>
     * </p>
     *
     * @return Document Approval Status
     */
    @SerializedName( "SalesDocApprovalStatus" )
    @JsonProperty( "SalesDocApprovalStatus" )
    @Nullable
    @ODataField( odataName = "SalesDocApprovalStatus" )
    private String salesDocApprovalStatus;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocApprovalStatus</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> SALES_DOC_APPROVAL_STATUS =
        new SalesOrderField<String>("SalesDocApprovalStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Header/All Items)
     */
    @SerializedName( "OverallSDProcessStatus" )
    @JsonProperty( "OverallSDProcessStatus" )
    @Nullable
    @ODataField( odataName = "OverallSDProcessStatus" )
    private String overallSDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDProcessStatus</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> OVERALL_SD_PROCESS_STATUS =
        new SalesOrderField<String>("OverallSDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @return Overall Status of Credit Checks
     */
    @SerializedName( "TotalCreditCheckStatus" )
    @JsonProperty( "TotalCreditCheckStatus" )
    @Nullable
    @ODataField( odataName = "TotalCreditCheckStatus" )
    private String totalCreditCheckStatus;
    /**
     * Use with available fluent helpers to apply the <b>TotalCreditCheckStatus</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> TOTAL_CREDIT_CHECK_STATUS =
        new SalesOrderField<String>("TotalCreditCheckStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallTotalDeliveryStatus</b>
     * </p>
     *
     * @return Overall Delivery Status (All Items)
     */
    @SerializedName( "OverallTotalDeliveryStatus" )
    @JsonProperty( "OverallTotalDeliveryStatus" )
    @Nullable
    @ODataField( odataName = "OverallTotalDeliveryStatus" )
    private String overallTotalDeliveryStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallTotalDeliveryStatus</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> OVERALL_TOTAL_DELIVERY_STATUS =
        new SalesOrderField<String>("OverallTotalDeliveryStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDDocumentRejectionSts</b>
     * </p>
     *
     * @return Rejection Status (All Items)
     */
    @SerializedName( "OverallSDDocumentRejectionSts" )
    @JsonProperty( "OverallSDDocumentRejectionSts" )
    @Nullable
    @ODataField( odataName = "OverallSDDocumentRejectionSts" )
    private String overallSDDocumentRejectionSts;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDDocumentRejectionSts</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> OVERALL_SD_DOCUMENT_REJECTION_STS =
        new SalesOrderField<String>("OverallSDDocumentRejectionSts");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentDate</b>
     * </p>
     *
     * @return Billing Date
     */
    @SerializedName( "BillingDocumentDate" )
    @JsonProperty( "BillingDocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingDocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingDocumentDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentDate</b> field to query operations.
     *
     */
    public final static SalesOrderField<LocalDateTime> BILLING_DOCUMENT_DATE =
        new SalesOrderField<LocalDateTime>("BillingDocumentDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     *
     * @return Contract Account Number
     */
    @SerializedName( "ContractAccount" )
    @JsonProperty( "ContractAccount" )
    @Nullable
    @ODataField( odataName = "ContractAccount" )
    private String contractAccount;
    /**
     * Use with available fluent helpers to apply the <b>ContractAccount</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CONTRACT_ACCOUNT = new SalesOrderField<String>("ContractAccount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @return Additional Value Days
     */
    @SerializedName( "AdditionalValueDays" )
    @JsonProperty( "AdditionalValueDays" )
    @Nullable
    @ODataField( odataName = "AdditionalValueDays" )
    private String additionalValueDays;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalValueDays</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> ADDITIONAL_VALUE_DAYS =
        new SalesOrderField<String>("AdditionalValueDays");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderSuplmnt</b>
     * </p>
     *
     * @return Purchase order number supplement
     */
    @SerializedName( "CustomerPurchaseOrderSuplmnt" )
    @JsonProperty( "CustomerPurchaseOrderSuplmnt" )
    @Nullable
    @ODataField( odataName = "CustomerPurchaseOrderSuplmnt" )
    private String customerPurchaseOrderSuplmnt;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderSuplmnt</b> field to query operations.
     *
     */
    public final static SalesOrderField<String> CUSTOMER_PURCHASE_ORDER_SUPLMNT =
        new SalesOrderField<String>("CustomerPurchaseOrderSuplmnt");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @return Date on which services are rendered
     */
    @SerializedName( "ServicesRenderedDate" )
    @JsonProperty( "ServicesRenderedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ServicesRenderedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime servicesRenderedDate;
    /**
     * Use with available fluent helpers to apply the <b>ServicesRenderedDate</b> field to query operations.
     *
     */
    public final static SalesOrderField<LocalDateTime> SERVICES_RENDERED_DATE =
        new SalesOrderField<LocalDateTime>("ServicesRenderedDate");
    /**
     * Navigation property <b>to_BillingPlan</b> for <b>SalesOrder</b> to single <b>SalesOrderBillingPlan</b>.
     *
     */
    @SerializedName( "to_BillingPlan" )
    @JsonProperty( "to_BillingPlan" )
    @ODataField( odataName = "to_BillingPlan" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderBillingPlan toBillingPlan;
    /**
     * Navigation property <b>to_Item</b> for <b>SalesOrder</b> to multiple <b>SalesOrderItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItem> toItem;
    /**
     * Navigation property <b>to_Partner</b> for <b>SalesOrder</b> to multiple <b>SalesOrderHeaderPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderHeaderPartner> toPartner;
    /**
     * Navigation property <b>to_PaymentPlanItemDetails</b> for <b>SalesOrder</b> to multiple
     * <b>SlsOrdPaymentPlanItemDetails</b>.
     *
     */
    @SerializedName( "to_PaymentPlanItemDetails" )
    @JsonProperty( "to_PaymentPlanItemDetails" )
    @ODataField( odataName = "to_PaymentPlanItemDetails" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsOrdPaymentPlanItemDetails> toPaymentPlanItemDetails;
    /**
     * Navigation property <b>to_PrecedingProcFlowDoc</b> for <b>SalesOrder</b> to multiple
     * <b>SalesOrderPrecdgProcFlow</b>.
     *
     */
    @SerializedName( "to_PrecedingProcFlowDoc" )
    @JsonProperty( "to_PrecedingProcFlowDoc" )
    @ODataField( odataName = "to_PrecedingProcFlowDoc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderPrecdgProcFlow> toPrecedingProcFlowDoc;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>SalesOrder</b> to multiple <b>SalesOrderHeaderPrElement</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderHeaderPrElement> toPricingElement;
    /**
     * Navigation property <b>to_RelatedObject</b> for <b>SalesOrder</b> to multiple <b>SalesOrderRelatedObject</b>.
     *
     */
    @SerializedName( "to_RelatedObject" )
    @JsonProperty( "to_RelatedObject" )
    @ODataField( odataName = "to_RelatedObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderRelatedObject> toRelatedObject;
    /**
     * Navigation property <b>to_SubsequentProcFlowDoc</b> for <b>SalesOrder</b> to multiple
     * <b>SalesOrderSubsqntProcFlow</b>.
     *
     */
    @SerializedName( "to_SubsequentProcFlowDoc" )
    @JsonProperty( "to_SubsequentProcFlowDoc" )
    @ODataField( odataName = "to_SubsequentProcFlowDoc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderSubsqntProcFlow> toSubsequentProcFlowDoc;
    /**
     * Navigation property <b>to_Text</b> for <b>SalesOrder</b> to multiple <b>SalesOrderText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingPlan</b> navigation property to query operations.
     *
     */
    public final static SalesOrderOneToOneLink<SalesOrderBillingPlan> TO_BILLING_PLAN =
        new SalesOrderOneToOneLink<SalesOrderBillingPlan>("to_BillingPlan");
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static SalesOrderLink<SalesOrderItem> TO_ITEM = new SalesOrderLink<SalesOrderItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static SalesOrderLink<SalesOrderHeaderPartner> TO_PARTNER =
        new SalesOrderLink<SalesOrderHeaderPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PaymentPlanItemDetails</b> navigation property to query
     * operations.
     *
     */
    public final static SalesOrderLink<SlsOrdPaymentPlanItemDetails> TO_PAYMENT_PLAN_ITEM_DETAILS =
        new SalesOrderLink<SlsOrdPaymentPlanItemDetails>("to_PaymentPlanItemDetails");
    /**
     * Use with available fluent helpers to apply the <b>to_PrecedingProcFlowDoc</b> navigation property to query
     * operations.
     *
     */
    public final static SalesOrderLink<SalesOrderPrecdgProcFlow> TO_PRECEDING_PROC_FLOW_DOC =
        new SalesOrderLink<SalesOrderPrecdgProcFlow>("to_PrecedingProcFlowDoc");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static SalesOrderLink<SalesOrderHeaderPrElement> TO_PRICING_ELEMENT =
        new SalesOrderLink<SalesOrderHeaderPrElement>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_RelatedObject</b> navigation property to query operations.
     *
     */
    public final static SalesOrderLink<SalesOrderRelatedObject> TO_RELATED_OBJECT =
        new SalesOrderLink<SalesOrderRelatedObject>("to_RelatedObject");
    /**
     * Use with available fluent helpers to apply the <b>to_SubsequentProcFlowDoc</b> navigation property to query
     * operations.
     *
     */
    public final static SalesOrderLink<SalesOrderSubsqntProcFlow> TO_SUBSEQUENT_PROC_FLOW_DOC =
        new SalesOrderLink<SalesOrderSubsqntProcFlow>("to_SubsequentProcFlowDoc");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static SalesOrderLink<SalesOrderText> TO_TEXT = new SalesOrderLink<SalesOrderText>("to_Text");

    @Nonnull
    @Override
    public Class<SalesOrder> getType()
    {
        return SalesOrder.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderType</b>
     * </p>
     *
     * @param salesOrderType
     *            Sales Order Type
     */
    public void setSalesOrderType( @Nullable final String salesOrderType )
    {
        rememberChangedField("SalesOrderType", this.salesOrderType);
        this.salesOrderType = salesOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SenderBusinessSystemName</b>
     * </p>
     *
     * @param senderBusinessSystemName
     *            External Business System ID
     */
    public void setSenderBusinessSystemName( @Nullable final String senderBusinessSystemName )
    {
        rememberChangedField("SenderBusinessSystemName", this.senderBusinessSystemName);
        this.senderBusinessSystemName = senderBusinessSystemName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocumentID</b>
     * </p>
     *
     * @param externalDocumentID
     *            External Document ID
     */
    public void setExternalDocumentID( @Nullable final String externalDocumentID )
    {
        rememberChangedField("ExternalDocumentID", this.externalDocumentID);
        this.externalDocumentID = externalDocumentID;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            UTC Time Stamp in Long Form (YYYYMMDDhhmmssmmmuuun)
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocLastChangeDateTime</b>
     * </p>
     *
     * @param externalDocLastChangeDateTime
     *            Timestamp for Revision of External Calls
     */
    public void setExternalDocLastChangeDateTime( @Nullable final ZonedDateTime externalDocLastChangeDateTime )
    {
        rememberChangedField("ExternalDocLastChangeDateTime", this.externalDocLastChangeDateTime);
        this.externalDocLastChangeDateTime = externalDocLastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByShipToParty</b>
     * </p>
     *
     * @param purchaseOrderByShipToParty
     *            Ship-to Party's Customer Reference
     */
    public void setPurchaseOrderByShipToParty( @Nullable final String purchaseOrderByShipToParty )
    {
        rememberChangedField("PurchaseOrderByShipToParty", this.purchaseOrderByShipToParty);
        this.purchaseOrderByShipToParty = purchaseOrderByShipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderType</b>
     * </p>
     *
     * @param customerPurchaseOrderType
     *            Customer Purchase Order Type
     */
    public void setCustomerPurchaseOrderType( @Nullable final String customerPurchaseOrderType )
    {
        rememberChangedField("CustomerPurchaseOrderType", this.customerPurchaseOrderType);
        this.customerPurchaseOrderType = customerPurchaseOrderType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @param customerPurchaseOrderDate
     *            Customer Reference Date
     */
    public void setCustomerPurchaseOrderDate( @Nullable final LocalDateTime customerPurchaseOrderDate )
    {
        rememberChangedField("CustomerPurchaseOrderDate", this.customerPurchaseOrderDate);
        this.customerPurchaseOrderDate = customerPurchaseOrderDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderDate</b>
     * </p>
     *
     * @param salesOrderDate
     *            Document Date (Date Received/Sent)
     */
    public void setSalesOrderDate( @Nullable final LocalDateTime salesOrderDate )
    {
        rememberChangedField("SalesOrderDate", this.salesOrderDate);
        this.salesOrderDate = salesOrderDate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @param totalNetAmount
     *            Net Value of the Sales Order in Document Currency
     */
    public void setTotalNetAmount( @Nullable final BigDecimal totalNetAmount )
    {
        rememberChangedField("TotalNetAmount", this.totalNetAmount);
        this.totalNetAmount = totalNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallDeliveryStatus</b>
     * </p>
     *
     * @param overallDeliveryStatus
     *            Delivery Status (All Items)
     */
    public void setOverallDeliveryStatus( @Nullable final String overallDeliveryStatus )
    {
        rememberChangedField("OverallDeliveryStatus", this.overallDeliveryStatus);
        this.overallDeliveryStatus = overallDeliveryStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalBlockStatus</b>
     * </p>
     *
     * @param totalBlockStatus
     *            Overall Block Status (Header)
     */
    public void setTotalBlockStatus( @Nullable final String totalBlockStatus )
    {
        rememberChangedField("TotalBlockStatus", this.totalBlockStatus);
        this.totalBlockStatus = totalBlockStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallOrdReltdBillgStatus</b>
     * </p>
     *
     * @param overallOrdReltdBillgStatus
     *            Order-Related Billing Status (All Items)
     */
    public void setOverallOrdReltdBillgStatus( @Nullable final String overallOrdReltdBillgStatus )
    {
        rememberChangedField("OverallOrdReltdBillgStatus", this.overallOrdReltdBillgStatus);
        this.overallOrdReltdBillgStatus = overallOrdReltdBillgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDDocReferenceStatus</b>
     * </p>
     *
     * @param overallSDDocReferenceStatus
     *            Reference Status (All Items)
     */
    public void setOverallSDDocReferenceStatus( @Nullable final String overallSDDocReferenceStatus )
    {
        rememberChangedField("OverallSDDocReferenceStatus", this.overallSDDocReferenceStatus);
        this.overallSDDocReferenceStatus = overallSDDocReferenceStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @param sDDocumentReason
     *            Order Reason (Reason for the Business Transaction)
     */
    public void setSDDocumentReason( @Nullable final String sDDocumentReason )
    {
        rememberChangedField("SDDocumentReason", this.sDDocumentReason);
        this.sDDocumentReason = sDDocumentReason;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>PriceDetnExchangeRate</b>
     * </p>
     *
     * @param priceDetnExchangeRate
     *            Exchange Rate for Price Determination
     */
    public void setPriceDetnExchangeRate( @Nullable final BigDecimal priceDetnExchangeRate )
    {
        rememberChangedField("PriceDetnExchangeRate", this.priceDetnExchangeRate);
        this.priceDetnExchangeRate = priceDetnExchangeRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     */
    public void setBillingPlan( @Nullable final String billingPlan )
    {
        rememberChangedField("BillingPlan", this.billingPlan);
        this.billingPlan = billingPlan;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @param requestedDeliveryDate
     *            Requested Delivery Date
     */
    public void setRequestedDeliveryDate( @Nullable final LocalDateTime requestedDeliveryDate )
    {
        rememberChangedField("RequestedDeliveryDate", this.requestedDeliveryDate);
        this.requestedDeliveryDate = requestedDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompleteDeliveryIsDefined</b>
     * </p>
     *
     * @param completeDeliveryIsDefined
     *            Complete Delivery Defined for Each Sales Order?
     */
    public void setCompleteDeliveryIsDefined( @Nullable final Boolean completeDeliveryIsDefined )
    {
        rememberChangedField("CompleteDeliveryIsDefined", this.completeDeliveryIsDefined);
        this.completeDeliveryIsDefined = completeDeliveryIsDefined;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillingBlockReason</b>
     * </p>
     *
     * @param headerBillingBlockReason
     *            Billing Block in SD Document
     */
    public void setHeaderBillingBlockReason( @Nullable final String headerBillingBlockReason )
    {
        rememberChangedField("HeaderBillingBlockReason", this.headerBillingBlockReason);
        this.headerBillingBlockReason = headerBillingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryBlockReason</b>
     * </p>
     *
     * @param deliveryBlockReason
     *            Delivery Block (Document Header)
     */
    public void setDeliveryBlockReason( @Nullable final String deliveryBlockReason )
    {
        rememberChangedField("DeliveryBlockReason", this.deliveryBlockReason);
        this.deliveryBlockReason = deliveryBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDateTypeRule</b>
     * </p>
     *
     * @param deliveryDateTypeRule
     *            Delivery Date Rule
     */
    public void setDeliveryDateTypeRule( @Nullable final String deliveryDateTypeRule )
    {
        rememberChangedField("DeliveryDateTypeRule", this.deliveryDateTypeRule);
        this.deliveryDateTypeRule = deliveryDateTypeRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPriceGroup</b>
     * </p>
     *
     * @param customerPriceGroup
     *            Customer Price Group
     */
    public void setCustomerPriceGroup( @Nullable final String customerPriceGroup )
    {
        rememberChangedField("CustomerPriceGroup", this.customerPriceGroup);
        this.customerPriceGroup = customerPriceGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceListType</b>
     * </p>
     *
     * @param priceListType
     *            Price List Type
     */
    public void setPriceListType( @Nullable final String priceListType )
    {
        rememberChangedField("PriceListType", this.priceListType);
        this.priceListType = priceListType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @param fixedValueDate
     *            Fixed Value Date
     */
    public void setFixedValueDate( @Nullable final LocalDateTime fixedValueDate )
    {
        rememberChangedField("FixedValueDate", this.fixedValueDate);
        this.fixedValueDate = fixedValueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>AssignmentReference</b>
     * </p>
     *
     * @param assignmentReference
     *            Assignment Number
     */
    public void setAssignmentReference( @Nullable final String assignmentReference )
    {
        rememberChangedField("AssignmentReference", this.assignmentReference);
        this.assignmentReference = assignmentReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @param referenceSDDocumentCategory
     *            Document Category of Preceding SD Document
     */
    public void setReferenceSDDocumentCategory( @Nullable final String referenceSDDocumentCategory )
    {
        rememberChangedField("ReferenceSDDocumentCategory", this.referenceSDDocumentCategory);
        this.referenceSDDocumentCategory = referenceSDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocExternalReference</b>
     * </p>
     *
     * @param accountingDocExternalReference
     *            Reference Document Number
     */
    public void setAccountingDocExternalReference( @Nullable final String accountingDocExternalReference )
    {
        rememberChangedField("AccountingDocExternalReference", this.accountingDocExternalReference);
        this.accountingDocExternalReference = accountingDocExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerAccountAssignmentGroup</b>
     * </p>
     *
     * @param customerAccountAssignmentGroup
     *            Account Assignment Group for Customer
     */
    public void setCustomerAccountAssignmentGroup( @Nullable final String customerAccountAssignmentGroup )
    {
        rememberChangedField("CustomerAccountAssignmentGroup", this.customerAccountAssignmentGroup);
        this.customerAccountAssignmentGroup = customerAccountAssignmentGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AccountingExchangeRate</b>
     * </p>
     *
     * @param accountingExchangeRate
     *            Exchange Rate for Postings to Financial Accounting
     */
    public void setAccountingExchangeRate( @Nullable final BigDecimal accountingExchangeRate )
    {
        rememberChangedField("AccountingExchangeRate", this.accountingExchangeRate);
        this.accountingExchangeRate = accountingExchangeRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup1</b>
     * </p>
     *
     * @param additionalCustomerGroup1
     *            Customer Group 1
     */
    public void setAdditionalCustomerGroup1( @Nullable final String additionalCustomerGroup1 )
    {
        rememberChangedField("AdditionalCustomerGroup1", this.additionalCustomerGroup1);
        this.additionalCustomerGroup1 = additionalCustomerGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup2</b>
     * </p>
     *
     * @param additionalCustomerGroup2
     *            Customer Group 2
     */
    public void setAdditionalCustomerGroup2( @Nullable final String additionalCustomerGroup2 )
    {
        rememberChangedField("AdditionalCustomerGroup2", this.additionalCustomerGroup2);
        this.additionalCustomerGroup2 = additionalCustomerGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup3</b>
     * </p>
     *
     * @param additionalCustomerGroup3
     *            Customer Group 3
     */
    public void setAdditionalCustomerGroup3( @Nullable final String additionalCustomerGroup3 )
    {
        rememberChangedField("AdditionalCustomerGroup3", this.additionalCustomerGroup3);
        this.additionalCustomerGroup3 = additionalCustomerGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup4</b>
     * </p>
     *
     * @param additionalCustomerGroup4
     *            Customer Group 4
     */
    public void setAdditionalCustomerGroup4( @Nullable final String additionalCustomerGroup4 )
    {
        rememberChangedField("AdditionalCustomerGroup4", this.additionalCustomerGroup4);
        this.additionalCustomerGroup4 = additionalCustomerGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalCustomerGroup5</b>
     * </p>
     *
     * @param additionalCustomerGroup5
     *            Customer Group 5
     */
    public void setAdditionalCustomerGroup5( @Nullable final String additionalCustomerGroup5 )
    {
        rememberChangedField("AdditionalCustomerGroup5", this.additionalCustomerGroup5);
        this.additionalCustomerGroup5 = additionalCustomerGroup5;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SlsDocIsRlvtForProofOfDeliv</b>
     * </p>
     *
     * @param slsDocIsRlvtForProofOfDeliv
     *            Relevant for POD processing
     */
    public void setSlsDocIsRlvtForProofOfDeliv( @Nullable final Boolean slsDocIsRlvtForProofOfDeliv )
    {
        rememberChangedField("SlsDocIsRlvtForProofOfDeliv", this.slsDocIsRlvtForProofOfDeliv);
        this.slsDocIsRlvtForProofOfDeliv = slsDocIsRlvtForProofOfDeliv;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification1</b>
     * </p>
     *
     * @param customerTaxClassification1
     *            Alternative Tax Classification
     */
    public void setCustomerTaxClassification1( @Nullable final String customerTaxClassification1 )
    {
        rememberChangedField("CustomerTaxClassification1", this.customerTaxClassification1);
        this.customerTaxClassification1 = customerTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification2</b>
     * </p>
     *
     * @param customerTaxClassification2
     *            Tax Classification 2 for Customer
     */
    public void setCustomerTaxClassification2( @Nullable final String customerTaxClassification2 )
    {
        rememberChangedField("CustomerTaxClassification2", this.customerTaxClassification2);
        this.customerTaxClassification2 = customerTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification3</b>
     * </p>
     *
     * @param customerTaxClassification3
     *            Tax Classification 3 for Customer
     */
    public void setCustomerTaxClassification3( @Nullable final String customerTaxClassification3 )
    {
        rememberChangedField("CustomerTaxClassification3", this.customerTaxClassification3);
        this.customerTaxClassification3 = customerTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification4</b>
     * </p>
     *
     * @param customerTaxClassification4
     *            Tax Classification 4 for Customer
     */
    public void setCustomerTaxClassification4( @Nullable final String customerTaxClassification4 )
    {
        rememberChangedField("CustomerTaxClassification4", this.customerTaxClassification4);
        this.customerTaxClassification4 = customerTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification5</b>
     * </p>
     *
     * @param customerTaxClassification5
     *            Tax Classification 5 for Customer
     */
    public void setCustomerTaxClassification5( @Nullable final String customerTaxClassification5 )
    {
        rememberChangedField("CustomerTaxClassification5", this.customerTaxClassification5);
        this.customerTaxClassification5 = customerTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification6</b>
     * </p>
     *
     * @param customerTaxClassification6
     *            Tax Classification 6 for Customer
     */
    public void setCustomerTaxClassification6( @Nullable final String customerTaxClassification6 )
    {
        rememberChangedField("CustomerTaxClassification6", this.customerTaxClassification6);
        this.customerTaxClassification6 = customerTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification7</b>
     * </p>
     *
     * @param customerTaxClassification7
     *            Tax Classification 7 for Customer
     */
    public void setCustomerTaxClassification7( @Nullable final String customerTaxClassification7 )
    {
        rememberChangedField("CustomerTaxClassification7", this.customerTaxClassification7);
        this.customerTaxClassification7 = customerTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification8</b>
     * </p>
     *
     * @param customerTaxClassification8
     *            Tax Classification 8 for Customer
     */
    public void setCustomerTaxClassification8( @Nullable final String customerTaxClassification8 )
    {
        rememberChangedField("CustomerTaxClassification8", this.customerTaxClassification8);
        this.customerTaxClassification8 = customerTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification9</b>
     * </p>
     *
     * @param customerTaxClassification9
     *            Tax Classification 9 for Customer
     */
    public void setCustomerTaxClassification9( @Nullable final String customerTaxClassification9 )
    {
        rememberChangedField("CustomerTaxClassification9", this.customerTaxClassification9);
        this.customerTaxClassification9 = customerTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxDepartureCountry</b>
     * </p>
     *
     * @param taxDepartureCountry
     *            Tax Departure Country/Region
     */
    public void setTaxDepartureCountry( @Nullable final String taxDepartureCountry )
    {
        rememberChangedField("TaxDepartureCountry", this.taxDepartureCountry);
        this.taxDepartureCountry = taxDepartureCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistrationCountry</b>
     * </p>
     *
     * @param vATRegistrationCountry
     *            Tax Destination Country/Region
     */
    public void setVATRegistrationCountry( @Nullable final String vATRegistrationCountry )
    {
        rememberChangedField("VATRegistrationCountry", this.vATRegistrationCountry);
        this.vATRegistrationCountry = vATRegistrationCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderApprovalReason</b>
     * </p>
     *
     * @param salesOrderApprovalReason
     *            Approval Request Reason ID
     */
    public void setSalesOrderApprovalReason( @Nullable final String salesOrderApprovalReason )
    {
        rememberChangedField("SalesOrderApprovalReason", this.salesOrderApprovalReason);
        this.salesOrderApprovalReason = salesOrderApprovalReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocApprovalStatus</b>
     * </p>
     *
     * @param salesDocApprovalStatus
     *            Document Approval Status
     */
    public void setSalesDocApprovalStatus( @Nullable final String salesDocApprovalStatus )
    {
        rememberChangedField("SalesDocApprovalStatus", this.salesDocApprovalStatus);
        this.salesDocApprovalStatus = salesDocApprovalStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @param overallSDProcessStatus
     *            Overall Processing Status (Header/All Items)
     */
    public void setOverallSDProcessStatus( @Nullable final String overallSDProcessStatus )
    {
        rememberChangedField("OverallSDProcessStatus", this.overallSDProcessStatus);
        this.overallSDProcessStatus = overallSDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalCreditCheckStatus</b>
     * </p>
     *
     * @param totalCreditCheckStatus
     *            Overall Status of Credit Checks
     */
    public void setTotalCreditCheckStatus( @Nullable final String totalCreditCheckStatus )
    {
        rememberChangedField("TotalCreditCheckStatus", this.totalCreditCheckStatus);
        this.totalCreditCheckStatus = totalCreditCheckStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallTotalDeliveryStatus</b>
     * </p>
     *
     * @param overallTotalDeliveryStatus
     *            Overall Delivery Status (All Items)
     */
    public void setOverallTotalDeliveryStatus( @Nullable final String overallTotalDeliveryStatus )
    {
        rememberChangedField("OverallTotalDeliveryStatus", this.overallTotalDeliveryStatus);
        this.overallTotalDeliveryStatus = overallTotalDeliveryStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDDocumentRejectionSts</b>
     * </p>
     *
     * @param overallSDDocumentRejectionSts
     *            Rejection Status (All Items)
     */
    public void setOverallSDDocumentRejectionSts( @Nullable final String overallSDDocumentRejectionSts )
    {
        rememberChangedField("OverallSDDocumentRejectionSts", this.overallSDDocumentRejectionSts);
        this.overallSDDocumentRejectionSts = overallSDDocumentRejectionSts;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentDate</b>
     * </p>
     *
     * @param billingDocumentDate
     *            Billing Date
     */
    public void setBillingDocumentDate( @Nullable final LocalDateTime billingDocumentDate )
    {
        rememberChangedField("BillingDocumentDate", this.billingDocumentDate);
        this.billingDocumentDate = billingDocumentDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     *
     * @param contractAccount
     *            Contract Account Number
     */
    public void setContractAccount( @Nullable final String contractAccount )
    {
        rememberChangedField("ContractAccount", this.contractAccount);
        this.contractAccount = contractAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @param additionalValueDays
     *            Additional Value Days
     */
    public void setAdditionalValueDays( @Nullable final String additionalValueDays )
    {
        rememberChangedField("AdditionalValueDays", this.additionalValueDays);
        this.additionalValueDays = additionalValueDays;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderSuplmnt</b>
     * </p>
     *
     * @param customerPurchaseOrderSuplmnt
     *            Purchase order number supplement
     */
    public void setCustomerPurchaseOrderSuplmnt( @Nullable final String customerPurchaseOrderSuplmnt )
    {
        rememberChangedField("CustomerPurchaseOrderSuplmnt", this.customerPurchaseOrderSuplmnt);
        this.customerPurchaseOrderSuplmnt = customerPurchaseOrderSuplmnt;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @param servicesRenderedDate
     *            Date on which services are rendered
     */
    public void setServicesRenderedDate( @Nullable final LocalDateTime servicesRenderedDate )
    {
        rememberChangedField("ServicesRenderedDate", this.servicesRenderedDate);
        this.servicesRenderedDate = servicesRenderedDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrder";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderType", getSalesOrderType());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("SalesGroup", getSalesGroup());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("SoldToParty", getSoldToParty());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("SenderBusinessSystemName", getSenderBusinessSystemName());
        values.put("ExternalDocumentID", getExternalDocumentID());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("ExternalDocLastChangeDateTime", getExternalDocLastChangeDateTime());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("PurchaseOrderByShipToParty", getPurchaseOrderByShipToParty());
        values.put("CustomerPurchaseOrderType", getCustomerPurchaseOrderType());
        values.put("CustomerPurchaseOrderDate", getCustomerPurchaseOrderDate());
        values.put("SalesOrderDate", getSalesOrderDate());
        values.put("TotalNetAmount", getTotalNetAmount());
        values.put("OverallDeliveryStatus", getOverallDeliveryStatus());
        values.put("TotalBlockStatus", getTotalBlockStatus());
        values.put("OverallOrdReltdBillgStatus", getOverallOrdReltdBillgStatus());
        values.put("OverallSDDocReferenceStatus", getOverallSDDocReferenceStatus());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("SDDocumentReason", getSDDocumentReason());
        values.put("PricingDate", getPricingDate());
        values.put("PriceDetnExchangeRate", getPriceDetnExchangeRate());
        values.put("BillingPlan", getBillingPlan());
        values.put("RequestedDeliveryDate", getRequestedDeliveryDate());
        values.put("ShippingCondition", getShippingCondition());
        values.put("CompleteDeliveryIsDefined", getCompleteDeliveryIsDefined());
        values.put("ShippingType", getShippingType());
        values.put("HeaderBillingBlockReason", getHeaderBillingBlockReason());
        values.put("DeliveryBlockReason", getDeliveryBlockReason());
        values.put("DeliveryDateTypeRule", getDeliveryDateTypeRule());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("CustomerPriceGroup", getCustomerPriceGroup());
        values.put("PriceListType", getPriceListType());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("PaymentMethod", getPaymentMethod());
        values.put("FixedValueDate", getFixedValueDate());
        values.put("AssignmentReference", getAssignmentReference());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentCategory", getReferenceSDDocumentCategory());
        values.put("AccountingDocExternalReference", getAccountingDocExternalReference());
        values.put("CustomerAccountAssignmentGroup", getCustomerAccountAssignmentGroup());
        values.put("AccountingExchangeRate", getAccountingExchangeRate());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("AdditionalCustomerGroup1", getAdditionalCustomerGroup1());
        values.put("AdditionalCustomerGroup2", getAdditionalCustomerGroup2());
        values.put("AdditionalCustomerGroup3", getAdditionalCustomerGroup3());
        values.put("AdditionalCustomerGroup4", getAdditionalCustomerGroup4());
        values.put("AdditionalCustomerGroup5", getAdditionalCustomerGroup5());
        values.put("SlsDocIsRlvtForProofOfDeliv", getSlsDocIsRlvtForProofOfDeliv());
        values.put("CustomerTaxClassification1", getCustomerTaxClassification1());
        values.put("CustomerTaxClassification2", getCustomerTaxClassification2());
        values.put("CustomerTaxClassification3", getCustomerTaxClassification3());
        values.put("CustomerTaxClassification4", getCustomerTaxClassification4());
        values.put("CustomerTaxClassification5", getCustomerTaxClassification5());
        values.put("CustomerTaxClassification6", getCustomerTaxClassification6());
        values.put("CustomerTaxClassification7", getCustomerTaxClassification7());
        values.put("CustomerTaxClassification8", getCustomerTaxClassification8());
        values.put("CustomerTaxClassification9", getCustomerTaxClassification9());
        values.put("TaxDepartureCountry", getTaxDepartureCountry());
        values.put("VATRegistrationCountry", getVATRegistrationCountry());
        values.put("SalesOrderApprovalReason", getSalesOrderApprovalReason());
        values.put("SalesDocApprovalStatus", getSalesDocApprovalStatus());
        values.put("OverallSDProcessStatus", getOverallSDProcessStatus());
        values.put("TotalCreditCheckStatus", getTotalCreditCheckStatus());
        values.put("OverallTotalDeliveryStatus", getOverallTotalDeliveryStatus());
        values.put("OverallSDDocumentRejectionSts", getOverallSDDocumentRejectionSts());
        values.put("BillingDocumentDate", getBillingDocumentDate());
        values.put("ContractAccount", getContractAccount());
        values.put("AdditionalValueDays", getAdditionalValueDays());
        values.put("CustomerPurchaseOrderSuplmnt", getCustomerPurchaseOrderSuplmnt());
        values.put("ServicesRenderedDate", getServicesRenderedDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderType") ) {
                final Object value = values.remove("SalesOrderType");
                if( (value == null) || (!value.equals(getSalesOrderType())) ) {
                    setSalesOrderType(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SenderBusinessSystemName") ) {
                final Object value = values.remove("SenderBusinessSystemName");
                if( (value == null) || (!value.equals(getSenderBusinessSystemName())) ) {
                    setSenderBusinessSystemName(((String) value));
                }
            }
            if( values.containsKey("ExternalDocumentID") ) {
                final Object value = values.remove("ExternalDocumentID");
                if( (value == null) || (!value.equals(getExternalDocumentID())) ) {
                    setExternalDocumentID(((String) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ExternalDocLastChangeDateTime") ) {
                final Object value = values.remove("ExternalDocLastChangeDateTime");
                if( (value == null) || (!value.equals(getExternalDocLastChangeDateTime())) ) {
                    setExternalDocLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByShipToParty") ) {
                final Object value = values.remove("PurchaseOrderByShipToParty");
                if( (value == null) || (!value.equals(getPurchaseOrderByShipToParty())) ) {
                    setPurchaseOrderByShipToParty(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderType") ) {
                final Object value = values.remove("CustomerPurchaseOrderType");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderType())) ) {
                    setCustomerPurchaseOrderType(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderDate") ) {
                final Object value = values.remove("CustomerPurchaseOrderDate");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderDate())) ) {
                    setCustomerPurchaseOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SalesOrderDate") ) {
                final Object value = values.remove("SalesOrderDate");
                if( (value == null) || (!value.equals(getSalesOrderDate())) ) {
                    setSalesOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TotalNetAmount") ) {
                final Object value = values.remove("TotalNetAmount");
                if( (value == null) || (!value.equals(getTotalNetAmount())) ) {
                    setTotalNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("OverallDeliveryStatus") ) {
                final Object value = values.remove("OverallDeliveryStatus");
                if( (value == null) || (!value.equals(getOverallDeliveryStatus())) ) {
                    setOverallDeliveryStatus(((String) value));
                }
            }
            if( values.containsKey("TotalBlockStatus") ) {
                final Object value = values.remove("TotalBlockStatus");
                if( (value == null) || (!value.equals(getTotalBlockStatus())) ) {
                    setTotalBlockStatus(((String) value));
                }
            }
            if( values.containsKey("OverallOrdReltdBillgStatus") ) {
                final Object value = values.remove("OverallOrdReltdBillgStatus");
                if( (value == null) || (!value.equals(getOverallOrdReltdBillgStatus())) ) {
                    setOverallOrdReltdBillgStatus(((String) value));
                }
            }
            if( values.containsKey("OverallSDDocReferenceStatus") ) {
                final Object value = values.remove("OverallSDDocReferenceStatus");
                if( (value == null) || (!value.equals(getOverallSDDocReferenceStatus())) ) {
                    setOverallSDDocReferenceStatus(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("SDDocumentReason") ) {
                final Object value = values.remove("SDDocumentReason");
                if( (value == null) || (!value.equals(getSDDocumentReason())) ) {
                    setSDDocumentReason(((String) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PriceDetnExchangeRate") ) {
                final Object value = values.remove("PriceDetnExchangeRate");
                if( (value == null) || (!value.equals(getPriceDetnExchangeRate())) ) {
                    setPriceDetnExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("BillingPlan") ) {
                final Object value = values.remove("BillingPlan");
                if( (value == null) || (!value.equals(getBillingPlan())) ) {
                    setBillingPlan(((String) value));
                }
            }
            if( values.containsKey("RequestedDeliveryDate") ) {
                final Object value = values.remove("RequestedDeliveryDate");
                if( (value == null) || (!value.equals(getRequestedDeliveryDate())) ) {
                    setRequestedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("CompleteDeliveryIsDefined") ) {
                final Object value = values.remove("CompleteDeliveryIsDefined");
                if( (value == null) || (!value.equals(getCompleteDeliveryIsDefined())) ) {
                    setCompleteDeliveryIsDefined(((Boolean) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("HeaderBillingBlockReason") ) {
                final Object value = values.remove("HeaderBillingBlockReason");
                if( (value == null) || (!value.equals(getHeaderBillingBlockReason())) ) {
                    setHeaderBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("DeliveryBlockReason") ) {
                final Object value = values.remove("DeliveryBlockReason");
                if( (value == null) || (!value.equals(getDeliveryBlockReason())) ) {
                    setDeliveryBlockReason(((String) value));
                }
            }
            if( values.containsKey("DeliveryDateTypeRule") ) {
                final Object value = values.remove("DeliveryDateTypeRule");
                if( (value == null) || (!value.equals(getDeliveryDateTypeRule())) ) {
                    setDeliveryDateTypeRule(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("CustomerPriceGroup") ) {
                final Object value = values.remove("CustomerPriceGroup");
                if( (value == null) || (!value.equals(getCustomerPriceGroup())) ) {
                    setCustomerPriceGroup(((String) value));
                }
            }
            if( values.containsKey("PriceListType") ) {
                final Object value = values.remove("PriceListType");
                if( (value == null) || (!value.equals(getPriceListType())) ) {
                    setPriceListType(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
            if( values.containsKey("FixedValueDate") ) {
                final Object value = values.remove("FixedValueDate");
                if( (value == null) || (!value.equals(getFixedValueDate())) ) {
                    setFixedValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AssignmentReference") ) {
                final Object value = values.remove("AssignmentReference");
                if( (value == null) || (!value.equals(getAssignmentReference())) ) {
                    setAssignmentReference(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentCategory") ) {
                final Object value = values.remove("ReferenceSDDocumentCategory");
                if( (value == null) || (!value.equals(getReferenceSDDocumentCategory())) ) {
                    setReferenceSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("AccountingDocExternalReference") ) {
                final Object value = values.remove("AccountingDocExternalReference");
                if( (value == null) || (!value.equals(getAccountingDocExternalReference())) ) {
                    setAccountingDocExternalReference(((String) value));
                }
            }
            if( values.containsKey("CustomerAccountAssignmentGroup") ) {
                final Object value = values.remove("CustomerAccountAssignmentGroup");
                if( (value == null) || (!value.equals(getCustomerAccountAssignmentGroup())) ) {
                    setCustomerAccountAssignmentGroup(((String) value));
                }
            }
            if( values.containsKey("AccountingExchangeRate") ) {
                final Object value = values.remove("AccountingExchangeRate");
                if( (value == null) || (!value.equals(getAccountingExchangeRate())) ) {
                    setAccountingExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup1") ) {
                final Object value = values.remove("AdditionalCustomerGroup1");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup1())) ) {
                    setAdditionalCustomerGroup1(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup2") ) {
                final Object value = values.remove("AdditionalCustomerGroup2");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup2())) ) {
                    setAdditionalCustomerGroup2(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup3") ) {
                final Object value = values.remove("AdditionalCustomerGroup3");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup3())) ) {
                    setAdditionalCustomerGroup3(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup4") ) {
                final Object value = values.remove("AdditionalCustomerGroup4");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup4())) ) {
                    setAdditionalCustomerGroup4(((String) value));
                }
            }
            if( values.containsKey("AdditionalCustomerGroup5") ) {
                final Object value = values.remove("AdditionalCustomerGroup5");
                if( (value == null) || (!value.equals(getAdditionalCustomerGroup5())) ) {
                    setAdditionalCustomerGroup5(((String) value));
                }
            }
            if( values.containsKey("SlsDocIsRlvtForProofOfDeliv") ) {
                final Object value = values.remove("SlsDocIsRlvtForProofOfDeliv");
                if( (value == null) || (!value.equals(getSlsDocIsRlvtForProofOfDeliv())) ) {
                    setSlsDocIsRlvtForProofOfDeliv(((Boolean) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification1") ) {
                final Object value = values.remove("CustomerTaxClassification1");
                if( (value == null) || (!value.equals(getCustomerTaxClassification1())) ) {
                    setCustomerTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification2") ) {
                final Object value = values.remove("CustomerTaxClassification2");
                if( (value == null) || (!value.equals(getCustomerTaxClassification2())) ) {
                    setCustomerTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification3") ) {
                final Object value = values.remove("CustomerTaxClassification3");
                if( (value == null) || (!value.equals(getCustomerTaxClassification3())) ) {
                    setCustomerTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification4") ) {
                final Object value = values.remove("CustomerTaxClassification4");
                if( (value == null) || (!value.equals(getCustomerTaxClassification4())) ) {
                    setCustomerTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification5") ) {
                final Object value = values.remove("CustomerTaxClassification5");
                if( (value == null) || (!value.equals(getCustomerTaxClassification5())) ) {
                    setCustomerTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification6") ) {
                final Object value = values.remove("CustomerTaxClassification6");
                if( (value == null) || (!value.equals(getCustomerTaxClassification6())) ) {
                    setCustomerTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification7") ) {
                final Object value = values.remove("CustomerTaxClassification7");
                if( (value == null) || (!value.equals(getCustomerTaxClassification7())) ) {
                    setCustomerTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification8") ) {
                final Object value = values.remove("CustomerTaxClassification8");
                if( (value == null) || (!value.equals(getCustomerTaxClassification8())) ) {
                    setCustomerTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification9") ) {
                final Object value = values.remove("CustomerTaxClassification9");
                if( (value == null) || (!value.equals(getCustomerTaxClassification9())) ) {
                    setCustomerTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("TaxDepartureCountry") ) {
                final Object value = values.remove("TaxDepartureCountry");
                if( (value == null) || (!value.equals(getTaxDepartureCountry())) ) {
                    setTaxDepartureCountry(((String) value));
                }
            }
            if( values.containsKey("VATRegistrationCountry") ) {
                final Object value = values.remove("VATRegistrationCountry");
                if( (value == null) || (!value.equals(getVATRegistrationCountry())) ) {
                    setVATRegistrationCountry(((String) value));
                }
            }
            if( values.containsKey("SalesOrderApprovalReason") ) {
                final Object value = values.remove("SalesOrderApprovalReason");
                if( (value == null) || (!value.equals(getSalesOrderApprovalReason())) ) {
                    setSalesOrderApprovalReason(((String) value));
                }
            }
            if( values.containsKey("SalesDocApprovalStatus") ) {
                final Object value = values.remove("SalesDocApprovalStatus");
                if( (value == null) || (!value.equals(getSalesDocApprovalStatus())) ) {
                    setSalesDocApprovalStatus(((String) value));
                }
            }
            if( values.containsKey("OverallSDProcessStatus") ) {
                final Object value = values.remove("OverallSDProcessStatus");
                if( (value == null) || (!value.equals(getOverallSDProcessStatus())) ) {
                    setOverallSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("TotalCreditCheckStatus") ) {
                final Object value = values.remove("TotalCreditCheckStatus");
                if( (value == null) || (!value.equals(getTotalCreditCheckStatus())) ) {
                    setTotalCreditCheckStatus(((String) value));
                }
            }
            if( values.containsKey("OverallTotalDeliveryStatus") ) {
                final Object value = values.remove("OverallTotalDeliveryStatus");
                if( (value == null) || (!value.equals(getOverallTotalDeliveryStatus())) ) {
                    setOverallTotalDeliveryStatus(((String) value));
                }
            }
            if( values.containsKey("OverallSDDocumentRejectionSts") ) {
                final Object value = values.remove("OverallSDDocumentRejectionSts");
                if( (value == null) || (!value.equals(getOverallSDDocumentRejectionSts())) ) {
                    setOverallSDDocumentRejectionSts(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentDate") ) {
                final Object value = values.remove("BillingDocumentDate");
                if( (value == null) || (!value.equals(getBillingDocumentDate())) ) {
                    setBillingDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ContractAccount") ) {
                final Object value = values.remove("ContractAccount");
                if( (value == null) || (!value.equals(getContractAccount())) ) {
                    setContractAccount(((String) value));
                }
            }
            if( values.containsKey("AdditionalValueDays") ) {
                final Object value = values.remove("AdditionalValueDays");
                if( (value == null) || (!value.equals(getAdditionalValueDays())) ) {
                    setAdditionalValueDays(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderSuplmnt") ) {
                final Object value = values.remove("CustomerPurchaseOrderSuplmnt");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderSuplmnt())) ) {
                    setCustomerPurchaseOrderSuplmnt(((String) value));
                }
            }
            if( values.containsKey("ServicesRenderedDate") ) {
                final Object value = values.remove("ServicesRenderedDate");
                if( (value == null) || (!value.equals(getServicesRenderedDate())) ) {
                    setServicesRenderedDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingPlan") ) {
                final Object value = (values).remove("to_BillingPlan");
                if( value instanceof Map ) {
                    if( toBillingPlan == null ) {
                        toBillingPlan = new SalesOrderBillingPlan();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillingPlan.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new SalesOrderItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderHeaderPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SalesOrderHeaderPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PaymentPlanItemDetails") ) {
                final Object value = (values).remove("to_PaymentPlanItemDetails");
                if( value instanceof Iterable ) {
                    if( toPaymentPlanItemDetails == null ) {
                        toPaymentPlanItemDetails = Lists.newArrayList();
                    } else {
                        toPaymentPlanItemDetails = Lists.newArrayList(toPaymentPlanItemDetails);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsOrdPaymentPlanItemDetails entity;
                        if( toPaymentPlanItemDetails.size() > i ) {
                            entity = toPaymentPlanItemDetails.get(i);
                        } else {
                            entity = new SlsOrdPaymentPlanItemDetails();
                            toPaymentPlanItemDetails.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PrecedingProcFlowDoc") ) {
                final Object value = (values).remove("to_PrecedingProcFlowDoc");
                if( value instanceof Iterable ) {
                    if( toPrecedingProcFlowDoc == null ) {
                        toPrecedingProcFlowDoc = Lists.newArrayList();
                    } else {
                        toPrecedingProcFlowDoc = Lists.newArrayList(toPrecedingProcFlowDoc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderPrecdgProcFlow entity;
                        if( toPrecedingProcFlowDoc.size() > i ) {
                            entity = toPrecedingProcFlowDoc.get(i);
                        } else {
                            entity = new SalesOrderPrecdgProcFlow();
                            toPrecedingProcFlowDoc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderHeaderPrElement entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new SalesOrderHeaderPrElement();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RelatedObject") ) {
                final Object value = (values).remove("to_RelatedObject");
                if( value instanceof Iterable ) {
                    if( toRelatedObject == null ) {
                        toRelatedObject = Lists.newArrayList();
                    } else {
                        toRelatedObject = Lists.newArrayList(toRelatedObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderRelatedObject entity;
                        if( toRelatedObject.size() > i ) {
                            entity = toRelatedObject.get(i);
                        } else {
                            entity = new SalesOrderRelatedObject();
                            toRelatedObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SubsequentProcFlowDoc") ) {
                final Object value = (values).remove("to_SubsequentProcFlowDoc");
                if( value instanceof Iterable ) {
                    if( toSubsequentProcFlowDoc == null ) {
                        toSubsequentProcFlowDoc = Lists.newArrayList();
                    } else {
                        toSubsequentProcFlowDoc = Lists.newArrayList(toSubsequentProcFlowDoc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderSubsqntProcFlow entity;
                        if( toSubsequentProcFlowDoc.size() > i ) {
                            entity = toSubsequentProcFlowDoc.get(i);
                        } else {
                            entity = new SalesOrderSubsqntProcFlow();
                            toSubsequentProcFlowDoc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new SalesOrderText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SalesOrderField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingPlan != null ) {
            (values).put("to_BillingPlan", toBillingPlan);
        }
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPaymentPlanItemDetails != null ) {
            (values).put("to_PaymentPlanItemDetails", toPaymentPlanItemDetails);
        }
        if( toPrecedingProcFlowDoc != null ) {
            (values).put("to_PrecedingProcFlowDoc", toPrecedingProcFlowDoc);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toRelatedObject != null ) {
            (values).put("to_RelatedObject", toRelatedObject);
        }
        if( toSubsequentProcFlowDoc != null ) {
            (values).put("to_SubsequentProcFlowDoc", toSubsequentProcFlowDoc);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderBillingPlan</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BillingPlan</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderBillingPlan</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderBillingPlan fetchBillingPlan()
    {
        return fetchFieldAsSingle("to_BillingPlan", SalesOrderBillingPlan.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderBillingPlan</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingPlan</b>.
     * <p>
     * If the navigation property <b>to_BillingPlan</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderBillingPlan</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderBillingPlan getBillingPlanOrFetch()
    {
        if( toBillingPlan == null ) {
            toBillingPlan = fetchBillingPlan();
        }
        return toBillingPlan;
    }

    /**
     * Retrieval of associated <b>SalesOrderBillingPlan</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingPlan</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingPlan</b> is already loaded, the result will
     *         contain the <b>SalesOrderBillingPlan</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderBillingPlan> getBillingPlanIfPresent()
    {
        return Option.of(toBillingPlan);
    }

    /**
     * Overwrites the associated <b>SalesOrderBillingPlan</b> entity for the loaded navigation property
     * <b>to_BillingPlan</b>.
     *
     * @param value
     *            New <b>SalesOrderBillingPlan</b> entity.
     */
    public void setBillingPlan( final SalesOrderBillingPlan value )
    {
        toBillingPlan = value;
    }

    /**
     * Fetches the <b>SalesOrderItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItem</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", SalesOrderItem.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>SalesOrderItem</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<SalesOrderItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItem</b> entities.
     */
    public void setItem( @Nonnull final List<SalesOrderItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItem</b> entities. This corresponds to the OData navigation
     * property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItem</b> entities.
     */
    public void addItem( SalesOrderItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderHeaderPartner</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderHeaderPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderHeaderPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SalesOrderHeaderPartner.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderHeaderPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderHeaderPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderHeaderPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SalesOrderHeaderPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SalesOrderHeaderPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderHeaderPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderHeaderPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderHeaderPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SalesOrderHeaderPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderHeaderPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderHeaderPartner</b> entities.
     */
    public void addPartner( SalesOrderHeaderPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SlsOrdPaymentPlanItemDetails</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PaymentPlanItemDetails</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsOrdPaymentPlanItemDetails</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdPaymentPlanItemDetails> fetchPaymentPlanItemDetails()
    {
        return fetchFieldAsList("to_PaymentPlanItemDetails", SlsOrdPaymentPlanItemDetails.class);
    }

    /**
     * Retrieval of associated <b>SlsOrdPaymentPlanItemDetails</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PaymentPlanItemDetails</b>.
     * <p>
     * If the navigation property <b>to_PaymentPlanItemDetails</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsOrdPaymentPlanItemDetails</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdPaymentPlanItemDetails> getPaymentPlanItemDetailsOrFetch()
    {
        if( toPaymentPlanItemDetails == null ) {
            toPaymentPlanItemDetails = fetchPaymentPlanItemDetails();
        }
        return toPaymentPlanItemDetails;
    }

    /**
     * Retrieval of associated <b>SlsOrdPaymentPlanItemDetails</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PaymentPlanItemDetails</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PaymentPlanItemDetails</b> is already loaded, the result
     *         will contain the <b>SlsOrdPaymentPlanItemDetails</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsOrdPaymentPlanItemDetails>> getPaymentPlanItemDetailsIfPresent()
    {
        return Option.of(toPaymentPlanItemDetails);
    }

    /**
     * Overwrites the list of associated <b>SlsOrdPaymentPlanItemDetails</b> entities for the loaded navigation property
     * <b>to_PaymentPlanItemDetails</b>.
     * <p>
     * If the navigation property <b>to_PaymentPlanItemDetails</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsOrdPaymentPlanItemDetails</b> entities.
     */
    public void setPaymentPlanItemDetails( @Nonnull final List<SlsOrdPaymentPlanItemDetails> value )
    {
        if( toPaymentPlanItemDetails == null ) {
            toPaymentPlanItemDetails = Lists.newArrayList();
        }
        toPaymentPlanItemDetails.clear();
        toPaymentPlanItemDetails.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsOrdPaymentPlanItemDetails</b> entities. This corresponds to the
     * OData navigation property <b>to_PaymentPlanItemDetails</b>.
     * <p>
     * If the navigation property <b>to_PaymentPlanItemDetails</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsOrdPaymentPlanItemDetails</b> entities.
     */
    public void addPaymentPlanItemDetails( SlsOrdPaymentPlanItemDetails... entity )
    {
        if( toPaymentPlanItemDetails == null ) {
            toPaymentPlanItemDetails = Lists.newArrayList();
        }
        toPaymentPlanItemDetails.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderPrecdgProcFlow</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PrecedingProcFlowDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderPrecdgProcFlow</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderPrecdgProcFlow> fetchPrecedingProcFlowDoc()
    {
        return fetchFieldAsList("to_PrecedingProcFlowDoc", SalesOrderPrecdgProcFlow.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderPrecdgProcFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PrecedingProcFlowDoc</b>.
     * <p>
     * If the navigation property <b>to_PrecedingProcFlowDoc</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderPrecdgProcFlow</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderPrecdgProcFlow> getPrecedingProcFlowDocOrFetch()
    {
        if( toPrecedingProcFlowDoc == null ) {
            toPrecedingProcFlowDoc = fetchPrecedingProcFlowDoc();
        }
        return toPrecedingProcFlowDoc;
    }

    /**
     * Retrieval of associated <b>SalesOrderPrecdgProcFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PrecedingProcFlowDoc</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PrecedingProcFlowDoc</b> is already loaded, the result
     *         will contain the <b>SalesOrderPrecdgProcFlow</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderPrecdgProcFlow>> getPrecedingProcFlowDocIfPresent()
    {
        return Option.of(toPrecedingProcFlowDoc);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderPrecdgProcFlow</b> entities for the loaded navigation property
     * <b>to_PrecedingProcFlowDoc</b>.
     * <p>
     * If the navigation property <b>to_PrecedingProcFlowDoc</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderPrecdgProcFlow</b> entities.
     */
    public void setPrecedingProcFlowDoc( @Nonnull final List<SalesOrderPrecdgProcFlow> value )
    {
        if( toPrecedingProcFlowDoc == null ) {
            toPrecedingProcFlowDoc = Lists.newArrayList();
        }
        toPrecedingProcFlowDoc.clear();
        toPrecedingProcFlowDoc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderPrecdgProcFlow</b> entities. This corresponds to the OData
     * navigation property <b>to_PrecedingProcFlowDoc</b>.
     * <p>
     * If the navigation property <b>to_PrecedingProcFlowDoc</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderPrecdgProcFlow</b> entities.
     */
    public void addPrecedingProcFlowDoc( SalesOrderPrecdgProcFlow... entity )
    {
        if( toPrecedingProcFlowDoc == null ) {
            toPrecedingProcFlowDoc = Lists.newArrayList();
        }
        toPrecedingProcFlowDoc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderHeaderPrElement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderHeaderPrElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderHeaderPrElement> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", SalesOrderHeaderPrElement.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderHeaderPrElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderHeaderPrElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderHeaderPrElement> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>SalesOrderHeaderPrElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>SalesOrderHeaderPrElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderHeaderPrElement>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderHeaderPrElement</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderHeaderPrElement</b> entities.
     */
    public void setPricingElement( @Nonnull final List<SalesOrderHeaderPrElement> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderHeaderPrElement</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderHeaderPrElement</b> entities.
     */
    public void addPricingElement( SalesOrderHeaderPrElement... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderRelatedObject</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RelatedObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderRelatedObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderRelatedObject> fetchRelatedObject()
    {
        return fetchFieldAsList("to_RelatedObject", SalesOrderRelatedObject.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderRelatedObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderRelatedObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderRelatedObject> getRelatedObjectOrFetch()
    {
        if( toRelatedObject == null ) {
            toRelatedObject = fetchRelatedObject();
        }
        return toRelatedObject;
    }

    /**
     * Retrieval of associated <b>SalesOrderRelatedObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RelatedObject</b> is already loaded, the result will
     *         contain the <b>SalesOrderRelatedObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderRelatedObject>> getRelatedObjectIfPresent()
    {
        return Option.of(toRelatedObject);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderRelatedObject</b> entities for the loaded navigation property
     * <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderRelatedObject</b> entities.
     */
    public void setRelatedObject( @Nonnull final List<SalesOrderRelatedObject> value )
    {
        if( toRelatedObject == null ) {
            toRelatedObject = Lists.newArrayList();
        }
        toRelatedObject.clear();
        toRelatedObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderRelatedObject</b> entities. This corresponds to the OData
     * navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderRelatedObject</b> entities.
     */
    public void addRelatedObject( SalesOrderRelatedObject... entity )
    {
        if( toRelatedObject == null ) {
            toRelatedObject = Lists.newArrayList();
        }
        toRelatedObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderSubsqntProcFlow</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SubsequentProcFlowDoc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderSubsqntProcFlow</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderSubsqntProcFlow> fetchSubsequentProcFlowDoc()
    {
        return fetchFieldAsList("to_SubsequentProcFlowDoc", SalesOrderSubsqntProcFlow.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderSubsqntProcFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubsequentProcFlowDoc</b>.
     * <p>
     * If the navigation property <b>to_SubsequentProcFlowDoc</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderSubsqntProcFlow</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderSubsqntProcFlow> getSubsequentProcFlowDocOrFetch()
    {
        if( toSubsequentProcFlowDoc == null ) {
            toSubsequentProcFlowDoc = fetchSubsequentProcFlowDoc();
        }
        return toSubsequentProcFlowDoc;
    }

    /**
     * Retrieval of associated <b>SalesOrderSubsqntProcFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubsequentProcFlowDoc</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubsequentProcFlowDoc</b> is already loaded, the result
     *         will contain the <b>SalesOrderSubsqntProcFlow</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderSubsqntProcFlow>> getSubsequentProcFlowDocIfPresent()
    {
        return Option.of(toSubsequentProcFlowDoc);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderSubsqntProcFlow</b> entities for the loaded navigation property
     * <b>to_SubsequentProcFlowDoc</b>.
     * <p>
     * If the navigation property <b>to_SubsequentProcFlowDoc</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderSubsqntProcFlow</b> entities.
     */
    public void setSubsequentProcFlowDoc( @Nonnull final List<SalesOrderSubsqntProcFlow> value )
    {
        if( toSubsequentProcFlowDoc == null ) {
            toSubsequentProcFlowDoc = Lists.newArrayList();
        }
        toSubsequentProcFlowDoc.clear();
        toSubsequentProcFlowDoc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderSubsqntProcFlow</b> entities. This corresponds to the OData
     * navigation property <b>to_SubsequentProcFlowDoc</b>.
     * <p>
     * If the navigation property <b>to_SubsequentProcFlowDoc</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderSubsqntProcFlow</b> entities.
     */
    public void addSubsequentProcFlowDoc( SalesOrderSubsqntProcFlow... entity )
    {
        if( toSubsequentProcFlowDoc == null ) {
            toSubsequentProcFlowDoc = Lists.newArrayList();
        }
        toSubsequentProcFlowDoc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderText> fetchText()
    {
        return fetchFieldAsList("to_Text", SalesOrderText.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>SalesOrderText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrder</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>SalesOrderText</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<SalesOrderText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderText</b> entities.
     */
    public void setText( @Nonnull final List<SalesOrderText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderText</b> entities. This corresponds to the OData navigation
     * property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrder</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderText</b> entities.
     */
    public void addText( SalesOrderText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesOrder instances.
     *
     */
    public final static class SalesOrderBuilder
    {

        private SalesOrderBillingPlan toBillingPlan;
        private String billingPlan = null;
        private List<SalesOrderItem> toItem = Lists.newArrayList();
        private List<SalesOrderHeaderPartner> toPartner = Lists.newArrayList();
        private List<SlsOrdPaymentPlanItemDetails> toPaymentPlanItemDetails = Lists.newArrayList();
        private List<SalesOrderPrecdgProcFlow> toPrecedingProcFlowDoc = Lists.newArrayList();
        private List<SalesOrderHeaderPrElement> toPricingElement = Lists.newArrayList();
        private List<SalesOrderRelatedObject> toRelatedObject = Lists.newArrayList();
        private List<SalesOrderSubsqntProcFlow> toSubsequentProcFlowDoc = Lists.newArrayList();
        private List<SalesOrderText> toText = Lists.newArrayList();

        private SalesOrder.SalesOrderBuilder toBillingPlan( final SalesOrderBillingPlan value )
        {
            toBillingPlan = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillingPlan</b> for <b>SalesOrder</b> to single <b>SalesOrderBillingPlan</b>.
         *
         * @param value
         *            The SalesOrderBillingPlan to build this SalesOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrder.SalesOrderBuilder billingPlan( final SalesOrderBillingPlan value )
        {
            return toBillingPlan(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BillingPlan</b>
         * </p>
         *
         * @param value
         *            The billingPlan to build this SalesOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrder.SalesOrderBuilder billingPlan( final String value )
        {
            billingPlan = value;
            return this;
        }

        private SalesOrder.SalesOrderBuilder toItem( final List<SalesOrderItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>SalesOrder</b> to multiple <b>SalesOrderItem</b>.
         *
         * @param value
         *            The SalesOrderItems to build this SalesOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrder.SalesOrderBuilder item( SalesOrderItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private SalesOrder.SalesOrderBuilder toPartner( final List<SalesOrderHeaderPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>SalesOrder</b> to multiple <b>SalesOrderHeaderPartner</b>.
         *
         * @param value
         *            The SalesOrderHeaderPartners to build this SalesOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrder.SalesOrderBuilder partner( SalesOrderHeaderPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private SalesOrder.SalesOrderBuilder toPaymentPlanItemDetails( final List<SlsOrdPaymentPlanItemDetails> value )
        {
            toPaymentPlanItemDetails.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PaymentPlanItemDetails</b> for <b>SalesOrder</b> to multiple
         * <b>SlsOrdPaymentPlanItemDetails</b>.
         *
         * @param value
         *            The SlsOrdPaymentPlanItemDetailss to build this SalesOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrder.SalesOrderBuilder paymentPlanItemDetails( SlsOrdPaymentPlanItemDetails... value )
        {
            return toPaymentPlanItemDetails(Lists.newArrayList(value));
        }

        private SalesOrder.SalesOrderBuilder toPrecedingProcFlowDoc( final List<SalesOrderPrecdgProcFlow> value )
        {
            toPrecedingProcFlowDoc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PrecedingProcFlowDoc</b> for <b>SalesOrder</b> to multiple
         * <b>SalesOrderPrecdgProcFlow</b>.
         *
         * @param value
         *            The SalesOrderPrecdgProcFlows to build this SalesOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrder.SalesOrderBuilder precedingProcFlowDoc( SalesOrderPrecdgProcFlow... value )
        {
            return toPrecedingProcFlowDoc(Lists.newArrayList(value));
        }

        private SalesOrder.SalesOrderBuilder toPricingElement( final List<SalesOrderHeaderPrElement> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>SalesOrder</b> to multiple
         * <b>SalesOrderHeaderPrElement</b>.
         *
         * @param value
         *            The SalesOrderHeaderPrElements to build this SalesOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrder.SalesOrderBuilder pricingElement( SalesOrderHeaderPrElement... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private SalesOrder.SalesOrderBuilder toRelatedObject( final List<SalesOrderRelatedObject> value )
        {
            toRelatedObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RelatedObject</b> for <b>SalesOrder</b> to multiple <b>SalesOrderRelatedObject</b>.
         *
         * @param value
         *            The SalesOrderRelatedObjects to build this SalesOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrder.SalesOrderBuilder relatedObject( SalesOrderRelatedObject... value )
        {
            return toRelatedObject(Lists.newArrayList(value));
        }

        private SalesOrder.SalesOrderBuilder toSubsequentProcFlowDoc( final List<SalesOrderSubsqntProcFlow> value )
        {
            toSubsequentProcFlowDoc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubsequentProcFlowDoc</b> for <b>SalesOrder</b> to multiple
         * <b>SalesOrderSubsqntProcFlow</b>.
         *
         * @param value
         *            The SalesOrderSubsqntProcFlows to build this SalesOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrder.SalesOrderBuilder subsequentProcFlowDoc( SalesOrderSubsqntProcFlow... value )
        {
            return toSubsequentProcFlowDoc(Lists.newArrayList(value));
        }

        private SalesOrder.SalesOrderBuilder toText( final List<SalesOrderText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>SalesOrder</b> to multiple <b>SalesOrderText</b>.
         *
         * @param value
         *            The SalesOrderTexts to build this SalesOrder with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrder.SalesOrderBuilder text( SalesOrderText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
