/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderBillingPlanItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderBillingPlanItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SalesOrderBillingPlanItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Billing Plan Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderBillingPlanItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderBillingPlanItem extends VdmEntity<SalesOrderBillingPlanItem>
{

    /**
     * Selector for all available fields of SalesOrderBillingPlanItem.
     *
     */
    public final static SalesOrderBillingPlanItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> SALES_ORDER =
        new SalesOrderBillingPlanItemField<String>("SalesOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @return Billing Plan Number / Invoicing Plan Number
     */
    @Key
    @SerializedName( "BillingPlan" )
    @JsonProperty( "BillingPlan" )
    @Nullable
    @ODataField( odataName = "BillingPlan" )
    private String billingPlan;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlan</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> BILLING_PLAN =
        new SalesOrderBillingPlanItemField<String>("BillingPlan");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItem</b>
     * </p>
     *
     * @return Item for billing plan/invoice plan/payment cards
     */
    @Key
    @SerializedName( "BillingPlanItem" )
    @JsonProperty( "BillingPlanItem" )
    @Nullable
    @ODataField( odataName = "BillingPlanItem" )
    private String billingPlanItem;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanItem</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> BILLING_PLAN_ITEM =
        new SalesOrderBillingPlanItemField<String>("BillingPlanItem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanDateCategory</b>
     * </p>
     *
     * @return Date Category
     */
    @SerializedName( "BillingPlanDateCategory" )
    @JsonProperty( "BillingPlanDateCategory" )
    @Nullable
    @ODataField( odataName = "BillingPlanDateCategory" )
    private String billingPlanDateCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanDateCategory</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> BILLING_PLAN_DATE_CATEGORY =
        new SalesOrderBillingPlanItemField<String>("BillingPlanDateCategory");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanBillingDate</b>
     * </p>
     *
     * @return Billing Date
     */
    @SerializedName( "BillingPlanBillingDate" )
    @JsonProperty( "BillingPlanBillingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingPlanBillingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingPlanBillingDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanBillingDate</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<LocalDateTime> BILLING_PLAN_BILLING_DATE =
        new SalesOrderBillingPlanItemField<LocalDateTime>("BillingPlanBillingDate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanAmount</b>
     * </p>
     *
     * @return Value to be billed/calc. on date in billing/invoice plan
     */
    @SerializedName( "BillingPlanAmount" )
    @JsonProperty( "BillingPlanAmount" )
    @Nullable
    @ODataField( odataName = "BillingPlanAmount" )
    private BigDecimal billingPlanAmount;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanAmount</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<BigDecimal> BILLING_PLAN_AMOUNT =
        new SalesOrderBillingPlanItemField<BigDecimal>("BillingPlanAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> TRANSACTION_CURRENCY =
        new SalesOrderBillingPlanItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanAmountPercent</b>
     * </p>
     *
     * @return Percentage of value to be invoiced
     */
    @SerializedName( "BillingPlanAmountPercent" )
    @JsonProperty( "BillingPlanAmountPercent" )
    @Nullable
    @ODataField( odataName = "BillingPlanAmountPercent" )
    private BigDecimal billingPlanAmountPercent;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanAmountPercent</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<BigDecimal> BILLING_PLAN_AMOUNT_PERCENT =
        new SalesOrderBillingPlanItemField<BigDecimal>("BillingPlanAmountPercent");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> CUSTOMER_PAYMENT_TERMS =
        new SalesOrderBillingPlanItemField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProposedBillingDocumentType</b>
     * </p>
     *
     * @return Proposed Billing Type for an Order-Related Billing Document
     */
    @SerializedName( "ProposedBillingDocumentType" )
    @JsonProperty( "ProposedBillingDocumentType" )
    @Nullable
    @ODataField( odataName = "ProposedBillingDocumentType" )
    private String proposedBillingDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ProposedBillingDocumentType</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> PROPOSED_BILLING_DOCUMENT_TYPE =
        new SalesOrderBillingPlanItemField<String>("ProposedBillingDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanDateDescriptionCode</b>
     * </p>
     *
     * @return Date Description
     */
    @SerializedName( "BillingPlanDateDescriptionCode" )
    @JsonProperty( "BillingPlanDateDescriptionCode" )
    @Nullable
    @ODataField( odataName = "BillingPlanDateDescriptionCode" )
    private String billingPlanDateDescriptionCode;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanDateDescriptionCode</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> BILLING_PLAN_DATE_DESCRIPTION_CODE =
        new SalesOrderBillingPlanItemField<String>("BillingPlanDateDescriptionCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingBlockReason</b>
     * </p>
     *
     * @return Billing Block for Billing Plan/Invoice Plan Dates
     */
    @SerializedName( "BillingBlockReason" )
    @JsonProperty( "BillingBlockReason" )
    @Nullable
    @ODataField( odataName = "BillingBlockReason" )
    private String billingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>BillingBlockReason</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> BILLING_BLOCK_REASON =
        new SalesOrderBillingPlanItemField<String>("BillingBlockReason");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanServiceStartDate</b>
     * </p>
     *
     * @return Settlement Start Date of Billing/Invoicing Date
     */
    @SerializedName( "BillingPlanServiceStartDate" )
    @JsonProperty( "BillingPlanServiceStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingPlanServiceStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingPlanServiceStartDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanServiceStartDate</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<LocalDateTime> BILLING_PLAN_SERVICE_START_DATE =
        new SalesOrderBillingPlanItemField<LocalDateTime>("BillingPlanServiceStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanServiceEndDate</b>
     * </p>
     *
     * @return Settlement End Date of Billing/Invoicing Date
     */
    @SerializedName( "BillingPlanServiceEndDate" )
    @JsonProperty( "BillingPlanServiceEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingPlanServiceEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingPlanServiceEndDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanServiceEndDate</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<LocalDateTime> BILLING_PLAN_SERVICE_END_DATE =
        new SalesOrderBillingPlanItemField<LocalDateTime>("BillingPlanServiceEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanRelatedBillgStatus</b>
     * </p>
     *
     * @return Billing Status for Billing Plan/Invoice Plan Date
     */
    @SerializedName( "BillingPlanRelatedBillgStatus" )
    @JsonProperty( "BillingPlanRelatedBillgStatus" )
    @Nullable
    @ODataField( odataName = "BillingPlanRelatedBillgStatus" )
    private String billingPlanRelatedBillgStatus;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanRelatedBillgStatus</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> BILLING_PLAN_RELATED_BILLG_STATUS =
        new SalesOrderBillingPlanItemField<String>("BillingPlanRelatedBillgStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanType</b>
     * </p>
     *
     * @return Billing/Invoicing Plan Type
     */
    @SerializedName( "BillingPlanType" )
    @JsonProperty( "BillingPlanType" )
    @Nullable
    @ODataField( odataName = "BillingPlanType" )
    private String billingPlanType;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanType</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> BILLING_PLAN_TYPE =
        new SalesOrderBillingPlanItemField<String>("BillingPlanType");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AdoptingBillingDateID</b>
     * </p>
     *
     * @return ID for Adopting Billing/Invoice Date
     */
    @SerializedName( "AdoptingBillingDateID" )
    @JsonProperty( "AdoptingBillingDateID" )
    @Nullable
    @ODataField( odataName = "AdoptingBillingDateID" )
    private String adoptingBillingDateID;
    /**
     * Use with available fluent helpers to apply the <b>AdoptingBillingDateID</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> ADOPTING_BILLING_DATE_ID =
        new SalesOrderBillingPlanItemField<String>("AdoptingBillingDateID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanBillingRule</b>
     * </p>
     *
     * @return Rule in billing plan/invoice plan
     */
    @SerializedName( "BillingPlanBillingRule" )
    @JsonProperty( "BillingPlanBillingRule" )
    @Nullable
    @ODataField( odataName = "BillingPlanBillingRule" )
    private String billingPlanBillingRule;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanBillingRule</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> BILLING_PLAN_BILLING_RULE =
        new SalesOrderBillingPlanItemField<String>("BillingPlanBillingRule");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanMilestoneUsage</b>
     * </p>
     *
     * @return Usage
     */
    @SerializedName( "BillingPlanMilestoneUsage" )
    @JsonProperty( "BillingPlanMilestoneUsage" )
    @Nullable
    @ODataField( odataName = "BillingPlanMilestoneUsage" )
    private String billingPlanMilestoneUsage;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanMilestoneUsage</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> BILLING_PLAN_MILESTONE_USAGE =
        new SalesOrderBillingPlanItemField<String>("BillingPlanMilestoneUsage");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillgPlnDteCorrectionRfndType</b>
     * </p>
     *
     * @return Indicator for Correction Date in Billing Plan
     */
    @SerializedName( "BillgPlnDteCorrectionRfndType" )
    @JsonProperty( "BillgPlnDteCorrectionRfndType" )
    @Nullable
    @ODataField( odataName = "BillgPlnDteCorrectionRfndType" )
    private String billgPlnDteCorrectionRfndType;
    /**
     * Use with available fluent helpers to apply the <b>BillgPlnDteCorrectionRfndType</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> BILLG_PLN_DTE_CORRECTION_RFND_TYPE =
        new SalesOrderBillingPlanItemField<String>("BillgPlnDteCorrectionRfndType");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AccountingExchangeRate</b>
     * </p>
     *
     * @return Exchange Rate for FI Postings
     */
    @SerializedName( "AccountingExchangeRate" )
    @JsonProperty( "AccountingExchangeRate" )
    @Nullable
    @ODataField( odataName = "AccountingExchangeRate" )
    private BigDecimal accountingExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>AccountingExchangeRate</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<BigDecimal> ACCOUNTING_EXCHANGE_RATE =
        new SalesOrderBillingPlanItemField<BigDecimal>("AccountingExchangeRate");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>PostponementReason</b>
     * </p>
     *
     * @return Reason for Postponement
     */
    @SerializedName( "PostponementReason" )
    @JsonProperty( "PostponementReason" )
    @Nullable
    @ODataField( odataName = "PostponementReason" )
    private String postponementReason;
    /**
     * Use with available fluent helpers to apply the <b>PostponementReason</b> field to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemField<String> POSTPONEMENT_REASON =
        new SalesOrderBillingPlanItemField<String>("PostponementReason");
    /**
     * Navigation property <b>to_BillingPlan</b> for <b>SalesOrderBillingPlanItem</b> to single
     * <b>SalesOrderBillingPlan</b>.
     *
     */
    @SerializedName( "to_BillingPlan" )
    @JsonProperty( "to_BillingPlan" )
    @ODataField( odataName = "to_BillingPlan" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderBillingPlan toBillingPlan;
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderBillingPlanItem</b> to single <b>SalesOrder</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrder toSalesOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingPlan</b> navigation property to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemOneToOneLink<SalesOrderBillingPlan> TO_BILLING_PLAN =
        new SalesOrderBillingPlanItemOneToOneLink<SalesOrderBillingPlan>("to_BillingPlan");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static SalesOrderBillingPlanItemOneToOneLink<SalesOrder> TO_SALES_ORDER =
        new SalesOrderBillingPlanItemOneToOneLink<SalesOrder>("to_SalesOrder");

    @Nonnull
    @Override
    public Class<SalesOrderBillingPlanItem> getType()
    {
        return SalesOrderBillingPlanItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     */
    public void setBillingPlan( @Nullable final String billingPlan )
    {
        rememberChangedField("BillingPlan", this.billingPlan);
        this.billingPlan = billingPlan;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanItem</b>
     * </p>
     *
     * @param billingPlanItem
     *            Item for billing plan/invoice plan/payment cards
     */
    public void setBillingPlanItem( @Nullable final String billingPlanItem )
    {
        rememberChangedField("BillingPlanItem", this.billingPlanItem);
        this.billingPlanItem = billingPlanItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanDateCategory</b>
     * </p>
     *
     * @param billingPlanDateCategory
     *            Date Category
     */
    public void setBillingPlanDateCategory( @Nullable final String billingPlanDateCategory )
    {
        rememberChangedField("BillingPlanDateCategory", this.billingPlanDateCategory);
        this.billingPlanDateCategory = billingPlanDateCategory;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanBillingDate</b>
     * </p>
     *
     * @param billingPlanBillingDate
     *            Billing Date
     */
    public void setBillingPlanBillingDate( @Nullable final LocalDateTime billingPlanBillingDate )
    {
        rememberChangedField("BillingPlanBillingDate", this.billingPlanBillingDate);
        this.billingPlanBillingDate = billingPlanBillingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanAmount</b>
     * </p>
     *
     * @param billingPlanAmount
     *            Value to be billed/calc. on date in billing/invoice plan
     */
    public void setBillingPlanAmount( @Nullable final BigDecimal billingPlanAmount )
    {
        rememberChangedField("BillingPlanAmount", this.billingPlanAmount);
        this.billingPlanAmount = billingPlanAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Currency Key
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanAmountPercent</b>
     * </p>
     *
     * @param billingPlanAmountPercent
     *            Percentage of value to be invoiced
     */
    public void setBillingPlanAmountPercent( @Nullable final BigDecimal billingPlanAmountPercent )
    {
        rememberChangedField("BillingPlanAmountPercent", this.billingPlanAmountPercent);
        this.billingPlanAmountPercent = billingPlanAmountPercent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProposedBillingDocumentType</b>
     * </p>
     *
     * @param proposedBillingDocumentType
     *            Proposed Billing Type for an Order-Related Billing Document
     */
    public void setProposedBillingDocumentType( @Nullable final String proposedBillingDocumentType )
    {
        rememberChangedField("ProposedBillingDocumentType", this.proposedBillingDocumentType);
        this.proposedBillingDocumentType = proposedBillingDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanDateDescriptionCode</b>
     * </p>
     *
     * @param billingPlanDateDescriptionCode
     *            Date Description
     */
    public void setBillingPlanDateDescriptionCode( @Nullable final String billingPlanDateDescriptionCode )
    {
        rememberChangedField("BillingPlanDateDescriptionCode", this.billingPlanDateDescriptionCode);
        this.billingPlanDateDescriptionCode = billingPlanDateDescriptionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingBlockReason</b>
     * </p>
     *
     * @param billingBlockReason
     *            Billing Block for Billing Plan/Invoice Plan Dates
     */
    public void setBillingBlockReason( @Nullable final String billingBlockReason )
    {
        rememberChangedField("BillingBlockReason", this.billingBlockReason);
        this.billingBlockReason = billingBlockReason;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanServiceStartDate</b>
     * </p>
     *
     * @param billingPlanServiceStartDate
     *            Settlement Start Date of Billing/Invoicing Date
     */
    public void setBillingPlanServiceStartDate( @Nullable final LocalDateTime billingPlanServiceStartDate )
    {
        rememberChangedField("BillingPlanServiceStartDate", this.billingPlanServiceStartDate);
        this.billingPlanServiceStartDate = billingPlanServiceStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanServiceEndDate</b>
     * </p>
     *
     * @param billingPlanServiceEndDate
     *            Settlement End Date of Billing/Invoicing Date
     */
    public void setBillingPlanServiceEndDate( @Nullable final LocalDateTime billingPlanServiceEndDate )
    {
        rememberChangedField("BillingPlanServiceEndDate", this.billingPlanServiceEndDate);
        this.billingPlanServiceEndDate = billingPlanServiceEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanRelatedBillgStatus</b>
     * </p>
     *
     * @param billingPlanRelatedBillgStatus
     *            Billing Status for Billing Plan/Invoice Plan Date
     */
    public void setBillingPlanRelatedBillgStatus( @Nullable final String billingPlanRelatedBillgStatus )
    {
        rememberChangedField("BillingPlanRelatedBillgStatus", this.billingPlanRelatedBillgStatus);
        this.billingPlanRelatedBillgStatus = billingPlanRelatedBillgStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanType</b>
     * </p>
     *
     * @param billingPlanType
     *            Billing/Invoicing Plan Type
     */
    public void setBillingPlanType( @Nullable final String billingPlanType )
    {
        rememberChangedField("BillingPlanType", this.billingPlanType);
        this.billingPlanType = billingPlanType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AdoptingBillingDateID</b>
     * </p>
     *
     * @param adoptingBillingDateID
     *            ID for Adopting Billing/Invoice Date
     */
    public void setAdoptingBillingDateID( @Nullable final String adoptingBillingDateID )
    {
        rememberChangedField("AdoptingBillingDateID", this.adoptingBillingDateID);
        this.adoptingBillingDateID = adoptingBillingDateID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanBillingRule</b>
     * </p>
     *
     * @param billingPlanBillingRule
     *            Rule in billing plan/invoice plan
     */
    public void setBillingPlanBillingRule( @Nullable final String billingPlanBillingRule )
    {
        rememberChangedField("BillingPlanBillingRule", this.billingPlanBillingRule);
        this.billingPlanBillingRule = billingPlanBillingRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanMilestoneUsage</b>
     * </p>
     *
     * @param billingPlanMilestoneUsage
     *            Usage
     */
    public void setBillingPlanMilestoneUsage( @Nullable final String billingPlanMilestoneUsage )
    {
        rememberChangedField("BillingPlanMilestoneUsage", this.billingPlanMilestoneUsage);
        this.billingPlanMilestoneUsage = billingPlanMilestoneUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillgPlnDteCorrectionRfndType</b>
     * </p>
     *
     * @param billgPlnDteCorrectionRfndType
     *            Indicator for Correction Date in Billing Plan
     */
    public void setBillgPlnDteCorrectionRfndType( @Nullable final String billgPlnDteCorrectionRfndType )
    {
        rememberChangedField("BillgPlnDteCorrectionRfndType", this.billgPlnDteCorrectionRfndType);
        this.billgPlnDteCorrectionRfndType = billgPlnDteCorrectionRfndType;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AccountingExchangeRate</b>
     * </p>
     *
     * @param accountingExchangeRate
     *            Exchange Rate for FI Postings
     */
    public void setAccountingExchangeRate( @Nullable final BigDecimal accountingExchangeRate )
    {
        rememberChangedField("AccountingExchangeRate", this.accountingExchangeRate);
        this.accountingExchangeRate = accountingExchangeRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>PostponementReason</b>
     * </p>
     *
     * @param postponementReason
     *            Reason for Postponement
     */
    public void setPostponementReason( @Nullable final String postponementReason )
    {
        rememberChangedField("PostponementReason", this.postponementReason);
        this.postponementReason = postponementReason;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderBillingPlanItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        result.put("BillingPlan", getBillingPlan());
        result.put("BillingPlanItem", getBillingPlanItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("BillingPlan", getBillingPlan());
        values.put("BillingPlanItem", getBillingPlanItem());
        values.put("BillingPlanDateCategory", getBillingPlanDateCategory());
        values.put("BillingPlanBillingDate", getBillingPlanBillingDate());
        values.put("BillingPlanAmount", getBillingPlanAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("BillingPlanAmountPercent", getBillingPlanAmountPercent());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("ProposedBillingDocumentType", getProposedBillingDocumentType());
        values.put("BillingPlanDateDescriptionCode", getBillingPlanDateDescriptionCode());
        values.put("BillingBlockReason", getBillingBlockReason());
        values.put("BillingPlanServiceStartDate", getBillingPlanServiceStartDate());
        values.put("BillingPlanServiceEndDate", getBillingPlanServiceEndDate());
        values.put("BillingPlanRelatedBillgStatus", getBillingPlanRelatedBillgStatus());
        values.put("BillingPlanType", getBillingPlanType());
        values.put("AdoptingBillingDateID", getAdoptingBillingDateID());
        values.put("BillingPlanBillingRule", getBillingPlanBillingRule());
        values.put("BillingPlanMilestoneUsage", getBillingPlanMilestoneUsage());
        values.put("BillgPlnDteCorrectionRfndType", getBillgPlnDteCorrectionRfndType());
        values.put("AccountingExchangeRate", getAccountingExchangeRate());
        values.put("PostponementReason", getPostponementReason());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("BillingPlan") ) {
                final Object value = values.remove("BillingPlan");
                if( (value == null) || (!value.equals(getBillingPlan())) ) {
                    setBillingPlan(((String) value));
                }
            }
            if( values.containsKey("BillingPlanItem") ) {
                final Object value = values.remove("BillingPlanItem");
                if( (value == null) || (!value.equals(getBillingPlanItem())) ) {
                    setBillingPlanItem(((String) value));
                }
            }
            if( values.containsKey("BillingPlanDateCategory") ) {
                final Object value = values.remove("BillingPlanDateCategory");
                if( (value == null) || (!value.equals(getBillingPlanDateCategory())) ) {
                    setBillingPlanDateCategory(((String) value));
                }
            }
            if( values.containsKey("BillingPlanBillingDate") ) {
                final Object value = values.remove("BillingPlanBillingDate");
                if( (value == null) || (!value.equals(getBillingPlanBillingDate())) ) {
                    setBillingPlanBillingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillingPlanAmount") ) {
                final Object value = values.remove("BillingPlanAmount");
                if( (value == null) || (!value.equals(getBillingPlanAmount())) ) {
                    setBillingPlanAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("BillingPlanAmountPercent") ) {
                final Object value = values.remove("BillingPlanAmountPercent");
                if( (value == null) || (!value.equals(getBillingPlanAmountPercent())) ) {
                    setBillingPlanAmountPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("ProposedBillingDocumentType") ) {
                final Object value = values.remove("ProposedBillingDocumentType");
                if( (value == null) || (!value.equals(getProposedBillingDocumentType())) ) {
                    setProposedBillingDocumentType(((String) value));
                }
            }
            if( values.containsKey("BillingPlanDateDescriptionCode") ) {
                final Object value = values.remove("BillingPlanDateDescriptionCode");
                if( (value == null) || (!value.equals(getBillingPlanDateDescriptionCode())) ) {
                    setBillingPlanDateDescriptionCode(((String) value));
                }
            }
            if( values.containsKey("BillingBlockReason") ) {
                final Object value = values.remove("BillingBlockReason");
                if( (value == null) || (!value.equals(getBillingBlockReason())) ) {
                    setBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("BillingPlanServiceStartDate") ) {
                final Object value = values.remove("BillingPlanServiceStartDate");
                if( (value == null) || (!value.equals(getBillingPlanServiceStartDate())) ) {
                    setBillingPlanServiceStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillingPlanServiceEndDate") ) {
                final Object value = values.remove("BillingPlanServiceEndDate");
                if( (value == null) || (!value.equals(getBillingPlanServiceEndDate())) ) {
                    setBillingPlanServiceEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillingPlanRelatedBillgStatus") ) {
                final Object value = values.remove("BillingPlanRelatedBillgStatus");
                if( (value == null) || (!value.equals(getBillingPlanRelatedBillgStatus())) ) {
                    setBillingPlanRelatedBillgStatus(((String) value));
                }
            }
            if( values.containsKey("BillingPlanType") ) {
                final Object value = values.remove("BillingPlanType");
                if( (value == null) || (!value.equals(getBillingPlanType())) ) {
                    setBillingPlanType(((String) value));
                }
            }
            if( values.containsKey("AdoptingBillingDateID") ) {
                final Object value = values.remove("AdoptingBillingDateID");
                if( (value == null) || (!value.equals(getAdoptingBillingDateID())) ) {
                    setAdoptingBillingDateID(((String) value));
                }
            }
            if( values.containsKey("BillingPlanBillingRule") ) {
                final Object value = values.remove("BillingPlanBillingRule");
                if( (value == null) || (!value.equals(getBillingPlanBillingRule())) ) {
                    setBillingPlanBillingRule(((String) value));
                }
            }
            if( values.containsKey("BillingPlanMilestoneUsage") ) {
                final Object value = values.remove("BillingPlanMilestoneUsage");
                if( (value == null) || (!value.equals(getBillingPlanMilestoneUsage())) ) {
                    setBillingPlanMilestoneUsage(((String) value));
                }
            }
            if( values.containsKey("BillgPlnDteCorrectionRfndType") ) {
                final Object value = values.remove("BillgPlnDteCorrectionRfndType");
                if( (value == null) || (!value.equals(getBillgPlnDteCorrectionRfndType())) ) {
                    setBillgPlnDteCorrectionRfndType(((String) value));
                }
            }
            if( values.containsKey("AccountingExchangeRate") ) {
                final Object value = values.remove("AccountingExchangeRate");
                if( (value == null) || (!value.equals(getAccountingExchangeRate())) ) {
                    setAccountingExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("PostponementReason") ) {
                final Object value = values.remove("PostponementReason");
                if( (value == null) || (!value.equals(getPostponementReason())) ) {
                    setPostponementReason(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingPlan") ) {
                final Object value = (values).remove("to_BillingPlan");
                if( value instanceof Map ) {
                    if( toBillingPlan == null ) {
                        toBillingPlan = new SalesOrderBillingPlan();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillingPlan.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Map ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = new SalesOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrderBillingPlanItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderBillingPlanItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderBillingPlanItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderBillingPlanItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingPlan != null ) {
            (values).put("to_BillingPlan", toBillingPlan);
        }
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderBillingPlan</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_BillingPlan</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderBillingPlan</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderBillingPlan fetchBillingPlan()
    {
        return fetchFieldAsSingle("to_BillingPlan", SalesOrderBillingPlan.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderBillingPlan</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingPlan</b>.
     * <p>
     * If the navigation property <b>to_BillingPlan</b> of a queried <b>SalesOrderBillingPlanItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderBillingPlan</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderBillingPlan getBillingPlanOrFetch()
    {
        if( toBillingPlan == null ) {
            toBillingPlan = fetchBillingPlan();
        }
        return toBillingPlan;
    }

    /**
     * Retrieval of associated <b>SalesOrderBillingPlan</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingPlan</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderBillingPlanItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingPlan</b> is already loaded, the result will
     *         contain the <b>SalesOrderBillingPlan</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderBillingPlan> getBillingPlanIfPresent()
    {
        return Option.of(toBillingPlan);
    }

    /**
     * Overwrites the associated <b>SalesOrderBillingPlan</b> entity for the loaded navigation property
     * <b>to_BillingPlan</b>.
     *
     * @param value
     *            New <b>SalesOrderBillingPlan</b> entity.
     */
    public void setBillingPlan( final SalesOrderBillingPlan value )
    {
        toBillingPlan = value;
    }

    /**
     * Fetches the <b>SalesOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder fetchSalesOrder()
    {
        return fetchFieldAsSingle("to_SalesOrder", SalesOrder.class);
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>SalesOrderBillingPlanItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderBillingPlanItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>SalesOrder</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<SalesOrder> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the associated <b>SalesOrder</b> entity for the loaded navigation property <b>to_SalesOrder</b>.
     *
     * @param value
     *            New <b>SalesOrder</b> entity.
     */
    public void setSalesOrder( final SalesOrder value )
    {
        toSalesOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderBillingPlanItem instances.
     *
     */
    public final static class SalesOrderBillingPlanItemBuilder
    {

        private SalesOrderBillingPlan toBillingPlan;
        private String billingPlan = null;
        private SalesOrder toSalesOrder;
        private String salesOrder = null;

        private SalesOrderBillingPlanItem.SalesOrderBillingPlanItemBuilder toBillingPlan(
            final SalesOrderBillingPlan value )
        {
            toBillingPlan = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillingPlan</b> for <b>SalesOrderBillingPlanItem</b> to single
         * <b>SalesOrderBillingPlan</b>.
         *
         * @param value
         *            The SalesOrderBillingPlan to build this SalesOrderBillingPlanItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderBillingPlanItem.SalesOrderBillingPlanItemBuilder billingPlan(
            final SalesOrderBillingPlan value )
        {
            return toBillingPlan(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BillingPlan</b>
         * </p>
         *
         * @param value
         *            The billingPlan to build this SalesOrderBillingPlanItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderBillingPlanItem.SalesOrderBillingPlanItemBuilder billingPlan( final String value )
        {
            billingPlan = value;
            return this;
        }

        private SalesOrderBillingPlanItem.SalesOrderBillingPlanItemBuilder toSalesOrder( final SalesOrder value )
        {
            toSalesOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderBillingPlanItem</b> to single <b>SalesOrder</b>.
         *
         * @param value
         *            The SalesOrder to build this SalesOrderBillingPlanItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderBillingPlanItem.SalesOrderBillingPlanItemBuilder salesOrder( final SalesOrder value )
        {
            return toSalesOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrder</b>
         * </p>
         *
         * @param value
         *            The salesOrder to build this SalesOrderBillingPlanItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderBillingPlanItem.SalesOrderBillingPlanItemBuilder salesOrder( final String value )
        {
            salesOrder = value;
            return this;
        }

    }

}
