/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
 * SalesOrderBillingPlanItem} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class SalesOrderBillingPlanItemUpdateFluentHelper
    extends
    FluentHelperUpdate<SalesOrderBillingPlanItemUpdateFluentHelper, SalesOrderBillingPlanItem>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     * SalesOrderBillingPlanItem} entity object that will be updated in the S/4HANA system.
     *
     */
    private final SalesOrderBillingPlanItem entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     * SalesOrderBillingPlanItem} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The SalesOrderBillingPlanItem to take the updated values from.
     */
    public SalesOrderBillingPlanItemUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final SalesOrderBillingPlanItem entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected SalesOrderBillingPlanItem getEntity()
    {
        return entity;
    }

}
