/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
 * SalesOrderHeaderPrElement} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class SalesOrderHeaderPrElementUpdateFluentHelper
    extends
    FluentHelperUpdate<SalesOrderHeaderPrElementUpdateFluentHelper, SalesOrderHeaderPrElement>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     * SalesOrderHeaderPrElement} entity object that will be updated in the S/4HANA system.
     *
     */
    private final SalesOrderHeaderPrElement entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     * SalesOrderHeaderPrElement} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The SalesOrderHeaderPrElement to take the updated values from.
     */
    public SalesOrderHeaderPrElementUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final SalesOrderHeaderPrElement entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected SalesOrderHeaderPrElement getEntity()
    {
        return entity;
    }

}
