/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SalesOrderItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Order Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderItem extends VdmEntity<SalesOrderItem>
{

    /**
     * Selector for all available fields of SalesOrderItem.
     *
     */
    public final static SalesOrderItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SALES_ORDER = new SalesOrderItemField<String>("SalesOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @Key
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SALES_ORDER_ITEM =
        new SalesOrderItemField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @return Higher-Level Item in Bill of Material Structures
     */
    @SerializedName( "HigherLevelItem" )
    @JsonProperty( "HigherLevelItem" )
    @Nullable
    @ODataField( odataName = "HigherLevelItem" )
    private String higherLevelItem;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItem</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> HIGHER_LEVEL_ITEM =
        new SalesOrderItemField<String>("HigherLevelItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItemUsage</b>
     * </p>
     *
     * @return ID for higher-level item usage
     */
    @SerializedName( "HigherLevelItemUsage" )
    @JsonProperty( "HigherLevelItemUsage" )
    @Nullable
    @ODataField( odataName = "HigherLevelItemUsage" )
    private String higherLevelItemUsage;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItemUsage</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> HIGHER_LEVEL_ITEM_USAGE =
        new SalesOrderItemField<String>("HigherLevelItemUsage");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemCategory</b>
     * </p>
     *
     * @return Sales Document Item Category
     */
    @SerializedName( "SalesOrderItemCategory" )
    @JsonProperty( "SalesOrderItemCategory" )
    @Nullable
    @ODataField( odataName = "SalesOrderItemCategory" )
    private String salesOrderItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItemCategory</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SALES_ORDER_ITEM_CATEGORY =
        new SalesOrderItemField<String>("SalesOrderItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemText</b>
     * </p>
     *
     * @return Short Text for Sales Order Item
     */
    @SerializedName( "SalesOrderItemText" )
    @JsonProperty( "SalesOrderItemText" )
    @Nullable
    @ODataField( odataName = "SalesOrderItemText" )
    private String salesOrderItemText;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItemText</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SALES_ORDER_ITEM_TEXT =
        new SalesOrderItemField<String>("SalesOrderItemText");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new SalesOrderItemField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByShipToParty</b>
     * </p>
     *
     * @return Ship-to Party's Customer Reference
     */
    @SerializedName( "PurchaseOrderByShipToParty" )
    @JsonProperty( "PurchaseOrderByShipToParty" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByShipToParty" )
    private String purchaseOrderByShipToParty;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByShipToParty</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PURCHASE_ORDER_BY_SHIP_TO_PARTY =
        new SalesOrderItemField<String>("PurchaseOrderByShipToParty");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>UnderlyingPurchaseOrderItem</b>
     * </p>
     *
     * @return Item Number of the Underlying Purchase Order
     */
    @SerializedName( "UnderlyingPurchaseOrderItem" )
    @JsonProperty( "UnderlyingPurchaseOrderItem" )
    @Nullable
    @ODataField( odataName = "UnderlyingPurchaseOrderItem" )
    private String underlyingPurchaseOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>UnderlyingPurchaseOrderItem</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> UNDERLYING_PURCHASE_ORDER_ITEM =
        new SalesOrderItemField<String>("UnderlyingPurchaseOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ExternalItemID</b>
     * </p>
     *
     * @return External Item ID
     */
    @SerializedName( "ExternalItemID" )
    @JsonProperty( "ExternalItemID" )
    @Nullable
    @ODataField( odataName = "ExternalItemID" )
    private String externalItemID;
    /**
     * Use with available fluent helpers to apply the <b>ExternalItemID</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> EXTERNAL_ITEM_ID =
        new SalesOrderItemField<String>("ExternalItemID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> MATERIAL = new SalesOrderItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Material Number Used by Customer
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> MATERIAL_BY_CUSTOMER =
        new SalesOrderItemField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Date for Pricing and Exchange Rate
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<LocalDateTime> PRICING_DATE =
        new SalesOrderItemField<LocalDateTime>("PricingDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PricingReferenceMaterial</b>
     * </p>
     *
     * @return Pricing Reference Material
     */
    @SerializedName( "PricingReferenceMaterial" )
    @JsonProperty( "PricingReferenceMaterial" )
    @Nullable
    @ODataField( odataName = "PricingReferenceMaterial" )
    private String pricingReferenceMaterial;
    /**
     * Use with available fluent helpers to apply the <b>PricingReferenceMaterial</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRICING_REFERENCE_MATERIAL =
        new SalesOrderItemField<String>("PricingReferenceMaterial");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @return Billing Plan Number / Invoicing Plan Number
     */
    @SerializedName( "BillingPlan" )
    @JsonProperty( "BillingPlan" )
    @Nullable
    @ODataField( odataName = "BillingPlan" )
    private String billingPlan;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlan</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> BILLING_PLAN = new SalesOrderItemField<String>("BillingPlan");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return Requested Quantity
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<BigDecimal> REQUESTED_QUANTITY =
        new SalesOrderItemField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @return Unit of the Requested Quantity
     */
    @SerializedName( "RequestedQuantityUnit" )
    @JsonProperty( "RequestedQuantityUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityUnit" )
    private String requestedQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> REQUESTED_QUANTITY_UNIT =
        new SalesOrderItemField<String>("RequestedQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Requested Quantity
     */
    @SerializedName( "RequestedQuantitySAPUnit" )
    @JsonProperty( "RequestedQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantitySAPUnit" )
    private String requestedQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> REQUESTED_QUANTITY_SAP_UNIT =
        new SalesOrderItemField<String>("RequestedQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Requested Quantity
     */
    @SerializedName( "RequestedQuantityISOUnit" )
    @JsonProperty( "RequestedQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityISOUnit" )
    private String requestedQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> REQUESTED_QUANTITY_ISO_UNIT =
        new SalesOrderItemField<String>("RequestedQuantityISOUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ORDER_QUANTITY_UNIT =
        new SalesOrderItemField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantitySAPUnit" )
    @JsonProperty( "OrderQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantitySAPUnit" )
    private String orderQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ORDER_QUANTITY_SAP_UNIT =
        new SalesOrderItemField<String>("OrderQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantityISOUnit" )
    @JsonProperty( "OrderQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityISOUnit" )
    private String orderQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ORDER_QUANTITY_ISO_UNIT =
        new SalesOrderItemField<String>("OrderQuantityISOUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdDelivQtyInOrderQtyUnit</b>
     * </p>
     *
     * @return Cumulative Confirmed Quantity in Sales Unit
     */
    @SerializedName( "ConfdDelivQtyInOrderQtyUnit" )
    @JsonProperty( "ConfdDelivQtyInOrderQtyUnit" )
    @Nullable
    @ODataField( odataName = "ConfdDelivQtyInOrderQtyUnit" )
    private BigDecimal confdDelivQtyInOrderQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConfdDelivQtyInOrderQtyUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<BigDecimal> CONFD_DELIV_QTY_IN_ORDER_QTY_UNIT =
        new SalesOrderItemField<BigDecimal>("ConfdDelivQtyInOrderQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @return Gross Weight of the Item
     */
    @SerializedName( "ItemGrossWeight" )
    @JsonProperty( "ItemGrossWeight" )
    @Nullable
    @ODataField( odataName = "ItemGrossWeight" )
    private BigDecimal itemGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemGrossWeight</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<BigDecimal> ITEM_GROSS_WEIGHT =
        new SalesOrderItemField<BigDecimal>("ItemGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight of the Item
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<BigDecimal> ITEM_NET_WEIGHT =
        new SalesOrderItemField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ITEM_WEIGHT_UNIT =
        new SalesOrderItemField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightSAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Item Weight
     */
    @SerializedName( "ItemWeightSAPUnit" )
    @JsonProperty( "ItemWeightSAPUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightSAPUnit" )
    private String itemWeightSAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightSAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ITEM_WEIGHT_SAP_UNIT =
        new SalesOrderItemField<String>("ItemWeightSAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Item Weight
     */
    @SerializedName( "ItemWeightISOUnit" )
    @JsonProperty( "ItemWeightISOUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightISOUnit" )
    private String itemWeightISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ITEM_WEIGHT_ISO_UNIT =
        new SalesOrderItemField<String>("ItemWeightISOUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume of the item
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<BigDecimal> ITEM_VOLUME = new SalesOrderItemField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ITEM_VOLUME_UNIT =
        new SalesOrderItemField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeSAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Item Volume
     */
    @SerializedName( "ItemVolumeSAPUnit" )
    @JsonProperty( "ItemVolumeSAPUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeSAPUnit" )
    private String itemVolumeSAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeSAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ITEM_VOLUME_SAP_UNIT =
        new SalesOrderItemField<String>("ItemVolumeSAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Item Volume
     */
    @SerializedName( "ItemVolumeISOUnit" )
    @JsonProperty( "ItemVolumeISOUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeISOUnit" )
    private String itemVolumeISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ITEM_VOLUME_ISO_UNIT =
        new SalesOrderItemField<String>("ItemVolumeISOUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> TRANSACTION_CURRENCY =
        new SalesOrderItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of the Order Item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<BigDecimal> NET_AMOUNT = new SalesOrderItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalSDDocReferenceStatus</b>
     * </p>
     *
     * @return Overall Reference Status (Item)
     */
    @SerializedName( "TotalSDDocReferenceStatus" )
    @JsonProperty( "TotalSDDocReferenceStatus" )
    @Nullable
    @ODataField( odataName = "TotalSDDocReferenceStatus" )
    private String totalSDDocReferenceStatus;
    /**
     * Use with available fluent helpers to apply the <b>TotalSDDocReferenceStatus</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> TOTAL_SD_DOC_REFERENCE_STATUS =
        new SalesOrderItemField<String>("TotalSDDocReferenceStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDDocReferenceStatus</b>
     * </p>
     *
     * @return Reference Status (Item)
     */
    @SerializedName( "SDDocReferenceStatus" )
    @JsonProperty( "SDDocReferenceStatus" )
    @Nullable
    @ODataField( odataName = "SDDocReferenceStatus" )
    private String sDDocReferenceStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDDocReferenceStatus</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SD_DOC_REFERENCE_STATUS =
        new SalesOrderItemField<String>("SDDocReferenceStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSubstitutionReason</b>
     * </p>
     *
     * @return Reason for material substitution
     */
    @SerializedName( "MaterialSubstitutionReason" )
    @JsonProperty( "MaterialSubstitutionReason" )
    @Nullable
    @ODataField( odataName = "MaterialSubstitutionReason" )
    private String materialSubstitutionReason;
    /**
     * Use with available fluent helpers to apply the <b>MaterialSubstitutionReason</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> MATERIAL_SUBSTITUTION_REASON =
        new SalesOrderItemField<String>("MaterialSubstitutionReason");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> MATERIAL_GROUP = new SalesOrderItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @return Material Price Group
     */
    @SerializedName( "MaterialPricingGroup" )
    @JsonProperty( "MaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MaterialPricingGroup" )
    private String materialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPricingGroup</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> MATERIAL_PRICING_GROUP =
        new SalesOrderItemField<String>("MaterialPricingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup1</b>
     * </p>
     *
     * @return Material Group 1
     */
    @SerializedName( "AdditionalMaterialGroup1" )
    @JsonProperty( "AdditionalMaterialGroup1" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup1" )
    private String additionalMaterialGroup1;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup1</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ADDITIONAL_MATERIAL_GROUP1 =
        new SalesOrderItemField<String>("AdditionalMaterialGroup1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup2</b>
     * </p>
     *
     * @return Material Group 2
     */
    @SerializedName( "AdditionalMaterialGroup2" )
    @JsonProperty( "AdditionalMaterialGroup2" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup2" )
    private String additionalMaterialGroup2;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup2</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ADDITIONAL_MATERIAL_GROUP2 =
        new SalesOrderItemField<String>("AdditionalMaterialGroup2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup3</b>
     * </p>
     *
     * @return Material Group 3
     */
    @SerializedName( "AdditionalMaterialGroup3" )
    @JsonProperty( "AdditionalMaterialGroup3" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup3" )
    private String additionalMaterialGroup3;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup3</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ADDITIONAL_MATERIAL_GROUP3 =
        new SalesOrderItemField<String>("AdditionalMaterialGroup3");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup4</b>
     * </p>
     *
     * @return Material Group 4
     */
    @SerializedName( "AdditionalMaterialGroup4" )
    @JsonProperty( "AdditionalMaterialGroup4" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup4" )
    private String additionalMaterialGroup4;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup4</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ADDITIONAL_MATERIAL_GROUP4 =
        new SalesOrderItemField<String>("AdditionalMaterialGroup4");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup5</b>
     * </p>
     *
     * @return Material Group 5
     */
    @SerializedName( "AdditionalMaterialGroup5" )
    @JsonProperty( "AdditionalMaterialGroup5" )
    @Nullable
    @ODataField( odataName = "AdditionalMaterialGroup5" )
    private String additionalMaterialGroup5;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMaterialGroup5</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ADDITIONAL_MATERIAL_GROUP5 =
        new SalesOrderItemField<String>("AdditionalMaterialGroup5");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentDate</b>
     * </p>
     *
     * @return Billing Date
     */
    @SerializedName( "BillingDocumentDate" )
    @JsonProperty( "BillingDocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingDocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingDocumentDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingDocumentDate</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<LocalDateTime> BILLING_DOCUMENT_DATE =
        new SalesOrderItemField<LocalDateTime>("BillingDocumentDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     *
     * @return Contract Account Number
     */
    @SerializedName( "ContractAccount" )
    @JsonProperty( "ContractAccount" )
    @Nullable
    @ODataField( odataName = "ContractAccount" )
    private String contractAccount;
    /**
     * Use with available fluent helpers to apply the <b>ContractAccount</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> CONTRACT_ACCOUNT =
        new SalesOrderItemField<String>("ContractAccount");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @return Additional Value Days
     */
    @SerializedName( "AdditionalValueDays" )
    @JsonProperty( "AdditionalValueDays" )
    @Nullable
    @ODataField( odataName = "AdditionalValueDays" )
    private String additionalValueDays;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalValueDays</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ADDITIONAL_VALUE_DAYS =
        new SalesOrderItemField<String>("AdditionalValueDays");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @return Date on which services are rendered
     */
    @SerializedName( "ServicesRenderedDate" )
    @JsonProperty( "ServicesRenderedDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ServicesRenderedDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime servicesRenderedDate;
    /**
     * Use with available fluent helpers to apply the <b>ServicesRenderedDate</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<LocalDateTime> SERVICES_RENDERED_DATE =
        new SalesOrderItemField<LocalDateTime>("ServicesRenderedDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> BATCH = new SalesOrderItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @return Plant (Own or External)
     */
    @SerializedName( "ProductionPlant" )
    @JsonProperty( "ProductionPlant" )
    @Nullable
    @ODataField( odataName = "ProductionPlant" )
    private String productionPlant;
    /**
     * Use with available fluent helpers to apply the <b>ProductionPlant</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRODUCTION_PLANT =
        new SalesOrderItemField<String>("ProductionPlant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OriginalPlant</b>
     * </p>
     *
     * @return Original Plant in Plant Substitution
     */
    @SerializedName( "OriginalPlant" )
    @JsonProperty( "OriginalPlant" )
    @Nullable
    @ODataField( odataName = "OriginalPlant" )
    private String originalPlant;
    /**
     * Use with available fluent helpers to apply the <b>OriginalPlant</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ORIGINAL_PLANT = new SalesOrderItemField<String>("OriginalPlant");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AltvBsdConfSubstitutionStatus</b>
     * </p>
     *
     * @return Substitution Status for Alternative-Based Confirmation (ABC)
     */
    @SerializedName( "AltvBsdConfSubstitutionStatus" )
    @JsonProperty( "AltvBsdConfSubstitutionStatus" )
    @Nullable
    @ODataField( odataName = "AltvBsdConfSubstitutionStatus" )
    private String altvBsdConfSubstitutionStatus;
    /**
     * Use with available fluent helpers to apply the <b>AltvBsdConfSubstitutionStatus</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ALTV_BSD_CONF_SUBSTITUTION_STATUS =
        new SalesOrderItemField<String>("AltvBsdConfSubstitutionStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> STORAGE_LOCATION =
        new SalesOrderItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryGroup</b>
     * </p>
     *
     * @return Delivery Group (Items are delivered together)
     */
    @SerializedName( "DeliveryGroup" )
    @JsonProperty( "DeliveryGroup" )
    @Nullable
    @ODataField( odataName = "DeliveryGroup" )
    private String deliveryGroup;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryGroup</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> DELIVERY_GROUP = new SalesOrderItemField<String>("DeliveryGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point / Receiving Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SHIPPING_POINT = new SalesOrderItemField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SHIPPING_TYPE = new SalesOrderItemField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @return Delivery Priority
     */
    @SerializedName( "DeliveryPriority" )
    @JsonProperty( "DeliveryPriority" )
    @Nullable
    @ODataField( odataName = "DeliveryPriority" )
    private String deliveryPriority;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryPriority</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> DELIVERY_PRIORITY =
        new SalesOrderItemField<String>("DeliveryPriority");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDateQuantityIsFixed</b>
     * </p>
     *
     * @return Delivery Date and Quantity Fixed
     */
    @SerializedName( "DeliveryDateQuantityIsFixed" )
    @JsonProperty( "DeliveryDateQuantityIsFixed" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DeliveryDateQuantityIsFixed" )
    private Boolean deliveryDateQuantityIsFixed;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDateQuantityIsFixed</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<Boolean> DELIVERY_DATE_QUANTITY_IS_FIXED =
        new SalesOrderItemField<Boolean>("DeliveryDateQuantityIsFixed");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDateTypeRule</b>
     * </p>
     *
     * @return Delivery Date Rule
     */
    @SerializedName( "DeliveryDateTypeRule" )
    @JsonProperty( "DeliveryDateTypeRule" )
    @Nullable
    @ODataField( odataName = "DeliveryDateTypeRule" )
    private String deliveryDateTypeRule;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDateTypeRule</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> DELIVERY_DATE_TYPE_RULE =
        new SalesOrderItemField<String>("DeliveryDateTypeRule");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> INCOTERMS_CLASSIFICATION =
        new SalesOrderItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> INCOTERMS_TRANSFER_LOCATION =
        new SalesOrderItemField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> INCOTERMS_LOCATION1 =
        new SalesOrderItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> INCOTERMS_LOCATION2 =
        new SalesOrderItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @return Tax Amount in Document Currency
     */
    @SerializedName( "TaxAmount" )
    @JsonProperty( "TaxAmount" )
    @Nullable
    @ODataField( odataName = "TaxAmount" )
    private BigDecimal taxAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxAmount</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<BigDecimal> TAX_AMOUNT = new SalesOrderItemField<BigDecimal>("TaxAmount");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification1" )
    @JsonProperty( "ProductTaxClassification1" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification1" )
    private String productTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification1</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRODUCT_TAX_CLASSIFICATION1 =
        new SalesOrderItemField<String>("ProductTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification2" )
    @JsonProperty( "ProductTaxClassification2" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification2" )
    private String productTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification2</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRODUCT_TAX_CLASSIFICATION2 =
        new SalesOrderItemField<String>("ProductTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification3" )
    @JsonProperty( "ProductTaxClassification3" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification3" )
    private String productTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification3</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRODUCT_TAX_CLASSIFICATION3 =
        new SalesOrderItemField<String>("ProductTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification4" )
    @JsonProperty( "ProductTaxClassification4" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification4" )
    private String productTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification4</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRODUCT_TAX_CLASSIFICATION4 =
        new SalesOrderItemField<String>("ProductTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification5" )
    @JsonProperty( "ProductTaxClassification5" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification5" )
    private String productTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification5</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRODUCT_TAX_CLASSIFICATION5 =
        new SalesOrderItemField<String>("ProductTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification6" )
    @JsonProperty( "ProductTaxClassification6" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification6" )
    private String productTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification6</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRODUCT_TAX_CLASSIFICATION6 =
        new SalesOrderItemField<String>("ProductTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification7" )
    @JsonProperty( "ProductTaxClassification7" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification7" )
    private String productTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification7</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRODUCT_TAX_CLASSIFICATION7 =
        new SalesOrderItemField<String>("ProductTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification8" )
    @JsonProperty( "ProductTaxClassification8" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification8" )
    private String productTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification8</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRODUCT_TAX_CLASSIFICATION8 =
        new SalesOrderItemField<String>("ProductTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification9" )
    @JsonProperty( "ProductTaxClassification9" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification9" )
    private String productTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification9</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PRODUCT_TAX_CLASSIFICATION9 =
        new SalesOrderItemField<String>("ProductTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MatlAccountAssignmentGroup</b>
     * </p>
     *
     * @return Account Assignment Group for Material
     */
    @SerializedName( "MatlAccountAssignmentGroup" )
    @JsonProperty( "MatlAccountAssignmentGroup" )
    @Nullable
    @ODataField( odataName = "MatlAccountAssignmentGroup" )
    private String matlAccountAssignmentGroup;
    /**
     * Use with available fluent helpers to apply the <b>MatlAccountAssignmentGroup</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> MATL_ACCOUNT_ASSIGNMENT_GROUP =
        new SalesOrderItemField<String>("MatlAccountAssignmentGroup");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostAmount</b>
     * </p>
     *
     * @return Cost in Document Currency
     */
    @SerializedName( "CostAmount" )
    @JsonProperty( "CostAmount" )
    @Nullable
    @ODataField( odataName = "CostAmount" )
    private BigDecimal costAmount;
    /**
     * Use with available fluent helpers to apply the <b>CostAmount</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<BigDecimal> COST_AMOUNT = new SalesOrderItemField<BigDecimal>("CostAmount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> CUSTOMER_PAYMENT_TERMS =
        new SalesOrderItemField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @return Fixed Value Date
     */
    @SerializedName( "FixedValueDate" )
    @JsonProperty( "FixedValueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FixedValueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime fixedValueDate;
    /**
     * Use with available fluent helpers to apply the <b>FixedValueDate</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<LocalDateTime> FIXED_VALUE_DATE =
        new SalesOrderItemField<LocalDateTime>("FixedValueDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @return Customer Group
     */
    @SerializedName( "CustomerGroup" )
    @JsonProperty( "CustomerGroup" )
    @Nullable
    @ODataField( odataName = "CustomerGroup" )
    private String customerGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerGroup</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> CUSTOMER_GROUP = new SalesOrderItemField<String>("CustomerGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @return Reason for Rejection of Sales Documents
     */
    @SerializedName( "SalesDocumentRjcnReason" )
    @JsonProperty( "SalesDocumentRjcnReason" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason" )
    private String salesDocumentRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SALES_DOCUMENT_RJCN_REASON =
        new SalesOrderItemField<String>("SalesDocumentRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block for Item
     */
    @SerializedName( "ItemBillingBlockReason" )
    @JsonProperty( "ItemBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "ItemBillingBlockReason" )
    private String itemBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>ItemBillingBlockReason</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ITEM_BILLING_BLOCK_REASON =
        new SalesOrderItemField<String>("ItemBillingBlockReason");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SlsDocIsRlvtForProofOfDeliv</b>
     * </p>
     *
     * @return Relevant for POD processing
     */
    @SerializedName( "SlsDocIsRlvtForProofOfDeliv" )
    @JsonProperty( "SlsDocIsRlvtForProofOfDeliv" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SlsDocIsRlvtForProofOfDeliv" )
    private Boolean slsDocIsRlvtForProofOfDeliv;
    /**
     * Use with available fluent helpers to apply the <b>SlsDocIsRlvtForProofOfDeliv</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<Boolean> SLS_DOC_IS_RLVT_FOR_PROOF_OF_DELIV =
        new SalesOrderItemField<Boolean>("SlsDocIsRlvtForProofOfDeliv");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> WBS_ELEMENT = new SalesOrderItemField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> PROFIT_CENTER = new SalesOrderItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AccountingExchangeRate</b>
     * </p>
     *
     * @return Exchange Rate for Postings to Financial Accounting
     */
    @SerializedName( "AccountingExchangeRate" )
    @JsonProperty( "AccountingExchangeRate" )
    @Nullable
    @ODataField( odataName = "AccountingExchangeRate" )
    private BigDecimal accountingExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>AccountingExchangeRate</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<BigDecimal> ACCOUNTING_EXCHANGE_RATE =
        new SalesOrderItemField<BigDecimal>("AccountingExchangeRate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> REFERENCE_SD_DOCUMENT =
        new SalesOrderItemField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @return Item Number of the Reference Item
     */
    @SerializedName( "ReferenceSDDocumentItem" )
    @JsonProperty( "ReferenceSDDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentItem" )
    private String referenceSDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentItem</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> REFERENCE_SD_DOCUMENT_ITEM =
        new SalesOrderItemField<String>("ReferenceSDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Item)
     */
    @SerializedName( "SDProcessStatus" )
    @JsonProperty( "SDProcessStatus" )
    @Nullable
    @ODataField( odataName = "SDProcessStatus" )
    private String sDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDProcessStatus</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> SD_PROCESS_STATUS =
        new SalesOrderItemField<String>("SDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryStatus</b>
     * </p>
     *
     * @return Delivery Status (Item)
     */
    @SerializedName( "DeliveryStatus" )
    @JsonProperty( "DeliveryStatus" )
    @Nullable
    @ODataField( odataName = "DeliveryStatus" )
    private String deliveryStatus;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryStatus</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> DELIVERY_STATUS = new SalesOrderItemField<String>("DeliveryStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderRelatedBillingStatus</b>
     * </p>
     *
     * @return Order-Related Billing Status (Item)
     */
    @SerializedName( "OrderRelatedBillingStatus" )
    @JsonProperty( "OrderRelatedBillingStatus" )
    @Nullable
    @ODataField( odataName = "OrderRelatedBillingStatus" )
    private String orderRelatedBillingStatus;
    /**
     * Use with available fluent helpers to apply the <b>OrderRelatedBillingStatus</b> field to query operations.
     *
     */
    public final static SalesOrderItemField<String> ORDER_RELATED_BILLING_STATUS =
        new SalesOrderItemField<String>("OrderRelatedBillingStatus");
    /**
     * Navigation property <b>to_BillingPlan</b> for <b>SalesOrderItem</b> to single <b>SalesOrderItemBillingPlan</b>.
     *
     */
    @SerializedName( "to_BillingPlan" )
    @JsonProperty( "to_BillingPlan" )
    @ODataField( odataName = "to_BillingPlan" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderItemBillingPlan toBillingPlan;
    /**
     * Navigation property <b>to_Partner</b> for <b>SalesOrderItem</b> to multiple <b>SalesOrderItemPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItemPartner> toPartner;
    /**
     * Navigation property <b>to_PrecedingProcFlowDocItem</b> for <b>SalesOrderItem</b> to multiple
     * <b>SalesOrderItmPrecdgProcFlow</b>.
     *
     */
    @SerializedName( "to_PrecedingProcFlowDocItem" )
    @JsonProperty( "to_PrecedingProcFlowDocItem" )
    @ODataField( odataName = "to_PrecedingProcFlowDocItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItmPrecdgProcFlow> toPrecedingProcFlowDocItem;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>SalesOrderItem</b> to multiple
     * <b>SalesOrderItemPrElement</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItemPrElement> toPricingElement;
    /**
     * Navigation property <b>to_RelatedObject</b> for <b>SalesOrderItem</b> to multiple
     * <b>SalesOrderItemRelatedObject</b>.
     *
     */
    @SerializedName( "to_RelatedObject" )
    @JsonProperty( "to_RelatedObject" )
    @ODataField( odataName = "to_RelatedObject" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItemRelatedObject> toRelatedObject;
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderItem</b> to single <b>SalesOrder</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrder toSalesOrder;
    /**
     * Navigation property <b>to_ScheduleLine</b> for <b>SalesOrderItem</b> to multiple <b>SalesOrderScheduleLine</b>.
     *
     */
    @SerializedName( "to_ScheduleLine" )
    @JsonProperty( "to_ScheduleLine" )
    @ODataField( odataName = "to_ScheduleLine" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderScheduleLine> toScheduleLine;
    /**
     * Navigation property <b>to_SubsequentProcFlowDocItem</b> for <b>SalesOrderItem</b> to multiple
     * <b>SalesOrderItmSubsqntProcFlow</b>.
     *
     */
    @SerializedName( "to_SubsequentProcFlowDocItem" )
    @JsonProperty( "to_SubsequentProcFlowDocItem" )
    @ODataField( odataName = "to_SubsequentProcFlowDocItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItmSubsqntProcFlow> toSubsequentProcFlowDocItem;
    /**
     * Navigation property <b>to_Text</b> for <b>SalesOrderItem</b> to multiple <b>SalesOrderItemText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItemText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingPlan</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemOneToOneLink<SalesOrderItemBillingPlan> TO_BILLING_PLAN =
        new SalesOrderItemOneToOneLink<SalesOrderItemBillingPlan>("to_BillingPlan");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemLink<SalesOrderItemPartner> TO_PARTNER =
        new SalesOrderItemLink<SalesOrderItemPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PrecedingProcFlowDocItem</b> navigation property to query
     * operations.
     *
     */
    public final static SalesOrderItemLink<SalesOrderItmPrecdgProcFlow> TO_PRECEDING_PROC_FLOW_DOC_ITEM =
        new SalesOrderItemLink<SalesOrderItmPrecdgProcFlow>("to_PrecedingProcFlowDocItem");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemLink<SalesOrderItemPrElement> TO_PRICING_ELEMENT =
        new SalesOrderItemLink<SalesOrderItemPrElement>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_RelatedObject</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemLink<SalesOrderItemRelatedObject> TO_RELATED_OBJECT =
        new SalesOrderItemLink<SalesOrderItemRelatedObject>("to_RelatedObject");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemOneToOneLink<SalesOrder> TO_SALES_ORDER =
        new SalesOrderItemOneToOneLink<SalesOrder>("to_SalesOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_ScheduleLine</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemLink<SalesOrderScheduleLine> TO_SCHEDULE_LINE =
        new SalesOrderItemLink<SalesOrderScheduleLine>("to_ScheduleLine");
    /**
     * Use with available fluent helpers to apply the <b>to_SubsequentProcFlowDocItem</b> navigation property to query
     * operations.
     *
     */
    public final static SalesOrderItemLink<SalesOrderItmSubsqntProcFlow> TO_SUBSEQUENT_PROC_FLOW_DOC_ITEM =
        new SalesOrderItemLink<SalesOrderItmSubsqntProcFlow>("to_SubsequentProcFlowDocItem");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemLink<SalesOrderItemText> TO_TEXT =
        new SalesOrderItemLink<SalesOrderItemText>("to_Text");

    @Nonnull
    @Override
    public Class<SalesOrderItem> getType()
    {
        return SalesOrderItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @param higherLevelItem
     *            Higher-Level Item in Bill of Material Structures
     */
    public void setHigherLevelItem( @Nullable final String higherLevelItem )
    {
        rememberChangedField("HigherLevelItem", this.higherLevelItem);
        this.higherLevelItem = higherLevelItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItemUsage</b>
     * </p>
     *
     * @param higherLevelItemUsage
     *            ID for higher-level item usage
     */
    public void setHigherLevelItemUsage( @Nullable final String higherLevelItemUsage )
    {
        rememberChangedField("HigherLevelItemUsage", this.higherLevelItemUsage);
        this.higherLevelItemUsage = higherLevelItemUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemCategory</b>
     * </p>
     *
     * @param salesOrderItemCategory
     *            Sales Document Item Category
     */
    public void setSalesOrderItemCategory( @Nullable final String salesOrderItemCategory )
    {
        rememberChangedField("SalesOrderItemCategory", this.salesOrderItemCategory);
        this.salesOrderItemCategory = salesOrderItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemText</b>
     * </p>
     *
     * @param salesOrderItemText
     *            Short Text for Sales Order Item
     */
    public void setSalesOrderItemText( @Nullable final String salesOrderItemText )
    {
        rememberChangedField("SalesOrderItemText", this.salesOrderItemText);
        this.salesOrderItemText = salesOrderItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByShipToParty</b>
     * </p>
     *
     * @param purchaseOrderByShipToParty
     *            Ship-to Party's Customer Reference
     */
    public void setPurchaseOrderByShipToParty( @Nullable final String purchaseOrderByShipToParty )
    {
        rememberChangedField("PurchaseOrderByShipToParty", this.purchaseOrderByShipToParty);
        this.purchaseOrderByShipToParty = purchaseOrderByShipToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>UnderlyingPurchaseOrderItem</b>
     * </p>
     *
     * @param underlyingPurchaseOrderItem
     *            Item Number of the Underlying Purchase Order
     */
    public void setUnderlyingPurchaseOrderItem( @Nullable final String underlyingPurchaseOrderItem )
    {
        rememberChangedField("UnderlyingPurchaseOrderItem", this.underlyingPurchaseOrderItem);
        this.underlyingPurchaseOrderItem = underlyingPurchaseOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ExternalItemID</b>
     * </p>
     *
     * @param externalItemID
     *            External Item ID
     */
    public void setExternalItemID( @Nullable final String externalItemID )
    {
        rememberChangedField("ExternalItemID", this.externalItemID);
        this.externalItemID = externalItemID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Material Number Used by Customer
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PricingReferenceMaterial</b>
     * </p>
     *
     * @param pricingReferenceMaterial
     *            Pricing Reference Material
     */
    public void setPricingReferenceMaterial( @Nullable final String pricingReferenceMaterial )
    {
        rememberChangedField("PricingReferenceMaterial", this.pricingReferenceMaterial);
        this.pricingReferenceMaterial = pricingReferenceMaterial;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     */
    public void setBillingPlan( @Nullable final String billingPlan )
    {
        rememberChangedField("BillingPlan", this.billingPlan);
        this.billingPlan = billingPlan;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            Requested Quantity
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @param requestedQuantityUnit
     *            Unit of the Requested Quantity
     */
    public void setRequestedQuantityUnit( @Nullable final String requestedQuantityUnit )
    {
        rememberChangedField("RequestedQuantityUnit", this.requestedQuantityUnit);
        this.requestedQuantityUnit = requestedQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantitySAPUnit</b>
     * </p>
     *
     * @param requestedQuantitySAPUnit
     *            SAP Unit Code for Requested Quantity
     */
    public void setRequestedQuantitySAPUnit( @Nullable final String requestedQuantitySAPUnit )
    {
        rememberChangedField("RequestedQuantitySAPUnit", this.requestedQuantitySAPUnit);
        this.requestedQuantitySAPUnit = requestedQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityISOUnit</b>
     * </p>
     *
     * @param requestedQuantityISOUnit
     *            ISO Unit Code for Requested Quantity
     */
    public void setRequestedQuantityISOUnit( @Nullable final String requestedQuantityISOUnit )
    {
        rememberChangedField("RequestedQuantityISOUnit", this.requestedQuantityISOUnit);
        this.requestedQuantityISOUnit = requestedQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @param orderQuantitySAPUnit
     *            SAP Unit Code for Order Quantity
     */
    public void setOrderQuantitySAPUnit( @Nullable final String orderQuantitySAPUnit )
    {
        rememberChangedField("OrderQuantitySAPUnit", this.orderQuantitySAPUnit);
        this.orderQuantitySAPUnit = orderQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @param orderQuantityISOUnit
     *            ISO Unit Code for Order Quantity
     */
    public void setOrderQuantityISOUnit( @Nullable final String orderQuantityISOUnit )
    {
        rememberChangedField("OrderQuantityISOUnit", this.orderQuantityISOUnit);
        this.orderQuantityISOUnit = orderQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdDelivQtyInOrderQtyUnit</b>
     * </p>
     *
     * @param confdDelivQtyInOrderQtyUnit
     *            Cumulative Confirmed Quantity in Sales Unit
     */
    public void setConfdDelivQtyInOrderQtyUnit( @Nullable final BigDecimal confdDelivQtyInOrderQtyUnit )
    {
        rememberChangedField("ConfdDelivQtyInOrderQtyUnit", this.confdDelivQtyInOrderQtyUnit);
        this.confdDelivQtyInOrderQtyUnit = confdDelivQtyInOrderQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @param itemGrossWeight
     *            Gross Weight of the Item
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight of the Item
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightSAPUnit</b>
     * </p>
     *
     * @param itemWeightSAPUnit
     *            SAP Unit Code for Item Weight
     */
    public void setItemWeightSAPUnit( @Nullable final String itemWeightSAPUnit )
    {
        rememberChangedField("ItemWeightSAPUnit", this.itemWeightSAPUnit);
        this.itemWeightSAPUnit = itemWeightSAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightISOUnit</b>
     * </p>
     *
     * @param itemWeightISOUnit
     *            ISO Unit Code for Item Weight
     */
    public void setItemWeightISOUnit( @Nullable final String itemWeightISOUnit )
    {
        rememberChangedField("ItemWeightISOUnit", this.itemWeightISOUnit);
        this.itemWeightISOUnit = itemWeightISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume of the item
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeSAPUnit</b>
     * </p>
     *
     * @param itemVolumeSAPUnit
     *            SAP Unit Code for Item Volume
     */
    public void setItemVolumeSAPUnit( @Nullable final String itemVolumeSAPUnit )
    {
        rememberChangedField("ItemVolumeSAPUnit", this.itemVolumeSAPUnit);
        this.itemVolumeSAPUnit = itemVolumeSAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeISOUnit</b>
     * </p>
     *
     * @param itemVolumeISOUnit
     *            ISO Unit Code for Item Volume
     */
    public void setItemVolumeISOUnit( @Nullable final String itemVolumeISOUnit )
    {
        rememberChangedField("ItemVolumeISOUnit", this.itemVolumeISOUnit);
        this.itemVolumeISOUnit = itemVolumeISOUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of the Order Item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>TotalSDDocReferenceStatus</b>
     * </p>
     *
     * @param totalSDDocReferenceStatus
     *            Overall Reference Status (Item)
     */
    public void setTotalSDDocReferenceStatus( @Nullable final String totalSDDocReferenceStatus )
    {
        rememberChangedField("TotalSDDocReferenceStatus", this.totalSDDocReferenceStatus);
        this.totalSDDocReferenceStatus = totalSDDocReferenceStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDDocReferenceStatus</b>
     * </p>
     *
     * @param sDDocReferenceStatus
     *            Reference Status (Item)
     */
    public void setSDDocReferenceStatus( @Nullable final String sDDocReferenceStatus )
    {
        rememberChangedField("SDDocReferenceStatus", this.sDDocReferenceStatus);
        this.sDDocReferenceStatus = sDDocReferenceStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSubstitutionReason</b>
     * </p>
     *
     * @param materialSubstitutionReason
     *            Reason for material substitution
     */
    public void setMaterialSubstitutionReason( @Nullable final String materialSubstitutionReason )
    {
        rememberChangedField("MaterialSubstitutionReason", this.materialSubstitutionReason);
        this.materialSubstitutionReason = materialSubstitutionReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @param materialPricingGroup
     *            Material Price Group
     */
    public void setMaterialPricingGroup( @Nullable final String materialPricingGroup )
    {
        rememberChangedField("MaterialPricingGroup", this.materialPricingGroup);
        this.materialPricingGroup = materialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup1</b>
     * </p>
     *
     * @param additionalMaterialGroup1
     *            Material Group 1
     */
    public void setAdditionalMaterialGroup1( @Nullable final String additionalMaterialGroup1 )
    {
        rememberChangedField("AdditionalMaterialGroup1", this.additionalMaterialGroup1);
        this.additionalMaterialGroup1 = additionalMaterialGroup1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup2</b>
     * </p>
     *
     * @param additionalMaterialGroup2
     *            Material Group 2
     */
    public void setAdditionalMaterialGroup2( @Nullable final String additionalMaterialGroup2 )
    {
        rememberChangedField("AdditionalMaterialGroup2", this.additionalMaterialGroup2);
        this.additionalMaterialGroup2 = additionalMaterialGroup2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup3</b>
     * </p>
     *
     * @param additionalMaterialGroup3
     *            Material Group 3
     */
    public void setAdditionalMaterialGroup3( @Nullable final String additionalMaterialGroup3 )
    {
        rememberChangedField("AdditionalMaterialGroup3", this.additionalMaterialGroup3);
        this.additionalMaterialGroup3 = additionalMaterialGroup3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup4</b>
     * </p>
     *
     * @param additionalMaterialGroup4
     *            Material Group 4
     */
    public void setAdditionalMaterialGroup4( @Nullable final String additionalMaterialGroup4 )
    {
        rememberChangedField("AdditionalMaterialGroup4", this.additionalMaterialGroup4);
        this.additionalMaterialGroup4 = additionalMaterialGroup4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMaterialGroup5</b>
     * </p>
     *
     * @param additionalMaterialGroup5
     *            Material Group 5
     */
    public void setAdditionalMaterialGroup5( @Nullable final String additionalMaterialGroup5 )
    {
        rememberChangedField("AdditionalMaterialGroup5", this.additionalMaterialGroup5);
        this.additionalMaterialGroup5 = additionalMaterialGroup5;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingDocumentDate</b>
     * </p>
     *
     * @param billingDocumentDate
     *            Billing Date
     */
    public void setBillingDocumentDate( @Nullable final LocalDateTime billingDocumentDate )
    {
        rememberChangedField("BillingDocumentDate", this.billingDocumentDate);
        this.billingDocumentDate = billingDocumentDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ContractAccount</b>
     * </p>
     *
     * @param contractAccount
     *            Contract Account Number
     */
    public void setContractAccount( @Nullable final String contractAccount )
    {
        rememberChangedField("ContractAccount", this.contractAccount);
        this.contractAccount = contractAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalValueDays</b>
     * </p>
     *
     * @param additionalValueDays
     *            Additional Value Days
     */
    public void setAdditionalValueDays( @Nullable final String additionalValueDays )
    {
        rememberChangedField("AdditionalValueDays", this.additionalValueDays);
        this.additionalValueDays = additionalValueDays;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ServicesRenderedDate</b>
     * </p>
     *
     * @param servicesRenderedDate
     *            Date on which services are rendered
     */
    public void setServicesRenderedDate( @Nullable final LocalDateTime servicesRenderedDate )
    {
        rememberChangedField("ServicesRenderedDate", this.servicesRenderedDate);
        this.servicesRenderedDate = servicesRenderedDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ProductionPlant</b>
     * </p>
     *
     * @param productionPlant
     *            Plant (Own or External)
     */
    public void setProductionPlant( @Nullable final String productionPlant )
    {
        rememberChangedField("ProductionPlant", this.productionPlant);
        this.productionPlant = productionPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>OriginalPlant</b>
     * </p>
     *
     * @param originalPlant
     *            Original Plant in Plant Substitution
     */
    public void setOriginalPlant( @Nullable final String originalPlant )
    {
        rememberChangedField("OriginalPlant", this.originalPlant);
        this.originalPlant = originalPlant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AltvBsdConfSubstitutionStatus</b>
     * </p>
     *
     * @param altvBsdConfSubstitutionStatus
     *            Substitution Status for Alternative-Based Confirmation (ABC)
     */
    public void setAltvBsdConfSubstitutionStatus( @Nullable final String altvBsdConfSubstitutionStatus )
    {
        rememberChangedField("AltvBsdConfSubstitutionStatus", this.altvBsdConfSubstitutionStatus);
        this.altvBsdConfSubstitutionStatus = altvBsdConfSubstitutionStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryGroup</b>
     * </p>
     *
     * @param deliveryGroup
     *            Delivery Group (Items are delivered together)
     */
    public void setDeliveryGroup( @Nullable final String deliveryGroup )
    {
        rememberChangedField("DeliveryGroup", this.deliveryGroup);
        this.deliveryGroup = deliveryGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @param deliveryPriority
     *            Delivery Priority
     */
    public void setDeliveryPriority( @Nullable final String deliveryPriority )
    {
        rememberChangedField("DeliveryPriority", this.deliveryPriority);
        this.deliveryPriority = deliveryPriority;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDateQuantityIsFixed</b>
     * </p>
     *
     * @param deliveryDateQuantityIsFixed
     *            Delivery Date and Quantity Fixed
     */
    public void setDeliveryDateQuantityIsFixed( @Nullable final Boolean deliveryDateQuantityIsFixed )
    {
        rememberChangedField("DeliveryDateQuantityIsFixed", this.deliveryDateQuantityIsFixed);
        this.deliveryDateQuantityIsFixed = deliveryDateQuantityIsFixed;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDateTypeRule</b>
     * </p>
     *
     * @param deliveryDateTypeRule
     *            Delivery Date Rule
     */
    public void setDeliveryDateTypeRule( @Nullable final String deliveryDateTypeRule )
    {
        rememberChangedField("DeliveryDateTypeRule", this.deliveryDateTypeRule);
        this.deliveryDateTypeRule = deliveryDateTypeRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @param taxAmount
     *            Tax Amount in Document Currency
     */
    public void setTaxAmount( @Nullable final BigDecimal taxAmount )
    {
        rememberChangedField("TaxAmount", this.taxAmount);
        this.taxAmount = taxAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @param productTaxClassification1
     *            Tax Classification for Material
     */
    public void setProductTaxClassification1( @Nullable final String productTaxClassification1 )
    {
        rememberChangedField("ProductTaxClassification1", this.productTaxClassification1);
        this.productTaxClassification1 = productTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @param productTaxClassification2
     *            Tax Classification for Material
     */
    public void setProductTaxClassification2( @Nullable final String productTaxClassification2 )
    {
        rememberChangedField("ProductTaxClassification2", this.productTaxClassification2);
        this.productTaxClassification2 = productTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @param productTaxClassification3
     *            Tax Classification for Material
     */
    public void setProductTaxClassification3( @Nullable final String productTaxClassification3 )
    {
        rememberChangedField("ProductTaxClassification3", this.productTaxClassification3);
        this.productTaxClassification3 = productTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @param productTaxClassification4
     *            Tax Classification for Material
     */
    public void setProductTaxClassification4( @Nullable final String productTaxClassification4 )
    {
        rememberChangedField("ProductTaxClassification4", this.productTaxClassification4);
        this.productTaxClassification4 = productTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @param productTaxClassification5
     *            Tax Classification for Material
     */
    public void setProductTaxClassification5( @Nullable final String productTaxClassification5 )
    {
        rememberChangedField("ProductTaxClassification5", this.productTaxClassification5);
        this.productTaxClassification5 = productTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @param productTaxClassification6
     *            Tax Classification for Material
     */
    public void setProductTaxClassification6( @Nullable final String productTaxClassification6 )
    {
        rememberChangedField("ProductTaxClassification6", this.productTaxClassification6);
        this.productTaxClassification6 = productTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @param productTaxClassification7
     *            Tax Classification for Material
     */
    public void setProductTaxClassification7( @Nullable final String productTaxClassification7 )
    {
        rememberChangedField("ProductTaxClassification7", this.productTaxClassification7);
        this.productTaxClassification7 = productTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @param productTaxClassification8
     *            Tax Classification for Material
     */
    public void setProductTaxClassification8( @Nullable final String productTaxClassification8 )
    {
        rememberChangedField("ProductTaxClassification8", this.productTaxClassification8);
        this.productTaxClassification8 = productTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @param productTaxClassification9
     *            Tax Classification for Material
     */
    public void setProductTaxClassification9( @Nullable final String productTaxClassification9 )
    {
        rememberChangedField("ProductTaxClassification9", this.productTaxClassification9);
        this.productTaxClassification9 = productTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MatlAccountAssignmentGroup</b>
     * </p>
     *
     * @param matlAccountAssignmentGroup
     *            Account Assignment Group for Material
     */
    public void setMatlAccountAssignmentGroup( @Nullable final String matlAccountAssignmentGroup )
    {
        rememberChangedField("MatlAccountAssignmentGroup", this.matlAccountAssignmentGroup);
        this.matlAccountAssignmentGroup = matlAccountAssignmentGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostAmount</b>
     * </p>
     *
     * @param costAmount
     *            Cost in Document Currency
     */
    public void setCostAmount( @Nullable final BigDecimal costAmount )
    {
        rememberChangedField("CostAmount", this.costAmount);
        this.costAmount = costAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FixedValueDate</b>
     * </p>
     *
     * @param fixedValueDate
     *            Fixed Value Date
     */
    public void setFixedValueDate( @Nullable final LocalDateTime fixedValueDate )
    {
        rememberChangedField("FixedValueDate", this.fixedValueDate);
        this.fixedValueDate = fixedValueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerGroup</b>
     * </p>
     *
     * @param customerGroup
     *            Customer Group
     */
    public void setCustomerGroup( @Nullable final String customerGroup )
    {
        rememberChangedField("CustomerGroup", this.customerGroup);
        this.customerGroup = customerGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     */
    public void setSalesDocumentRjcnReason( @Nullable final String salesDocumentRjcnReason )
    {
        rememberChangedField("SalesDocumentRjcnReason", this.salesDocumentRjcnReason);
        this.salesDocumentRjcnReason = salesDocumentRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ItemBillingBlockReason</b>
     * </p>
     *
     * @param itemBillingBlockReason
     *            Billing Block for Item
     */
    public void setItemBillingBlockReason( @Nullable final String itemBillingBlockReason )
    {
        rememberChangedField("ItemBillingBlockReason", this.itemBillingBlockReason);
        this.itemBillingBlockReason = itemBillingBlockReason;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SlsDocIsRlvtForProofOfDeliv</b>
     * </p>
     *
     * @param slsDocIsRlvtForProofOfDeliv
     *            Relevant for POD processing
     */
    public void setSlsDocIsRlvtForProofOfDeliv( @Nullable final Boolean slsDocIsRlvtForProofOfDeliv )
    {
        rememberChangedField("SlsDocIsRlvtForProofOfDeliv", this.slsDocIsRlvtForProofOfDeliv);
        this.slsDocIsRlvtForProofOfDeliv = slsDocIsRlvtForProofOfDeliv;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AccountingExchangeRate</b>
     * </p>
     *
     * @param accountingExchangeRate
     *            Exchange Rate for Postings to Financial Accounting
     */
    public void setAccountingExchangeRate( @Nullable final BigDecimal accountingExchangeRate )
    {
        rememberChangedField("AccountingExchangeRate", this.accountingExchangeRate);
        this.accountingExchangeRate = accountingExchangeRate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @param referenceSDDocumentItem
     *            Item Number of the Reference Item
     */
    public void setReferenceSDDocumentItem( @Nullable final String referenceSDDocumentItem )
    {
        rememberChangedField("ReferenceSDDocumentItem", this.referenceSDDocumentItem);
        this.referenceSDDocumentItem = referenceSDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @param sDProcessStatus
     *            Overall Processing Status (Item)
     */
    public void setSDProcessStatus( @Nullable final String sDProcessStatus )
    {
        rememberChangedField("SDProcessStatus", this.sDProcessStatus);
        this.sDProcessStatus = sDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryStatus</b>
     * </p>
     *
     * @param deliveryStatus
     *            Delivery Status (Item)
     */
    public void setDeliveryStatus( @Nullable final String deliveryStatus )
    {
        rememberChangedField("DeliveryStatus", this.deliveryStatus);
        this.deliveryStatus = deliveryStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OrderRelatedBillingStatus</b>
     * </p>
     *
     * @param orderRelatedBillingStatus
     *            Order-Related Billing Status (Item)
     */
    public void setOrderRelatedBillingStatus( @Nullable final String orderRelatedBillingStatus )
    {
        rememberChangedField("OrderRelatedBillingStatus", this.orderRelatedBillingStatus);
        this.orderRelatedBillingStatus = orderRelatedBillingStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        result.put("SalesOrderItem", getSalesOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("HigherLevelItem", getHigherLevelItem());
        values.put("HigherLevelItemUsage", getHigherLevelItemUsage());
        values.put("SalesOrderItemCategory", getSalesOrderItemCategory());
        values.put("SalesOrderItemText", getSalesOrderItemText());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("PurchaseOrderByShipToParty", getPurchaseOrderByShipToParty());
        values.put("UnderlyingPurchaseOrderItem", getUnderlyingPurchaseOrderItem());
        values.put("ExternalItemID", getExternalItemID());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("PricingDate", getPricingDate());
        values.put("PricingReferenceMaterial", getPricingReferenceMaterial());
        values.put("BillingPlan", getBillingPlan());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("RequestedQuantityUnit", getRequestedQuantityUnit());
        values.put("RequestedQuantitySAPUnit", getRequestedQuantitySAPUnit());
        values.put("RequestedQuantityISOUnit", getRequestedQuantityISOUnit());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("OrderQuantitySAPUnit", getOrderQuantitySAPUnit());
        values.put("OrderQuantityISOUnit", getOrderQuantityISOUnit());
        values.put("ConfdDelivQtyInOrderQtyUnit", getConfdDelivQtyInOrderQtyUnit());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("ItemWeightSAPUnit", getItemWeightSAPUnit());
        values.put("ItemWeightISOUnit", getItemWeightISOUnit());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("ItemVolumeSAPUnit", getItemVolumeSAPUnit());
        values.put("ItemVolumeISOUnit", getItemVolumeISOUnit());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("NetAmount", getNetAmount());
        values.put("TotalSDDocReferenceStatus", getTotalSDDocReferenceStatus());
        values.put("SDDocReferenceStatus", getSDDocReferenceStatus());
        values.put("MaterialSubstitutionReason", getMaterialSubstitutionReason());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialPricingGroup", getMaterialPricingGroup());
        values.put("AdditionalMaterialGroup1", getAdditionalMaterialGroup1());
        values.put("AdditionalMaterialGroup2", getAdditionalMaterialGroup2());
        values.put("AdditionalMaterialGroup3", getAdditionalMaterialGroup3());
        values.put("AdditionalMaterialGroup4", getAdditionalMaterialGroup4());
        values.put("AdditionalMaterialGroup5", getAdditionalMaterialGroup5());
        values.put("BillingDocumentDate", getBillingDocumentDate());
        values.put("ContractAccount", getContractAccount());
        values.put("AdditionalValueDays", getAdditionalValueDays());
        values.put("ServicesRenderedDate", getServicesRenderedDate());
        values.put("Batch", getBatch());
        values.put("ProductionPlant", getProductionPlant());
        values.put("OriginalPlant", getOriginalPlant());
        values.put("AltvBsdConfSubstitutionStatus", getAltvBsdConfSubstitutionStatus());
        values.put("StorageLocation", getStorageLocation());
        values.put("DeliveryGroup", getDeliveryGroup());
        values.put("ShippingPoint", getShippingPoint());
        values.put("ShippingType", getShippingType());
        values.put("DeliveryPriority", getDeliveryPriority());
        values.put("DeliveryDateQuantityIsFixed", getDeliveryDateQuantityIsFixed());
        values.put("DeliveryDateTypeRule", getDeliveryDateTypeRule());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("TaxAmount", getTaxAmount());
        values.put("ProductTaxClassification1", getProductTaxClassification1());
        values.put("ProductTaxClassification2", getProductTaxClassification2());
        values.put("ProductTaxClassification3", getProductTaxClassification3());
        values.put("ProductTaxClassification4", getProductTaxClassification4());
        values.put("ProductTaxClassification5", getProductTaxClassification5());
        values.put("ProductTaxClassification6", getProductTaxClassification6());
        values.put("ProductTaxClassification7", getProductTaxClassification7());
        values.put("ProductTaxClassification8", getProductTaxClassification8());
        values.put("ProductTaxClassification9", getProductTaxClassification9());
        values.put("MatlAccountAssignmentGroup", getMatlAccountAssignmentGroup());
        values.put("CostAmount", getCostAmount());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("FixedValueDate", getFixedValueDate());
        values.put("CustomerGroup", getCustomerGroup());
        values.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        values.put("ItemBillingBlockReason", getItemBillingBlockReason());
        values.put("SlsDocIsRlvtForProofOfDeliv", getSlsDocIsRlvtForProofOfDeliv());
        values.put("WBSElement", getWBSElement());
        values.put("ProfitCenter", getProfitCenter());
        values.put("AccountingExchangeRate", getAccountingExchangeRate());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentItem", getReferenceSDDocumentItem());
        values.put("SDProcessStatus", getSDProcessStatus());
        values.put("DeliveryStatus", getDeliveryStatus());
        values.put("OrderRelatedBillingStatus", getOrderRelatedBillingStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItem") ) {
                final Object value = values.remove("HigherLevelItem");
                if( (value == null) || (!value.equals(getHigherLevelItem())) ) {
                    setHigherLevelItem(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItemUsage") ) {
                final Object value = values.remove("HigherLevelItemUsage");
                if( (value == null) || (!value.equals(getHigherLevelItemUsage())) ) {
                    setHigherLevelItemUsage(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItemCategory") ) {
                final Object value = values.remove("SalesOrderItemCategory");
                if( (value == null) || (!value.equals(getSalesOrderItemCategory())) ) {
                    setSalesOrderItemCategory(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItemText") ) {
                final Object value = values.remove("SalesOrderItemText");
                if( (value == null) || (!value.equals(getSalesOrderItemText())) ) {
                    setSalesOrderItemText(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByShipToParty") ) {
                final Object value = values.remove("PurchaseOrderByShipToParty");
                if( (value == null) || (!value.equals(getPurchaseOrderByShipToParty())) ) {
                    setPurchaseOrderByShipToParty(((String) value));
                }
            }
            if( values.containsKey("UnderlyingPurchaseOrderItem") ) {
                final Object value = values.remove("UnderlyingPurchaseOrderItem");
                if( (value == null) || (!value.equals(getUnderlyingPurchaseOrderItem())) ) {
                    setUnderlyingPurchaseOrderItem(((String) value));
                }
            }
            if( values.containsKey("ExternalItemID") ) {
                final Object value = values.remove("ExternalItemID");
                if( (value == null) || (!value.equals(getExternalItemID())) ) {
                    setExternalItemID(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PricingReferenceMaterial") ) {
                final Object value = values.remove("PricingReferenceMaterial");
                if( (value == null) || (!value.equals(getPricingReferenceMaterial())) ) {
                    setPricingReferenceMaterial(((String) value));
                }
            }
            if( values.containsKey("BillingPlan") ) {
                final Object value = values.remove("BillingPlan");
                if( (value == null) || (!value.equals(getBillingPlan())) ) {
                    setBillingPlan(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RequestedQuantityUnit") ) {
                final Object value = values.remove("RequestedQuantityUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityUnit())) ) {
                    setRequestedQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantitySAPUnit") ) {
                final Object value = values.remove("RequestedQuantitySAPUnit");
                if( (value == null) || (!value.equals(getRequestedQuantitySAPUnit())) ) {
                    setRequestedQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantityISOUnit") ) {
                final Object value = values.remove("RequestedQuantityISOUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityISOUnit())) ) {
                    setRequestedQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantitySAPUnit") ) {
                final Object value = values.remove("OrderQuantitySAPUnit");
                if( (value == null) || (!value.equals(getOrderQuantitySAPUnit())) ) {
                    setOrderQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityISOUnit") ) {
                final Object value = values.remove("OrderQuantityISOUnit");
                if( (value == null) || (!value.equals(getOrderQuantityISOUnit())) ) {
                    setOrderQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("ConfdDelivQtyInOrderQtyUnit") ) {
                final Object value = values.remove("ConfdDelivQtyInOrderQtyUnit");
                if( (value == null) || (!value.equals(getConfdDelivQtyInOrderQtyUnit())) ) {
                    setConfdDelivQtyInOrderQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightSAPUnit") ) {
                final Object value = values.remove("ItemWeightSAPUnit");
                if( (value == null) || (!value.equals(getItemWeightSAPUnit())) ) {
                    setItemWeightSAPUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightISOUnit") ) {
                final Object value = values.remove("ItemWeightISOUnit");
                if( (value == null) || (!value.equals(getItemWeightISOUnit())) ) {
                    setItemWeightISOUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolumeSAPUnit") ) {
                final Object value = values.remove("ItemVolumeSAPUnit");
                if( (value == null) || (!value.equals(getItemVolumeSAPUnit())) ) {
                    setItemVolumeSAPUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolumeISOUnit") ) {
                final Object value = values.remove("ItemVolumeISOUnit");
                if( (value == null) || (!value.equals(getItemVolumeISOUnit())) ) {
                    setItemVolumeISOUnit(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TotalSDDocReferenceStatus") ) {
                final Object value = values.remove("TotalSDDocReferenceStatus");
                if( (value == null) || (!value.equals(getTotalSDDocReferenceStatus())) ) {
                    setTotalSDDocReferenceStatus(((String) value));
                }
            }
            if( values.containsKey("SDDocReferenceStatus") ) {
                final Object value = values.remove("SDDocReferenceStatus");
                if( (value == null) || (!value.equals(getSDDocReferenceStatus())) ) {
                    setSDDocReferenceStatus(((String) value));
                }
            }
            if( values.containsKey("MaterialSubstitutionReason") ) {
                final Object value = values.remove("MaterialSubstitutionReason");
                if( (value == null) || (!value.equals(getMaterialSubstitutionReason())) ) {
                    setMaterialSubstitutionReason(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialPricingGroup") ) {
                final Object value = values.remove("MaterialPricingGroup");
                if( (value == null) || (!value.equals(getMaterialPricingGroup())) ) {
                    setMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup1") ) {
                final Object value = values.remove("AdditionalMaterialGroup1");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup1())) ) {
                    setAdditionalMaterialGroup1(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup2") ) {
                final Object value = values.remove("AdditionalMaterialGroup2");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup2())) ) {
                    setAdditionalMaterialGroup2(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup3") ) {
                final Object value = values.remove("AdditionalMaterialGroup3");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup3())) ) {
                    setAdditionalMaterialGroup3(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup4") ) {
                final Object value = values.remove("AdditionalMaterialGroup4");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup4())) ) {
                    setAdditionalMaterialGroup4(((String) value));
                }
            }
            if( values.containsKey("AdditionalMaterialGroup5") ) {
                final Object value = values.remove("AdditionalMaterialGroup5");
                if( (value == null) || (!value.equals(getAdditionalMaterialGroup5())) ) {
                    setAdditionalMaterialGroup5(((String) value));
                }
            }
            if( values.containsKey("BillingDocumentDate") ) {
                final Object value = values.remove("BillingDocumentDate");
                if( (value == null) || (!value.equals(getBillingDocumentDate())) ) {
                    setBillingDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ContractAccount") ) {
                final Object value = values.remove("ContractAccount");
                if( (value == null) || (!value.equals(getContractAccount())) ) {
                    setContractAccount(((String) value));
                }
            }
            if( values.containsKey("AdditionalValueDays") ) {
                final Object value = values.remove("AdditionalValueDays");
                if( (value == null) || (!value.equals(getAdditionalValueDays())) ) {
                    setAdditionalValueDays(((String) value));
                }
            }
            if( values.containsKey("ServicesRenderedDate") ) {
                final Object value = values.remove("ServicesRenderedDate");
                if( (value == null) || (!value.equals(getServicesRenderedDate())) ) {
                    setServicesRenderedDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("ProductionPlant") ) {
                final Object value = values.remove("ProductionPlant");
                if( (value == null) || (!value.equals(getProductionPlant())) ) {
                    setProductionPlant(((String) value));
                }
            }
            if( values.containsKey("OriginalPlant") ) {
                final Object value = values.remove("OriginalPlant");
                if( (value == null) || (!value.equals(getOriginalPlant())) ) {
                    setOriginalPlant(((String) value));
                }
            }
            if( values.containsKey("AltvBsdConfSubstitutionStatus") ) {
                final Object value = values.remove("AltvBsdConfSubstitutionStatus");
                if( (value == null) || (!value.equals(getAltvBsdConfSubstitutionStatus())) ) {
                    setAltvBsdConfSubstitutionStatus(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("DeliveryGroup") ) {
                final Object value = values.remove("DeliveryGroup");
                if( (value == null) || (!value.equals(getDeliveryGroup())) ) {
                    setDeliveryGroup(((String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("DeliveryPriority") ) {
                final Object value = values.remove("DeliveryPriority");
                if( (value == null) || (!value.equals(getDeliveryPriority())) ) {
                    setDeliveryPriority(((String) value));
                }
            }
            if( values.containsKey("DeliveryDateQuantityIsFixed") ) {
                final Object value = values.remove("DeliveryDateQuantityIsFixed");
                if( (value == null) || (!value.equals(getDeliveryDateQuantityIsFixed())) ) {
                    setDeliveryDateQuantityIsFixed(((Boolean) value));
                }
            }
            if( values.containsKey("DeliveryDateTypeRule") ) {
                final Object value = values.remove("DeliveryDateTypeRule");
                if( (value == null) || (!value.equals(getDeliveryDateTypeRule())) ) {
                    setDeliveryDateTypeRule(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("TaxAmount") ) {
                final Object value = values.remove("TaxAmount");
                if( (value == null) || (!value.equals(getTaxAmount())) ) {
                    setTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("ProductTaxClassification1") ) {
                final Object value = values.remove("ProductTaxClassification1");
                if( (value == null) || (!value.equals(getProductTaxClassification1())) ) {
                    setProductTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification2") ) {
                final Object value = values.remove("ProductTaxClassification2");
                if( (value == null) || (!value.equals(getProductTaxClassification2())) ) {
                    setProductTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification3") ) {
                final Object value = values.remove("ProductTaxClassification3");
                if( (value == null) || (!value.equals(getProductTaxClassification3())) ) {
                    setProductTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification4") ) {
                final Object value = values.remove("ProductTaxClassification4");
                if( (value == null) || (!value.equals(getProductTaxClassification4())) ) {
                    setProductTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification5") ) {
                final Object value = values.remove("ProductTaxClassification5");
                if( (value == null) || (!value.equals(getProductTaxClassification5())) ) {
                    setProductTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification6") ) {
                final Object value = values.remove("ProductTaxClassification6");
                if( (value == null) || (!value.equals(getProductTaxClassification6())) ) {
                    setProductTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification7") ) {
                final Object value = values.remove("ProductTaxClassification7");
                if( (value == null) || (!value.equals(getProductTaxClassification7())) ) {
                    setProductTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification8") ) {
                final Object value = values.remove("ProductTaxClassification8");
                if( (value == null) || (!value.equals(getProductTaxClassification8())) ) {
                    setProductTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification9") ) {
                final Object value = values.remove("ProductTaxClassification9");
                if( (value == null) || (!value.equals(getProductTaxClassification9())) ) {
                    setProductTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("MatlAccountAssignmentGroup") ) {
                final Object value = values.remove("MatlAccountAssignmentGroup");
                if( (value == null) || (!value.equals(getMatlAccountAssignmentGroup())) ) {
                    setMatlAccountAssignmentGroup(((String) value));
                }
            }
            if( values.containsKey("CostAmount") ) {
                final Object value = values.remove("CostAmount");
                if( (value == null) || (!value.equals(getCostAmount())) ) {
                    setCostAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("FixedValueDate") ) {
                final Object value = values.remove("FixedValueDate");
                if( (value == null) || (!value.equals(getFixedValueDate())) ) {
                    setFixedValueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CustomerGroup") ) {
                final Object value = values.remove("CustomerGroup");
                if( (value == null) || (!value.equals(getCustomerGroup())) ) {
                    setCustomerGroup(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentRjcnReason") ) {
                final Object value = values.remove("SalesDocumentRjcnReason");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason())) ) {
                    setSalesDocumentRjcnReason(((String) value));
                }
            }
            if( values.containsKey("ItemBillingBlockReason") ) {
                final Object value = values.remove("ItemBillingBlockReason");
                if( (value == null) || (!value.equals(getItemBillingBlockReason())) ) {
                    setItemBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("SlsDocIsRlvtForProofOfDeliv") ) {
                final Object value = values.remove("SlsDocIsRlvtForProofOfDeliv");
                if( (value == null) || (!value.equals(getSlsDocIsRlvtForProofOfDeliv())) ) {
                    setSlsDocIsRlvtForProofOfDeliv(((Boolean) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("AccountingExchangeRate") ) {
                final Object value = values.remove("AccountingExchangeRate");
                if( (value == null) || (!value.equals(getAccountingExchangeRate())) ) {
                    setAccountingExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentItem") ) {
                final Object value = values.remove("ReferenceSDDocumentItem");
                if( (value == null) || (!value.equals(getReferenceSDDocumentItem())) ) {
                    setReferenceSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SDProcessStatus") ) {
                final Object value = values.remove("SDProcessStatus");
                if( (value == null) || (!value.equals(getSDProcessStatus())) ) {
                    setSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("DeliveryStatus") ) {
                final Object value = values.remove("DeliveryStatus");
                if( (value == null) || (!value.equals(getDeliveryStatus())) ) {
                    setDeliveryStatus(((String) value));
                }
            }
            if( values.containsKey("OrderRelatedBillingStatus") ) {
                final Object value = values.remove("OrderRelatedBillingStatus");
                if( (value == null) || (!value.equals(getOrderRelatedBillingStatus())) ) {
                    setOrderRelatedBillingStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingPlan") ) {
                final Object value = (values).remove("to_BillingPlan");
                if( value instanceof Map ) {
                    if( toBillingPlan == null ) {
                        toBillingPlan = new SalesOrderItemBillingPlan();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toBillingPlan.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItemPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SalesOrderItemPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PrecedingProcFlowDocItem") ) {
                final Object value = (values).remove("to_PrecedingProcFlowDocItem");
                if( value instanceof Iterable ) {
                    if( toPrecedingProcFlowDocItem == null ) {
                        toPrecedingProcFlowDocItem = Lists.newArrayList();
                    } else {
                        toPrecedingProcFlowDocItem = Lists.newArrayList(toPrecedingProcFlowDocItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItmPrecdgProcFlow entity;
                        if( toPrecedingProcFlowDocItem.size() > i ) {
                            entity = toPrecedingProcFlowDocItem.get(i);
                        } else {
                            entity = new SalesOrderItmPrecdgProcFlow();
                            toPrecedingProcFlowDocItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItemPrElement entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new SalesOrderItemPrElement();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RelatedObject") ) {
                final Object value = (values).remove("to_RelatedObject");
                if( value instanceof Iterable ) {
                    if( toRelatedObject == null ) {
                        toRelatedObject = Lists.newArrayList();
                    } else {
                        toRelatedObject = Lists.newArrayList(toRelatedObject);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItemRelatedObject entity;
                        if( toRelatedObject.size() > i ) {
                            entity = toRelatedObject.get(i);
                        } else {
                            entity = new SalesOrderItemRelatedObject();
                            toRelatedObject.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Map ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = new SalesOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ScheduleLine") ) {
                final Object value = (values).remove("to_ScheduleLine");
                if( value instanceof Iterable ) {
                    if( toScheduleLine == null ) {
                        toScheduleLine = Lists.newArrayList();
                    } else {
                        toScheduleLine = Lists.newArrayList(toScheduleLine);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderScheduleLine entity;
                        if( toScheduleLine.size() > i ) {
                            entity = toScheduleLine.get(i);
                        } else {
                            entity = new SalesOrderScheduleLine();
                            toScheduleLine.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SubsequentProcFlowDocItem") ) {
                final Object value = (values).remove("to_SubsequentProcFlowDocItem");
                if( value instanceof Iterable ) {
                    if( toSubsequentProcFlowDocItem == null ) {
                        toSubsequentProcFlowDocItem = Lists.newArrayList();
                    } else {
                        toSubsequentProcFlowDocItem = Lists.newArrayList(toSubsequentProcFlowDocItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItmSubsqntProcFlow entity;
                        if( toSubsequentProcFlowDocItem.size() > i ) {
                            entity = toSubsequentProcFlowDocItem.get(i);
                        } else {
                            entity = new SalesOrderItmSubsqntProcFlow();
                            toSubsequentProcFlowDocItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItemText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new SalesOrderItemText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SalesOrderItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingPlan != null ) {
            (values).put("to_BillingPlan", toBillingPlan);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPrecedingProcFlowDocItem != null ) {
            (values).put("to_PrecedingProcFlowDocItem", toPrecedingProcFlowDocItem);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toRelatedObject != null ) {
            (values).put("to_RelatedObject", toRelatedObject);
        }
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        if( toScheduleLine != null ) {
            (values).put("to_ScheduleLine", toScheduleLine);
        }
        if( toSubsequentProcFlowDocItem != null ) {
            (values).put("to_SubsequentProcFlowDocItem", toSubsequentProcFlowDocItem);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderItemBillingPlan</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BillingPlan</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderItemBillingPlan</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderItemBillingPlan fetchBillingPlan()
    {
        return fetchFieldAsSingle("to_BillingPlan", SalesOrderItemBillingPlan.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItemBillingPlan</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingPlan</b>.
     * <p>
     * If the navigation property <b>to_BillingPlan</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItemBillingPlan</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderItemBillingPlan getBillingPlanOrFetch()
    {
        if( toBillingPlan == null ) {
            toBillingPlan = fetchBillingPlan();
        }
        return toBillingPlan;
    }

    /**
     * Retrieval of associated <b>SalesOrderItemBillingPlan</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_BillingPlan</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingPlan</b> is already loaded, the result will
     *         contain the <b>SalesOrderItemBillingPlan</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderItemBillingPlan> getBillingPlanIfPresent()
    {
        return Option.of(toBillingPlan);
    }

    /**
     * Overwrites the associated <b>SalesOrderItemBillingPlan</b> entity for the loaded navigation property
     * <b>to_BillingPlan</b>.
     *
     * @param value
     *            New <b>SalesOrderItemBillingPlan</b> entity.
     */
    public void setBillingPlan( final SalesOrderItemBillingPlan value )
    {
        toBillingPlan = value;
    }

    /**
     * Fetches the <b>SalesOrderItemPartner</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItemPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SalesOrderItemPartner.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItemPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SalesOrderItemPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SalesOrderItemPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderItemPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItemPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItemPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SalesOrderItemPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItemPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItemPartner</b> entities.
     */
    public void addPartner( SalesOrderItemPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderItmPrecdgProcFlow</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PrecedingProcFlowDocItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItmPrecdgProcFlow</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItmPrecdgProcFlow> fetchPrecedingProcFlowDocItem()
    {
        return fetchFieldAsList("to_PrecedingProcFlowDocItem", SalesOrderItmPrecdgProcFlow.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItmPrecdgProcFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PrecedingProcFlowDocItem</b>.
     * <p>
     * If the navigation property <b>to_PrecedingProcFlowDocItem</b> of a queried <b>SalesOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItmPrecdgProcFlow</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItmPrecdgProcFlow> getPrecedingProcFlowDocItemOrFetch()
    {
        if( toPrecedingProcFlowDocItem == null ) {
            toPrecedingProcFlowDocItem = fetchPrecedingProcFlowDocItem();
        }
        return toPrecedingProcFlowDocItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderItmPrecdgProcFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PrecedingProcFlowDocItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PrecedingProcFlowDocItem</b> is already loaded, the
     *         result will contain the <b>SalesOrderItmPrecdgProcFlow</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderItmPrecdgProcFlow>> getPrecedingProcFlowDocItemIfPresent()
    {
        return Option.of(toPrecedingProcFlowDocItem);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItmPrecdgProcFlow</b> entities for the loaded navigation property
     * <b>to_PrecedingProcFlowDocItem</b>.
     * <p>
     * If the navigation property <b>to_PrecedingProcFlowDocItem</b> of a queried <b>SalesOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItmPrecdgProcFlow</b> entities.
     */
    public void setPrecedingProcFlowDocItem( @Nonnull final List<SalesOrderItmPrecdgProcFlow> value )
    {
        if( toPrecedingProcFlowDocItem == null ) {
            toPrecedingProcFlowDocItem = Lists.newArrayList();
        }
        toPrecedingProcFlowDocItem.clear();
        toPrecedingProcFlowDocItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItmPrecdgProcFlow</b> entities. This corresponds to the
     * OData navigation property <b>to_PrecedingProcFlowDocItem</b>.
     * <p>
     * If the navigation property <b>to_PrecedingProcFlowDocItem</b> of a queried <b>SalesOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItmPrecdgProcFlow</b> entities.
     */
    public void addPrecedingProcFlowDocItem( SalesOrderItmPrecdgProcFlow... entity )
    {
        if( toPrecedingProcFlowDocItem == null ) {
            toPrecedingProcFlowDocItem = Lists.newArrayList();
        }
        toPrecedingProcFlowDocItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderItemPrElement</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItemPrElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemPrElement> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", SalesOrderItemPrElement.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItemPrElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItemPrElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemPrElement> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>SalesOrderItemPrElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>SalesOrderItemPrElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderItemPrElement>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItemPrElement</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItemPrElement</b> entities.
     */
    public void setPricingElement( @Nonnull final List<SalesOrderItemPrElement> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItemPrElement</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItemPrElement</b> entities.
     */
    public void addPricingElement( SalesOrderItemPrElement... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderItemRelatedObject</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RelatedObject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItemRelatedObject</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemRelatedObject> fetchRelatedObject()
    {
        return fetchFieldAsList("to_RelatedObject", SalesOrderItemRelatedObject.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItemRelatedObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItemRelatedObject</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemRelatedObject> getRelatedObjectOrFetch()
    {
        if( toRelatedObject == null ) {
            toRelatedObject = fetchRelatedObject();
        }
        return toRelatedObject;
    }

    /**
     * Retrieval of associated <b>SalesOrderItemRelatedObject</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RelatedObject</b> is already loaded, the result will
     *         contain the <b>SalesOrderItemRelatedObject</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderItemRelatedObject>> getRelatedObjectIfPresent()
    {
        return Option.of(toRelatedObject);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItemRelatedObject</b> entities for the loaded navigation property
     * <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItemRelatedObject</b> entities.
     */
    public void setRelatedObject( @Nonnull final List<SalesOrderItemRelatedObject> value )
    {
        if( toRelatedObject == null ) {
            toRelatedObject = Lists.newArrayList();
        }
        toRelatedObject.clear();
        toRelatedObject.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItemRelatedObject</b> entities. This corresponds to the
     * OData navigation property <b>to_RelatedObject</b>.
     * <p>
     * If the navigation property <b>to_RelatedObject</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItemRelatedObject</b> entities.
     */
    public void addRelatedObject( SalesOrderItemRelatedObject... entity )
    {
        if( toRelatedObject == null ) {
            toRelatedObject = Lists.newArrayList();
        }
        toRelatedObject.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder fetchSalesOrder()
    {
        return fetchFieldAsSingle("to_SalesOrder", SalesOrder.class);
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>SalesOrder</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<SalesOrder> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the associated <b>SalesOrder</b> entity for the loaded navigation property <b>to_SalesOrder</b>.
     *
     * @param value
     *            New <b>SalesOrder</b> entity.
     */
    public void setSalesOrder( final SalesOrder value )
    {
        toSalesOrder = value;
    }

    /**
     * Fetches the <b>SalesOrderScheduleLine</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_ScheduleLine</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderScheduleLine</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderScheduleLine> fetchScheduleLine()
    {
        return fetchFieldAsList("to_ScheduleLine", SalesOrderScheduleLine.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderScheduleLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderScheduleLine</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderScheduleLine> getScheduleLineOrFetch()
    {
        if( toScheduleLine == null ) {
            toScheduleLine = fetchScheduleLine();
        }
        return toScheduleLine;
    }

    /**
     * Retrieval of associated <b>SalesOrderScheduleLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ScheduleLine</b> is already loaded, the result will
     *         contain the <b>SalesOrderScheduleLine</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderScheduleLine>> getScheduleLineIfPresent()
    {
        return Option.of(toScheduleLine);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderScheduleLine</b> entities for the loaded navigation property
     * <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderScheduleLine</b> entities.
     */
    public void setScheduleLine( @Nonnull final List<SalesOrderScheduleLine> value )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.clear();
        toScheduleLine.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderScheduleLine</b> entities. This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderScheduleLine</b> entities.
     */
    public void addScheduleLine( SalesOrderScheduleLine... entity )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderItmSubsqntProcFlow</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_SubsequentProcFlowDocItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItmSubsqntProcFlow</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItmSubsqntProcFlow> fetchSubsequentProcFlowDocItem()
    {
        return fetchFieldAsList("to_SubsequentProcFlowDocItem", SalesOrderItmSubsqntProcFlow.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItmSubsqntProcFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubsequentProcFlowDocItem</b>.
     * <p>
     * If the navigation property <b>to_SubsequentProcFlowDocItem</b> of a queried <b>SalesOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItmSubsqntProcFlow</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItmSubsqntProcFlow> getSubsequentProcFlowDocItemOrFetch()
    {
        if( toSubsequentProcFlowDocItem == null ) {
            toSubsequentProcFlowDocItem = fetchSubsequentProcFlowDocItem();
        }
        return toSubsequentProcFlowDocItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderItmSubsqntProcFlow</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_SubsequentProcFlowDocItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubsequentProcFlowDocItem</b> is already loaded, the
     *         result will contain the <b>SalesOrderItmSubsqntProcFlow</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderItmSubsqntProcFlow>> getSubsequentProcFlowDocItemIfPresent()
    {
        return Option.of(toSubsequentProcFlowDocItem);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItmSubsqntProcFlow</b> entities for the loaded navigation property
     * <b>to_SubsequentProcFlowDocItem</b>.
     * <p>
     * If the navigation property <b>to_SubsequentProcFlowDocItem</b> of a queried <b>SalesOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItmSubsqntProcFlow</b> entities.
     */
    public void setSubsequentProcFlowDocItem( @Nonnull final List<SalesOrderItmSubsqntProcFlow> value )
    {
        if( toSubsequentProcFlowDocItem == null ) {
            toSubsequentProcFlowDocItem = Lists.newArrayList();
        }
        toSubsequentProcFlowDocItem.clear();
        toSubsequentProcFlowDocItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItmSubsqntProcFlow</b> entities. This corresponds to the
     * OData navigation property <b>to_SubsequentProcFlowDocItem</b>.
     * <p>
     * If the navigation property <b>to_SubsequentProcFlowDocItem</b> of a queried <b>SalesOrderItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItmSubsqntProcFlow</b> entities.
     */
    public void addSubsequentProcFlowDocItem( SalesOrderItmSubsqntProcFlow... entity )
    {
        if( toSubsequentProcFlowDocItem == null ) {
            toSubsequentProcFlowDocItem = Lists.newArrayList();
        }
        toSubsequentProcFlowDocItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderItemText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItemText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemText> fetchText()
    {
        return fetchFieldAsList("to_Text", SalesOrderItemText.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>SalesOrderItemText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>SalesOrderItemText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<SalesOrderItemText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItemText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItemText</b> entities.
     */
    public void setText( @Nonnull final List<SalesOrderItemText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrderItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItemText</b> entities.
     */
    public void addText( SalesOrderItemText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderItem instances.
     *
     */
    public final static class SalesOrderItemBuilder
    {

        private SalesOrderItemBillingPlan toBillingPlan;
        private String billingPlan = null;
        private List<SalesOrderItemPartner> toPartner = Lists.newArrayList();
        private List<SalesOrderItmPrecdgProcFlow> toPrecedingProcFlowDocItem = Lists.newArrayList();
        private List<SalesOrderItemPrElement> toPricingElement = Lists.newArrayList();
        private List<SalesOrderItemRelatedObject> toRelatedObject = Lists.newArrayList();
        private SalesOrder toSalesOrder;
        private String salesOrder = null;
        private List<SalesOrderScheduleLine> toScheduleLine = Lists.newArrayList();
        private List<SalesOrderItmSubsqntProcFlow> toSubsequentProcFlowDocItem = Lists.newArrayList();
        private List<SalesOrderItemText> toText = Lists.newArrayList();

        private SalesOrderItem.SalesOrderItemBuilder toBillingPlan( final SalesOrderItemBillingPlan value )
        {
            toBillingPlan = value;
            return this;
        }

        /**
         * Navigation property <b>to_BillingPlan</b> for <b>SalesOrderItem</b> to single
         * <b>SalesOrderItemBillingPlan</b>.
         *
         * @param value
         *            The SalesOrderItemBillingPlan to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder billingPlan( final SalesOrderItemBillingPlan value )
        {
            return toBillingPlan(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>BillingPlan</b>
         * </p>
         *
         * @param value
         *            The billingPlan to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder billingPlan( final String value )
        {
            billingPlan = value;
            return this;
        }

        private SalesOrderItem.SalesOrderItemBuilder toPartner( final List<SalesOrderItemPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>SalesOrderItem</b> to multiple <b>SalesOrderItemPartner</b>.
         *
         * @param value
         *            The SalesOrderItemPartners to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder partner( SalesOrderItemPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private SalesOrderItem.SalesOrderItemBuilder toPrecedingProcFlowDocItem(
            final List<SalesOrderItmPrecdgProcFlow> value )
        {
            toPrecedingProcFlowDocItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PrecedingProcFlowDocItem</b> for <b>SalesOrderItem</b> to multiple
         * <b>SalesOrderItmPrecdgProcFlow</b>.
         *
         * @param value
         *            The SalesOrderItmPrecdgProcFlows to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder precedingProcFlowDocItem( SalesOrderItmPrecdgProcFlow... value )
        {
            return toPrecedingProcFlowDocItem(Lists.newArrayList(value));
        }

        private SalesOrderItem.SalesOrderItemBuilder toPricingElement( final List<SalesOrderItemPrElement> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>SalesOrderItem</b> to multiple
         * <b>SalesOrderItemPrElement</b>.
         *
         * @param value
         *            The SalesOrderItemPrElements to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder pricingElement( SalesOrderItemPrElement... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private SalesOrderItem.SalesOrderItemBuilder toRelatedObject( final List<SalesOrderItemRelatedObject> value )
        {
            toRelatedObject.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RelatedObject</b> for <b>SalesOrderItem</b> to multiple
         * <b>SalesOrderItemRelatedObject</b>.
         *
         * @param value
         *            The SalesOrderItemRelatedObjects to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder relatedObject( SalesOrderItemRelatedObject... value )
        {
            return toRelatedObject(Lists.newArrayList(value));
        }

        private SalesOrderItem.SalesOrderItemBuilder toSalesOrder( final SalesOrder value )
        {
            toSalesOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderItem</b> to single <b>SalesOrder</b>.
         *
         * @param value
         *            The SalesOrder to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder salesOrder( final SalesOrder value )
        {
            return toSalesOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrder</b>
         * </p>
         *
         * @param value
         *            The salesOrder to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder salesOrder( final String value )
        {
            salesOrder = value;
            return this;
        }

        private SalesOrderItem.SalesOrderItemBuilder toScheduleLine( final List<SalesOrderScheduleLine> value )
        {
            toScheduleLine.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ScheduleLine</b> for <b>SalesOrderItem</b> to multiple
         * <b>SalesOrderScheduleLine</b>.
         *
         * @param value
         *            The SalesOrderScheduleLines to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder scheduleLine( SalesOrderScheduleLine... value )
        {
            return toScheduleLine(Lists.newArrayList(value));
        }

        private SalesOrderItem.SalesOrderItemBuilder toSubsequentProcFlowDocItem(
            final List<SalesOrderItmSubsqntProcFlow> value )
        {
            toSubsequentProcFlowDocItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubsequentProcFlowDocItem</b> for <b>SalesOrderItem</b> to multiple
         * <b>SalesOrderItmSubsqntProcFlow</b>.
         *
         * @param value
         *            The SalesOrderItmSubsqntProcFlows to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder subsequentProcFlowDocItem( SalesOrderItmSubsqntProcFlow... value )
        {
            return toSubsequentProcFlowDocItem(Lists.newArrayList(value));
        }

        private SalesOrderItem.SalesOrderItemBuilder toText( final List<SalesOrderItemText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>SalesOrderItem</b> to multiple <b>SalesOrderItemText</b>.
         *
         * @param value
         *            The SalesOrderItemTexts to build this SalesOrderItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItem.SalesOrderItemBuilder text( SalesOrderItemText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
