/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderItemBillingPlanField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderItemBillingPlanLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderItemBillingPlanOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SalesOrderItemBillingPlanSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Billing Plan
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderItemBillingPlanType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderItemBillingPlan extends VdmEntity<SalesOrderItemBillingPlan>
{

    /**
     * Selector for all available fields of SalesOrderItemBillingPlan.
     *
     */
    public final static SalesOrderItemBillingPlanSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<String> SALES_ORDER =
        new SalesOrderItemBillingPlanField<String>("SalesOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @Key
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<String> SALES_ORDER_ITEM =
        new SalesOrderItemBillingPlanField<String>("SalesOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @return Billing Plan Number / Invoicing Plan Number
     */
    @Key
    @SerializedName( "BillingPlan" )
    @JsonProperty( "BillingPlan" )
    @Nullable
    @ODataField( odataName = "BillingPlan" )
    private String billingPlan;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlan</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<String> BILLING_PLAN =
        new SalesOrderItemBillingPlanField<String>("BillingPlan");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanIsInHeader</b>
     * </p>
     *
     * @return Indicator for Billing Plan in Header
     */
    @SerializedName( "BillingPlanIsInHeader" )
    @JsonProperty( "BillingPlanIsInHeader" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "BillingPlanIsInHeader" )
    private Boolean billingPlanIsInHeader;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanIsInHeader</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<Boolean> BILLING_PLAN_IS_IN_HEADER =
        new SalesOrderItemBillingPlanField<Boolean>("BillingPlanIsInHeader");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanStartDate</b>
     * </p>
     *
     * @return Start Date for Billing Plan/Invoice Plan
     */
    @SerializedName( "BillingPlanStartDate" )
    @JsonProperty( "BillingPlanStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingPlanStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingPlanStartDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanStartDate</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<LocalDateTime> BILLING_PLAN_START_DATE =
        new SalesOrderItemBillingPlanField<LocalDateTime>("BillingPlanStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanStartDateRule</b>
     * </p>
     *
     * @return Rule for Origin of Start Date of Billing/Invoicing Plan
     */
    @SerializedName( "BillingPlanStartDateRule" )
    @JsonProperty( "BillingPlanStartDateRule" )
    @Nullable
    @ODataField( odataName = "BillingPlanStartDateRule" )
    private String billingPlanStartDateRule;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanStartDateRule</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<String> BILLING_PLAN_START_DATE_RULE =
        new SalesOrderItemBillingPlanField<String>("BillingPlanStartDateRule");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceBillingPlan</b>
     * </p>
     *
     * @return Reference Billing Plan Number / Invoicing Plan Number
     */
    @SerializedName( "ReferenceBillingPlan" )
    @JsonProperty( "ReferenceBillingPlan" )
    @Nullable
    @ODataField( odataName = "ReferenceBillingPlan" )
    private String referenceBillingPlan;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceBillingPlan</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<String> REFERENCE_BILLING_PLAN =
        new SalesOrderItemBillingPlanField<String>("ReferenceBillingPlan");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanCategory</b>
     * </p>
     *
     * @return Billing plan category
     */
    @SerializedName( "BillingPlanCategory" )
    @JsonProperty( "BillingPlanCategory" )
    @Nullable
    @ODataField( odataName = "BillingPlanCategory" )
    private String billingPlanCategory;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanCategory</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<String> BILLING_PLAN_CATEGORY =
        new SalesOrderItemBillingPlanField<String>("BillingPlanCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanType</b>
     * </p>
     *
     * @return Billing/Invoicing Plan Type
     */
    @SerializedName( "BillingPlanType" )
    @JsonProperty( "BillingPlanType" )
    @Nullable
    @ODataField( odataName = "BillingPlanType" )
    private String billingPlanType;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanType</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<String> BILLING_PLAN_TYPE =
        new SalesOrderItemBillingPlanField<String>("BillingPlanType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanEndDate</b>
     * </p>
     *
     * @return End Date Billing Plan/Invoice Plan
     */
    @SerializedName( "BillingPlanEndDate" )
    @JsonProperty( "BillingPlanEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BillingPlanEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime billingPlanEndDate;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanEndDate</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<LocalDateTime> BILLING_PLAN_END_DATE =
        new SalesOrderItemBillingPlanField<LocalDateTime>("BillingPlanEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanEndDateRule</b>
     * </p>
     *
     * @return Rule for Origin of End Date for Billing/Invoicing Plan
     */
    @SerializedName( "BillingPlanEndDateRule" )
    @JsonProperty( "BillingPlanEndDateRule" )
    @Nullable
    @ODataField( odataName = "BillingPlanEndDateRule" )
    private String billingPlanEndDateRule;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanEndDateRule</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<String> BILLING_PLAN_END_DATE_RULE =
        new SalesOrderItemBillingPlanField<String>("BillingPlanEndDateRule");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanSearchTerm</b>
     * </p>
     *
     * @return Sort Field
     */
    @SerializedName( "BillingPlanSearchTerm" )
    @JsonProperty( "BillingPlanSearchTerm" )
    @Nullable
    @ODataField( odataName = "BillingPlanSearchTerm" )
    private String billingPlanSearchTerm;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlanSearchTerm</b> field to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanField<String> BILLING_PLAN_SEARCH_TERM =
        new SalesOrderItemBillingPlanField<String>("BillingPlanSearchTerm");
    /**
     * Navigation property <b>to_BillingPlanItem</b> for <b>SalesOrderItemBillingPlan</b> to multiple
     * <b>SlsOrderItemBillingPlanItem</b>.
     *
     */
    @SerializedName( "to_BillingPlanItem" )
    @JsonProperty( "to_BillingPlanItem" )
    @ODataField( odataName = "to_BillingPlanItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsOrderItemBillingPlanItem> toBillingPlanItem;
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderItemBillingPlan</b> to single <b>SalesOrder</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrder toSalesOrder;
    /**
     * Navigation property <b>to_SalesOrderItem</b> for <b>SalesOrderItemBillingPlan</b> to single
     * <b>SalesOrderItem</b>.
     *
     */
    @SerializedName( "to_SalesOrderItem" )
    @JsonProperty( "to_SalesOrderItem" )
    @ODataField( odataName = "to_SalesOrderItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderItem toSalesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>to_BillingPlanItem</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanLink<SlsOrderItemBillingPlanItem> TO_BILLING_PLAN_ITEM =
        new SalesOrderItemBillingPlanLink<SlsOrderItemBillingPlanItem>("to_BillingPlanItem");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanOneToOneLink<SalesOrder> TO_SALES_ORDER =
        new SalesOrderItemBillingPlanOneToOneLink<SalesOrder>("to_SalesOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrderItem</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemBillingPlanOneToOneLink<SalesOrderItem> TO_SALES_ORDER_ITEM =
        new SalesOrderItemBillingPlanOneToOneLink<SalesOrderItem>("to_SalesOrderItem");

    @Nonnull
    @Override
    public Class<SalesOrderItemBillingPlan> getType()
    {
        return SalesOrderItemBillingPlan.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     */
    public void setBillingPlan( @Nullable final String billingPlan )
    {
        rememberChangedField("BillingPlan", this.billingPlan);
        this.billingPlan = billingPlan;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanIsInHeader</b>
     * </p>
     *
     * @param billingPlanIsInHeader
     *            Indicator for Billing Plan in Header
     */
    public void setBillingPlanIsInHeader( @Nullable final Boolean billingPlanIsInHeader )
    {
        rememberChangedField("BillingPlanIsInHeader", this.billingPlanIsInHeader);
        this.billingPlanIsInHeader = billingPlanIsInHeader;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanStartDate</b>
     * </p>
     *
     * @param billingPlanStartDate
     *            Start Date for Billing Plan/Invoice Plan
     */
    public void setBillingPlanStartDate( @Nullable final LocalDateTime billingPlanStartDate )
    {
        rememberChangedField("BillingPlanStartDate", this.billingPlanStartDate);
        this.billingPlanStartDate = billingPlanStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanStartDateRule</b>
     * </p>
     *
     * @param billingPlanStartDateRule
     *            Rule for Origin of Start Date of Billing/Invoicing Plan
     */
    public void setBillingPlanStartDateRule( @Nullable final String billingPlanStartDateRule )
    {
        rememberChangedField("BillingPlanStartDateRule", this.billingPlanStartDateRule);
        this.billingPlanStartDateRule = billingPlanStartDateRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceBillingPlan</b>
     * </p>
     *
     * @param referenceBillingPlan
     *            Reference Billing Plan Number / Invoicing Plan Number
     */
    public void setReferenceBillingPlan( @Nullable final String referenceBillingPlan )
    {
        rememberChangedField("ReferenceBillingPlan", this.referenceBillingPlan);
        this.referenceBillingPlan = referenceBillingPlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanCategory</b>
     * </p>
     *
     * @param billingPlanCategory
     *            Billing plan category
     */
    public void setBillingPlanCategory( @Nullable final String billingPlanCategory )
    {
        rememberChangedField("BillingPlanCategory", this.billingPlanCategory);
        this.billingPlanCategory = billingPlanCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanType</b>
     * </p>
     *
     * @param billingPlanType
     *            Billing/Invoicing Plan Type
     */
    public void setBillingPlanType( @Nullable final String billingPlanType )
    {
        rememberChangedField("BillingPlanType", this.billingPlanType);
        this.billingPlanType = billingPlanType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanEndDate</b>
     * </p>
     *
     * @param billingPlanEndDate
     *            End Date Billing Plan/Invoice Plan
     */
    public void setBillingPlanEndDate( @Nullable final LocalDateTime billingPlanEndDate )
    {
        rememberChangedField("BillingPlanEndDate", this.billingPlanEndDate);
        this.billingPlanEndDate = billingPlanEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanEndDateRule</b>
     * </p>
     *
     * @param billingPlanEndDateRule
     *            Rule for Origin of End Date for Billing/Invoicing Plan
     */
    public void setBillingPlanEndDateRule( @Nullable final String billingPlanEndDateRule )
    {
        rememberChangedField("BillingPlanEndDateRule", this.billingPlanEndDateRule);
        this.billingPlanEndDateRule = billingPlanEndDateRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlanSearchTerm</b>
     * </p>
     *
     * @param billingPlanSearchTerm
     *            Sort Field
     */
    public void setBillingPlanSearchTerm( @Nullable final String billingPlanSearchTerm )
    {
        rememberChangedField("BillingPlanSearchTerm", this.billingPlanSearchTerm);
        this.billingPlanSearchTerm = billingPlanSearchTerm;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderItemBillingPlan";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        result.put("SalesOrderItem", getSalesOrderItem());
        result.put("BillingPlan", getBillingPlan());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("BillingPlan", getBillingPlan());
        values.put("BillingPlanIsInHeader", getBillingPlanIsInHeader());
        values.put("BillingPlanStartDate", getBillingPlanStartDate());
        values.put("BillingPlanStartDateRule", getBillingPlanStartDateRule());
        values.put("ReferenceBillingPlan", getReferenceBillingPlan());
        values.put("BillingPlanCategory", getBillingPlanCategory());
        values.put("BillingPlanType", getBillingPlanType());
        values.put("BillingPlanEndDate", getBillingPlanEndDate());
        values.put("BillingPlanEndDateRule", getBillingPlanEndDateRule());
        values.put("BillingPlanSearchTerm", getBillingPlanSearchTerm());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("BillingPlan") ) {
                final Object value = values.remove("BillingPlan");
                if( (value == null) || (!value.equals(getBillingPlan())) ) {
                    setBillingPlan(((String) value));
                }
            }
            if( values.containsKey("BillingPlanIsInHeader") ) {
                final Object value = values.remove("BillingPlanIsInHeader");
                if( (value == null) || (!value.equals(getBillingPlanIsInHeader())) ) {
                    setBillingPlanIsInHeader(((Boolean) value));
                }
            }
            if( values.containsKey("BillingPlanStartDate") ) {
                final Object value = values.remove("BillingPlanStartDate");
                if( (value == null) || (!value.equals(getBillingPlanStartDate())) ) {
                    setBillingPlanStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillingPlanStartDateRule") ) {
                final Object value = values.remove("BillingPlanStartDateRule");
                if( (value == null) || (!value.equals(getBillingPlanStartDateRule())) ) {
                    setBillingPlanStartDateRule(((String) value));
                }
            }
            if( values.containsKey("ReferenceBillingPlan") ) {
                final Object value = values.remove("ReferenceBillingPlan");
                if( (value == null) || (!value.equals(getReferenceBillingPlan())) ) {
                    setReferenceBillingPlan(((String) value));
                }
            }
            if( values.containsKey("BillingPlanCategory") ) {
                final Object value = values.remove("BillingPlanCategory");
                if( (value == null) || (!value.equals(getBillingPlanCategory())) ) {
                    setBillingPlanCategory(((String) value));
                }
            }
            if( values.containsKey("BillingPlanType") ) {
                final Object value = values.remove("BillingPlanType");
                if( (value == null) || (!value.equals(getBillingPlanType())) ) {
                    setBillingPlanType(((String) value));
                }
            }
            if( values.containsKey("BillingPlanEndDate") ) {
                final Object value = values.remove("BillingPlanEndDate");
                if( (value == null) || (!value.equals(getBillingPlanEndDate())) ) {
                    setBillingPlanEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BillingPlanEndDateRule") ) {
                final Object value = values.remove("BillingPlanEndDateRule");
                if( (value == null) || (!value.equals(getBillingPlanEndDateRule())) ) {
                    setBillingPlanEndDateRule(((String) value));
                }
            }
            if( values.containsKey("BillingPlanSearchTerm") ) {
                final Object value = values.remove("BillingPlanSearchTerm");
                if( (value == null) || (!value.equals(getBillingPlanSearchTerm())) ) {
                    setBillingPlanSearchTerm(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BillingPlanItem") ) {
                final Object value = (values).remove("to_BillingPlanItem");
                if( value instanceof Iterable ) {
                    if( toBillingPlanItem == null ) {
                        toBillingPlanItem = Lists.newArrayList();
                    } else {
                        toBillingPlanItem = Lists.newArrayList(toBillingPlanItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsOrderItemBillingPlanItem entity;
                        if( toBillingPlanItem.size() > i ) {
                            entity = toBillingPlanItem.get(i);
                        } else {
                            entity = new SlsOrderItemBillingPlanItem();
                            toBillingPlanItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Map ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = new SalesOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesOrderItem") ) {
                final Object value = (values).remove("to_SalesOrderItem");
                if( value instanceof Map ) {
                    if( toSalesOrderItem == null ) {
                        toSalesOrderItem = new SalesOrderItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrderItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrderItemBillingPlanField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderItemBillingPlanField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderItemBillingPlanField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderItemBillingPlanField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBillingPlanItem != null ) {
            (values).put("to_BillingPlanItem", toBillingPlanItem);
        }
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        if( toSalesOrderItem != null ) {
            (values).put("to_SalesOrderItem", toSalesOrderItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SlsOrderItemBillingPlanItem</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_BillingPlanItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsOrderItemBillingPlanItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrderItemBillingPlanItem> fetchBillingPlanItem()
    {
        return fetchFieldAsList("to_BillingPlanItem", SlsOrderItemBillingPlanItem.class);
    }

    /**
     * Retrieval of associated <b>SlsOrderItemBillingPlanItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BillingPlanItem</b>.
     * <p>
     * If the navigation property <b>to_BillingPlanItem</b> of a queried <b>SalesOrderItemBillingPlan</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsOrderItemBillingPlanItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrderItemBillingPlanItem> getBillingPlanItemOrFetch()
    {
        if( toBillingPlanItem == null ) {
            toBillingPlanItem = fetchBillingPlanItem();
        }
        return toBillingPlanItem;
    }

    /**
     * Retrieval of associated <b>SlsOrderItemBillingPlanItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BillingPlanItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItemBillingPlan</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BillingPlanItem</b> is already loaded, the result will
     *         contain the <b>SlsOrderItemBillingPlanItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsOrderItemBillingPlanItem>> getBillingPlanItemIfPresent()
    {
        return Option.of(toBillingPlanItem);
    }

    /**
     * Overwrites the list of associated <b>SlsOrderItemBillingPlanItem</b> entities for the loaded navigation property
     * <b>to_BillingPlanItem</b>.
     * <p>
     * If the navigation property <b>to_BillingPlanItem</b> of a queried <b>SalesOrderItemBillingPlan</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsOrderItemBillingPlanItem</b> entities.
     */
    public void setBillingPlanItem( @Nonnull final List<SlsOrderItemBillingPlanItem> value )
    {
        if( toBillingPlanItem == null ) {
            toBillingPlanItem = Lists.newArrayList();
        }
        toBillingPlanItem.clear();
        toBillingPlanItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsOrderItemBillingPlanItem</b> entities. This corresponds to the
     * OData navigation property <b>to_BillingPlanItem</b>.
     * <p>
     * If the navigation property <b>to_BillingPlanItem</b> of a queried <b>SalesOrderItemBillingPlan</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsOrderItemBillingPlanItem</b> entities.
     */
    public void addBillingPlanItem( SlsOrderItemBillingPlanItem... entity )
    {
        if( toBillingPlanItem == null ) {
            toBillingPlanItem = Lists.newArrayList();
        }
        toBillingPlanItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder fetchSalesOrder()
    {
        return fetchFieldAsSingle("to_SalesOrder", SalesOrder.class);
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>SalesOrderItemBillingPlan</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItemBillingPlan</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>SalesOrder</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<SalesOrder> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the associated <b>SalesOrder</b> entity for the loaded navigation property <b>to_SalesOrder</b>.
     *
     * @param value
     *            New <b>SalesOrder</b> entity.
     */
    public void setSalesOrder( final SalesOrder value )
    {
        toSalesOrder = value;
    }

    /**
     * Fetches the <b>SalesOrderItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesOrderItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderItem fetchSalesOrderItem()
    {
        return fetchFieldAsSingle("to_SalesOrderItem", SalesOrderItem.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrderItem</b>.
     * <p>
     * If the navigation property <b>to_SalesOrderItem</b> of a queried <b>SalesOrderItemBillingPlan</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderItem getSalesOrderItemOrFetch()
    {
        if( toSalesOrderItem == null ) {
            toSalesOrderItem = fetchSalesOrderItem();
        }
        return toSalesOrderItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrderItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItemBillingPlan</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrderItem</b> is already loaded, the result will
     *         contain the <b>SalesOrderItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderItem> getSalesOrderItemIfPresent()
    {
        return Option.of(toSalesOrderItem);
    }

    /**
     * Overwrites the associated <b>SalesOrderItem</b> entity for the loaded navigation property
     * <b>to_SalesOrderItem</b>.
     *
     * @param value
     *            New <b>SalesOrderItem</b> entity.
     */
    public void setSalesOrderItem( final SalesOrderItem value )
    {
        toSalesOrderItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderItemBillingPlan instances.
     *
     */
    public final static class SalesOrderItemBillingPlanBuilder
    {

        private List<SlsOrderItemBillingPlanItem> toBillingPlanItem = Lists.newArrayList();
        private SalesOrder toSalesOrder;
        private String salesOrder = null;
        private SalesOrderItem toSalesOrderItem;
        private String salesOrderItem = null;

        private SalesOrderItemBillingPlan.SalesOrderItemBillingPlanBuilder toBillingPlanItem(
            final List<SlsOrderItemBillingPlanItem> value )
        {
            toBillingPlanItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BillingPlanItem</b> for <b>SalesOrderItemBillingPlan</b> to multiple
         * <b>SlsOrderItemBillingPlanItem</b>.
         *
         * @param value
         *            The SlsOrderItemBillingPlanItems to build this SalesOrderItemBillingPlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemBillingPlan.SalesOrderItemBillingPlanBuilder billingPlanItem(
            SlsOrderItemBillingPlanItem... value )
        {
            return toBillingPlanItem(Lists.newArrayList(value));
        }

        private SalesOrderItemBillingPlan.SalesOrderItemBillingPlanBuilder toSalesOrder( final SalesOrder value )
        {
            toSalesOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderItemBillingPlan</b> to single <b>SalesOrder</b>.
         *
         * @param value
         *            The SalesOrder to build this SalesOrderItemBillingPlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemBillingPlan.SalesOrderItemBillingPlanBuilder salesOrder( final SalesOrder value )
        {
            return toSalesOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrder</b>
         * </p>
         *
         * @param value
         *            The salesOrder to build this SalesOrderItemBillingPlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemBillingPlan.SalesOrderItemBillingPlanBuilder salesOrder( final String value )
        {
            salesOrder = value;
            return this;
        }

        private SalesOrderItemBillingPlan.SalesOrderItemBillingPlanBuilder toSalesOrderItem(
            final SalesOrderItem value )
        {
            toSalesOrderItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrderItem</b> for <b>SalesOrderItemBillingPlan</b> to single
         * <b>SalesOrderItem</b>.
         *
         * @param value
         *            The SalesOrderItem to build this SalesOrderItemBillingPlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemBillingPlan.SalesOrderItemBillingPlanBuilder salesOrderItem( final SalesOrderItem value )
        {
            return toSalesOrderItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrderItem</b>
         * </p>
         *
         * @param value
         *            The salesOrderItem to build this SalesOrderItemBillingPlan with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemBillingPlan.SalesOrderItemBillingPlanBuilder salesOrderItem( final String value )
        {
            salesOrderItem = value;
            return this;
        }

    }

}
