/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderItemPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderItemPartnerLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderItemPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SalesOrderItemPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderItemPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderItemPartner extends VdmEntity<SalesOrderItemPartner>
{

    /**
     * Selector for all available fields of SalesOrderItemPartner.
     *
     */
    public final static SalesOrderItemPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderItemPartnerField<String> SALES_ORDER =
        new SalesOrderItemPartnerField<String>("SalesOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @Key
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static SalesOrderItemPartnerField<String> SALES_ORDER_ITEM =
        new SalesOrderItemPartnerField<String>("SalesOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static SalesOrderItemPartnerField<String> PARTNER_FUNCTION =
        new SalesOrderItemPartnerField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static SalesOrderItemPartnerField<String> CUSTOMER =
        new SalesOrderItemPartnerField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SalesOrderItemPartnerField<String> SUPPLIER =
        new SalesOrderItemPartnerField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static SalesOrderItemPartnerField<String> PERSONNEL =
        new SalesOrderItemPartnerField<String>("Personnel");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Number of Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static SalesOrderItemPartnerField<String> CONTACT_PERSON =
        new SalesOrderItemPartnerField<String>("ContactPerson");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @return Address Number
     */
    @SerializedName( "AddressID" )
    @JsonProperty( "AddressID" )
    @Nullable
    @ODataField( odataName = "AddressID" )
    private String addressID;
    /**
     * Use with available fluent helpers to apply the <b>AddressID</b> field to query operations.
     *
     */
    public final static SalesOrderItemPartnerField<String> ADDRESS_ID =
        new SalesOrderItemPartnerField<String>("AddressID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistration</b>
     * </p>
     *
     * @return VAT Registration Number
     */
    @SerializedName( "VATRegistration" )
    @JsonProperty( "VATRegistration" )
    @Nullable
    @ODataField( odataName = "VATRegistration" )
    private String vATRegistration;
    /**
     * Use with available fluent helpers to apply the <b>VATRegistration</b> field to query operations.
     *
     */
    public final static SalesOrderItemPartnerField<String> VAT_REGISTRATION =
        new SalesOrderItemPartnerField<String>("VATRegistration");
    /**
     * Navigation property <b>to_Address</b> for <b>SalesOrderItemPartner</b> to multiple
     * <b>SalesOrderItemPartnerAddress</b>.
     *
     */
    @SerializedName( "to_Address" )
    @JsonProperty( "to_Address" )
    @ODataField( odataName = "to_Address" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItemPartnerAddress> toAddress;
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderItemPartner</b> to single <b>SalesOrder</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrder toSalesOrder;
    /**
     * Navigation property <b>to_SalesOrderItem</b> for <b>SalesOrderItemPartner</b> to single <b>SalesOrderItem</b>.
     *
     */
    @SerializedName( "to_SalesOrderItem" )
    @JsonProperty( "to_SalesOrderItem" )
    @ODataField( odataName = "to_SalesOrderItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderItem toSalesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>to_Address</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemPartnerLink<SalesOrderItemPartnerAddress> TO_ADDRESS =
        new SalesOrderItemPartnerLink<SalesOrderItemPartnerAddress>("to_Address");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemPartnerOneToOneLink<SalesOrder> TO_SALES_ORDER =
        new SalesOrderItemPartnerOneToOneLink<SalesOrder>("to_SalesOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrderItem</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemPartnerOneToOneLink<SalesOrderItem> TO_SALES_ORDER_ITEM =
        new SalesOrderItemPartnerOneToOneLink<SalesOrderItem>("to_SalesOrderItem");

    @Nonnull
    @Override
    public Class<SalesOrderItemPartner> getType()
    {
        return SalesOrderItemPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel Number
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Number of Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AddressID</b>
     * </p>
     *
     * @param addressID
     *            Address Number
     */
    public void setAddressID( @Nullable final String addressID )
    {
        rememberChangedField("AddressID", this.addressID);
        this.addressID = addressID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>VATRegistration</b>
     * </p>
     *
     * @param vATRegistration
     *            VAT Registration Number
     */
    public void setVATRegistration( @Nullable final String vATRegistration )
    {
        rememberChangedField("VATRegistration", this.vATRegistration);
        this.vATRegistration = vATRegistration;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderItemPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        result.put("SalesOrderItem", getSalesOrderItem());
        result.put("PartnerFunction", getPartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("Customer", getCustomer());
        values.put("Supplier", getSupplier());
        values.put("Personnel", getPersonnel());
        values.put("ContactPerson", getContactPerson());
        values.put("AddressID", getAddressID());
        values.put("VATRegistration", getVATRegistration());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
            if( values.containsKey("AddressID") ) {
                final Object value = values.remove("AddressID");
                if( (value == null) || (!value.equals(getAddressID())) ) {
                    setAddressID(((String) value));
                }
            }
            if( values.containsKey("VATRegistration") ) {
                final Object value = values.remove("VATRegistration");
                if( (value == null) || (!value.equals(getVATRegistration())) ) {
                    setVATRegistration(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Address") ) {
                final Object value = (values).remove("to_Address");
                if( value instanceof Iterable ) {
                    if( toAddress == null ) {
                        toAddress = Lists.newArrayList();
                    } else {
                        toAddress = Lists.newArrayList(toAddress);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItemPartnerAddress entity;
                        if( toAddress.size() > i ) {
                            entity = toAddress.get(i);
                        } else {
                            entity = new SalesOrderItemPartnerAddress();
                            toAddress.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Map ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = new SalesOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesOrderItem") ) {
                final Object value = (values).remove("to_SalesOrderItem");
                if( value instanceof Map ) {
                    if( toSalesOrderItem == null ) {
                        toSalesOrderItem = new SalesOrderItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrderItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrderItemPartnerField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderItemPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderItemPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderItemPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toAddress != null ) {
            (values).put("to_Address", toAddress);
        }
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        if( toSalesOrderItem != null ) {
            (values).put("to_SalesOrderItem", toSalesOrderItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderItemPartnerAddress</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Address</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItemPartnerAddress</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemPartnerAddress> fetchAddress()
    {
        return fetchFieldAsList("to_Address", SalesOrderItemPartnerAddress.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItemPartnerAddress</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Address</b>.
     * <p>
     * If the navigation property <b>to_Address</b> of a queried <b>SalesOrderItemPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItemPartnerAddress</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemPartnerAddress> getAddressOrFetch()
    {
        if( toAddress == null ) {
            toAddress = fetchAddress();
        }
        return toAddress;
    }

    /**
     * Retrieval of associated <b>SalesOrderItemPartnerAddress</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Address</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItemPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Address</b> is already loaded, the result will contain
     *         the <b>SalesOrderItemPartnerAddress</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderItemPartnerAddress>> getAddressIfPresent()
    {
        return Option.of(toAddress);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItemPartnerAddress</b> entities for the loaded navigation property
     * <b>to_Address</b>.
     * <p>
     * If the navigation property <b>to_Address</b> of a queried <b>SalesOrderItemPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItemPartnerAddress</b> entities.
     */
    public void setAddress( @Nonnull final List<SalesOrderItemPartnerAddress> value )
    {
        if( toAddress == null ) {
            toAddress = Lists.newArrayList();
        }
        toAddress.clear();
        toAddress.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItemPartnerAddress</b> entities. This corresponds to the
     * OData navigation property <b>to_Address</b>.
     * <p>
     * If the navigation property <b>to_Address</b> of a queried <b>SalesOrderItemPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItemPartnerAddress</b> entities.
     */
    public void addAddress( SalesOrderItemPartnerAddress... entity )
    {
        if( toAddress == null ) {
            toAddress = Lists.newArrayList();
        }
        toAddress.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder fetchSalesOrder()
    {
        return fetchFieldAsSingle("to_SalesOrder", SalesOrder.class);
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>SalesOrderItemPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItemPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>SalesOrder</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<SalesOrder> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the associated <b>SalesOrder</b> entity for the loaded navigation property <b>to_SalesOrder</b>.
     *
     * @param value
     *            New <b>SalesOrder</b> entity.
     */
    public void setSalesOrder( final SalesOrder value )
    {
        toSalesOrder = value;
    }

    /**
     * Fetches the <b>SalesOrderItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesOrderItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderItem fetchSalesOrderItem()
    {
        return fetchFieldAsSingle("to_SalesOrderItem", SalesOrderItem.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrderItem</b>.
     * <p>
     * If the navigation property <b>to_SalesOrderItem</b> of a queried <b>SalesOrderItemPartner</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderItem getSalesOrderItemOrFetch()
    {
        if( toSalesOrderItem == null ) {
            toSalesOrderItem = fetchSalesOrderItem();
        }
        return toSalesOrderItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrderItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItemPartner</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrderItem</b> is already loaded, the result will
     *         contain the <b>SalesOrderItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderItem> getSalesOrderItemIfPresent()
    {
        return Option.of(toSalesOrderItem);
    }

    /**
     * Overwrites the associated <b>SalesOrderItem</b> entity for the loaded navigation property
     * <b>to_SalesOrderItem</b>.
     *
     * @param value
     *            New <b>SalesOrderItem</b> entity.
     */
    public void setSalesOrderItem( final SalesOrderItem value )
    {
        toSalesOrderItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderItemPartner instances.
     *
     */
    public final static class SalesOrderItemPartnerBuilder
    {

        private List<SalesOrderItemPartnerAddress> toAddress = Lists.newArrayList();
        private SalesOrder toSalesOrder;
        private String salesOrder = null;
        private SalesOrderItem toSalesOrderItem;
        private String salesOrderItem = null;

        private SalesOrderItemPartner.SalesOrderItemPartnerBuilder toAddress(
            final List<SalesOrderItemPartnerAddress> value )
        {
            toAddress.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Address</b> for <b>SalesOrderItemPartner</b> to multiple
         * <b>SalesOrderItemPartnerAddress</b>.
         *
         * @param value
         *            The SalesOrderItemPartnerAddresss to build this SalesOrderItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemPartner.SalesOrderItemPartnerBuilder address( SalesOrderItemPartnerAddress... value )
        {
            return toAddress(Lists.newArrayList(value));
        }

        private SalesOrderItemPartner.SalesOrderItemPartnerBuilder toSalesOrder( final SalesOrder value )
        {
            toSalesOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderItemPartner</b> to single <b>SalesOrder</b>.
         *
         * @param value
         *            The SalesOrder to build this SalesOrderItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemPartner.SalesOrderItemPartnerBuilder salesOrder( final SalesOrder value )
        {
            return toSalesOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrder</b>
         * </p>
         *
         * @param value
         *            The salesOrder to build this SalesOrderItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemPartner.SalesOrderItemPartnerBuilder salesOrder( final String value )
        {
            salesOrder = value;
            return this;
        }

        private SalesOrderItemPartner.SalesOrderItemPartnerBuilder toSalesOrderItem( final SalesOrderItem value )
        {
            toSalesOrderItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrderItem</b> for <b>SalesOrderItemPartner</b> to single
         * <b>SalesOrderItem</b>.
         *
         * @param value
         *            The SalesOrderItem to build this SalesOrderItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemPartner.SalesOrderItemPartnerBuilder salesOrderItem( final SalesOrderItem value )
        {
            return toSalesOrderItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrderItem</b>
         * </p>
         *
         * @param value
         *            The salesOrderItem to build this SalesOrderItemPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemPartner.SalesOrderItemPartnerBuilder salesOrderItem( final String value )
        {
            salesOrderItem = value;
            return this;
        }

    }

}
