/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderItmPrecdgProcFlowField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderItmPrecdgProcFlowOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SalesOrderItmPrecdgProcFlowSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Preceding Process Flow
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderItmPrecdgProcFlowType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderItmPrecdgProcFlow extends VdmEntity<SalesOrderItmPrecdgProcFlow>
{

    /**
     * Selector for all available fields of SalesOrderItmPrecdgProcFlow.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Subsequent Sales and Distribution Document
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<String> SALES_ORDER =
        new SalesOrderItmPrecdgProcFlowField<String>("SalesOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Subsequent Item of an SD Document
     */
    @Key
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<String> SALES_ORDER_ITEM =
        new SalesOrderItmPrecdgProcFlowField<String>("SalesOrderItem");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocRelationshipUUID</b>
     * </p>
     *
     * @return SD Unique Document Relationship Identification
     */
    @Key
    @SerializedName( "DocRelationshipUUID" )
    @JsonProperty( "DocRelationshipUUID" )
    @Nullable
    @ODataField( odataName = "DocRelationshipUUID" )
    private UUID docRelationshipUUID;
    /**
     * Use with available fluent helpers to apply the <b>DocRelationshipUUID</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<UUID> DOC_RELATIONSHIP_UUID =
        new SalesOrderItmPrecdgProcFlowField<UUID>("DocRelationshipUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocument</b>
     * </p>
     *
     * @return Preceding sales and distribution document
     */
    @SerializedName( "PrecedingDocument" )
    @JsonProperty( "PrecedingDocument" )
    @Nullable
    @ODataField( odataName = "PrecedingDocument" )
    private String precedingDocument;
    /**
     * Use with available fluent helpers to apply the <b>PrecedingDocument</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<String> PRECEDING_DOCUMENT =
        new SalesOrderItmPrecdgProcFlowField<String>("PrecedingDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocumentItem</b>
     * </p>
     *
     * @return Preceding Item of an SD Document
     */
    @SerializedName( "PrecedingDocumentItem" )
    @JsonProperty( "PrecedingDocumentItem" )
    @Nullable
    @ODataField( odataName = "PrecedingDocumentItem" )
    private String precedingDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>PrecedingDocumentItem</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<String> PRECEDING_DOCUMENT_ITEM =
        new SalesOrderItmPrecdgProcFlowField<String>("PrecedingDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocumentCategory</b>
     * </p>
     *
     * @return Document Category of Preceding SD Document
     */
    @SerializedName( "PrecedingDocumentCategory" )
    @JsonProperty( "PrecedingDocumentCategory" )
    @Nullable
    @ODataField( odataName = "PrecedingDocumentCategory" )
    private String precedingDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>PrecedingDocumentCategory</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<String> PRECEDING_DOCUMENT_CATEGORY =
        new SalesOrderItmPrecdgProcFlowField<String>("PrecedingDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessFlowLevel</b>
     * </p>
     *
     * @return Level of the document flow record
     */
    @SerializedName( "ProcessFlowLevel" )
    @JsonProperty( "ProcessFlowLevel" )
    @Nullable
    @ODataField( odataName = "ProcessFlowLevel" )
    private String processFlowLevel;
    /**
     * Use with available fluent helpers to apply the <b>ProcessFlowLevel</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<String> PROCESS_FLOW_LEVEL =
        new SalesOrderItmPrecdgProcFlowField<String>("ProcessFlowLevel");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RelatedProcFlowDocStsFieldName</b>
     * </p>
     *
     * @return Field Name
     */
    @SerializedName( "RelatedProcFlowDocStsFieldName" )
    @JsonProperty( "RelatedProcFlowDocStsFieldName" )
    @Nullable
    @ODataField( odataName = "RelatedProcFlowDocStsFieldName" )
    private String relatedProcFlowDocStsFieldName;
    /**
     * Use with available fluent helpers to apply the <b>RelatedProcFlowDocStsFieldName</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<String> RELATED_PROC_FLOW_DOC_STS_FIELD_NAME =
        new SalesOrderItmPrecdgProcFlowField<String>("RelatedProcFlowDocStsFieldName");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Item)
     */
    @SerializedName( "SDProcessStatus" )
    @JsonProperty( "SDProcessStatus" )
    @Nullable
    @ODataField( odataName = "SDProcessStatus" )
    private String sDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDProcessStatus</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<String> SD_PROCESS_STATUS =
        new SalesOrderItmPrecdgProcFlowField<String>("SDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingTransferStatus</b>
     * </p>
     *
     * @return Status for Transfer to Accounting
     */
    @SerializedName( "AccountingTransferStatus" )
    @JsonProperty( "AccountingTransferStatus" )
    @Nullable
    @ODataField( odataName = "AccountingTransferStatus" )
    private String accountingTransferStatus;
    /**
     * Use with available fluent helpers to apply the <b>AccountingTransferStatus</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<String> ACCOUNTING_TRANSFER_STATUS =
        new SalesOrderItmPrecdgProcFlowField<String>("AccountingTransferStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrelimBillingDocumentStatus</b>
     * </p>
     *
     * @return Preliminary Billing Document Status
     */
    @SerializedName( "PrelimBillingDocumentStatus" )
    @JsonProperty( "PrelimBillingDocumentStatus" )
    @Nullable
    @ODataField( odataName = "PrelimBillingDocumentStatus" )
    private String prelimBillingDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>PrelimBillingDocumentStatus</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<String> PRELIM_BILLING_DOCUMENT_STATUS =
        new SalesOrderItmPrecdgProcFlowField<String>("PrelimBillingDocumentStatus");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<LocalDateTime> CREATION_DATE =
        new SalesOrderItmPrecdgProcFlowField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @return Entry time
     */
    @SerializedName( "CreationTime" )
    @JsonProperty( "CreationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CreationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime creationTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationTime</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<LocalTime> CREATION_TIME =
        new SalesOrderItmPrecdgProcFlowField<LocalTime>("CreationTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowField<LocalDateTime> LAST_CHANGE_DATE =
        new SalesOrderItmPrecdgProcFlowField<LocalDateTime>("LastChangeDate");
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderItmPrecdgProcFlow</b> to single <b>SalesOrder</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrder toSalesOrder;
    /**
     * Navigation property <b>to_SalesOrderItem</b> for <b>SalesOrderItmPrecdgProcFlow</b> to single
     * <b>SalesOrderItem</b>.
     *
     */
    @SerializedName( "to_SalesOrderItem" )
    @JsonProperty( "to_SalesOrderItem" )
    @ODataField( odataName = "to_SalesOrderItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderItem toSalesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowOneToOneLink<SalesOrder> TO_SALES_ORDER =
        new SalesOrderItmPrecdgProcFlowOneToOneLink<SalesOrder>("to_SalesOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrderItem</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItmPrecdgProcFlowOneToOneLink<SalesOrderItem> TO_SALES_ORDER_ITEM =
        new SalesOrderItmPrecdgProcFlowOneToOneLink<SalesOrderItem>("to_SalesOrderItem");

    @Nonnull
    @Override
    public Class<SalesOrderItmPrecdgProcFlow> getType()
    {
        return SalesOrderItmPrecdgProcFlow.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Subsequent Sales and Distribution Document
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Subsequent Item of an SD Document
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>DocRelationshipUUID</b>
     * </p>
     *
     * @param docRelationshipUUID
     *            SD Unique Document Relationship Identification
     */
    public void setDocRelationshipUUID( @Nullable final UUID docRelationshipUUID )
    {
        rememberChangedField("DocRelationshipUUID", this.docRelationshipUUID);
        this.docRelationshipUUID = docRelationshipUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocument</b>
     * </p>
     *
     * @param precedingDocument
     *            Preceding sales and distribution document
     */
    public void setPrecedingDocument( @Nullable final String precedingDocument )
    {
        rememberChangedField("PrecedingDocument", this.precedingDocument);
        this.precedingDocument = precedingDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocumentItem</b>
     * </p>
     *
     * @param precedingDocumentItem
     *            Preceding Item of an SD Document
     */
    public void setPrecedingDocumentItem( @Nullable final String precedingDocumentItem )
    {
        rememberChangedField("PrecedingDocumentItem", this.precedingDocumentItem);
        this.precedingDocumentItem = precedingDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PrecedingDocumentCategory</b>
     * </p>
     *
     * @param precedingDocumentCategory
     *            Document Category of Preceding SD Document
     */
    public void setPrecedingDocumentCategory( @Nullable final String precedingDocumentCategory )
    {
        rememberChangedField("PrecedingDocumentCategory", this.precedingDocumentCategory);
        this.precedingDocumentCategory = precedingDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProcessFlowLevel</b>
     * </p>
     *
     * @param processFlowLevel
     *            Level of the document flow record
     */
    public void setProcessFlowLevel( @Nullable final String processFlowLevel )
    {
        rememberChangedField("ProcessFlowLevel", this.processFlowLevel);
        this.processFlowLevel = processFlowLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RelatedProcFlowDocStsFieldName</b>
     * </p>
     *
     * @param relatedProcFlowDocStsFieldName
     *            Field Name
     */
    public void setRelatedProcFlowDocStsFieldName( @Nullable final String relatedProcFlowDocStsFieldName )
    {
        rememberChangedField("RelatedProcFlowDocStsFieldName", this.relatedProcFlowDocStsFieldName);
        this.relatedProcFlowDocStsFieldName = relatedProcFlowDocStsFieldName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @param sDProcessStatus
     *            Overall Processing Status (Item)
     */
    public void setSDProcessStatus( @Nullable final String sDProcessStatus )
    {
        rememberChangedField("SDProcessStatus", this.sDProcessStatus);
        this.sDProcessStatus = sDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AccountingTransferStatus</b>
     * </p>
     *
     * @param accountingTransferStatus
     *            Status for Transfer to Accounting
     */
    public void setAccountingTransferStatus( @Nullable final String accountingTransferStatus )
    {
        rememberChangedField("AccountingTransferStatus", this.accountingTransferStatus);
        this.accountingTransferStatus = accountingTransferStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PrelimBillingDocumentStatus</b>
     * </p>
     *
     * @param prelimBillingDocumentStatus
     *            Preliminary Billing Document Status
     */
    public void setPrelimBillingDocumentStatus( @Nullable final String prelimBillingDocumentStatus )
    {
        rememberChangedField("PrelimBillingDocumentStatus", this.prelimBillingDocumentStatus);
        this.prelimBillingDocumentStatus = prelimBillingDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationTime</b>
     * </p>
     *
     * @param creationTime
     *            Entry time
     */
    public void setCreationTime( @Nullable final LocalTime creationTime )
    {
        rememberChangedField("CreationTime", this.creationTime);
        this.creationTime = creationTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderItmPrecdgProcFlow";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        result.put("SalesOrderItem", getSalesOrderItem());
        result.put("DocRelationshipUUID", getDocRelationshipUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("DocRelationshipUUID", getDocRelationshipUUID());
        values.put("PrecedingDocument", getPrecedingDocument());
        values.put("PrecedingDocumentItem", getPrecedingDocumentItem());
        values.put("PrecedingDocumentCategory", getPrecedingDocumentCategory());
        values.put("ProcessFlowLevel", getProcessFlowLevel());
        values.put("RelatedProcFlowDocStsFieldName", getRelatedProcFlowDocStsFieldName());
        values.put("SDProcessStatus", getSDProcessStatus());
        values.put("AccountingTransferStatus", getAccountingTransferStatus());
        values.put("PrelimBillingDocumentStatus", getPrelimBillingDocumentStatus());
        values.put("CreationDate", getCreationDate());
        values.put("CreationTime", getCreationTime());
        values.put("LastChangeDate", getLastChangeDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("DocRelationshipUUID") ) {
                final Object value = values.remove("DocRelationshipUUID");
                if( (value == null) || (!value.equals(getDocRelationshipUUID())) ) {
                    setDocRelationshipUUID(((UUID) value));
                }
            }
            if( values.containsKey("PrecedingDocument") ) {
                final Object value = values.remove("PrecedingDocument");
                if( (value == null) || (!value.equals(getPrecedingDocument())) ) {
                    setPrecedingDocument(((String) value));
                }
            }
            if( values.containsKey("PrecedingDocumentItem") ) {
                final Object value = values.remove("PrecedingDocumentItem");
                if( (value == null) || (!value.equals(getPrecedingDocumentItem())) ) {
                    setPrecedingDocumentItem(((String) value));
                }
            }
            if( values.containsKey("PrecedingDocumentCategory") ) {
                final Object value = values.remove("PrecedingDocumentCategory");
                if( (value == null) || (!value.equals(getPrecedingDocumentCategory())) ) {
                    setPrecedingDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("ProcessFlowLevel") ) {
                final Object value = values.remove("ProcessFlowLevel");
                if( (value == null) || (!value.equals(getProcessFlowLevel())) ) {
                    setProcessFlowLevel(((String) value));
                }
            }
            if( values.containsKey("RelatedProcFlowDocStsFieldName") ) {
                final Object value = values.remove("RelatedProcFlowDocStsFieldName");
                if( (value == null) || (!value.equals(getRelatedProcFlowDocStsFieldName())) ) {
                    setRelatedProcFlowDocStsFieldName(((String) value));
                }
            }
            if( values.containsKey("SDProcessStatus") ) {
                final Object value = values.remove("SDProcessStatus");
                if( (value == null) || (!value.equals(getSDProcessStatus())) ) {
                    setSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("AccountingTransferStatus") ) {
                final Object value = values.remove("AccountingTransferStatus");
                if( (value == null) || (!value.equals(getAccountingTransferStatus())) ) {
                    setAccountingTransferStatus(((String) value));
                }
            }
            if( values.containsKey("PrelimBillingDocumentStatus") ) {
                final Object value = values.remove("PrelimBillingDocumentStatus");
                if( (value == null) || (!value.equals(getPrelimBillingDocumentStatus())) ) {
                    setPrelimBillingDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreationTime") ) {
                final Object value = values.remove("CreationTime");
                if( (value == null) || (!value.equals(getCreationTime())) ) {
                    setCreationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Map ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = new SalesOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesOrderItem") ) {
                final Object value = (values).remove("to_SalesOrderItem");
                if( value instanceof Map ) {
                    if( toSalesOrderItem == null ) {
                        toSalesOrderItem = new SalesOrderItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrderItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SalesOrderItmPrecdgProcFlowField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderItmPrecdgProcFlowField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderItmPrecdgProcFlowField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderItmPrecdgProcFlowField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        if( toSalesOrderItem != null ) {
            (values).put("to_SalesOrderItem", toSalesOrderItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder fetchSalesOrder()
    {
        return fetchFieldAsSingle("to_SalesOrder", SalesOrder.class);
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>SalesOrderItmPrecdgProcFlow</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItmPrecdgProcFlow</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>SalesOrder</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<SalesOrder> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the associated <b>SalesOrder</b> entity for the loaded navigation property <b>to_SalesOrder</b>.
     *
     * @param value
     *            New <b>SalesOrder</b> entity.
     */
    public void setSalesOrder( final SalesOrder value )
    {
        toSalesOrder = value;
    }

    /**
     * Fetches the <b>SalesOrderItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesOrderItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderItem fetchSalesOrderItem()
    {
        return fetchFieldAsSingle("to_SalesOrderItem", SalesOrderItem.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrderItem</b>.
     * <p>
     * If the navigation property <b>to_SalesOrderItem</b> of a queried <b>SalesOrderItmPrecdgProcFlow</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderItem getSalesOrderItemOrFetch()
    {
        if( toSalesOrderItem == null ) {
            toSalesOrderItem = fetchSalesOrderItem();
        }
        return toSalesOrderItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrderItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItmPrecdgProcFlow</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrderItem</b> is already loaded, the result will
     *         contain the <b>SalesOrderItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderItem> getSalesOrderItemIfPresent()
    {
        return Option.of(toSalesOrderItem);
    }

    /**
     * Overwrites the associated <b>SalesOrderItem</b> entity for the loaded navigation property
     * <b>to_SalesOrderItem</b>.
     *
     * @param value
     *            New <b>SalesOrderItem</b> entity.
     */
    public void setSalesOrderItem( final SalesOrderItem value )
    {
        toSalesOrderItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderItmPrecdgProcFlow instances.
     *
     */
    public final static class SalesOrderItmPrecdgProcFlowBuilder
    {

        private SalesOrder toSalesOrder;
        private String salesOrder = null;
        private SalesOrderItem toSalesOrderItem;
        private String salesOrderItem = null;

        private SalesOrderItmPrecdgProcFlow.SalesOrderItmPrecdgProcFlowBuilder toSalesOrder( final SalesOrder value )
        {
            toSalesOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderItmPrecdgProcFlow</b> to single <b>SalesOrder</b>.
         *
         * @param value
         *            The SalesOrder to build this SalesOrderItmPrecdgProcFlow with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItmPrecdgProcFlow.SalesOrderItmPrecdgProcFlowBuilder salesOrder( final SalesOrder value )
        {
            return toSalesOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrder</b>
         * </p>
         *
         * @param value
         *            The salesOrder to build this SalesOrderItmPrecdgProcFlow with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItmPrecdgProcFlow.SalesOrderItmPrecdgProcFlowBuilder salesOrder( final String value )
        {
            salesOrder = value;
            return this;
        }

        private SalesOrderItmPrecdgProcFlow.SalesOrderItmPrecdgProcFlowBuilder toSalesOrderItem(
            final SalesOrderItem value )
        {
            toSalesOrderItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrderItem</b> for <b>SalesOrderItmPrecdgProcFlow</b> to single
         * <b>SalesOrderItem</b>.
         *
         * @param value
         *            The SalesOrderItem to build this SalesOrderItmPrecdgProcFlow with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItmPrecdgProcFlow.SalesOrderItmPrecdgProcFlowBuilder salesOrderItem(
            final SalesOrderItem value )
        {
            return toSalesOrderItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrderItem</b>
         * </p>
         *
         * @param value
         *            The salesOrderItem to build this SalesOrderItmPrecdgProcFlow with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItmPrecdgProcFlow.SalesOrderItmPrecdgProcFlowBuilder salesOrderItem( final String value )
        {
            salesOrderItem = value;
            return this;
        }

    }

}
