/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderPartnerAddressField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderPartnerAddressOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SalesOrderPartnerAddressSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Partner Address
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderPartnerAddressType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderPartnerAddress extends VdmEntity<SalesOrderPartnerAddress>
{

    /**
     * Selector for all available fields of SalesOrderPartnerAddress.
     *
     */
    public final static SalesOrderPartnerAddressSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales and Distribution Document Number
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> SALES_ORDER =
        new SalesOrderPartnerAddressField<String>("SalesOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> PARTNER_FUNCTION =
        new SalesOrderPartnerAddressField<String>("PartnerFunction");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AddressRepresentationCode</b>
     * </p>
     *
     * @return Version ID for International Addresses
     */
    @Key
    @SerializedName( "AddressRepresentationCode" )
    @JsonProperty( "AddressRepresentationCode" )
    @Nullable
    @ODataField( odataName = "AddressRepresentationCode" )
    private String addressRepresentationCode;
    /**
     * Use with available fluent helpers to apply the <b>AddressRepresentationCode</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> ADDRESS_REPRESENTATION_CODE =
        new SalesOrderPartnerAddressField<String>("AddressRepresentationCode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "CorrespondenceLanguage" )
    @JsonProperty( "CorrespondenceLanguage" )
    @Nullable
    @ODataField( odataName = "CorrespondenceLanguage" )
    private String correspondenceLanguage;
    /**
     * Use with available fluent helpers to apply the <b>CorrespondenceLanguage</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> CORRESPONDENCE_LANGUAGE =
        new SalesOrderPartnerAddressField<String>("CorrespondenceLanguage");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>AddresseeFullName</b>
     * </p>
     *
     * @return Full Name of Person
     */
    @SerializedName( "AddresseeFullName" )
    @JsonProperty( "AddresseeFullName" )
    @Nullable
    @ODataField( odataName = "AddresseeFullName" )
    private String addresseeFullName;
    /**
     * Use with available fluent helpers to apply the <b>AddresseeFullName</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> ADDRESSEE_FULL_NAME =
        new SalesOrderPartnerAddressField<String>("AddresseeFullName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationName1</b>
     * </p>
     *
     * @return Name 1
     */
    @SerializedName( "OrganizationName1" )
    @JsonProperty( "OrganizationName1" )
    @Nullable
    @ODataField( odataName = "OrganizationName1" )
    private String organizationName1;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationName1</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> ORGANIZATION_NAME1 =
        new SalesOrderPartnerAddressField<String>("OrganizationName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationName2</b>
     * </p>
     *
     * @return Name 2
     */
    @SerializedName( "OrganizationName2" )
    @JsonProperty( "OrganizationName2" )
    @Nullable
    @ODataField( odataName = "OrganizationName2" )
    private String organizationName2;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationName2</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> ORGANIZATION_NAME2 =
        new SalesOrderPartnerAddressField<String>("OrganizationName2");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationName3</b>
     * </p>
     *
     * @return Name 3
     */
    @SerializedName( "OrganizationName3" )
    @JsonProperty( "OrganizationName3" )
    @Nullable
    @ODataField( odataName = "OrganizationName3" )
    private String organizationName3;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationName3</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> ORGANIZATION_NAME3 =
        new SalesOrderPartnerAddressField<String>("OrganizationName3");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationName4</b>
     * </p>
     *
     * @return Name 4
     */
    @SerializedName( "OrganizationName4" )
    @JsonProperty( "OrganizationName4" )
    @Nullable
    @ODataField( odataName = "OrganizationName4" )
    private String organizationName4;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationName4</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> ORGANIZATION_NAME4 =
        new SalesOrderPartnerAddressField<String>("OrganizationName4");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @return City
     */
    @SerializedName( "CityName" )
    @JsonProperty( "CityName" )
    @Nullable
    @ODataField( odataName = "CityName" )
    private String cityName;
    /**
     * Use with available fluent helpers to apply the <b>CityName</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> CITY_NAME =
        new SalesOrderPartnerAddressField<String>("CityName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DistrictName</b>
     * </p>
     *
     * @return District
     */
    @SerializedName( "DistrictName" )
    @JsonProperty( "DistrictName" )
    @Nullable
    @ODataField( odataName = "DistrictName" )
    private String districtName;
    /**
     * Use with available fluent helpers to apply the <b>DistrictName</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> DISTRICT_NAME =
        new SalesOrderPartnerAddressField<String>("DistrictName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @return City Postal Code
     */
    @SerializedName( "PostalCode" )
    @JsonProperty( "PostalCode" )
    @Nullable
    @ODataField( odataName = "PostalCode" )
    private String postalCode;
    /**
     * Use with available fluent helpers to apply the <b>PostalCode</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> POSTAL_CODE =
        new SalesOrderPartnerAddressField<String>("PostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName1</b>
     * </p>
     *
     * @return Street 2
     */
    @SerializedName( "StreetPrefixName1" )
    @JsonProperty( "StreetPrefixName1" )
    @Nullable
    @ODataField( odataName = "StreetPrefixName1" )
    private String streetPrefixName1;
    /**
     * Use with available fluent helpers to apply the <b>StreetPrefixName1</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> STREET_PREFIX_NAME1 =
        new SalesOrderPartnerAddressField<String>("StreetPrefixName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName2</b>
     * </p>
     *
     * @return Street 3
     */
    @SerializedName( "StreetPrefixName2" )
    @JsonProperty( "StreetPrefixName2" )
    @Nullable
    @ODataField( odataName = "StreetPrefixName2" )
    private String streetPrefixName2;
    /**
     * Use with available fluent helpers to apply the <b>StreetPrefixName2</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> STREET_PREFIX_NAME2 =
        new SalesOrderPartnerAddressField<String>("StreetPrefixName2");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @return Street
     */
    @SerializedName( "StreetName" )
    @JsonProperty( "StreetName" )
    @Nullable
    @ODataField( odataName = "StreetName" )
    private String streetName;
    /**
     * Use with available fluent helpers to apply the <b>StreetName</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> STREET_NAME =
        new SalesOrderPartnerAddressField<String>("StreetName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName1</b>
     * </p>
     *
     * @return Street 4
     */
    @SerializedName( "StreetSuffixName1" )
    @JsonProperty( "StreetSuffixName1" )
    @Nullable
    @ODataField( odataName = "StreetSuffixName1" )
    private String streetSuffixName1;
    /**
     * Use with available fluent helpers to apply the <b>StreetSuffixName1</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> STREET_SUFFIX_NAME1 =
        new SalesOrderPartnerAddressField<String>("StreetSuffixName1");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName2</b>
     * </p>
     *
     * @return Street 5
     */
    @SerializedName( "StreetSuffixName2" )
    @JsonProperty( "StreetSuffixName2" )
    @Nullable
    @ODataField( odataName = "StreetSuffixName2" )
    private String streetSuffixName2;
    /**
     * Use with available fluent helpers to apply the <b>StreetSuffixName2</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> STREET_SUFFIX_NAME2 =
        new SalesOrderPartnerAddressField<String>("StreetSuffixName2");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @return House Number
     */
    @SerializedName( "HouseNumber" )
    @JsonProperty( "HouseNumber" )
    @Nullable
    @ODataField( odataName = "HouseNumber" )
    private String houseNumber;
    /**
     * Use with available fluent helpers to apply the <b>HouseNumber</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> HOUSE_NUMBER =
        new SalesOrderPartnerAddressField<String>("HouseNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @return Country/Region Key
     */
    @SerializedName( "Country" )
    @JsonProperty( "Country" )
    @Nullable
    @ODataField( odataName = "Country" )
    private String country;
    /**
     * Use with available fluent helpers to apply the <b>Country</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> COUNTRY =
        new SalesOrderPartnerAddressField<String>("Country");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @return Region (State, Province, County)
     */
    @SerializedName( "Region" )
    @JsonProperty( "Region" )
    @Nullable
    @ODataField( odataName = "Region" )
    private String region;
    /**
     * Use with available fluent helpers to apply the <b>Region</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> REGION =
        new SalesOrderPartnerAddressField<String>("Region");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @return Form-of-Address Key
     */
    @SerializedName( "FormOfAddress" )
    @JsonProperty( "FormOfAddress" )
    @Nullable
    @ODataField( odataName = "FormOfAddress" )
    private String formOfAddress;
    /**
     * Use with available fluent helpers to apply the <b>FormOfAddress</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> FORM_OF_ADDRESS =
        new SalesOrderPartnerAddressField<String>("FormOfAddress");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> TAX_JURISDICTION =
        new SalesOrderPartnerAddressField<String>("TaxJurisdiction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TransportZone</b>
     * </p>
     *
     * @return Transportation zone to or from which the goods are delivered
     */
    @SerializedName( "TransportZone" )
    @JsonProperty( "TransportZone" )
    @Nullable
    @ODataField( odataName = "TransportZone" )
    private String transportZone;
    /**
     * Use with available fluent helpers to apply the <b>TransportZone</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> TRANSPORT_ZONE =
        new SalesOrderPartnerAddressField<String>("TransportZone");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @return PO Box
     */
    @SerializedName( "POBox" )
    @JsonProperty( "POBox" )
    @Nullable
    @ODataField( odataName = "POBox" )
    private String pOBox;
    /**
     * Use with available fluent helpers to apply the <b>POBox</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> PO_BOX =
        new SalesOrderPartnerAddressField<String>("POBox");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBoxPostalCode</b>
     * </p>
     *
     * @return PO Box Postal Code
     */
    @SerializedName( "POBoxPostalCode" )
    @JsonProperty( "POBoxPostalCode" )
    @Nullable
    @ODataField( odataName = "POBoxPostalCode" )
    private String pOBoxPostalCode;
    /**
     * Use with available fluent helpers to apply the <b>POBoxPostalCode</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> PO_BOX_POSTAL_CODE =
        new SalesOrderPartnerAddressField<String>("POBoxPostalCode");
    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @return Email Address
     */
    @SerializedName( "EmailAddress" )
    @JsonProperty( "EmailAddress" )
    @Nullable
    @ODataField( odataName = "EmailAddress" )
    private String emailAddress;
    /**
     * Use with available fluent helpers to apply the <b>EmailAddress</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> EMAIL_ADDRESS =
        new SalesOrderPartnerAddressField<String>("EmailAddress");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MobilePhoneCountry</b>
     * </p>
     *
     * @return Country/Region for Telephone/Fax Number
     */
    @SerializedName( "MobilePhoneCountry" )
    @JsonProperty( "MobilePhoneCountry" )
    @Nullable
    @ODataField( odataName = "MobilePhoneCountry" )
    private String mobilePhoneCountry;
    /**
     * Use with available fluent helpers to apply the <b>MobilePhoneCountry</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> MOBILE_PHONE_COUNTRY =
        new SalesOrderPartnerAddressField<String>("MobilePhoneCountry");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MobileNumber</b>
     * </p>
     *
     * @return Telephone No.: Dialing Code + Number
     */
    @SerializedName( "MobileNumber" )
    @JsonProperty( "MobileNumber" )
    @Nullable
    @ODataField( odataName = "MobileNumber" )
    private String mobileNumber;
    /**
     * Use with available fluent helpers to apply the <b>MobileNumber</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> MOBILE_NUMBER =
        new SalesOrderPartnerAddressField<String>("MobileNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumberCountry</b>
     * </p>
     *
     * @return Country/Region for Telephone/Fax Number
     */
    @SerializedName( "PhoneNumberCountry" )
    @JsonProperty( "PhoneNumberCountry" )
    @Nullable
    @ODataField( odataName = "PhoneNumberCountry" )
    private String phoneNumberCountry;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumberCountry</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> PHONE_NUMBER_COUNTRY =
        new SalesOrderPartnerAddressField<String>("PhoneNumberCountry");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @return Telephone No.: Dialing Code + Number
     */
    @SerializedName( "PhoneNumber" )
    @JsonProperty( "PhoneNumber" )
    @Nullable
    @ODataField( odataName = "PhoneNumber" )
    private String phoneNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhoneNumber</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> PHONE_NUMBER =
        new SalesOrderPartnerAddressField<String>("PhoneNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhoneExtensionNumber</b>
     * </p>
     *
     * @return Telephone no.: Extension
     */
    @SerializedName( "PhoneExtensionNumber" )
    @JsonProperty( "PhoneExtensionNumber" )
    @Nullable
    @ODataField( odataName = "PhoneExtensionNumber" )
    private String phoneExtensionNumber;
    /**
     * Use with available fluent helpers to apply the <b>PhoneExtensionNumber</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> PHONE_EXTENSION_NUMBER =
        new SalesOrderPartnerAddressField<String>("PhoneExtensionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumberCountry</b>
     * </p>
     *
     * @return Country/Region for Telephone/Fax Number
     */
    @SerializedName( "FaxNumberCountry" )
    @JsonProperty( "FaxNumberCountry" )
    @Nullable
    @ODataField( odataName = "FaxNumberCountry" )
    private String faxNumberCountry;
    /**
     * Use with available fluent helpers to apply the <b>FaxNumberCountry</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> FAX_NUMBER_COUNTRY =
        new SalesOrderPartnerAddressField<String>("FaxNumberCountry");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxAreaCodeSubscriberNumber</b>
     * </p>
     *
     * @return Fax Number: Dialing Code+Number
     */
    @SerializedName( "FaxAreaCodeSubscriberNumber" )
    @JsonProperty( "FaxAreaCodeSubscriberNumber" )
    @Nullable
    @ODataField( odataName = "FaxAreaCodeSubscriberNumber" )
    private String faxAreaCodeSubscriberNumber;
    /**
     * Use with available fluent helpers to apply the <b>FaxAreaCodeSubscriberNumber</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> FAX_AREA_CODE_SUBSCRIBER_NUMBER =
        new SalesOrderPartnerAddressField<String>("FaxAreaCodeSubscriberNumber");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FaxExtensionNumber</b>
     * </p>
     *
     * @return Fax no.: Extension
     */
    @SerializedName( "FaxExtensionNumber" )
    @JsonProperty( "FaxExtensionNumber" )
    @Nullable
    @ODataField( odataName = "FaxExtensionNumber" )
    private String faxExtensionNumber;
    /**
     * Use with available fluent helpers to apply the <b>FaxExtensionNumber</b> field to query operations.
     *
     */
    public final static SalesOrderPartnerAddressField<String> FAX_EXTENSION_NUMBER =
        new SalesOrderPartnerAddressField<String>("FaxExtensionNumber");
    /**
     * Navigation property <b>to_Partner</b> for <b>SalesOrderPartnerAddress</b> to single
     * <b>SalesOrderHeaderPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderHeaderPartner toPartner;
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderPartnerAddress</b> to single <b>SalesOrder</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrder toSalesOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static SalesOrderPartnerAddressOneToOneLink<SalesOrderHeaderPartner> TO_PARTNER =
        new SalesOrderPartnerAddressOneToOneLink<SalesOrderHeaderPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static SalesOrderPartnerAddressOneToOneLink<SalesOrder> TO_SALES_ORDER =
        new SalesOrderPartnerAddressOneToOneLink<SalesOrder>("to_SalesOrder");

    @Nonnull
    @Override
    public Class<SalesOrderPartnerAddress> getType()
    {
        return SalesOrderPartnerAddress.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales and Distribution Document Number
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>AddressRepresentationCode</b>
     * </p>
     *
     * @param addressRepresentationCode
     *            Version ID for International Addresses
     */
    public void setAddressRepresentationCode( @Nullable final String addressRepresentationCode )
    {
        rememberChangedField("AddressRepresentationCode", this.addressRepresentationCode);
        this.addressRepresentationCode = addressRepresentationCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CorrespondenceLanguage</b>
     * </p>
     *
     * @param correspondenceLanguage
     *            Language Key
     */
    public void setCorrespondenceLanguage( @Nullable final String correspondenceLanguage )
    {
        rememberChangedField("CorrespondenceLanguage", this.correspondenceLanguage);
        this.correspondenceLanguage = correspondenceLanguage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>AddresseeFullName</b>
     * </p>
     *
     * @param addresseeFullName
     *            Full Name of Person
     */
    public void setAddresseeFullName( @Nullable final String addresseeFullName )
    {
        rememberChangedField("AddresseeFullName", this.addresseeFullName);
        this.addresseeFullName = addresseeFullName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationName1</b>
     * </p>
     *
     * @param organizationName1
     *            Name 1
     */
    public void setOrganizationName1( @Nullable final String organizationName1 )
    {
        rememberChangedField("OrganizationName1", this.organizationName1);
        this.organizationName1 = organizationName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationName2</b>
     * </p>
     *
     * @param organizationName2
     *            Name 2
     */
    public void setOrganizationName2( @Nullable final String organizationName2 )
    {
        rememberChangedField("OrganizationName2", this.organizationName2);
        this.organizationName2 = organizationName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationName3</b>
     * </p>
     *
     * @param organizationName3
     *            Name 3
     */
    public void setOrganizationName3( @Nullable final String organizationName3 )
    {
        rememberChangedField("OrganizationName3", this.organizationName3);
        this.organizationName3 = organizationName3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationName4</b>
     * </p>
     *
     * @param organizationName4
     *            Name 4
     */
    public void setOrganizationName4( @Nullable final String organizationName4 )
    {
        rememberChangedField("OrganizationName4", this.organizationName4);
        this.organizationName4 = organizationName4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CityName</b>
     * </p>
     *
     * @param cityName
     *            City
     */
    public void setCityName( @Nullable final String cityName )
    {
        rememberChangedField("CityName", this.cityName);
        this.cityName = cityName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DistrictName</b>
     * </p>
     *
     * @param districtName
     *            District
     */
    public void setDistrictName( @Nullable final String districtName )
    {
        rememberChangedField("DistrictName", this.districtName);
        this.districtName = districtName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PostalCode</b>
     * </p>
     *
     * @param postalCode
     *            City Postal Code
     */
    public void setPostalCode( @Nullable final String postalCode )
    {
        rememberChangedField("PostalCode", this.postalCode);
        this.postalCode = postalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName1</b>
     * </p>
     *
     * @param streetPrefixName1
     *            Street 2
     */
    public void setStreetPrefixName1( @Nullable final String streetPrefixName1 )
    {
        rememberChangedField("StreetPrefixName1", this.streetPrefixName1);
        this.streetPrefixName1 = streetPrefixName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetPrefixName2</b>
     * </p>
     *
     * @param streetPrefixName2
     *            Street 3
     */
    public void setStreetPrefixName2( @Nullable final String streetPrefixName2 )
    {
        rememberChangedField("StreetPrefixName2", this.streetPrefixName2);
        this.streetPrefixName2 = streetPrefixName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>StreetName</b>
     * </p>
     *
     * @param streetName
     *            Street
     */
    public void setStreetName( @Nullable final String streetName )
    {
        rememberChangedField("StreetName", this.streetName);
        this.streetName = streetName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName1</b>
     * </p>
     *
     * @param streetSuffixName1
     *            Street 4
     */
    public void setStreetSuffixName1( @Nullable final String streetSuffixName1 )
    {
        rememberChangedField("StreetSuffixName1", this.streetSuffixName1);
        this.streetSuffixName1 = streetSuffixName1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>StreetSuffixName2</b>
     * </p>
     *
     * @param streetSuffixName2
     *            Street 5
     */
    public void setStreetSuffixName2( @Nullable final String streetSuffixName2 )
    {
        rememberChangedField("StreetSuffixName2", this.streetSuffixName2);
        this.streetSuffixName2 = streetSuffixName2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>HouseNumber</b>
     * </p>
     *
     * @param houseNumber
     *            House Number
     */
    public void setHouseNumber( @Nullable final String houseNumber )
    {
        rememberChangedField("HouseNumber", this.houseNumber);
        this.houseNumber = houseNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Country</b>
     * </p>
     *
     * @param country
     *            Country/Region Key
     */
    public void setCountry( @Nullable final String country )
    {
        rememberChangedField("Country", this.country);
        this.country = country;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>Region</b>
     * </p>
     *
     * @param region
     *            Region (State, Province, County)
     */
    public void setRegion( @Nullable final String region )
    {
        rememberChangedField("Region", this.region);
        this.region = region;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FormOfAddress</b>
     * </p>
     *
     * @param formOfAddress
     *            Form-of-Address Key
     */
    public void setFormOfAddress( @Nullable final String formOfAddress )
    {
        rememberChangedField("FormOfAddress", this.formOfAddress);
        this.formOfAddress = formOfAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>TransportZone</b>
     * </p>
     *
     * @param transportZone
     *            Transportation zone to or from which the goods are delivered
     */
    public void setTransportZone( @Nullable final String transportZone )
    {
        rememberChangedField("TransportZone", this.transportZone);
        this.transportZone = transportZone;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBox</b>
     * </p>
     *
     * @param pOBox
     *            PO Box
     */
    public void setPOBox( @Nullable final String pOBox )
    {
        rememberChangedField("POBox", this.pOBox);
        this.pOBox = pOBox;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>POBoxPostalCode</b>
     * </p>
     *
     * @param pOBoxPostalCode
     *            PO Box Postal Code
     */
    public void setPOBoxPostalCode( @Nullable final String pOBoxPostalCode )
    {
        rememberChangedField("POBoxPostalCode", this.pOBoxPostalCode);
        this.pOBoxPostalCode = pOBoxPostalCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 241
     * <p>
     * Original property name from the Odata EDM: <b>EmailAddress</b>
     * </p>
     *
     * @param emailAddress
     *            Email Address
     */
    public void setEmailAddress( @Nullable final String emailAddress )
    {
        rememberChangedField("EmailAddress", this.emailAddress);
        this.emailAddress = emailAddress;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>MobilePhoneCountry</b>
     * </p>
     *
     * @param mobilePhoneCountry
     *            Country/Region for Telephone/Fax Number
     */
    public void setMobilePhoneCountry( @Nullable final String mobilePhoneCountry )
    {
        rememberChangedField("MobilePhoneCountry", this.mobilePhoneCountry);
        this.mobilePhoneCountry = mobilePhoneCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>MobileNumber</b>
     * </p>
     *
     * @param mobileNumber
     *            Telephone No.: Dialing Code + Number
     */
    public void setMobileNumber( @Nullable final String mobileNumber )
    {
        rememberChangedField("MobileNumber", this.mobileNumber);
        this.mobileNumber = mobileNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumberCountry</b>
     * </p>
     *
     * @param phoneNumberCountry
     *            Country/Region for Telephone/Fax Number
     */
    public void setPhoneNumberCountry( @Nullable final String phoneNumberCountry )
    {
        rememberChangedField("PhoneNumberCountry", this.phoneNumberCountry);
        this.phoneNumberCountry = phoneNumberCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PhoneNumber</b>
     * </p>
     *
     * @param phoneNumber
     *            Telephone No.: Dialing Code + Number
     */
    public void setPhoneNumber( @Nullable final String phoneNumber )
    {
        rememberChangedField("PhoneNumber", this.phoneNumber);
        this.phoneNumber = phoneNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PhoneExtensionNumber</b>
     * </p>
     *
     * @param phoneExtensionNumber
     *            Telephone no.: Extension
     */
    public void setPhoneExtensionNumber( @Nullable final String phoneExtensionNumber )
    {
        rememberChangedField("PhoneExtensionNumber", this.phoneExtensionNumber);
        this.phoneExtensionNumber = phoneExtensionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FaxNumberCountry</b>
     * </p>
     *
     * @param faxNumberCountry
     *            Country/Region for Telephone/Fax Number
     */
    public void setFaxNumberCountry( @Nullable final String faxNumberCountry )
    {
        rememberChangedField("FaxNumberCountry", this.faxNumberCountry);
        this.faxNumberCountry = faxNumberCountry;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>FaxAreaCodeSubscriberNumber</b>
     * </p>
     *
     * @param faxAreaCodeSubscriberNumber
     *            Fax Number: Dialing Code+Number
     */
    public void setFaxAreaCodeSubscriberNumber( @Nullable final String faxAreaCodeSubscriberNumber )
    {
        rememberChangedField("FaxAreaCodeSubscriberNumber", this.faxAreaCodeSubscriberNumber);
        this.faxAreaCodeSubscriberNumber = faxAreaCodeSubscriberNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FaxExtensionNumber</b>
     * </p>
     *
     * @param faxExtensionNumber
     *            Fax no.: Extension
     */
    public void setFaxExtensionNumber( @Nullable final String faxExtensionNumber )
    {
        rememberChangedField("FaxExtensionNumber", this.faxExtensionNumber);
        this.faxExtensionNumber = faxExtensionNumber;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderPartnerAddress";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        result.put("PartnerFunction", getPartnerFunction());
        result.put("AddressRepresentationCode", getAddressRepresentationCode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("AddressRepresentationCode", getAddressRepresentationCode());
        values.put("CorrespondenceLanguage", getCorrespondenceLanguage());
        values.put("AddresseeFullName", getAddresseeFullName());
        values.put("OrganizationName1", getOrganizationName1());
        values.put("OrganizationName2", getOrganizationName2());
        values.put("OrganizationName3", getOrganizationName3());
        values.put("OrganizationName4", getOrganizationName4());
        values.put("CityName", getCityName());
        values.put("DistrictName", getDistrictName());
        values.put("PostalCode", getPostalCode());
        values.put("StreetPrefixName1", getStreetPrefixName1());
        values.put("StreetPrefixName2", getStreetPrefixName2());
        values.put("StreetName", getStreetName());
        values.put("StreetSuffixName1", getStreetSuffixName1());
        values.put("StreetSuffixName2", getStreetSuffixName2());
        values.put("HouseNumber", getHouseNumber());
        values.put("Country", getCountry());
        values.put("Region", getRegion());
        values.put("FormOfAddress", getFormOfAddress());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("TransportZone", getTransportZone());
        values.put("POBox", getPOBox());
        values.put("POBoxPostalCode", getPOBoxPostalCode());
        values.put("EmailAddress", getEmailAddress());
        values.put("MobilePhoneCountry", getMobilePhoneCountry());
        values.put("MobileNumber", getMobileNumber());
        values.put("PhoneNumberCountry", getPhoneNumberCountry());
        values.put("PhoneNumber", getPhoneNumber());
        values.put("PhoneExtensionNumber", getPhoneExtensionNumber());
        values.put("FaxNumberCountry", getFaxNumberCountry());
        values.put("FaxAreaCodeSubscriberNumber", getFaxAreaCodeSubscriberNumber());
        values.put("FaxExtensionNumber", getFaxExtensionNumber());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("AddressRepresentationCode") ) {
                final Object value = values.remove("AddressRepresentationCode");
                if( (value == null) || (!value.equals(getAddressRepresentationCode())) ) {
                    setAddressRepresentationCode(((String) value));
                }
            }
            if( values.containsKey("CorrespondenceLanguage") ) {
                final Object value = values.remove("CorrespondenceLanguage");
                if( (value == null) || (!value.equals(getCorrespondenceLanguage())) ) {
                    setCorrespondenceLanguage(((String) value));
                }
            }
            if( values.containsKey("AddresseeFullName") ) {
                final Object value = values.remove("AddresseeFullName");
                if( (value == null) || (!value.equals(getAddresseeFullName())) ) {
                    setAddresseeFullName(((String) value));
                }
            }
            if( values.containsKey("OrganizationName1") ) {
                final Object value = values.remove("OrganizationName1");
                if( (value == null) || (!value.equals(getOrganizationName1())) ) {
                    setOrganizationName1(((String) value));
                }
            }
            if( values.containsKey("OrganizationName2") ) {
                final Object value = values.remove("OrganizationName2");
                if( (value == null) || (!value.equals(getOrganizationName2())) ) {
                    setOrganizationName2(((String) value));
                }
            }
            if( values.containsKey("OrganizationName3") ) {
                final Object value = values.remove("OrganizationName3");
                if( (value == null) || (!value.equals(getOrganizationName3())) ) {
                    setOrganizationName3(((String) value));
                }
            }
            if( values.containsKey("OrganizationName4") ) {
                final Object value = values.remove("OrganizationName4");
                if( (value == null) || (!value.equals(getOrganizationName4())) ) {
                    setOrganizationName4(((String) value));
                }
            }
            if( values.containsKey("CityName") ) {
                final Object value = values.remove("CityName");
                if( (value == null) || (!value.equals(getCityName())) ) {
                    setCityName(((String) value));
                }
            }
            if( values.containsKey("DistrictName") ) {
                final Object value = values.remove("DistrictName");
                if( (value == null) || (!value.equals(getDistrictName())) ) {
                    setDistrictName(((String) value));
                }
            }
            if( values.containsKey("PostalCode") ) {
                final Object value = values.remove("PostalCode");
                if( (value == null) || (!value.equals(getPostalCode())) ) {
                    setPostalCode(((String) value));
                }
            }
            if( values.containsKey("StreetPrefixName1") ) {
                final Object value = values.remove("StreetPrefixName1");
                if( (value == null) || (!value.equals(getStreetPrefixName1())) ) {
                    setStreetPrefixName1(((String) value));
                }
            }
            if( values.containsKey("StreetPrefixName2") ) {
                final Object value = values.remove("StreetPrefixName2");
                if( (value == null) || (!value.equals(getStreetPrefixName2())) ) {
                    setStreetPrefixName2(((String) value));
                }
            }
            if( values.containsKey("StreetName") ) {
                final Object value = values.remove("StreetName");
                if( (value == null) || (!value.equals(getStreetName())) ) {
                    setStreetName(((String) value));
                }
            }
            if( values.containsKey("StreetSuffixName1") ) {
                final Object value = values.remove("StreetSuffixName1");
                if( (value == null) || (!value.equals(getStreetSuffixName1())) ) {
                    setStreetSuffixName1(((String) value));
                }
            }
            if( values.containsKey("StreetSuffixName2") ) {
                final Object value = values.remove("StreetSuffixName2");
                if( (value == null) || (!value.equals(getStreetSuffixName2())) ) {
                    setStreetSuffixName2(((String) value));
                }
            }
            if( values.containsKey("HouseNumber") ) {
                final Object value = values.remove("HouseNumber");
                if( (value == null) || (!value.equals(getHouseNumber())) ) {
                    setHouseNumber(((String) value));
                }
            }
            if( values.containsKey("Country") ) {
                final Object value = values.remove("Country");
                if( (value == null) || (!value.equals(getCountry())) ) {
                    setCountry(((String) value));
                }
            }
            if( values.containsKey("Region") ) {
                final Object value = values.remove("Region");
                if( (value == null) || (!value.equals(getRegion())) ) {
                    setRegion(((String) value));
                }
            }
            if( values.containsKey("FormOfAddress") ) {
                final Object value = values.remove("FormOfAddress");
                if( (value == null) || (!value.equals(getFormOfAddress())) ) {
                    setFormOfAddress(((String) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("TransportZone") ) {
                final Object value = values.remove("TransportZone");
                if( (value == null) || (!value.equals(getTransportZone())) ) {
                    setTransportZone(((String) value));
                }
            }
            if( values.containsKey("POBox") ) {
                final Object value = values.remove("POBox");
                if( (value == null) || (!value.equals(getPOBox())) ) {
                    setPOBox(((String) value));
                }
            }
            if( values.containsKey("POBoxPostalCode") ) {
                final Object value = values.remove("POBoxPostalCode");
                if( (value == null) || (!value.equals(getPOBoxPostalCode())) ) {
                    setPOBoxPostalCode(((String) value));
                }
            }
            if( values.containsKey("EmailAddress") ) {
                final Object value = values.remove("EmailAddress");
                if( (value == null) || (!value.equals(getEmailAddress())) ) {
                    setEmailAddress(((String) value));
                }
            }
            if( values.containsKey("MobilePhoneCountry") ) {
                final Object value = values.remove("MobilePhoneCountry");
                if( (value == null) || (!value.equals(getMobilePhoneCountry())) ) {
                    setMobilePhoneCountry(((String) value));
                }
            }
            if( values.containsKey("MobileNumber") ) {
                final Object value = values.remove("MobileNumber");
                if( (value == null) || (!value.equals(getMobileNumber())) ) {
                    setMobileNumber(((String) value));
                }
            }
            if( values.containsKey("PhoneNumberCountry") ) {
                final Object value = values.remove("PhoneNumberCountry");
                if( (value == null) || (!value.equals(getPhoneNumberCountry())) ) {
                    setPhoneNumberCountry(((String) value));
                }
            }
            if( values.containsKey("PhoneNumber") ) {
                final Object value = values.remove("PhoneNumber");
                if( (value == null) || (!value.equals(getPhoneNumber())) ) {
                    setPhoneNumber(((String) value));
                }
            }
            if( values.containsKey("PhoneExtensionNumber") ) {
                final Object value = values.remove("PhoneExtensionNumber");
                if( (value == null) || (!value.equals(getPhoneExtensionNumber())) ) {
                    setPhoneExtensionNumber(((String) value));
                }
            }
            if( values.containsKey("FaxNumberCountry") ) {
                final Object value = values.remove("FaxNumberCountry");
                if( (value == null) || (!value.equals(getFaxNumberCountry())) ) {
                    setFaxNumberCountry(((String) value));
                }
            }
            if( values.containsKey("FaxAreaCodeSubscriberNumber") ) {
                final Object value = values.remove("FaxAreaCodeSubscriberNumber");
                if( (value == null) || (!value.equals(getFaxAreaCodeSubscriberNumber())) ) {
                    setFaxAreaCodeSubscriberNumber(((String) value));
                }
            }
            if( values.containsKey("FaxExtensionNumber") ) {
                final Object value = values.remove("FaxExtensionNumber");
                if( (value == null) || (!value.equals(getFaxExtensionNumber())) ) {
                    setFaxExtensionNumber(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Map ) {
                    if( toPartner == null ) {
                        toPartner = new SalesOrderHeaderPartner();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPartner.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Map ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = new SalesOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrderPartnerAddressField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderPartnerAddressField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderPartnerAddressField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderPartnerAddressField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderHeaderPartner</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderHeaderPartner</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderHeaderPartner fetchPartner()
    {
        return fetchFieldAsSingle("to_Partner", SalesOrderHeaderPartner.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderHeaderPartner</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderPartnerAddress</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderHeaderPartner</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderHeaderPartner getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SalesOrderHeaderPartner</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderPartnerAddress</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SalesOrderHeaderPartner</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderHeaderPartner> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the associated <b>SalesOrderHeaderPartner</b> entity for the loaded navigation property
     * <b>to_Partner</b>.
     *
     * @param value
     *            New <b>SalesOrderHeaderPartner</b> entity.
     */
    public void setPartner( final SalesOrderHeaderPartner value )
    {
        toPartner = value;
    }

    /**
     * Fetches the <b>SalesOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder fetchSalesOrder()
    {
        return fetchFieldAsSingle("to_SalesOrder", SalesOrder.class);
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>SalesOrderPartnerAddress</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderPartnerAddress</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>SalesOrder</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<SalesOrder> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the associated <b>SalesOrder</b> entity for the loaded navigation property <b>to_SalesOrder</b>.
     *
     * @param value
     *            New <b>SalesOrder</b> entity.
     */
    public void setSalesOrder( final SalesOrder value )
    {
        toSalesOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderPartnerAddress instances.
     *
     */
    public final static class SalesOrderPartnerAddressBuilder
    {

        private SalesOrderHeaderPartner toPartner;
        private SalesOrder toSalesOrder;
        private String salesOrder = null;

        private SalesOrderPartnerAddress.SalesOrderPartnerAddressBuilder toPartner(
            final SalesOrderHeaderPartner value )
        {
            toPartner = value;
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>SalesOrderPartnerAddress</b> to single
         * <b>SalesOrderHeaderPartner</b>.
         *
         * @param value
         *            The SalesOrderHeaderPartner to build this SalesOrderPartnerAddress with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderPartnerAddress.SalesOrderPartnerAddressBuilder partner( final SalesOrderHeaderPartner value )
        {
            return toPartner(value);
        }

        private SalesOrderPartnerAddress.SalesOrderPartnerAddressBuilder toSalesOrder( final SalesOrder value )
        {
            toSalesOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderPartnerAddress</b> to single <b>SalesOrder</b>.
         *
         * @param value
         *            The SalesOrder to build this SalesOrderPartnerAddress with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderPartnerAddress.SalesOrderPartnerAddressBuilder salesOrder( final SalesOrder value )
        {
            return toSalesOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrder</b>
         * </p>
         *
         * @param value
         *            The salesOrder to build this SalesOrderPartnerAddress with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderPartnerAddress.SalesOrderPartnerAddressBuilder salesOrder( final String value )
        {
            salesOrder = value;
            return this;
        }

    }

}
