/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderScheduleLineField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SalesOrderScheduleLineSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Item Schedule Line
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderScheduleLineType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderScheduleLine extends VdmEntity<SalesOrderScheduleLine>
{

    /**
     * Selector for all available fields of SalesOrderScheduleLine.
     *
     */
    public final static SalesOrderScheduleLineSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Document
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<String> SALES_ORDER =
        new SalesOrderScheduleLineField<String>("SalesOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @Key
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<String> SALES_ORDER_ITEM =
        new SalesOrderScheduleLineField<String>("SalesOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Schedule Line Number
     */
    @Key
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<String> SCHEDULE_LINE =
        new SalesOrderScheduleLineField<String>("ScheduleLine");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @return Requested Delivery Date
     */
    @SerializedName( "RequestedDeliveryDate" )
    @JsonProperty( "RequestedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requestedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryDate</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<LocalDateTime> REQUESTED_DELIVERY_DATE =
        new SalesOrderScheduleLineField<LocalDateTime>("RequestedDeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedDeliveryDate</b>
     * </p>
     *
     * @return Confirmed Delivery Date
     */
    @SerializedName( "ConfirmedDeliveryDate" )
    @JsonProperty( "ConfirmedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedDeliveryDate</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<LocalDateTime> CONFIRMED_DELIVERY_DATE =
        new SalesOrderScheduleLineField<LocalDateTime>("ConfirmedDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<String> ORDER_QUANTITY_UNIT =
        new SalesOrderScheduleLineField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantitySAPUnit" )
    @JsonProperty( "OrderQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantitySAPUnit" )
    private String orderQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<String> ORDER_QUANTITY_SAP_UNIT =
        new SalesOrderScheduleLineField<String>("OrderQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantityISOUnit" )
    @JsonProperty( "OrderQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityISOUnit" )
    private String orderQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<String> ORDER_QUANTITY_ISO_UNIT =
        new SalesOrderScheduleLineField<String>("OrderQuantityISOUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @return Order Quantity in Sales Units
     */
    @SerializedName( "ScheduleLineOrderQuantity" )
    @JsonProperty( "ScheduleLineOrderQuantity" )
    @Nullable
    @ODataField( odataName = "ScheduleLineOrderQuantity" )
    private BigDecimal scheduleLineOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineOrderQuantity</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<BigDecimal> SCHEDULE_LINE_ORDER_QUANTITY =
        new SalesOrderScheduleLineField<BigDecimal>("ScheduleLineOrderQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdOrderQtyByMatlAvailCheck</b>
     * </p>
     *
     * @return Confirmed Quantity
     */
    @SerializedName( "ConfdOrderQtyByMatlAvailCheck" )
    @JsonProperty( "ConfdOrderQtyByMatlAvailCheck" )
    @Nullable
    @ODataField( odataName = "ConfdOrderQtyByMatlAvailCheck" )
    private BigDecimal confdOrderQtyByMatlAvailCheck;
    /**
     * Use with available fluent helpers to apply the <b>ConfdOrderQtyByMatlAvailCheck</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<BigDecimal> CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK =
        new SalesOrderScheduleLineField<BigDecimal>("ConfdOrderQtyByMatlAvailCheck");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveredQtyInOrderQtyUnit</b>
     * </p>
     *
     * @return Delivered Quantity
     */
    @SerializedName( "DeliveredQtyInOrderQtyUnit" )
    @JsonProperty( "DeliveredQtyInOrderQtyUnit" )
    @Nullable
    @ODataField( odataName = "DeliveredQtyInOrderQtyUnit" )
    private BigDecimal deliveredQtyInOrderQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>DeliveredQtyInOrderQtyUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<BigDecimal> DELIVERED_QTY_IN_ORDER_QTY_UNIT =
        new SalesOrderScheduleLineField<BigDecimal>("DeliveredQtyInOrderQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpenConfdDelivQtyInOrdQtyUnit</b>
     * </p>
     *
     * @return Open Confirmed Delivery Quantity
     */
    @SerializedName( "OpenConfdDelivQtyInOrdQtyUnit" )
    @JsonProperty( "OpenConfdDelivQtyInOrdQtyUnit" )
    @Nullable
    @ODataField( odataName = "OpenConfdDelivQtyInOrdQtyUnit" )
    private BigDecimal openConfdDelivQtyInOrdQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>OpenConfdDelivQtyInOrdQtyUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<BigDecimal> OPEN_CONFD_DELIV_QTY_IN_ORD_QTY_UNIT =
        new SalesOrderScheduleLineField<BigDecimal>("OpenConfdDelivQtyInOrdQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CorrectedQtyInOrderQtyUnit</b>
     * </p>
     *
     * @return Corrected quantity in sales unit
     */
    @SerializedName( "CorrectedQtyInOrderQtyUnit" )
    @JsonProperty( "CorrectedQtyInOrderQtyUnit" )
    @Nullable
    @ODataField( odataName = "CorrectedQtyInOrderQtyUnit" )
    private BigDecimal correctedQtyInOrderQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>CorrectedQtyInOrderQtyUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<BigDecimal> CORRECTED_QTY_IN_ORDER_QTY_UNIT =
        new SalesOrderScheduleLineField<BigDecimal>("CorrectedQtyInOrderQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DelivBlockReasonForSchedLine</b>
     * </p>
     *
     * @return Schedule Line Blocked for Delivery
     */
    @SerializedName( "DelivBlockReasonForSchedLine" )
    @JsonProperty( "DelivBlockReasonForSchedLine" )
    @Nullable
    @ODataField( odataName = "DelivBlockReasonForSchedLine" )
    private String delivBlockReasonForSchedLine;
    /**
     * Use with available fluent helpers to apply the <b>DelivBlockReasonForSchedLine</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineField<String> DELIV_BLOCK_REASON_FOR_SCHED_LINE =
        new SalesOrderScheduleLineField<String>("DelivBlockReasonForSchedLine");

    @Nonnull
    @Override
    public Class<SalesOrderScheduleLine> getType()
    {
        return SalesOrderScheduleLine.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Document
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Document Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Schedule Line Number
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @param requestedDeliveryDate
     *            Requested Delivery Date
     */
    public void setRequestedDeliveryDate( @Nullable final LocalDateTime requestedDeliveryDate )
    {
        rememberChangedField("RequestedDeliveryDate", this.requestedDeliveryDate);
        this.requestedDeliveryDate = requestedDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedDeliveryDate</b>
     * </p>
     *
     * @param confirmedDeliveryDate
     *            Confirmed Delivery Date
     */
    public void setConfirmedDeliveryDate( @Nullable final LocalDateTime confirmedDeliveryDate )
    {
        rememberChangedField("ConfirmedDeliveryDate", this.confirmedDeliveryDate);
        this.confirmedDeliveryDate = confirmedDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @param orderQuantitySAPUnit
     *            SAP Unit Code for Order Quantity
     */
    public void setOrderQuantitySAPUnit( @Nullable final String orderQuantitySAPUnit )
    {
        rememberChangedField("OrderQuantitySAPUnit", this.orderQuantitySAPUnit);
        this.orderQuantitySAPUnit = orderQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @param orderQuantityISOUnit
     *            ISO Unit Code for Order Quantity
     */
    public void setOrderQuantityISOUnit( @Nullable final String orderQuantityISOUnit )
    {
        rememberChangedField("OrderQuantityISOUnit", this.orderQuantityISOUnit);
        this.orderQuantityISOUnit = orderQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @param scheduleLineOrderQuantity
     *            Order Quantity in Sales Units
     */
    public void setScheduleLineOrderQuantity( @Nullable final BigDecimal scheduleLineOrderQuantity )
    {
        rememberChangedField("ScheduleLineOrderQuantity", this.scheduleLineOrderQuantity);
        this.scheduleLineOrderQuantity = scheduleLineOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdOrderQtyByMatlAvailCheck</b>
     * </p>
     *
     * @param confdOrderQtyByMatlAvailCheck
     *            Confirmed Quantity
     */
    public void setConfdOrderQtyByMatlAvailCheck( @Nullable final BigDecimal confdOrderQtyByMatlAvailCheck )
    {
        rememberChangedField("ConfdOrderQtyByMatlAvailCheck", this.confdOrderQtyByMatlAvailCheck);
        this.confdOrderQtyByMatlAvailCheck = confdOrderQtyByMatlAvailCheck;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveredQtyInOrderQtyUnit</b>
     * </p>
     *
     * @param deliveredQtyInOrderQtyUnit
     *            Delivered Quantity
     */
    public void setDeliveredQtyInOrderQtyUnit( @Nullable final BigDecimal deliveredQtyInOrderQtyUnit )
    {
        rememberChangedField("DeliveredQtyInOrderQtyUnit", this.deliveredQtyInOrderQtyUnit);
        this.deliveredQtyInOrderQtyUnit = deliveredQtyInOrderQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpenConfdDelivQtyInOrdQtyUnit</b>
     * </p>
     *
     * @param openConfdDelivQtyInOrdQtyUnit
     *            Open Confirmed Delivery Quantity
     */
    public void setOpenConfdDelivQtyInOrdQtyUnit( @Nullable final BigDecimal openConfdDelivQtyInOrdQtyUnit )
    {
        rememberChangedField("OpenConfdDelivQtyInOrdQtyUnit", this.openConfdDelivQtyInOrdQtyUnit);
        this.openConfdDelivQtyInOrdQtyUnit = openConfdDelivQtyInOrdQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CorrectedQtyInOrderQtyUnit</b>
     * </p>
     *
     * @param correctedQtyInOrderQtyUnit
     *            Corrected quantity in sales unit
     */
    public void setCorrectedQtyInOrderQtyUnit( @Nullable final BigDecimal correctedQtyInOrderQtyUnit )
    {
        rememberChangedField("CorrectedQtyInOrderQtyUnit", this.correctedQtyInOrderQtyUnit);
        this.correctedQtyInOrderQtyUnit = correctedQtyInOrderQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DelivBlockReasonForSchedLine</b>
     * </p>
     *
     * @param delivBlockReasonForSchedLine
     *            Schedule Line Blocked for Delivery
     */
    public void setDelivBlockReasonForSchedLine( @Nullable final String delivBlockReasonForSchedLine )
    {
        rememberChangedField("DelivBlockReasonForSchedLine", this.delivBlockReasonForSchedLine);
        this.delivBlockReasonForSchedLine = delivBlockReasonForSchedLine;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderScheduleLine";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        result.put("SalesOrderItem", getSalesOrderItem());
        result.put("ScheduleLine", getScheduleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("RequestedDeliveryDate", getRequestedDeliveryDate());
        values.put("ConfirmedDeliveryDate", getConfirmedDeliveryDate());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("OrderQuantitySAPUnit", getOrderQuantitySAPUnit());
        values.put("OrderQuantityISOUnit", getOrderQuantityISOUnit());
        values.put("ScheduleLineOrderQuantity", getScheduleLineOrderQuantity());
        values.put("ConfdOrderQtyByMatlAvailCheck", getConfdOrderQtyByMatlAvailCheck());
        values.put("DeliveredQtyInOrderQtyUnit", getDeliveredQtyInOrderQtyUnit());
        values.put("OpenConfdDelivQtyInOrdQtyUnit", getOpenConfdDelivQtyInOrdQtyUnit());
        values.put("CorrectedQtyInOrderQtyUnit", getCorrectedQtyInOrderQtyUnit());
        values.put("DelivBlockReasonForSchedLine", getDelivBlockReasonForSchedLine());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("RequestedDeliveryDate") ) {
                final Object value = values.remove("RequestedDeliveryDate");
                if( (value == null) || (!value.equals(getRequestedDeliveryDate())) ) {
                    setRequestedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedDeliveryDate") ) {
                final Object value = values.remove("ConfirmedDeliveryDate");
                if( (value == null) || (!value.equals(getConfirmedDeliveryDate())) ) {
                    setConfirmedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantitySAPUnit") ) {
                final Object value = values.remove("OrderQuantitySAPUnit");
                if( (value == null) || (!value.equals(getOrderQuantitySAPUnit())) ) {
                    setOrderQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityISOUnit") ) {
                final Object value = values.remove("OrderQuantityISOUnit");
                if( (value == null) || (!value.equals(getOrderQuantityISOUnit())) ) {
                    setOrderQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineOrderQuantity") ) {
                final Object value = values.remove("ScheduleLineOrderQuantity");
                if( (value == null) || (!value.equals(getScheduleLineOrderQuantity())) ) {
                    setScheduleLineOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfdOrderQtyByMatlAvailCheck") ) {
                final Object value = values.remove("ConfdOrderQtyByMatlAvailCheck");
                if( (value == null) || (!value.equals(getConfdOrderQtyByMatlAvailCheck())) ) {
                    setConfdOrderQtyByMatlAvailCheck(((BigDecimal) value));
                }
            }
            if( values.containsKey("DeliveredQtyInOrderQtyUnit") ) {
                final Object value = values.remove("DeliveredQtyInOrderQtyUnit");
                if( (value == null) || (!value.equals(getDeliveredQtyInOrderQtyUnit())) ) {
                    setDeliveredQtyInOrderQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpenConfdDelivQtyInOrdQtyUnit") ) {
                final Object value = values.remove("OpenConfdDelivQtyInOrdQtyUnit");
                if( (value == null) || (!value.equals(getOpenConfdDelivQtyInOrdQtyUnit())) ) {
                    setOpenConfdDelivQtyInOrdQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("CorrectedQtyInOrderQtyUnit") ) {
                final Object value = values.remove("CorrectedQtyInOrderQtyUnit");
                if( (value == null) || (!value.equals(getCorrectedQtyInOrderQtyUnit())) ) {
                    setCorrectedQtyInOrderQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("DelivBlockReasonForSchedLine") ) {
                final Object value = values.remove("DelivBlockReasonForSchedLine");
                if( (value == null) || (!value.equals(getDelivBlockReasonForSchedLine())) ) {
                    setDelivBlockReasonForSchedLine(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrderScheduleLineField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderScheduleLineField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderScheduleLineField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderScheduleLineField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService.DEFAULT_SERVICE_PATH);
    }

}
