/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SalesOrderSubsqntProcFlowSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlow
 * SalesOrderSubsqntProcFlow} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SalesOrderSubsqntProcFlowByKeyFluentHelper
    extends
    FluentHelperByKey<SalesOrderSubsqntProcFlowByKeyFluentHelper, SalesOrderSubsqntProcFlow, SalesOrderSubsqntProcFlowSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderSubsqntProcFlow
     * SalesOrderSubsqntProcFlow} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesOrderSubsqntProcFlow}
     * @param docRelationshipUUID
     *            SD Unique Document Relationship Identification
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesOrderSubsqntProcFlow}
     * @param salesOrder
     *            Preceding sales and distribution document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public SalesOrderSubsqntProcFlowByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesOrder,
        final UUID docRelationshipUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesOrder", salesOrder);
        this.key.put("DocRelationshipUUID", docRelationshipUUID);
    }

    @Override
    @Nonnull
    protected Class<SalesOrderSubsqntProcFlow> getEntityClass()
    {
        return SalesOrderSubsqntProcFlow.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
