/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SlsOrdPaymentPlanItemDetailsField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SlsOrdPaymentPlanItemDetailsOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SlsOrdPaymentPlanItemDetailsSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Header Payment Plan
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsOrdPaymentPlanItemDetailsType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsOrdPaymentPlanItemDetails extends VdmEntity<SlsOrdPaymentPlanItemDetails>
{

    /**
     * Selector for all available fields of SlsOrdPaymentPlanItemDetails.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> SALES_ORDER =
        new SlsOrdPaymentPlanItemDetailsField<String>("SalesOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PaymentPlanItem</b>
     * </p>
     *
     * @return Item for billing plan/invoice plan/payment cards
     */
    @Key
    @SerializedName( "PaymentPlanItem" )
    @JsonProperty( "PaymentPlanItem" )
    @Nullable
    @ODataField( odataName = "PaymentPlanItem" )
    private String paymentPlanItem;
    /**
     * Use with available fluent helpers to apply the <b>PaymentPlanItem</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> PAYMENT_PLAN_ITEM =
        new SlsOrdPaymentPlanItemDetailsField<String>("PaymentPlanItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentPlan</b>
     * </p>
     *
     * @return Billing Plan Number / Invoicing Plan Number
     */
    @SerializedName( "PaymentPlan" )
    @JsonProperty( "PaymentPlan" )
    @Nullable
    @ODataField( odataName = "PaymentPlan" )
    private String paymentPlan;
    /**
     * Use with available fluent helpers to apply the <b>PaymentPlan</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> PAYMENT_PLAN =
        new SlsOrdPaymentPlanItemDetailsField<String>("PaymentPlan");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicPaymentType</b>
     * </p>
     *
     * @return Electronic Payment: Payment Type
     */
    @SerializedName( "ElectronicPaymentType" )
    @JsonProperty( "ElectronicPaymentType" )
    @Nullable
    @ODataField( odataName = "ElectronicPaymentType" )
    private String electronicPaymentType;
    /**
     * Use with available fluent helpers to apply the <b>ElectronicPaymentType</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> ELECTRONIC_PAYMENT_TYPE =
        new SlsOrdPaymentPlanItemDetailsField<String>("ElectronicPaymentType");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicPayment</b>
     * </p>
     *
     * @return Electronic Payment: Account Number
     */
    @SerializedName( "ElectronicPayment" )
    @JsonProperty( "ElectronicPayment" )
    @Nullable
    @ODataField( odataName = "ElectronicPayment" )
    private String electronicPayment;
    /**
     * Use with available fluent helpers to apply the <b>ElectronicPayment</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> ELECTRONIC_PAYMENT =
        new SlsOrdPaymentPlanItemDetailsField<String>("ElectronicPayment");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EPaytValidityStartDate</b>
     * </p>
     *
     * @return Electronic Payment: Valid from
     */
    @SerializedName( "EPaytValidityStartDate" )
    @JsonProperty( "EPaytValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EPaytValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime ePaytValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>EPaytValidityStartDate</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<LocalDateTime> E_PAYT_VALIDITY_START_DATE =
        new SlsOrdPaymentPlanItemDetailsField<LocalDateTime>("EPaytValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EPaytValidityEndDate</b>
     * </p>
     *
     * @return Electronic Payment: Valid to
     */
    @SerializedName( "EPaytValidityEndDate" )
    @JsonProperty( "EPaytValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EPaytValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime ePaytValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>EPaytValidityEndDate</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<LocalDateTime> E_PAYT_VALIDITY_END_DATE =
        new SlsOrdPaymentPlanItemDetailsField<LocalDateTime>("EPaytValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicPaymentHolderName</b>
     * </p>
     *
     * @return Electronic Payment: Name of Account Holder
     */
    @SerializedName( "ElectronicPaymentHolderName" )
    @JsonProperty( "ElectronicPaymentHolderName" )
    @Nullable
    @ODataField( odataName = "ElectronicPaymentHolderName" )
    private String electronicPaymentHolderName;
    /**
     * Use with available fluent helpers to apply the <b>ElectronicPaymentHolderName</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> ELECTRONIC_PAYMENT_HOLDER_NAME =
        new SlsOrdPaymentPlanItemDetailsField<String>("ElectronicPaymentHolderName");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizedAmountInAuthznCrcy</b>
     * </p>
     *
     * @return Electronic Payment: Authorized Amount
     */
    @SerializedName( "AuthorizedAmountInAuthznCrcy" )
    @JsonProperty( "AuthorizedAmountInAuthznCrcy" )
    @Nullable
    @ODataField( odataName = "AuthorizedAmountInAuthznCrcy" )
    private BigDecimal authorizedAmountInAuthznCrcy;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizedAmountInAuthznCrcy</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<BigDecimal> AUTHORIZED_AMOUNT_IN_AUTHZN_CRCY =
        new SlsOrdPaymentPlanItemDetailsField<BigDecimal>("AuthorizedAmountInAuthznCrcy");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationCurrency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "AuthorizationCurrency" )
    @JsonProperty( "AuthorizationCurrency" )
    @Nullable
    @ODataField( odataName = "AuthorizationCurrency" )
    private String authorizationCurrency;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationCurrency</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> AUTHORIZATION_CURRENCY =
        new SlsOrdPaymentPlanItemDetailsField<String>("AuthorizationCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationByDigitalPaytSrvc</b>
     * </p>
     *
     * @return Electronic Payment: Authorization Number
     */
    @SerializedName( "AuthorizationByDigitalPaytSrvc" )
    @JsonProperty( "AuthorizationByDigitalPaytSrvc" )
    @Nullable
    @ODataField( odataName = "AuthorizationByDigitalPaytSrvc" )
    private String authorizationByDigitalPaytSrvc;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationByDigitalPaytSrvc</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> AUTHORIZATION_BY_DIGITAL_PAYT_SRVC =
        new SlsOrdPaymentPlanItemDetailsField<String>("AuthorizationByDigitalPaytSrvc");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationByAcquirer</b>
     * </p>
     *
     * @return Electronic Payment: Authorization Reference Code
     */
    @SerializedName( "AuthorizationByAcquirer" )
    @JsonProperty( "AuthorizationByAcquirer" )
    @Nullable
    @ODataField( odataName = "AuthorizationByAcquirer" )
    private String authorizationByAcquirer;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationByAcquirer</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> AUTHORIZATION_BY_ACQUIRER =
        new SlsOrdPaymentPlanItemDetailsField<String>("AuthorizationByAcquirer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationDate</b>
     * </p>
     *
     * @return Electronic Payment: Authorization Date
     */
    @SerializedName( "AuthorizationDate" )
    @JsonProperty( "AuthorizationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "AuthorizationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime authorizationDate;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationDate</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<LocalDateTime> AUTHORIZATION_DATE =
        new SlsOrdPaymentPlanItemDetailsField<LocalDateTime>("AuthorizationDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationTime</b>
     * </p>
     *
     * @return Electronic Payment: Authorization Time
     */
    @SerializedName( "AuthorizationTime" )
    @JsonProperty( "AuthorizationTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "AuthorizationTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime authorizationTime;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationTime</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<LocalTime> AUTHORIZATION_TIME =
        new SlsOrdPaymentPlanItemDetailsField<LocalTime>("AuthorizationTime");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationStatusName</b>
     * </p>
     *
     * @return Payment cards: Result text
     */
    @SerializedName( "AuthorizationStatusName" )
    @JsonProperty( "AuthorizationStatusName" )
    @Nullable
    @ODataField( odataName = "AuthorizationStatusName" )
    private String authorizationStatusName;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationStatusName</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> AUTHORIZATION_STATUS_NAME =
        new SlsOrdPaymentPlanItemDetailsField<String>("AuthorizationStatusName");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>EPaytByDigitalPaymentSrvc</b>
     * </p>
     *
     * @return Token for Digital Payment Integration in SD
     */
    @SerializedName( "EPaytByDigitalPaymentSrvc" )
    @JsonProperty( "EPaytByDigitalPaymentSrvc" )
    @Nullable
    @ODataField( odataName = "EPaytByDigitalPaymentSrvc" )
    private String ePaytByDigitalPaymentSrvc;
    /**
     * Use with available fluent helpers to apply the <b>EPaytByDigitalPaymentSrvc</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> E_PAYT_BY_DIGITAL_PAYMENT_SRVC =
        new SlsOrdPaymentPlanItemDetailsField<String>("EPaytByDigitalPaymentSrvc");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicPaymentCallStatus</b>
     * </p>
     *
     * @return Electronic Payment: Call Status
     */
    @SerializedName( "ElectronicPaymentCallStatus" )
    @JsonProperty( "ElectronicPaymentCallStatus" )
    @Nullable
    @ODataField( odataName = "ElectronicPaymentCallStatus" )
    private String electronicPaymentCallStatus;
    /**
     * Use with available fluent helpers to apply the <b>ElectronicPaymentCallStatus</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> ELECTRONIC_PAYMENT_CALL_STATUS =
        new SlsOrdPaymentPlanItemDetailsField<String>("ElectronicPaymentCallStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EPaytAuthorizationResult</b>
     * </p>
     *
     * @return Electronic Payment: Response to Authorization Checks
     */
    @SerializedName( "EPaytAuthorizationResult" )
    @JsonProperty( "EPaytAuthorizationResult" )
    @Nullable
    @ODataField( odataName = "EPaytAuthorizationResult" )
    private String ePaytAuthorizationResult;
    /**
     * Use with available fluent helpers to apply the <b>EPaytAuthorizationResult</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> E_PAYT_AUTHORIZATION_RESULT =
        new SlsOrdPaymentPlanItemDetailsField<String>("EPaytAuthorizationResult");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EPaytToBeAuthorizedAmount</b>
     * </p>
     *
     * @return Electronic Payment: Amount to Be Authorized
     */
    @SerializedName( "EPaytToBeAuthorizedAmount" )
    @JsonProperty( "EPaytToBeAuthorizedAmount" )
    @Nullable
    @ODataField( odataName = "EPaytToBeAuthorizedAmount" )
    private BigDecimal ePaytToBeAuthorizedAmount;
    /**
     * Use with available fluent helpers to apply the <b>EPaytToBeAuthorizedAmount</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<BigDecimal> E_PAYT_TO_BE_AUTHORIZED_AMOUNT =
        new SlsOrdPaymentPlanItemDetailsField<BigDecimal>("EPaytToBeAuthorizedAmount");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EPaytAuthorizationIsExpired</b>
     * </p>
     *
     * @return Electronic Payment: Authorization Expired
     */
    @SerializedName( "EPaytAuthorizationIsExpired" )
    @JsonProperty( "EPaytAuthorizationIsExpired" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EPaytAuthorizationIsExpired" )
    private Boolean ePaytAuthorizationIsExpired;
    /**
     * Use with available fluent helpers to apply the <b>EPaytAuthorizationIsExpired</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<Boolean> E_PAYT_AUTHORIZATION_IS_EXPIRED =
        new SlsOrdPaymentPlanItemDetailsField<Boolean>("EPaytAuthorizationIsExpired");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EPaytAmountIsChanged</b>
     * </p>
     *
     * @return Electronic Payment: Amount Changed
     */
    @SerializedName( "EPaytAmountIsChanged" )
    @JsonProperty( "EPaytAmountIsChanged" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EPaytAmountIsChanged" )
    private Boolean ePaytAmountIsChanged;
    /**
     * Use with available fluent helpers to apply the <b>EPaytAmountIsChanged</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<Boolean> E_PAYT_AMOUNT_IS_CHANGED =
        new SlsOrdPaymentPlanItemDetailsField<Boolean>("EPaytAmountIsChanged");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PreauthorizationIsRequested</b>
     * </p>
     *
     * @return Electronic Payment: Preauthorization
     */
    @SerializedName( "PreauthorizationIsRequested" )
    @JsonProperty( "PreauthorizationIsRequested" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "PreauthorizationIsRequested" )
    private Boolean preauthorizationIsRequested;
    /**
     * Use with available fluent helpers to apply the <b>PreauthorizationIsRequested</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<Boolean> PREAUTHORIZATION_IS_REQUESTED =
        new SlsOrdPaymentPlanItemDetailsField<Boolean>("PreauthorizationIsRequested");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentServiceProvider</b>
     * </p>
     *
     * @return Payment Service Provider for Digital Payments
     */
    @SerializedName( "PaymentServiceProvider" )
    @JsonProperty( "PaymentServiceProvider" )
    @Nullable
    @ODataField( odataName = "PaymentServiceProvider" )
    private String paymentServiceProvider;
    /**
     * Use with available fluent helpers to apply the <b>PaymentServiceProvider</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> PAYMENT_SERVICE_PROVIDER =
        new SlsOrdPaymentPlanItemDetailsField<String>("PaymentServiceProvider");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PaymentByPaymentServicePrvdr</b>
     * </p>
     *
     * @return Digital Payments: Payment ID from Payment Service Provider
     */
    @SerializedName( "PaymentByPaymentServicePrvdr" )
    @JsonProperty( "PaymentByPaymentServicePrvdr" )
    @Nullable
    @ODataField( odataName = "PaymentByPaymentServicePrvdr" )
    private String paymentByPaymentServicePrvdr;
    /**
     * Use with available fluent helpers to apply the <b>PaymentByPaymentServicePrvdr</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> PAYMENT_BY_PAYMENT_SERVICE_PRVDR =
        new SlsOrdPaymentPlanItemDetailsField<String>("PaymentByPaymentServicePrvdr");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TransactionByPaytSrvcPrvdr</b>
     * </p>
     *
     * @return SAP Digital Payments: Transaction ID of PSP
     */
    @SerializedName( "TransactionByPaytSrvcPrvdr" )
    @JsonProperty( "TransactionByPaytSrvcPrvdr" )
    @Nullable
    @ODataField( odataName = "TransactionByPaytSrvcPrvdr" )
    private String transactionByPaytSrvcPrvdr;
    /**
     * Use with available fluent helpers to apply the <b>TransactionByPaytSrvcPrvdr</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> TRANSACTION_BY_PAYT_SRVC_PRVDR =
        new SlsOrdPaymentPlanItemDetailsField<String>("TransactionByPaytSrvcPrvdr");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>MerchantByClearingHouse</b>
     * </p>
     *
     * @return Electronic Payment: Merchant ID at Clearing House
     */
    @SerializedName( "MerchantByClearingHouse" )
    @JsonProperty( "MerchantByClearingHouse" )
    @Nullable
    @ODataField( odataName = "MerchantByClearingHouse" )
    private String merchantByClearingHouse;
    /**
     * Use with available fluent helpers to apply the <b>MerchantByClearingHouse</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> MERCHANT_BY_CLEARING_HOUSE =
        new SlsOrdPaymentPlanItemDetailsField<String>("MerchantByClearingHouse");
    /**
     * Constraints: Not nullable, Maximum length: 44
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardAuthznRelationID</b>
     * </p>
     *
     * @return Unique identifier of a previous successful authorization
     */
    @SerializedName( "PaymentCardAuthznRelationID" )
    @JsonProperty( "PaymentCardAuthznRelationID" )
    @Nullable
    @ODataField( odataName = "PaymentCardAuthznRelationID" )
    private String paymentCardAuthznRelationID;
    /**
     * Use with available fluent helpers to apply the <b>PaymentCardAuthznRelationID</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> PAYMENT_CARD_AUTHZN_RELATION_ID =
        new SlsOrdPaymentPlanItemDetailsField<String>("PaymentCardAuthznRelationID");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumToBeAuthorizedAmount</b>
     * </p>
     *
     * @return Value to be billed/calc. on date in billing/invoice plan
     */
    @SerializedName( "MaximumToBeAuthorizedAmount" )
    @JsonProperty( "MaximumToBeAuthorizedAmount" )
    @Nullable
    @ODataField( odataName = "MaximumToBeAuthorizedAmount" )
    private BigDecimal maximumToBeAuthorizedAmount;
    /**
     * Use with available fluent helpers to apply the <b>MaximumToBeAuthorizedAmount</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<BigDecimal> MAXIMUM_TO_BE_AUTHORIZED_AMOUNT =
        new SlsOrdPaymentPlanItemDetailsField<BigDecimal>("MaximumToBeAuthorizedAmount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaytPlnForAuthorizationItem</b>
     * </p>
     *
     * @return Higher-level payment card plan number for billing
     */
    @SerializedName( "PaytPlnForAuthorizationItem" )
    @JsonProperty( "PaytPlnForAuthorizationItem" )
    @Nullable
    @ODataField( odataName = "PaytPlnForAuthorizationItem" )
    private String paytPlnForAuthorizationItem;
    /**
     * Use with available fluent helpers to apply the <b>PaytPlnForAuthorizationItem</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> PAYT_PLN_FOR_AUTHORIZATION_ITEM =
        new SlsOrdPaymentPlanItemDetailsField<String>("PaytPlnForAuthorizationItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PaytPlnItmForAuthorizationItem</b>
     * </p>
     *
     * @return Higher-level item in billing plan
     */
    @SerializedName( "PaytPlnItmForAuthorizationItem" )
    @JsonProperty( "PaytPlnItmForAuthorizationItem" )
    @Nullable
    @ODataField( odataName = "PaytPlnItmForAuthorizationItem" )
    private String paytPlnItmForAuthorizationItem;
    /**
     * Use with available fluent helpers to apply the <b>PaytPlnItmForAuthorizationItem</b> field to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsField<String> PAYT_PLN_ITM_FOR_AUTHORIZATION_ITEM =
        new SlsOrdPaymentPlanItemDetailsField<String>("PaytPlnItmForAuthorizationItem");
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>SlsOrdPaymentPlanItemDetails</b> to single <b>SalesOrder</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrder toSalesOrder;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static SlsOrdPaymentPlanItemDetailsOneToOneLink<SalesOrder> TO_SALES_ORDER =
        new SlsOrdPaymentPlanItemDetailsOneToOneLink<SalesOrder>("to_SalesOrder");

    @Nonnull
    @Override
    public Class<SlsOrdPaymentPlanItemDetails> getType()
    {
        return SlsOrdPaymentPlanItemDetails.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PaymentPlanItem</b>
     * </p>
     *
     * @param paymentPlanItem
     *            Item for billing plan/invoice plan/payment cards
     */
    public void setPaymentPlanItem( @Nullable final String paymentPlanItem )
    {
        rememberChangedField("PaymentPlanItem", this.paymentPlanItem);
        this.paymentPlanItem = paymentPlanItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaymentPlan</b>
     * </p>
     *
     * @param paymentPlan
     *            Billing Plan Number / Invoicing Plan Number
     */
    public void setPaymentPlan( @Nullable final String paymentPlan )
    {
        rememberChangedField("PaymentPlan", this.paymentPlan);
        this.paymentPlan = paymentPlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicPaymentType</b>
     * </p>
     *
     * @param electronicPaymentType
     *            Electronic Payment: Payment Type
     */
    public void setElectronicPaymentType( @Nullable final String electronicPaymentType )
    {
        rememberChangedField("ElectronicPaymentType", this.electronicPaymentType);
        this.electronicPaymentType = electronicPaymentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicPayment</b>
     * </p>
     *
     * @param electronicPayment
     *            Electronic Payment: Account Number
     */
    public void setElectronicPayment( @Nullable final String electronicPayment )
    {
        rememberChangedField("ElectronicPayment", this.electronicPayment);
        this.electronicPayment = electronicPayment;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EPaytValidityStartDate</b>
     * </p>
     *
     * @param ePaytValidityStartDate
     *            Electronic Payment: Valid from
     */
    public void setEPaytValidityStartDate( @Nullable final LocalDateTime ePaytValidityStartDate )
    {
        rememberChangedField("EPaytValidityStartDate", this.ePaytValidityStartDate);
        this.ePaytValidityStartDate = ePaytValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EPaytValidityEndDate</b>
     * </p>
     *
     * @param ePaytValidityEndDate
     *            Electronic Payment: Valid to
     */
    public void setEPaytValidityEndDate( @Nullable final LocalDateTime ePaytValidityEndDate )
    {
        rememberChangedField("EPaytValidityEndDate", this.ePaytValidityEndDate);
        this.ePaytValidityEndDate = ePaytValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicPaymentHolderName</b>
     * </p>
     *
     * @param electronicPaymentHolderName
     *            Electronic Payment: Name of Account Holder
     */
    public void setElectronicPaymentHolderName( @Nullable final String electronicPaymentHolderName )
    {
        rememberChangedField("ElectronicPaymentHolderName", this.electronicPaymentHolderName);
        this.electronicPaymentHolderName = electronicPaymentHolderName;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizedAmountInAuthznCrcy</b>
     * </p>
     *
     * @param authorizedAmountInAuthznCrcy
     *            Electronic Payment: Authorized Amount
     */
    public void setAuthorizedAmountInAuthznCrcy( @Nullable final BigDecimal authorizedAmountInAuthznCrcy )
    {
        rememberChangedField("AuthorizedAmountInAuthznCrcy", this.authorizedAmountInAuthznCrcy);
        this.authorizedAmountInAuthznCrcy = authorizedAmountInAuthznCrcy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationCurrency</b>
     * </p>
     *
     * @param authorizationCurrency
     *            Currency Key
     */
    public void setAuthorizationCurrency( @Nullable final String authorizationCurrency )
    {
        rememberChangedField("AuthorizationCurrency", this.authorizationCurrency);
        this.authorizationCurrency = authorizationCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationByDigitalPaytSrvc</b>
     * </p>
     *
     * @param authorizationByDigitalPaytSrvc
     *            Electronic Payment: Authorization Number
     */
    public void setAuthorizationByDigitalPaytSrvc( @Nullable final String authorizationByDigitalPaytSrvc )
    {
        rememberChangedField("AuthorizationByDigitalPaytSrvc", this.authorizationByDigitalPaytSrvc);
        this.authorizationByDigitalPaytSrvc = authorizationByDigitalPaytSrvc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationByAcquirer</b>
     * </p>
     *
     * @param authorizationByAcquirer
     *            Electronic Payment: Authorization Reference Code
     */
    public void setAuthorizationByAcquirer( @Nullable final String authorizationByAcquirer )
    {
        rememberChangedField("AuthorizationByAcquirer", this.authorizationByAcquirer);
        this.authorizationByAcquirer = authorizationByAcquirer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationDate</b>
     * </p>
     *
     * @param authorizationDate
     *            Electronic Payment: Authorization Date
     */
    public void setAuthorizationDate( @Nullable final LocalDateTime authorizationDate )
    {
        rememberChangedField("AuthorizationDate", this.authorizationDate);
        this.authorizationDate = authorizationDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationTime</b>
     * </p>
     *
     * @param authorizationTime
     *            Electronic Payment: Authorization Time
     */
    public void setAuthorizationTime( @Nullable final LocalTime authorizationTime )
    {
        rememberChangedField("AuthorizationTime", this.authorizationTime);
        this.authorizationTime = authorizationTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationStatusName</b>
     * </p>
     *
     * @param authorizationStatusName
     *            Payment cards: Result text
     */
    public void setAuthorizationStatusName( @Nullable final String authorizationStatusName )
    {
        rememberChangedField("AuthorizationStatusName", this.authorizationStatusName);
        this.authorizationStatusName = authorizationStatusName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>EPaytByDigitalPaymentSrvc</b>
     * </p>
     *
     * @param ePaytByDigitalPaymentSrvc
     *            Token for Digital Payment Integration in SD
     */
    public void setEPaytByDigitalPaymentSrvc( @Nullable final String ePaytByDigitalPaymentSrvc )
    {
        rememberChangedField("EPaytByDigitalPaymentSrvc", this.ePaytByDigitalPaymentSrvc);
        this.ePaytByDigitalPaymentSrvc = ePaytByDigitalPaymentSrvc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ElectronicPaymentCallStatus</b>
     * </p>
     *
     * @param electronicPaymentCallStatus
     *            Electronic Payment: Call Status
     */
    public void setElectronicPaymentCallStatus( @Nullable final String electronicPaymentCallStatus )
    {
        rememberChangedField("ElectronicPaymentCallStatus", this.electronicPaymentCallStatus);
        this.electronicPaymentCallStatus = electronicPaymentCallStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>EPaytAuthorizationResult</b>
     * </p>
     *
     * @param ePaytAuthorizationResult
     *            Electronic Payment: Response to Authorization Checks
     */
    public void setEPaytAuthorizationResult( @Nullable final String ePaytAuthorizationResult )
    {
        rememberChangedField("EPaytAuthorizationResult", this.ePaytAuthorizationResult);
        this.ePaytAuthorizationResult = ePaytAuthorizationResult;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EPaytToBeAuthorizedAmount</b>
     * </p>
     *
     * @param ePaytToBeAuthorizedAmount
     *            Electronic Payment: Amount to Be Authorized
     */
    public void setEPaytToBeAuthorizedAmount( @Nullable final BigDecimal ePaytToBeAuthorizedAmount )
    {
        rememberChangedField("EPaytToBeAuthorizedAmount", this.ePaytToBeAuthorizedAmount);
        this.ePaytToBeAuthorizedAmount = ePaytToBeAuthorizedAmount;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EPaytAuthorizationIsExpired</b>
     * </p>
     *
     * @param ePaytAuthorizationIsExpired
     *            Electronic Payment: Authorization Expired
     */
    public void setEPaytAuthorizationIsExpired( @Nullable final Boolean ePaytAuthorizationIsExpired )
    {
        rememberChangedField("EPaytAuthorizationIsExpired", this.ePaytAuthorizationIsExpired);
        this.ePaytAuthorizationIsExpired = ePaytAuthorizationIsExpired;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EPaytAmountIsChanged</b>
     * </p>
     *
     * @param ePaytAmountIsChanged
     *            Electronic Payment: Amount Changed
     */
    public void setEPaytAmountIsChanged( @Nullable final Boolean ePaytAmountIsChanged )
    {
        rememberChangedField("EPaytAmountIsChanged", this.ePaytAmountIsChanged);
        this.ePaytAmountIsChanged = ePaytAmountIsChanged;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>PreauthorizationIsRequested</b>
     * </p>
     *
     * @param preauthorizationIsRequested
     *            Electronic Payment: Preauthorization
     */
    public void setPreauthorizationIsRequested( @Nullable final Boolean preauthorizationIsRequested )
    {
        rememberChangedField("PreauthorizationIsRequested", this.preauthorizationIsRequested);
        this.preauthorizationIsRequested = preauthorizationIsRequested;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>PaymentServiceProvider</b>
     * </p>
     *
     * @param paymentServiceProvider
     *            Payment Service Provider for Digital Payments
     */
    public void setPaymentServiceProvider( @Nullable final String paymentServiceProvider )
    {
        rememberChangedField("PaymentServiceProvider", this.paymentServiceProvider);
        this.paymentServiceProvider = paymentServiceProvider;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PaymentByPaymentServicePrvdr</b>
     * </p>
     *
     * @param paymentByPaymentServicePrvdr
     *            Digital Payments: Payment ID from Payment Service Provider
     */
    public void setPaymentByPaymentServicePrvdr( @Nullable final String paymentByPaymentServicePrvdr )
    {
        rememberChangedField("PaymentByPaymentServicePrvdr", this.paymentByPaymentServicePrvdr);
        this.paymentByPaymentServicePrvdr = paymentByPaymentServicePrvdr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TransactionByPaytSrvcPrvdr</b>
     * </p>
     *
     * @param transactionByPaytSrvcPrvdr
     *            SAP Digital Payments: Transaction ID of PSP
     */
    public void setTransactionByPaytSrvcPrvdr( @Nullable final String transactionByPaytSrvcPrvdr )
    {
        rememberChangedField("TransactionByPaytSrvcPrvdr", this.transactionByPaytSrvcPrvdr);
        this.transactionByPaytSrvcPrvdr = transactionByPaytSrvcPrvdr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>MerchantByClearingHouse</b>
     * </p>
     *
     * @param merchantByClearingHouse
     *            Electronic Payment: Merchant ID at Clearing House
     */
    public void setMerchantByClearingHouse( @Nullable final String merchantByClearingHouse )
    {
        rememberChangedField("MerchantByClearingHouse", this.merchantByClearingHouse);
        this.merchantByClearingHouse = merchantByClearingHouse;
    }

    /**
     * Constraints: Not nullable, Maximum length: 44
     * <p>
     * Original property name from the Odata EDM: <b>PaymentCardAuthznRelationID</b>
     * </p>
     *
     * @param paymentCardAuthznRelationID
     *            Unique identifier of a previous successful authorization
     */
    public void setPaymentCardAuthznRelationID( @Nullable final String paymentCardAuthznRelationID )
    {
        rememberChangedField("PaymentCardAuthznRelationID", this.paymentCardAuthznRelationID);
        this.paymentCardAuthznRelationID = paymentCardAuthznRelationID;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>MaximumToBeAuthorizedAmount</b>
     * </p>
     *
     * @param maximumToBeAuthorizedAmount
     *            Value to be billed/calc. on date in billing/invoice plan
     */
    public void setMaximumToBeAuthorizedAmount( @Nullable final BigDecimal maximumToBeAuthorizedAmount )
    {
        rememberChangedField("MaximumToBeAuthorizedAmount", this.maximumToBeAuthorizedAmount);
        this.maximumToBeAuthorizedAmount = maximumToBeAuthorizedAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PaytPlnForAuthorizationItem</b>
     * </p>
     *
     * @param paytPlnForAuthorizationItem
     *            Higher-level payment card plan number for billing
     */
    public void setPaytPlnForAuthorizationItem( @Nullable final String paytPlnForAuthorizationItem )
    {
        rememberChangedField("PaytPlnForAuthorizationItem", this.paytPlnForAuthorizationItem);
        this.paytPlnForAuthorizationItem = paytPlnForAuthorizationItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>PaytPlnItmForAuthorizationItem</b>
     * </p>
     *
     * @param paytPlnItmForAuthorizationItem
     *            Higher-level item in billing plan
     */
    public void setPaytPlnItmForAuthorizationItem( @Nullable final String paytPlnItmForAuthorizationItem )
    {
        rememberChangedField("PaytPlnItmForAuthorizationItem", this.paytPlnItmForAuthorizationItem);
        this.paytPlnItmForAuthorizationItem = paytPlnItmForAuthorizationItem;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsOrdPaymentPlanItemDetails";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        result.put("PaymentPlanItem", getPaymentPlanItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("PaymentPlanItem", getPaymentPlanItem());
        values.put("PaymentPlan", getPaymentPlan());
        values.put("ElectronicPaymentType", getElectronicPaymentType());
        values.put("ElectronicPayment", getElectronicPayment());
        values.put("EPaytValidityStartDate", getEPaytValidityStartDate());
        values.put("EPaytValidityEndDate", getEPaytValidityEndDate());
        values.put("ElectronicPaymentHolderName", getElectronicPaymentHolderName());
        values.put("AuthorizedAmountInAuthznCrcy", getAuthorizedAmountInAuthznCrcy());
        values.put("AuthorizationCurrency", getAuthorizationCurrency());
        values.put("AuthorizationByDigitalPaytSrvc", getAuthorizationByDigitalPaytSrvc());
        values.put("AuthorizationByAcquirer", getAuthorizationByAcquirer());
        values.put("AuthorizationDate", getAuthorizationDate());
        values.put("AuthorizationTime", getAuthorizationTime());
        values.put("AuthorizationStatusName", getAuthorizationStatusName());
        values.put("EPaytByDigitalPaymentSrvc", getEPaytByDigitalPaymentSrvc());
        values.put("ElectronicPaymentCallStatus", getElectronicPaymentCallStatus());
        values.put("EPaytAuthorizationResult", getEPaytAuthorizationResult());
        values.put("EPaytToBeAuthorizedAmount", getEPaytToBeAuthorizedAmount());
        values.put("EPaytAuthorizationIsExpired", getEPaytAuthorizationIsExpired());
        values.put("EPaytAmountIsChanged", getEPaytAmountIsChanged());
        values.put("PreauthorizationIsRequested", getPreauthorizationIsRequested());
        values.put("PaymentServiceProvider", getPaymentServiceProvider());
        values.put("PaymentByPaymentServicePrvdr", getPaymentByPaymentServicePrvdr());
        values.put("TransactionByPaytSrvcPrvdr", getTransactionByPaytSrvcPrvdr());
        values.put("MerchantByClearingHouse", getMerchantByClearingHouse());
        values.put("PaymentCardAuthznRelationID", getPaymentCardAuthznRelationID());
        values.put("MaximumToBeAuthorizedAmount", getMaximumToBeAuthorizedAmount());
        values.put("PaytPlnForAuthorizationItem", getPaytPlnForAuthorizationItem());
        values.put("PaytPlnItmForAuthorizationItem", getPaytPlnItmForAuthorizationItem());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("PaymentPlanItem") ) {
                final Object value = values.remove("PaymentPlanItem");
                if( (value == null) || (!value.equals(getPaymentPlanItem())) ) {
                    setPaymentPlanItem(((String) value));
                }
            }
            if( values.containsKey("PaymentPlan") ) {
                final Object value = values.remove("PaymentPlan");
                if( (value == null) || (!value.equals(getPaymentPlan())) ) {
                    setPaymentPlan(((String) value));
                }
            }
            if( values.containsKey("ElectronicPaymentType") ) {
                final Object value = values.remove("ElectronicPaymentType");
                if( (value == null) || (!value.equals(getElectronicPaymentType())) ) {
                    setElectronicPaymentType(((String) value));
                }
            }
            if( values.containsKey("ElectronicPayment") ) {
                final Object value = values.remove("ElectronicPayment");
                if( (value == null) || (!value.equals(getElectronicPayment())) ) {
                    setElectronicPayment(((String) value));
                }
            }
            if( values.containsKey("EPaytValidityStartDate") ) {
                final Object value = values.remove("EPaytValidityStartDate");
                if( (value == null) || (!value.equals(getEPaytValidityStartDate())) ) {
                    setEPaytValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EPaytValidityEndDate") ) {
                final Object value = values.remove("EPaytValidityEndDate");
                if( (value == null) || (!value.equals(getEPaytValidityEndDate())) ) {
                    setEPaytValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ElectronicPaymentHolderName") ) {
                final Object value = values.remove("ElectronicPaymentHolderName");
                if( (value == null) || (!value.equals(getElectronicPaymentHolderName())) ) {
                    setElectronicPaymentHolderName(((String) value));
                }
            }
            if( values.containsKey("AuthorizedAmountInAuthznCrcy") ) {
                final Object value = values.remove("AuthorizedAmountInAuthznCrcy");
                if( (value == null) || (!value.equals(getAuthorizedAmountInAuthznCrcy())) ) {
                    setAuthorizedAmountInAuthznCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("AuthorizationCurrency") ) {
                final Object value = values.remove("AuthorizationCurrency");
                if( (value == null) || (!value.equals(getAuthorizationCurrency())) ) {
                    setAuthorizationCurrency(((String) value));
                }
            }
            if( values.containsKey("AuthorizationByDigitalPaytSrvc") ) {
                final Object value = values.remove("AuthorizationByDigitalPaytSrvc");
                if( (value == null) || (!value.equals(getAuthorizationByDigitalPaytSrvc())) ) {
                    setAuthorizationByDigitalPaytSrvc(((String) value));
                }
            }
            if( values.containsKey("AuthorizationByAcquirer") ) {
                final Object value = values.remove("AuthorizationByAcquirer");
                if( (value == null) || (!value.equals(getAuthorizationByAcquirer())) ) {
                    setAuthorizationByAcquirer(((String) value));
                }
            }
            if( values.containsKey("AuthorizationDate") ) {
                final Object value = values.remove("AuthorizationDate");
                if( (value == null) || (!value.equals(getAuthorizationDate())) ) {
                    setAuthorizationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AuthorizationTime") ) {
                final Object value = values.remove("AuthorizationTime");
                if( (value == null) || (!value.equals(getAuthorizationTime())) ) {
                    setAuthorizationTime(((LocalTime) value));
                }
            }
            if( values.containsKey("AuthorizationStatusName") ) {
                final Object value = values.remove("AuthorizationStatusName");
                if( (value == null) || (!value.equals(getAuthorizationStatusName())) ) {
                    setAuthorizationStatusName(((String) value));
                }
            }
            if( values.containsKey("EPaytByDigitalPaymentSrvc") ) {
                final Object value = values.remove("EPaytByDigitalPaymentSrvc");
                if( (value == null) || (!value.equals(getEPaytByDigitalPaymentSrvc())) ) {
                    setEPaytByDigitalPaymentSrvc(((String) value));
                }
            }
            if( values.containsKey("ElectronicPaymentCallStatus") ) {
                final Object value = values.remove("ElectronicPaymentCallStatus");
                if( (value == null) || (!value.equals(getElectronicPaymentCallStatus())) ) {
                    setElectronicPaymentCallStatus(((String) value));
                }
            }
            if( values.containsKey("EPaytAuthorizationResult") ) {
                final Object value = values.remove("EPaytAuthorizationResult");
                if( (value == null) || (!value.equals(getEPaytAuthorizationResult())) ) {
                    setEPaytAuthorizationResult(((String) value));
                }
            }
            if( values.containsKey("EPaytToBeAuthorizedAmount") ) {
                final Object value = values.remove("EPaytToBeAuthorizedAmount");
                if( (value == null) || (!value.equals(getEPaytToBeAuthorizedAmount())) ) {
                    setEPaytToBeAuthorizedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("EPaytAuthorizationIsExpired") ) {
                final Object value = values.remove("EPaytAuthorizationIsExpired");
                if( (value == null) || (!value.equals(getEPaytAuthorizationIsExpired())) ) {
                    setEPaytAuthorizationIsExpired(((Boolean) value));
                }
            }
            if( values.containsKey("EPaytAmountIsChanged") ) {
                final Object value = values.remove("EPaytAmountIsChanged");
                if( (value == null) || (!value.equals(getEPaytAmountIsChanged())) ) {
                    setEPaytAmountIsChanged(((Boolean) value));
                }
            }
            if( values.containsKey("PreauthorizationIsRequested") ) {
                final Object value = values.remove("PreauthorizationIsRequested");
                if( (value == null) || (!value.equals(getPreauthorizationIsRequested())) ) {
                    setPreauthorizationIsRequested(((Boolean) value));
                }
            }
            if( values.containsKey("PaymentServiceProvider") ) {
                final Object value = values.remove("PaymentServiceProvider");
                if( (value == null) || (!value.equals(getPaymentServiceProvider())) ) {
                    setPaymentServiceProvider(((String) value));
                }
            }
            if( values.containsKey("PaymentByPaymentServicePrvdr") ) {
                final Object value = values.remove("PaymentByPaymentServicePrvdr");
                if( (value == null) || (!value.equals(getPaymentByPaymentServicePrvdr())) ) {
                    setPaymentByPaymentServicePrvdr(((String) value));
                }
            }
            if( values.containsKey("TransactionByPaytSrvcPrvdr") ) {
                final Object value = values.remove("TransactionByPaytSrvcPrvdr");
                if( (value == null) || (!value.equals(getTransactionByPaytSrvcPrvdr())) ) {
                    setTransactionByPaytSrvcPrvdr(((String) value));
                }
            }
            if( values.containsKey("MerchantByClearingHouse") ) {
                final Object value = values.remove("MerchantByClearingHouse");
                if( (value == null) || (!value.equals(getMerchantByClearingHouse())) ) {
                    setMerchantByClearingHouse(((String) value));
                }
            }
            if( values.containsKey("PaymentCardAuthznRelationID") ) {
                final Object value = values.remove("PaymentCardAuthznRelationID");
                if( (value == null) || (!value.equals(getPaymentCardAuthznRelationID())) ) {
                    setPaymentCardAuthznRelationID(((String) value));
                }
            }
            if( values.containsKey("MaximumToBeAuthorizedAmount") ) {
                final Object value = values.remove("MaximumToBeAuthorizedAmount");
                if( (value == null) || (!value.equals(getMaximumToBeAuthorizedAmount())) ) {
                    setMaximumToBeAuthorizedAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("PaytPlnForAuthorizationItem") ) {
                final Object value = values.remove("PaytPlnForAuthorizationItem");
                if( (value == null) || (!value.equals(getPaytPlnForAuthorizationItem())) ) {
                    setPaytPlnForAuthorizationItem(((String) value));
                }
            }
            if( values.containsKey("PaytPlnItmForAuthorizationItem") ) {
                final Object value = values.remove("PaytPlnItmForAuthorizationItem");
                if( (value == null) || (!value.equals(getPaytPlnItmForAuthorizationItem())) ) {
                    setPaytPlnItmForAuthorizationItem(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Map ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = new SalesOrder();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrder.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SlsOrdPaymentPlanItemDetailsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SlsOrdPaymentPlanItemDetailsField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsOrdPaymentPlanItemDetailsField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsOrdPaymentPlanItemDetailsField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrder</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrder</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder fetchSalesOrder()
    {
        return fetchFieldAsSingle("to_SalesOrder", SalesOrder.class);
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>SlsOrdPaymentPlanItemDetails</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrder</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrder getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>SalesOrder</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>SlsOrdPaymentPlanItemDetails</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>SalesOrder</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<SalesOrder> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the associated <b>SalesOrder</b> entity for the loaded navigation property <b>to_SalesOrder</b>.
     *
     * @param value
     *            New <b>SalesOrder</b> entity.
     */
    public void setSalesOrder( final SalesOrder value )
    {
        toSalesOrder = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsOrdPaymentPlanItemDetails instances.
     *
     */
    public final static class SlsOrdPaymentPlanItemDetailsBuilder
    {

        private SalesOrder toSalesOrder;
        private String salesOrder = null;

        private SlsOrdPaymentPlanItemDetails.SlsOrdPaymentPlanItemDetailsBuilder toSalesOrder( final SalesOrder value )
        {
            toSalesOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>SlsOrdPaymentPlanItemDetails</b> to single <b>SalesOrder</b>.
         *
         * @param value
         *            The SalesOrder to build this SlsOrdPaymentPlanItemDetails with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdPaymentPlanItemDetails.SlsOrdPaymentPlanItemDetailsBuilder salesOrder( final SalesOrder value )
        {
            return toSalesOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrder</b>
         * </p>
         *
         * @param value
         *            The salesOrder to build this SlsOrdPaymentPlanItemDetails with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdPaymentPlanItemDetails.SlsOrdPaymentPlanItemDetailsBuilder salesOrder( final String value )
        {
            salesOrder = value;
            return this;
        }

    }

}
