/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable.SlsOrdPaymentPlanItemDetailsSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
 * SlsOrdPaymentPlanItemDetails} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SlsOrdPaymentPlanItemDetailsByKeyFluentHelper
    extends
    FluentHelperByKey<SlsOrdPaymentPlanItemDetailsByKeyFluentHelper, SlsOrdPaymentPlanItemDetails, SlsOrdPaymentPlanItemDetailsSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     * SlsOrdPaymentPlanItemDetails} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SlsOrdPaymentPlanItemDetails}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SlsOrdPaymentPlanItemDetails}
     * @param paymentPlanItem
     *            Item for billing plan/invoice plan/payment cards
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param salesOrder
     *            Sales Order
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public SlsOrdPaymentPlanItemDetailsByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesOrder,
        final String paymentPlanItem )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesOrder", salesOrder);
        this.key.put("PaymentPlanItem", paymentPlanItem);
    }

    @Override
    @Nonnull
    protected Class<SlsOrdPaymentPlanItemDetails> getEntityClass()
    {
        return SlsOrdPaymentPlanItemDetails.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
