/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SalesOrderServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService SalesOrderService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSalesOrderServiceBatch
    extends
    BatchFluentHelperBasic<SalesOrderServiceBatch, SalesOrderServiceBatchChangeSet>
    implements
    SalesOrderServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSalesOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSalesOrderServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesOrderServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSalesOrderServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSalesOrderServiceBatchChangeSet(this, service);
    }

}
