/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem;

/**
 * Implementation of the {@link SalesOrderServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService SalesOrderService}.
 *
 */
public class DefaultSalesOrderServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesOrderServiceBatch, SalesOrderServiceBatchChangeSet>
    implements
    SalesOrderServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesOrderServiceBatchChangeSet(
        @Nonnull final DefaultSalesOrderServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesOrderServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrder( @Nonnull final SalesOrder salesOrder )
    {
        return addRequestCreate(service::createSalesOrder, salesOrder);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrder( @Nonnull final SalesOrder salesOrder )
    {
        return addRequestUpdate(service::updateSalesOrder, salesOrder);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrder( @Nonnull final SalesOrder salesOrder )
    {
        return addRequestDelete(service::deleteSalesOrder, salesOrder);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderBillingPlan(
        @Nonnull final SalesOrderBillingPlan salesOrderBillingPlan )
    {
        return addRequestCreate(service::createSalesOrderBillingPlan, salesOrderBillingPlan);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderBillingPlan(
        @Nonnull final SalesOrderBillingPlan salesOrderBillingPlan )
    {
        return addRequestUpdate(service::updateSalesOrderBillingPlan, salesOrderBillingPlan);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderBillingPlanItem(
        @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem )
    {
        return addRequestCreate(service::createSalesOrderBillingPlanItem, salesOrderBillingPlanItem);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderBillingPlanItem(
        @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem )
    {
        return addRequestUpdate(service::updateSalesOrderBillingPlanItem, salesOrderBillingPlanItem);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderBillingPlanItem(
        @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem )
    {
        return addRequestDelete(service::deleteSalesOrderBillingPlanItem, salesOrderBillingPlanItem);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderHeaderPartner(
        @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner )
    {
        return addRequestCreate(service::createSalesOrderHeaderPartner, salesOrderHeaderPartner);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderHeaderPartner(
        @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner )
    {
        return addRequestUpdate(service::updateSalesOrderHeaderPartner, salesOrderHeaderPartner);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderHeaderPartner(
        @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner )
    {
        return addRequestDelete(service::deleteSalesOrderHeaderPartner, salesOrderHeaderPartner);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderHeaderPrElement(
        @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement )
    {
        return addRequestCreate(service::createSalesOrderHeaderPrElement, salesOrderHeaderPrElement);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderHeaderPrElement(
        @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement )
    {
        return addRequestUpdate(service::updateSalesOrderHeaderPrElement, salesOrderHeaderPrElement);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderHeaderPrElement(
        @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement )
    {
        return addRequestDelete(service::deleteSalesOrderHeaderPrElement, salesOrderHeaderPrElement);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem )
    {
        return addRequestCreate(service::createSalesOrderItem, salesOrderItem);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem )
    {
        return addRequestUpdate(service::updateSalesOrderItem, salesOrderItem);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem )
    {
        return addRequestDelete(service::deleteSalesOrderItem, salesOrderItem);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderItemBillingPlan(
        @Nonnull final SalesOrderItemBillingPlan salesOrderItemBillingPlan )
    {
        return addRequestCreate(service::createSalesOrderItemBillingPlan, salesOrderItemBillingPlan);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderItemBillingPlan(
        @Nonnull final SalesOrderItemBillingPlan salesOrderItemBillingPlan )
    {
        return addRequestUpdate(service::updateSalesOrderItemBillingPlan, salesOrderItemBillingPlan);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderItemPartner(
        @Nonnull final SalesOrderItemPartner salesOrderItemPartner )
    {
        return addRequestCreate(service::createSalesOrderItemPartner, salesOrderItemPartner);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderItemPartner(
        @Nonnull final SalesOrderItemPartner salesOrderItemPartner )
    {
        return addRequestUpdate(service::updateSalesOrderItemPartner, salesOrderItemPartner);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderItemPartner(
        @Nonnull final SalesOrderItemPartner salesOrderItemPartner )
    {
        return addRequestDelete(service::deleteSalesOrderItemPartner, salesOrderItemPartner);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderItemPartnerAddress(
        @Nonnull final SalesOrderItemPartnerAddress salesOrderItemPartnerAddress )
    {
        return addRequestUpdate(service::updateSalesOrderItemPartnerAddress, salesOrderItemPartnerAddress);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderItemPrElement(
        @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement )
    {
        return addRequestCreate(service::createSalesOrderItemPrElement, salesOrderItemPrElement);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderItemPrElement(
        @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement )
    {
        return addRequestUpdate(service::updateSalesOrderItemPrElement, salesOrderItemPrElement);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderItemPrElement(
        @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement )
    {
        return addRequestDelete(service::deleteSalesOrderItemPrElement, salesOrderItemPrElement);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderItemRelatedObject(
        @Nonnull final SalesOrderItemRelatedObject salesOrderItemRelatedObject )
    {
        return addRequestCreate(service::createSalesOrderItemRelatedObject, salesOrderItemRelatedObject);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderItemRelatedObject(
        @Nonnull final SalesOrderItemRelatedObject salesOrderItemRelatedObject )
    {
        return addRequestDelete(service::deleteSalesOrderItemRelatedObject, salesOrderItemRelatedObject);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderItemText(
        @Nonnull final SalesOrderItemText salesOrderItemText )
    {
        return addRequestCreate(service::createSalesOrderItemText, salesOrderItemText);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderItemText(
        @Nonnull final SalesOrderItemText salesOrderItemText )
    {
        return addRequestUpdate(service::updateSalesOrderItemText, salesOrderItemText);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderItemText(
        @Nonnull final SalesOrderItemText salesOrderItemText )
    {
        return addRequestDelete(service::deleteSalesOrderItemText, salesOrderItemText);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderPartnerAddress(
        @Nonnull final SalesOrderPartnerAddress salesOrderPartnerAddress )
    {
        return addRequestUpdate(service::updateSalesOrderPartnerAddress, salesOrderPartnerAddress);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderRelatedObject(
        @Nonnull final SalesOrderRelatedObject salesOrderRelatedObject )
    {
        return addRequestCreate(service::createSalesOrderRelatedObject, salesOrderRelatedObject);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderRelatedObject(
        @Nonnull final SalesOrderRelatedObject salesOrderRelatedObject )
    {
        return addRequestDelete(service::deleteSalesOrderRelatedObject, salesOrderRelatedObject);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderScheduleLine(
        @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine )
    {
        return addRequestCreate(service::createSalesOrderScheduleLine, salesOrderScheduleLine);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderScheduleLine(
        @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine )
    {
        return addRequestUpdate(service::updateSalesOrderScheduleLine, salesOrderScheduleLine);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderScheduleLine(
        @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine )
    {
        return addRequestDelete(service::deleteSalesOrderScheduleLine, salesOrderScheduleLine);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSalesOrderText( @Nonnull final SalesOrderText salesOrderText )
    {
        return addRequestCreate(service::createSalesOrderText, salesOrderText);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSalesOrderText( @Nonnull final SalesOrderText salesOrderText )
    {
        return addRequestUpdate(service::updateSalesOrderText, salesOrderText);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSalesOrderText( @Nonnull final SalesOrderText salesOrderText )
    {
        return addRequestDelete(service::deleteSalesOrderText, salesOrderText);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSlsOrderItemBillingPlanItem(
        @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem )
    {
        return addRequestCreate(service::createSlsOrderItemBillingPlanItem, slsOrderItemBillingPlanItem);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSlsOrderItemBillingPlanItem(
        @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem )
    {
        return addRequestUpdate(service::updateSlsOrderItemBillingPlanItem, slsOrderItemBillingPlanItem);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSlsOrderItemBillingPlanItem(
        @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem )
    {
        return addRequestDelete(service::deleteSlsOrderItemBillingPlanItem, slsOrderItemBillingPlanItem);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet createSlsOrdPaymentPlanItemDetails(
        @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails )
    {
        return addRequestCreate(service::createSlsOrdPaymentPlanItemDetails, slsOrdPaymentPlanItemDetails);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet updateSlsOrdPaymentPlanItemDetails(
        @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails )
    {
        return addRequestUpdate(service::updateSlsOrdPaymentPlanItemDetails, slsOrdPaymentPlanItemDetails);
    }

    @Nonnull
    @Override
    public SalesOrderServiceBatchChangeSet deleteSlsOrdPaymentPlanItemDetails(
        @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails )
    {
        return addRequestDelete(service::deleteSlsOrdPaymentPlanItemDetails, slsOrdPaymentPlanItemDetails);
    }

}
