/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderService SalesOrderService}.
 *
 */
public interface SalesOrderServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SalesOrderServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SalesOrderServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity
     * and save it to the S/4HANA system.
     *
     * @param salesOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet createSalesOrder( @Nonnull final SalesOrder salesOrder );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder}
     * entity and save it to the S/4HANA system.
     *
     * @param salesOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet updateSalesOrder( @Nonnull final SalesOrder salesOrder );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder}
     * entity in the S/4HANA system.
     *
     * @param salesOrder
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrder SalesOrder} entity
     *            object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet deleteSalesOrder( @Nonnull final SalesOrder salesOrder );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     * SalesOrderBillingPlan} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBillingPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     *            SalesOrderBillingPlan} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSalesOrderBillingPlan( @Nonnull final SalesOrderBillingPlan salesOrderBillingPlan );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     * SalesOrderBillingPlan} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBillingPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlan
     *            SalesOrderBillingPlan} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSalesOrderBillingPlan( @Nonnull final SalesOrderBillingPlan salesOrderBillingPlan );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     * SalesOrderBillingPlanItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *            SalesOrderBillingPlanItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSalesOrderBillingPlanItem( @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     * SalesOrderBillingPlanItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *            SalesOrderBillingPlanItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSalesOrderBillingPlanItem( @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     * SalesOrderBillingPlanItem} entity in the S/4HANA system.
     *
     * @param salesOrderBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
     *            SalesOrderBillingPlanItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        deleteSalesOrderBillingPlanItem( @Nonnull final SalesOrderBillingPlanItem salesOrderBillingPlanItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     * SalesOrderHeaderPartner} entity and save it to the S/4HANA system.
     *
     * @param salesOrderHeaderPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *            SalesOrderHeaderPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSalesOrderHeaderPartner( @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     * SalesOrderHeaderPartner} entity and save it to the S/4HANA system.
     *
     * @param salesOrderHeaderPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *            SalesOrderHeaderPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSalesOrderHeaderPartner( @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     * SalesOrderHeaderPartner} entity in the S/4HANA system.
     *
     * @param salesOrderHeaderPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPartner
     *            SalesOrderHeaderPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        deleteSalesOrderHeaderPartner( @Nonnull final SalesOrderHeaderPartner salesOrderHeaderPartner );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     * SalesOrderHeaderPrElement} entity and save it to the S/4HANA system.
     *
     * @param salesOrderHeaderPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *            SalesOrderHeaderPrElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSalesOrderHeaderPrElement( @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     * SalesOrderHeaderPrElement} entity and save it to the S/4HANA system.
     *
     * @param salesOrderHeaderPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *            SalesOrderHeaderPrElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSalesOrderHeaderPrElement( @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     * SalesOrderHeaderPrElement} entity in the S/4HANA system.
     *
     * @param salesOrderHeaderPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderHeaderPrElement
     *            SalesOrderHeaderPrElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        deleteSalesOrderHeaderPrElement( @Nonnull final SalesOrderHeaderPrElement salesOrderHeaderPrElement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     * entity and save it to the S/4HANA system.
     *
     * @param salesOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet createSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem
     * SalesOrderItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet updateSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem
     * SalesOrderItem} entity in the S/4HANA system.
     *
     * @param salesOrderItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItem SalesOrderItem}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet deleteSalesOrderItem( @Nonnull final SalesOrderItem salesOrderItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     * SalesOrderItemBillingPlan} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemBillingPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     *            SalesOrderItemBillingPlan} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSalesOrderItemBillingPlan( @Nonnull final SalesOrderItemBillingPlan salesOrderItemBillingPlan );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     * SalesOrderItemBillingPlan} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemBillingPlan
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
     *            SalesOrderItemBillingPlan} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSalesOrderItemBillingPlan( @Nonnull final SalesOrderItemBillingPlan salesOrderItemBillingPlan );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     * SalesOrderItemPartner} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *            SalesOrderItemPartner} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSalesOrderItemPartner( @Nonnull final SalesOrderItemPartner salesOrderItemPartner );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     * SalesOrderItemPartner} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *            SalesOrderItemPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSalesOrderItemPartner( @Nonnull final SalesOrderItemPartner salesOrderItemPartner );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     * SalesOrderItemPartner} entity in the S/4HANA system.
     *
     * @param salesOrderItemPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartner
     *            SalesOrderItemPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        deleteSalesOrderItemPartner( @Nonnull final SalesOrderItemPartner salesOrderItemPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress
     * SalesOrderItemPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPartnerAddress
     *            SalesOrderItemPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSalesOrderItemPartnerAddress( @Nonnull final SalesOrderItemPartnerAddress salesOrderItemPartnerAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     * SalesOrderItemPrElement} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *            SalesOrderItemPrElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSalesOrderItemPrElement( @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     * SalesOrderItemPrElement} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *            SalesOrderItemPrElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSalesOrderItemPrElement( @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     * SalesOrderItemPrElement} entity in the S/4HANA system.
     *
     * @param salesOrderItemPrElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemPrElement
     *            SalesOrderItemPrElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        deleteSalesOrderItemPrElement( @Nonnull final SalesOrderItemPrElement salesOrderItemPrElement );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     * SalesOrderItemRelatedObject} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     *            SalesOrderItemRelatedObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSalesOrderItemRelatedObject( @Nonnull final SalesOrderItemRelatedObject salesOrderItemRelatedObject );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     * SalesOrderItemRelatedObject} entity in the S/4HANA system.
     *
     * @param salesOrderItemRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
     *            SalesOrderItemRelatedObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        deleteSalesOrderItemRelatedObject( @Nonnull final SalesOrderItemRelatedObject salesOrderItemRelatedObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     * SalesOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *            SalesOrderItemText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet createSalesOrderItemText( @Nonnull final SalesOrderItemText salesOrderItemText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     * SalesOrderItemText} entity and save it to the S/4HANA system.
     *
     * @param salesOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *            SalesOrderItemText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet updateSalesOrderItemText( @Nonnull final SalesOrderItemText salesOrderItemText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     * SalesOrderItemText} entity in the S/4HANA system.
     *
     * @param salesOrderItemText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemText
     *            SalesOrderItemText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet deleteSalesOrderItemText( @Nonnull final SalesOrderItemText salesOrderItemText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress
     * SalesOrderPartnerAddress} entity and save it to the S/4HANA system.
     *
     * @param salesOrderPartnerAddress
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress
     *            SalesOrderPartnerAddress} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSalesOrderPartnerAddress( @Nonnull final SalesOrderPartnerAddress salesOrderPartnerAddress );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     * SalesOrderRelatedObject} entity and save it to the S/4HANA system.
     *
     * @param salesOrderRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     *            SalesOrderRelatedObject} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSalesOrderRelatedObject( @Nonnull final SalesOrderRelatedObject salesOrderRelatedObject );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     * SalesOrderRelatedObject} entity in the S/4HANA system.
     *
     * @param salesOrderRelatedObject
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderRelatedObject
     *            SalesOrderRelatedObject} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        deleteSalesOrderRelatedObject( @Nonnull final SalesOrderRelatedObject salesOrderRelatedObject );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     * SalesOrderScheduleLine} entity and save it to the S/4HANA system.
     *
     * @param salesOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *            SalesOrderScheduleLine} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSalesOrderScheduleLine( @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     * SalesOrderScheduleLine} entity and save it to the S/4HANA system.
     *
     * @param salesOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *            SalesOrderScheduleLine} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSalesOrderScheduleLine( @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     * SalesOrderScheduleLine} entity in the S/4HANA system.
     *
     * @param salesOrderScheduleLine
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine
     *            SalesOrderScheduleLine} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        deleteSalesOrderScheduleLine( @Nonnull final SalesOrderScheduleLine salesOrderScheduleLine );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     * entity and save it to the S/4HANA system.
     *
     * @param salesOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet createSalesOrderText( @Nonnull final SalesOrderText salesOrderText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText
     * SalesOrderText} entity and save it to the S/4HANA system.
     *
     * @param salesOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet updateSalesOrderText( @Nonnull final SalesOrderText salesOrderText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText
     * SalesOrderText} entity in the S/4HANA system.
     *
     * @param salesOrderText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet deleteSalesOrderText( @Nonnull final SalesOrderText salesOrderText );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     * SlsOrderItemBillingPlanItem} entity and save it to the S/4HANA system.
     *
     * @param slsOrderItemBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *            SlsOrderItemBillingPlanItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSlsOrderItemBillingPlanItem( @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     * SlsOrderItemBillingPlanItem} entity and save it to the S/4HANA system.
     *
     * @param slsOrderItemBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *            SlsOrderItemBillingPlanItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSlsOrderItemBillingPlanItem( @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     * SlsOrderItemBillingPlanItem} entity in the S/4HANA system.
     *
     * @param slsOrderItemBillingPlanItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
     *            SlsOrderItemBillingPlanItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        deleteSlsOrderItemBillingPlanItem( @Nonnull final SlsOrderItemBillingPlanItem slsOrderItemBillingPlanItem );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     * SlsOrdPaymentPlanItemDetails} entity and save it to the S/4HANA system.
     *
     * @param slsOrdPaymentPlanItemDetails
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *            SlsOrdPaymentPlanItemDetails} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        createSlsOrdPaymentPlanItemDetails( @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     * SlsOrdPaymentPlanItemDetails} entity and save it to the S/4HANA system.
     *
     * @param slsOrdPaymentPlanItemDetails
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *            SlsOrdPaymentPlanItemDetails} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        updateSlsOrdPaymentPlanItemDetails( @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     * SlsOrdPaymentPlanItemDetails} entity in the S/4HANA system.
     *
     * @param slsOrdPaymentPlanItemDetails
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
     *            SlsOrdPaymentPlanItemDetails} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderServiceBatchChangeSet
        deleteSlsOrdPaymentPlanItemDetails( @Nonnull final SlsOrdPaymentPlanItemDetails slsOrdPaymentPlanItemDetails );

}
