/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem
 * SalesOrderBillingPlanItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderBillingPlanItemField
 * SalesOrderBillingPlanItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderBillingPlanItemLink
 * SalesOrderBillingPlanItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN
 * BILLING_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_ITEM
 * BILLING_PLAN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_DATE_CATEGORY
 * BILLING_PLAN_DATE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_BILLING_DATE
 * BILLING_PLAN_BILLING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_AMOUNT
 * BILLING_PLAN_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_AMOUNT_PERCENT
 * BILLING_PLAN_AMOUNT_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#CUSTOMER_PAYMENT_TERMS
 * CUSTOMER_PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#PROPOSED_BILLING_DOCUMENT_TYPE
 * PROPOSED_BILLING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_DATE_DESCRIPTION_CODE
 * BILLING_PLAN_DATE_DESCRIPTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_BLOCK_REASON
 * BILLING_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_SERVICE_START_DATE
 * BILLING_PLAN_SERVICE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_SERVICE_END_DATE
 * BILLING_PLAN_SERVICE_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_RELATED_BILLG_STATUS
 * BILLING_PLAN_RELATED_BILLG_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_TYPE
 * BILLING_PLAN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#ADOPTING_BILLING_DATE_ID
 * ADOPTING_BILLING_DATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_BILLING_RULE
 * BILLING_PLAN_BILLING_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLING_PLAN_MILESTONE_USAGE
 * BILLING_PLAN_MILESTONE_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#BILLG_PLN_DTE_CORRECTION_RFND_TYPE
 * BILLG_PLN_DTE_CORRECTION_RFND_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#ACCOUNTING_EXCHANGE_RATE
 * ACCOUNTING_EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#POSTPONEMENT_REASON
 * POSTPONEMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#TO_BILLING_PLAN
 * TO_BILLING_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderBillingPlanItem#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * </ul>
 *
 */
public interface SalesOrderBillingPlanItemSelectable extends EntitySelectable<SalesOrderBillingPlanItem>
{

}
