/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan
 * SalesOrderItemBillingPlan}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderItemBillingPlanField
 * SalesOrderItemBillingPlanField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderItemBillingPlanLink
 * SalesOrderItemBillingPlanLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#BILLING_PLAN
 * BILLING_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#BILLING_PLAN_IS_IN_HEADER
 * BILLING_PLAN_IS_IN_HEADER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#BILLING_PLAN_START_DATE
 * BILLING_PLAN_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#BILLING_PLAN_START_DATE_RULE
 * BILLING_PLAN_START_DATE_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#REFERENCE_BILLING_PLAN
 * REFERENCE_BILLING_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#BILLING_PLAN_CATEGORY
 * BILLING_PLAN_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#BILLING_PLAN_TYPE
 * BILLING_PLAN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#BILLING_PLAN_END_DATE
 * BILLING_PLAN_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#BILLING_PLAN_END_DATE_RULE
 * BILLING_PLAN_END_DATE_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#BILLING_PLAN_SEARCH_TERM
 * BILLING_PLAN_SEARCH_TERM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#TO_BILLING_PLAN_ITEM
 * TO_BILLING_PLAN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemBillingPlan#TO_SALES_ORDER_ITEM
 * TO_SALES_ORDER_ITEM}</li>
 * </ul>
 *
 */
public interface SalesOrderItemBillingPlanSelectable extends EntitySelectable<SalesOrderItemBillingPlan>
{

}
