/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject
 * SalesOrderItemRelatedObject}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderItemRelatedObjectField
 * SalesOrderItemRelatedObjectField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderItemRelatedObjectLink
 * SalesOrderItemRelatedObjectLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject#SD_DOC_RELATED_OBJECT_SEQUENCE_NMBR
 * SD_DOC_RELATED_OBJECT_SEQUENCE_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject#SD_DOCUMENT_RELATED_OBJECT_TYPE
 * SD_DOCUMENT_RELATED_OBJECT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject#SD_DOC_RELATED_OBJECT_SYSTEM
 * SD_DOC_RELATED_OBJECT_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject#SD_DOC_RELATED_OBJECT_REFERENCE1
 * SD_DOC_RELATED_OBJECT_REFERENCE1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject#SD_DOC_RELATED_OBJECT_REFERENCE2
 * SD_DOC_RELATED_OBJECT_REFERENCE2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItemRelatedObject#TO_SALES_ORDER_ITEM
 * TO_SALES_ORDER_ITEM}</li>
 * </ul>
 *
 */
public interface SalesOrderItemRelatedObjectSelectable extends EntitySelectable<SalesOrderItemRelatedObject>
{

}
