/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow
 * SalesOrderItmSubsqntProcFlow}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderItmSubsqntProcFlowField
 * SalesOrderItmSubsqntProcFlowField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderItmSubsqntProcFlowLink
 * SalesOrderItmSubsqntProcFlowLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#DOC_RELATIONSHIP_UUID
 * DOC_RELATIONSHIP_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#SUBSEQUENT_DOCUMENT
 * SUBSEQUENT_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#SUBSEQUENT_DOCUMENT_ITEM
 * SUBSEQUENT_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#SUBSEQUENT_DOCUMENT_CATEGORY
 * SUBSEQUENT_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#PROCESS_FLOW_LEVEL
 * PROCESS_FLOW_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#RELATED_PROC_FLOW_DOC_STS_FIELD_NAME
 * RELATED_PROC_FLOW_DOC_STS_FIELD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#SD_PROCESS_STATUS
 * SD_PROCESS_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#ACCOUNTING_TRANSFER_STATUS
 * ACCOUNTING_TRANSFER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#PRELIM_BILLING_DOCUMENT_STATUS
 * PRELIM_BILLING_DOCUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#SUBSQNT_DOC_ITM_PRECDG_DOCUMENT
 * SUBSQNT_DOC_ITM_PRECDG_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#SUBSQNT_DOC_ITM_PRECDG_DOC_ITEM
 * SUBSQNT_DOC_ITM_PRECDG_DOC_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#SUBSQNT_DOC_ITM_PRECDG_DOC_CATEGORY
 * SUBSQNT_DOC_ITM_PRECDG_DOC_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#CREATION_TIME
 * CREATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderItmSubsqntProcFlow#TO_SALES_ORDER_ITEM
 * TO_SALES_ORDER_ITEM}</li>
 * </ul>
 *
 */
public interface SalesOrderItmSubsqntProcFlowSelectable extends EntitySelectable<SalesOrderItmSubsqntProcFlow>
{

}
