/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress
 * SalesOrderPartnerAddress}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderPartnerAddressField
 * SalesOrderPartnerAddressField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderPartnerAddressLink
 * SalesOrderPartnerAddressLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#ADDRESS_REPRESENTATION_CODE
 * ADDRESS_REPRESENTATION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#CORRESPONDENCE_LANGUAGE
 * CORRESPONDENCE_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#ADDRESSEE_FULL_NAME
 * ADDRESSEE_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#ORGANIZATION_NAME1
 * ORGANIZATION_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#ORGANIZATION_NAME2
 * ORGANIZATION_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#ORGANIZATION_NAME3
 * ORGANIZATION_NAME3}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#ORGANIZATION_NAME4
 * ORGANIZATION_NAME4}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#CITY_NAME
 * CITY_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#DISTRICT_NAME
 * DISTRICT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#POSTAL_CODE
 * POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#STREET_PREFIX_NAME1
 * STREET_PREFIX_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#STREET_PREFIX_NAME2
 * STREET_PREFIX_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#STREET_NAME
 * STREET_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#STREET_SUFFIX_NAME1
 * STREET_SUFFIX_NAME1}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#STREET_SUFFIX_NAME2
 * STREET_SUFFIX_NAME2}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#HOUSE_NUMBER
 * HOUSE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#COUNTRY
 * COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#REGION
 * REGION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#FORM_OF_ADDRESS
 * FORM_OF_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#TAX_JURISDICTION
 * TAX_JURISDICTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#TRANSPORT_ZONE
 * TRANSPORT_ZONE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#PO_BOX
 * PO_BOX}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#PO_BOX_POSTAL_CODE
 * PO_BOX_POSTAL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#EMAIL_ADDRESS
 * EMAIL_ADDRESS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#MOBILE_PHONE_COUNTRY
 * MOBILE_PHONE_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#MOBILE_NUMBER
 * MOBILE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#PHONE_NUMBER_COUNTRY
 * PHONE_NUMBER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#PHONE_NUMBER
 * PHONE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#PHONE_EXTENSION_NUMBER
 * PHONE_EXTENSION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#FAX_NUMBER_COUNTRY
 * FAX_NUMBER_COUNTRY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#FAX_AREA_CODE_SUBSCRIBER_NUMBER
 * FAX_AREA_CODE_SUBSCRIBER_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#FAX_EXTENSION_NUMBER
 * FAX_EXTENSION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#TO_PARTNER
 * TO_PARTNER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderPartnerAddress#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * </ul>
 *
 */
public interface SalesOrderPartnerAddressSelectable extends EntitySelectable<SalesOrderPartnerAddress>
{

}
