/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine SalesOrderScheduleLine}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderScheduleLineField
 * SalesOrderScheduleLineField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderScheduleLineLink
 * SalesOrderScheduleLineLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#SCHEDULE_LINE
 * SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#REQUESTED_DELIVERY_DATE
 * REQUESTED_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#CONFIRMED_DELIVERY_DATE
 * CONFIRMED_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#ORDER_QUANTITY_SAP_UNIT
 * ORDER_QUANTITY_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#ORDER_QUANTITY_ISO_UNIT
 * ORDER_QUANTITY_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#SCHEDULE_LINE_ORDER_QUANTITY
 * SCHEDULE_LINE_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK
 * CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#DELIVERED_QTY_IN_ORDER_QTY_UNIT
 * DELIVERED_QTY_IN_ORDER_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#OPEN_CONFD_DELIV_QTY_IN_ORD_QTY_UNIT
 * OPEN_CONFD_DELIV_QTY_IN_ORD_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#CORRECTED_QTY_IN_ORDER_QTY_UNIT
 * CORRECTED_QTY_IN_ORDER_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderScheduleLine#DELIV_BLOCK_REASON_FOR_SCHED_LINE
 * DELIV_BLOCK_REASON_FOR_SCHED_LINE}</li>
 * </ul>
 *
 */
public interface SalesOrderScheduleLineSelectable extends EntitySelectable<SalesOrderScheduleLine>
{

}
