/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText SalesOrderText}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SalesOrderTextField
 * SalesOrderTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SalesOrderTextLink SalesOrderTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText#LONG_TEXT_ID
 * LONG_TEXT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText#LONG_TEXT LONG_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SalesOrderText#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * </ul>
 *
 */
public interface SalesOrderTextSelectable extends EntitySelectable<SalesOrderText>
{

}
