/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails
 * SlsOrdPaymentPlanItemDetails}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SlsOrdPaymentPlanItemDetailsField
 * SlsOrdPaymentPlanItemDetailsField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SlsOrdPaymentPlanItemDetailsLink
 * SlsOrdPaymentPlanItemDetailsLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#PAYMENT_PLAN_ITEM
 * PAYMENT_PLAN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#PAYMENT_PLAN
 * PAYMENT_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#ELECTRONIC_PAYMENT_TYPE
 * ELECTRONIC_PAYMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#ELECTRONIC_PAYMENT
 * ELECTRONIC_PAYMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#E_PAYT_VALIDITY_START_DATE
 * E_PAYT_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#E_PAYT_VALIDITY_END_DATE
 * E_PAYT_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#ELECTRONIC_PAYMENT_HOLDER_NAME
 * ELECTRONIC_PAYMENT_HOLDER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#AUTHORIZED_AMOUNT_IN_AUTHZN_CRCY
 * AUTHORIZED_AMOUNT_IN_AUTHZN_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#AUTHORIZATION_CURRENCY
 * AUTHORIZATION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#AUTHORIZATION_BY_DIGITAL_PAYT_SRVC
 * AUTHORIZATION_BY_DIGITAL_PAYT_SRVC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#AUTHORIZATION_BY_ACQUIRER
 * AUTHORIZATION_BY_ACQUIRER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#AUTHORIZATION_DATE
 * AUTHORIZATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#AUTHORIZATION_TIME
 * AUTHORIZATION_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#AUTHORIZATION_STATUS_NAME
 * AUTHORIZATION_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#E_PAYT_BY_DIGITAL_PAYMENT_SRVC
 * E_PAYT_BY_DIGITAL_PAYMENT_SRVC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#ELECTRONIC_PAYMENT_CALL_STATUS
 * ELECTRONIC_PAYMENT_CALL_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#E_PAYT_AUTHORIZATION_RESULT
 * E_PAYT_AUTHORIZATION_RESULT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#E_PAYT_TO_BE_AUTHORIZED_AMOUNT
 * E_PAYT_TO_BE_AUTHORIZED_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#E_PAYT_AUTHORIZATION_IS_EXPIRED
 * E_PAYT_AUTHORIZATION_IS_EXPIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#E_PAYT_AMOUNT_IS_CHANGED
 * E_PAYT_AMOUNT_IS_CHANGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#PREAUTHORIZATION_IS_REQUESTED
 * PREAUTHORIZATION_IS_REQUESTED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#PAYMENT_SERVICE_PROVIDER
 * PAYMENT_SERVICE_PROVIDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#PAYMENT_BY_PAYMENT_SERVICE_PRVDR
 * PAYMENT_BY_PAYMENT_SERVICE_PRVDR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#TRANSACTION_BY_PAYT_SRVC_PRVDR
 * TRANSACTION_BY_PAYT_SRVC_PRVDR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#MERCHANT_BY_CLEARING_HOUSE
 * MERCHANT_BY_CLEARING_HOUSE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#PAYMENT_CARD_AUTHZN_RELATION_ID
 * PAYMENT_CARD_AUTHZN_RELATION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#MAXIMUM_TO_BE_AUTHORIZED_AMOUNT
 * MAXIMUM_TO_BE_AUTHORIZED_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#PAYT_PLN_FOR_AUTHORIZATION_ITEM
 * PAYT_PLN_FOR_AUTHORIZATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#PAYT_PLN_ITM_FOR_AUTHORIZATION_ITEM
 * PAYT_PLN_ITM_FOR_AUTHORIZATION_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrdPaymentPlanItemDetails#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * </ul>
 *
 */
public interface SlsOrdPaymentPlanItemDetailsSelectable extends EntitySelectable<SlsOrdPaymentPlanItemDetails>
{

}
