/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem
 * SlsOrderItemBillingPlanItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.field.SlsOrderItemBillingPlanItemField
 * SlsOrderItemBillingPlanItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.link.SlsOrderItemBillingPlanItemLink
 * SlsOrderItemBillingPlanItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN
 * BILLING_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_ITEM
 * BILLING_PLAN_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_DATE_CATEGORY
 * BILLING_PLAN_DATE_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_BILLING_DATE
 * BILLING_PLAN_BILLING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_AMOUNT
 * BILLING_PLAN_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_AMOUNT_PERCENT
 * BILLING_PLAN_AMOUNT_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#CUSTOMER_PAYMENT_TERMS
 * CUSTOMER_PAYMENT_TERMS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#PROPOSED_BILLING_DOCUMENT_TYPE
 * PROPOSED_BILLING_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_DATE_DESCRIPTION_CODE
 * BILLING_PLAN_DATE_DESCRIPTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_BLOCK_REASON
 * BILLING_BLOCK_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_SERVICE_START_DATE
 * BILLING_PLAN_SERVICE_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_SERVICE_END_DATE
 * BILLING_PLAN_SERVICE_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_RELATED_BILLG_STATUS
 * BILLING_PLAN_RELATED_BILLG_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_TYPE
 * BILLING_PLAN_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#ADOPTING_BILLING_DATE_ID
 * ADOPTING_BILLING_DATE_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_BILLING_RULE
 * BILLING_PLAN_BILLING_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLING_PLAN_MILESTONE_USAGE
 * BILLING_PLAN_MILESTONE_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#BILLG_PLN_DTE_CORRECTION_RFND_TYPE
 * BILLG_PLN_DTE_CORRECTION_RFND_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#ACCOUNTING_EXCHANGE_RATE
 * ACCOUNTING_EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#POSTPONEMENT_REASON
 * POSTPONEMENT_REASON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#TO_BILLING_PLAN
 * TO_BILLING_PLAN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorder.SlsOrderItemBillingPlanItem#TO_SALES_ORDER_ITEM
 * TO_SALES_ORDER_ITEM}</li>
 * </ul>
 *
 */
public interface SlsOrderItemBillingPlanItemSelectable extends EntitySelectable<SlsOrderItemBillingPlanItem>
{

}
