/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.field.SalesOrderItemSimulationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.link.SalesOrderItemSimulationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.link.SalesOrderItemSimulationOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.selectable.SalesOrderItemSimulationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Order Item Simulation (API)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderItemSimulationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderItemSimulation extends VdmEntity<SalesOrderItemSimulation>
{

    /**
     * Selector for all available fields of SalesOrderItemSimulation.
     *
     */
    public final static SalesOrderItemSimulationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> SALES_ORDER =
        new SalesOrderItemSimulationField<String>("SalesOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Order Item
     */
    @Key
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> SALES_ORDER_ITEM =
        new SalesOrderItemSimulationField<String>("SalesOrderItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @return Higher-Level Item in Bill of Material Structures
     */
    @SerializedName( "HigherLevelItem" )
    @JsonProperty( "HigherLevelItem" )
    @Nullable
    @ODataField( odataName = "HigherLevelItem" )
    private String higherLevelItem;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItem</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> HIGHER_LEVEL_ITEM =
        new SalesOrderItemSimulationField<String>("HigherLevelItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItemUsage</b>
     * </p>
     *
     * @return ID for higher-level item usage
     */
    @SerializedName( "HigherLevelItemUsage" )
    @JsonProperty( "HigherLevelItemUsage" )
    @Nullable
    @ODataField( odataName = "HigherLevelItemUsage" )
    private String higherLevelItemUsage;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItemUsage</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> HIGHER_LEVEL_ITEM_USAGE =
        new SalesOrderItemSimulationField<String>("HigherLevelItemUsage");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemCategory</b>
     * </p>
     *
     * @return Sales Document Item Category
     */
    @SerializedName( "SalesOrderItemCategory" )
    @JsonProperty( "SalesOrderItemCategory" )
    @Nullable
    @ODataField( odataName = "SalesOrderItemCategory" )
    private String salesOrderItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItemCategory</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> SALES_ORDER_ITEM_CATEGORY =
        new SalesOrderItemSimulationField<String>("SalesOrderItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemText</b>
     * </p>
     *
     * @return Short Text for Sales Order Item
     */
    @SerializedName( "SalesOrderItemText" )
    @JsonProperty( "SalesOrderItemText" )
    @Nullable
    @ODataField( odataName = "SalesOrderItemText" )
    private String salesOrderItemText;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItemText</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> SALES_ORDER_ITEM_TEXT =
        new SalesOrderItemSimulationField<String>("SalesOrderItemText");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new SalesOrderItemSimulationField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> MATERIAL =
        new SalesOrderItemSimulationField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Material Number Used by Customer
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> MATERIAL_BY_CUSTOMER =
        new SalesOrderItemSimulationField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Date for Pricing and Exchange Rate
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<LocalDateTime> PRICING_DATE =
        new SalesOrderItemSimulationField<LocalDateTime>("PricingDate");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PricingReferenceMaterial</b>
     * </p>
     *
     * @return Pricing Reference Material
     */
    @SerializedName( "PricingReferenceMaterial" )
    @JsonProperty( "PricingReferenceMaterial" )
    @Nullable
    @ODataField( odataName = "PricingReferenceMaterial" )
    private String pricingReferenceMaterial;
    /**
     * Use with available fluent helpers to apply the <b>PricingReferenceMaterial</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PRICING_REFERENCE_MATERIAL =
        new SalesOrderItemSimulationField<String>("PricingReferenceMaterial");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return Requested Quantity
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> REQUESTED_QUANTITY =
        new SalesOrderItemSimulationField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @return Unit of the Requested Quantity
     */
    @SerializedName( "RequestedQuantityUnit" )
    @JsonProperty( "RequestedQuantityUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityUnit" )
    private String requestedQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> REQUESTED_QUANTITY_UNIT =
        new SalesOrderItemSimulationField<String>("RequestedQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Requested Quantity
     */
    @SerializedName( "RequestedQuantitySAPUnit" )
    @JsonProperty( "RequestedQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantitySAPUnit" )
    private String requestedQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> REQUESTED_QUANTITY_SAP_UNIT =
        new SalesOrderItemSimulationField<String>("RequestedQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Requested Quantity
     */
    @SerializedName( "RequestedQuantityISOUnit" )
    @JsonProperty( "RequestedQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityISOUnit" )
    private String requestedQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> REQUESTED_QUANTITY_ISO_UNIT =
        new SalesOrderItemSimulationField<String>("RequestedQuantityISOUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> ORDER_QUANTITY_UNIT =
        new SalesOrderItemSimulationField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantitySAPUnit" )
    @JsonProperty( "OrderQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantitySAPUnit" )
    private String orderQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> ORDER_QUANTITY_SAP_UNIT =
        new SalesOrderItemSimulationField<String>("OrderQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantityISOUnit" )
    @JsonProperty( "OrderQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityISOUnit" )
    private String orderQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> ORDER_QUANTITY_ISO_UNIT =
        new SalesOrderItemSimulationField<String>("OrderQuantityISOUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdDelivQtyInOrderQtyUnit</b>
     * </p>
     *
     * @return Cumulative Confirmed Quantity in Sales Unit
     */
    @SerializedName( "ConfdDelivQtyInOrderQtyUnit" )
    @JsonProperty( "ConfdDelivQtyInOrderQtyUnit" )
    @Nullable
    @ODataField( odataName = "ConfdDelivQtyInOrderQtyUnit" )
    private BigDecimal confdDelivQtyInOrderQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>ConfdDelivQtyInOrderQtyUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> CONFD_DELIV_QTY_IN_ORDER_QTY_UNIT =
        new SalesOrderItemSimulationField<BigDecimal>("ConfdDelivQtyInOrderQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @return Gross Weight of the Item
     */
    @SerializedName( "ItemGrossWeight" )
    @JsonProperty( "ItemGrossWeight" )
    @Nullable
    @ODataField( odataName = "ItemGrossWeight" )
    private BigDecimal itemGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemGrossWeight</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> ITEM_GROSS_WEIGHT =
        new SalesOrderItemSimulationField<BigDecimal>("ItemGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight of the Item
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> ITEM_NET_WEIGHT =
        new SalesOrderItemSimulationField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> ITEM_WEIGHT_UNIT =
        new SalesOrderItemSimulationField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightSAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Item Weight
     */
    @SerializedName( "ItemWeightSAPUnit" )
    @JsonProperty( "ItemWeightSAPUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightSAPUnit" )
    private String itemWeightSAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightSAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> ITEM_WEIGHT_SAP_UNIT =
        new SalesOrderItemSimulationField<String>("ItemWeightSAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Item Weight
     */
    @SerializedName( "ItemWeightISOUnit" )
    @JsonProperty( "ItemWeightISOUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightISOUnit" )
    private String itemWeightISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> ITEM_WEIGHT_ISO_UNIT =
        new SalesOrderItemSimulationField<String>("ItemWeightISOUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume of the item
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> ITEM_VOLUME =
        new SalesOrderItemSimulationField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> ITEM_VOLUME_UNIT =
        new SalesOrderItemSimulationField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeSAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Item Volume
     */
    @SerializedName( "ItemVolumeSAPUnit" )
    @JsonProperty( "ItemVolumeSAPUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeSAPUnit" )
    private String itemVolumeSAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeSAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> ITEM_VOLUME_SAP_UNIT =
        new SalesOrderItemSimulationField<String>("ItemVolumeSAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Item Volume
     */
    @SerializedName( "ItemVolumeISOUnit" )
    @JsonProperty( "ItemVolumeISOUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeISOUnit" )
    private String itemVolumeISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> ITEM_VOLUME_ISO_UNIT =
        new SalesOrderItemSimulationField<String>("ItemVolumeISOUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> TRANSACTION_CURRENCY =
        new SalesOrderItemSimulationField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of the Order Item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> NET_AMOUNT =
        new SalesOrderItemSimulationField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @return Tax Amount in Document Currency
     */
    @SerializedName( "TaxAmount" )
    @JsonProperty( "TaxAmount" )
    @Nullable
    @ODataField( odataName = "TaxAmount" )
    private BigDecimal taxAmount;
    /**
     * Use with available fluent helpers to apply the <b>TaxAmount</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> TAX_AMOUNT =
        new SalesOrderItemSimulationField<BigDecimal>("TaxAmount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostAmount</b>
     * </p>
     *
     * @return Cost in Document Currency
     */
    @SerializedName( "CostAmount" )
    @JsonProperty( "CostAmount" )
    @Nullable
    @ODataField( odataName = "CostAmount" )
    private BigDecimal costAmount;
    /**
     * Use with available fluent helpers to apply the <b>CostAmount</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> COST_AMOUNT =
        new SalesOrderItemSimulationField<BigDecimal>("CostAmount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal1Amount</b>
     * </p>
     *
     * @return Subtotal 1 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal1Amount" )
    @JsonProperty( "Subtotal1Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal1Amount" )
    private BigDecimal subtotal1Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal1Amount</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> SUBTOTAL1_AMOUNT =
        new SalesOrderItemSimulationField<BigDecimal>("Subtotal1Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal2Amount</b>
     * </p>
     *
     * @return Subtotal 2 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal2Amount" )
    @JsonProperty( "Subtotal2Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal2Amount" )
    private BigDecimal subtotal2Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal2Amount</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> SUBTOTAL2_AMOUNT =
        new SalesOrderItemSimulationField<BigDecimal>("Subtotal2Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal3Amount</b>
     * </p>
     *
     * @return Subtotal 3 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal3Amount" )
    @JsonProperty( "Subtotal3Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal3Amount" )
    private BigDecimal subtotal3Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal3Amount</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> SUBTOTAL3_AMOUNT =
        new SalesOrderItemSimulationField<BigDecimal>("Subtotal3Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal4Amount</b>
     * </p>
     *
     * @return Subtotal 4 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal4Amount" )
    @JsonProperty( "Subtotal4Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal4Amount" )
    private BigDecimal subtotal4Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal4Amount</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> SUBTOTAL4_AMOUNT =
        new SalesOrderItemSimulationField<BigDecimal>("Subtotal4Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal5Amount</b>
     * </p>
     *
     * @return Subtotal 5 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal5Amount" )
    @JsonProperty( "Subtotal5Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal5Amount" )
    private BigDecimal subtotal5Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal5Amount</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> SUBTOTAL5_AMOUNT =
        new SalesOrderItemSimulationField<BigDecimal>("Subtotal5Amount");
    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal6Amount</b>
     * </p>
     *
     * @return Subtotal 6 from Pricing Procedure for Price Element
     */
    @SerializedName( "Subtotal6Amount" )
    @JsonProperty( "Subtotal6Amount" )
    @Nullable
    @ODataField( odataName = "Subtotal6Amount" )
    private BigDecimal subtotal6Amount;
    /**
     * Use with available fluent helpers to apply the <b>Subtotal6Amount</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<BigDecimal> SUBTOTAL6_AMOUNT =
        new SalesOrderItemSimulationField<BigDecimal>("Subtotal6Amount");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSubstitutionReason</b>
     * </p>
     *
     * @return Reason for material substitution
     */
    @SerializedName( "MaterialSubstitutionReason" )
    @JsonProperty( "MaterialSubstitutionReason" )
    @Nullable
    @ODataField( odataName = "MaterialSubstitutionReason" )
    private String materialSubstitutionReason;
    /**
     * Use with available fluent helpers to apply the <b>MaterialSubstitutionReason</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> MATERIAL_SUBSTITUTION_REASON =
        new SalesOrderItemSimulationField<String>("MaterialSubstitutionReason");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> MATERIAL_GROUP =
        new SalesOrderItemSimulationField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @return Material Price Group
     */
    @SerializedName( "MaterialPricingGroup" )
    @JsonProperty( "MaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MaterialPricingGroup" )
    private String materialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPricingGroup</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> MATERIAL_PRICING_GROUP =
        new SalesOrderItemSimulationField<String>("MaterialPricingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> BATCH =
        new SalesOrderItemSimulationField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant (Own or External)
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PLANT =
        new SalesOrderItemSimulationField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> STORAGE_LOCATION =
        new SalesOrderItemSimulationField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryGroup</b>
     * </p>
     *
     * @return Delivery Group (Items are delivered together)
     */
    @SerializedName( "DeliveryGroup" )
    @JsonProperty( "DeliveryGroup" )
    @Nullable
    @ODataField( odataName = "DeliveryGroup" )
    private String deliveryGroup;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryGroup</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> DELIVERY_GROUP =
        new SalesOrderItemSimulationField<String>("DeliveryGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point / Receiving Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> SHIPPING_POINT =
        new SalesOrderItemSimulationField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> SHIPPING_TYPE =
        new SalesOrderItemSimulationField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @return Delivery Priority
     */
    @SerializedName( "DeliveryPriority" )
    @JsonProperty( "DeliveryPriority" )
    @Nullable
    @ODataField( odataName = "DeliveryPriority" )
    private String deliveryPriority;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryPriority</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> DELIVERY_PRIORITY =
        new SalesOrderItemSimulationField<String>("DeliveryPriority");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> INCOTERMS_CLASSIFICATION =
        new SalesOrderItemSimulationField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> INCOTERMS_TRANSFER_LOCATION =
        new SalesOrderItemSimulationField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> INCOTERMS_LOCATION1 =
        new SalesOrderItemSimulationField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> INCOTERMS_LOCATION2 =
        new SalesOrderItemSimulationField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification1" )
    @JsonProperty( "ProductTaxClassification1" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification1" )
    private String productTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification1</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION1 =
        new SalesOrderItemSimulationField<String>("ProductTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification2" )
    @JsonProperty( "ProductTaxClassification2" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification2" )
    private String productTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification2</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION2 =
        new SalesOrderItemSimulationField<String>("ProductTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification3" )
    @JsonProperty( "ProductTaxClassification3" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification3" )
    private String productTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification3</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION3 =
        new SalesOrderItemSimulationField<String>("ProductTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification4" )
    @JsonProperty( "ProductTaxClassification4" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification4" )
    private String productTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification4</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION4 =
        new SalesOrderItemSimulationField<String>("ProductTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification5" )
    @JsonProperty( "ProductTaxClassification5" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification5" )
    private String productTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification5</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION5 =
        new SalesOrderItemSimulationField<String>("ProductTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification6" )
    @JsonProperty( "ProductTaxClassification6" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification6" )
    private String productTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification6</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION6 =
        new SalesOrderItemSimulationField<String>("ProductTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification7" )
    @JsonProperty( "ProductTaxClassification7" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification7" )
    private String productTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification7</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION7 =
        new SalesOrderItemSimulationField<String>("ProductTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification8" )
    @JsonProperty( "ProductTaxClassification8" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification8" )
    private String productTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification8</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION8 =
        new SalesOrderItemSimulationField<String>("ProductTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification for Material
     */
    @SerializedName( "ProductTaxClassification9" )
    @JsonProperty( "ProductTaxClassification9" )
    @Nullable
    @ODataField( odataName = "ProductTaxClassification9" )
    private String productTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>ProductTaxClassification9</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> PRODUCT_TAX_CLASSIFICATION9 =
        new SalesOrderItemSimulationField<String>("ProductTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> REFERENCE_SD_DOCUMENT =
        new SalesOrderItemSimulationField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @return Item Number of the Reference Item
     */
    @SerializedName( "ReferenceSDDocumentItem" )
    @JsonProperty( "ReferenceSDDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentItem" )
    private String referenceSDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentItem</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> REFERENCE_SD_DOCUMENT_ITEM =
        new SalesOrderItemSimulationField<String>("ReferenceSDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> CUSTOMER_PAYMENT_TERMS =
        new SalesOrderItemSimulationField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @return Reason for Rejection of Sales Documents
     */
    @SerializedName( "SalesDocumentRjcnReason" )
    @JsonProperty( "SalesDocumentRjcnReason" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason" )
    private String salesDocumentRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason</b> field to query operations.
     *
     */
    public final static SalesOrderItemSimulationField<String> SALES_DOCUMENT_RJCN_REASON =
        new SalesOrderItemSimulationField<String>("SalesDocumentRjcnReason");
    /**
     * Navigation property <b>to_Partner</b> for <b>SalesOrderItemSimulation</b> to multiple
     * <b>SalesOrderItemPartnerSimln</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItemPartnerSimln> toPartner;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>SalesOrderItemSimulation</b> to multiple
     * <b>SalesOrderItmPrcgElmntSimln</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItmPrcgElmntSimln> toPricingElement;
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderItemSimulation</b> to single
     * <b>SalesOrderSimulation</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderSimulation toSalesOrder;
    /**
     * Navigation property <b>to_ScheduleLine</b> for <b>SalesOrderItemSimulation</b> to multiple
     * <b>SalesOrderScheduleLineSimln</b>.
     *
     */
    @SerializedName( "to_ScheduleLine" )
    @JsonProperty( "to_ScheduleLine" )
    @ODataField( odataName = "to_ScheduleLine" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderScheduleLineSimln> toScheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemSimulationLink<SalesOrderItemPartnerSimln> TO_PARTNER =
        new SalesOrderItemSimulationLink<SalesOrderItemPartnerSimln>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemSimulationLink<SalesOrderItmPrcgElmntSimln> TO_PRICING_ELEMENT =
        new SalesOrderItemSimulationLink<SalesOrderItmPrcgElmntSimln>("to_PricingElement");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemSimulationOneToOneLink<SalesOrderSimulation> TO_SALES_ORDER =
        new SalesOrderItemSimulationOneToOneLink<SalesOrderSimulation>("to_SalesOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_ScheduleLine</b> navigation property to query operations.
     *
     */
    public final static SalesOrderItemSimulationLink<SalesOrderScheduleLineSimln> TO_SCHEDULE_LINE =
        new SalesOrderItemSimulationLink<SalesOrderScheduleLineSimln>("to_ScheduleLine");

    @Nonnull
    @Override
    public Class<SalesOrderItemSimulation> getType()
    {
        return SalesOrderItemSimulation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Order Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @param higherLevelItem
     *            Higher-Level Item in Bill of Material Structures
     */
    public void setHigherLevelItem( @Nullable final String higherLevelItem )
    {
        rememberChangedField("HigherLevelItem", this.higherLevelItem);
        this.higherLevelItem = higherLevelItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItemUsage</b>
     * </p>
     *
     * @param higherLevelItemUsage
     *            ID for higher-level item usage
     */
    public void setHigherLevelItemUsage( @Nullable final String higherLevelItemUsage )
    {
        rememberChangedField("HigherLevelItemUsage", this.higherLevelItemUsage);
        this.higherLevelItemUsage = higherLevelItemUsage;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemCategory</b>
     * </p>
     *
     * @param salesOrderItemCategory
     *            Sales Document Item Category
     */
    public void setSalesOrderItemCategory( @Nullable final String salesOrderItemCategory )
    {
        rememberChangedField("SalesOrderItemCategory", this.salesOrderItemCategory);
        this.salesOrderItemCategory = salesOrderItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItemText</b>
     * </p>
     *
     * @param salesOrderItemText
     *            Short Text for Sales Order Item
     */
    public void setSalesOrderItemText( @Nullable final String salesOrderItemText )
    {
        rememberChangedField("SalesOrderItemText", this.salesOrderItemText);
        this.salesOrderItemText = salesOrderItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Material Number Used by Customer
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>PricingReferenceMaterial</b>
     * </p>
     *
     * @param pricingReferenceMaterial
     *            Pricing Reference Material
     */
    public void setPricingReferenceMaterial( @Nullable final String pricingReferenceMaterial )
    {
        rememberChangedField("PricingReferenceMaterial", this.pricingReferenceMaterial);
        this.pricingReferenceMaterial = pricingReferenceMaterial;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            Requested Quantity
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @param requestedQuantityUnit
     *            Unit of the Requested Quantity
     */
    public void setRequestedQuantityUnit( @Nullable final String requestedQuantityUnit )
    {
        rememberChangedField("RequestedQuantityUnit", this.requestedQuantityUnit);
        this.requestedQuantityUnit = requestedQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantitySAPUnit</b>
     * </p>
     *
     * @param requestedQuantitySAPUnit
     *            SAP Unit Code for Requested Quantity
     */
    public void setRequestedQuantitySAPUnit( @Nullable final String requestedQuantitySAPUnit )
    {
        rememberChangedField("RequestedQuantitySAPUnit", this.requestedQuantitySAPUnit);
        this.requestedQuantitySAPUnit = requestedQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityISOUnit</b>
     * </p>
     *
     * @param requestedQuantityISOUnit
     *            ISO Unit Code for Requested Quantity
     */
    public void setRequestedQuantityISOUnit( @Nullable final String requestedQuantityISOUnit )
    {
        rememberChangedField("RequestedQuantityISOUnit", this.requestedQuantityISOUnit);
        this.requestedQuantityISOUnit = requestedQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @param orderQuantitySAPUnit
     *            SAP Unit Code for Order Quantity
     */
    public void setOrderQuantitySAPUnit( @Nullable final String orderQuantitySAPUnit )
    {
        rememberChangedField("OrderQuantitySAPUnit", this.orderQuantitySAPUnit);
        this.orderQuantitySAPUnit = orderQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @param orderQuantityISOUnit
     *            ISO Unit Code for Order Quantity
     */
    public void setOrderQuantityISOUnit( @Nullable final String orderQuantityISOUnit )
    {
        rememberChangedField("OrderQuantityISOUnit", this.orderQuantityISOUnit);
        this.orderQuantityISOUnit = orderQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdDelivQtyInOrderQtyUnit</b>
     * </p>
     *
     * @param confdDelivQtyInOrderQtyUnit
     *            Cumulative Confirmed Quantity in Sales Unit
     */
    public void setConfdDelivQtyInOrderQtyUnit( @Nullable final BigDecimal confdDelivQtyInOrderQtyUnit )
    {
        rememberChangedField("ConfdDelivQtyInOrderQtyUnit", this.confdDelivQtyInOrderQtyUnit);
        this.confdDelivQtyInOrderQtyUnit = confdDelivQtyInOrderQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @param itemGrossWeight
     *            Gross Weight of the Item
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight of the Item
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightSAPUnit</b>
     * </p>
     *
     * @param itemWeightSAPUnit
     *            SAP Unit Code for Item Weight
     */
    public void setItemWeightSAPUnit( @Nullable final String itemWeightSAPUnit )
    {
        rememberChangedField("ItemWeightSAPUnit", this.itemWeightSAPUnit);
        this.itemWeightSAPUnit = itemWeightSAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightISOUnit</b>
     * </p>
     *
     * @param itemWeightISOUnit
     *            ISO Unit Code for Item Weight
     */
    public void setItemWeightISOUnit( @Nullable final String itemWeightISOUnit )
    {
        rememberChangedField("ItemWeightISOUnit", this.itemWeightISOUnit);
        this.itemWeightISOUnit = itemWeightISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume of the item
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeSAPUnit</b>
     * </p>
     *
     * @param itemVolumeSAPUnit
     *            SAP Unit Code for Item Volume
     */
    public void setItemVolumeSAPUnit( @Nullable final String itemVolumeSAPUnit )
    {
        rememberChangedField("ItemVolumeSAPUnit", this.itemVolumeSAPUnit);
        this.itemVolumeSAPUnit = itemVolumeSAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeISOUnit</b>
     * </p>
     *
     * @param itemVolumeISOUnit
     *            ISO Unit Code for Item Volume
     */
    public void setItemVolumeISOUnit( @Nullable final String itemVolumeISOUnit )
    {
        rememberChangedField("ItemVolumeISOUnit", this.itemVolumeISOUnit);
        this.itemVolumeISOUnit = itemVolumeISOUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of the Order Item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TaxAmount</b>
     * </p>
     *
     * @param taxAmount
     *            Tax Amount in Document Currency
     */
    public void setTaxAmount( @Nullable final BigDecimal taxAmount )
    {
        rememberChangedField("TaxAmount", this.taxAmount);
        this.taxAmount = taxAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CostAmount</b>
     * </p>
     *
     * @param costAmount
     *            Cost in Document Currency
     */
    public void setCostAmount( @Nullable final BigDecimal costAmount )
    {
        rememberChangedField("CostAmount", this.costAmount);
        this.costAmount = costAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal1Amount</b>
     * </p>
     *
     * @param subtotal1Amount
     *            Subtotal 1 from Pricing Procedure for Price Element
     */
    public void setSubtotal1Amount( @Nullable final BigDecimal subtotal1Amount )
    {
        rememberChangedField("Subtotal1Amount", this.subtotal1Amount);
        this.subtotal1Amount = subtotal1Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal2Amount</b>
     * </p>
     *
     * @param subtotal2Amount
     *            Subtotal 2 from Pricing Procedure for Price Element
     */
    public void setSubtotal2Amount( @Nullable final BigDecimal subtotal2Amount )
    {
        rememberChangedField("Subtotal2Amount", this.subtotal2Amount);
        this.subtotal2Amount = subtotal2Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal3Amount</b>
     * </p>
     *
     * @param subtotal3Amount
     *            Subtotal 3 from Pricing Procedure for Price Element
     */
    public void setSubtotal3Amount( @Nullable final BigDecimal subtotal3Amount )
    {
        rememberChangedField("Subtotal3Amount", this.subtotal3Amount);
        this.subtotal3Amount = subtotal3Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal4Amount</b>
     * </p>
     *
     * @param subtotal4Amount
     *            Subtotal 4 from Pricing Procedure for Price Element
     */
    public void setSubtotal4Amount( @Nullable final BigDecimal subtotal4Amount )
    {
        rememberChangedField("Subtotal4Amount", this.subtotal4Amount);
        this.subtotal4Amount = subtotal4Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal5Amount</b>
     * </p>
     *
     * @param subtotal5Amount
     *            Subtotal 5 from Pricing Procedure for Price Element
     */
    public void setSubtotal5Amount( @Nullable final BigDecimal subtotal5Amount )
    {
        rememberChangedField("Subtotal5Amount", this.subtotal5Amount);
        this.subtotal5Amount = subtotal5Amount;
    }

    /**
     * Constraints: Not nullable, Precision: 14, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>Subtotal6Amount</b>
     * </p>
     *
     * @param subtotal6Amount
     *            Subtotal 6 from Pricing Procedure for Price Element
     */
    public void setSubtotal6Amount( @Nullable final BigDecimal subtotal6Amount )
    {
        rememberChangedField("Subtotal6Amount", this.subtotal6Amount);
        this.subtotal6Amount = subtotal6Amount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>MaterialSubstitutionReason</b>
     * </p>
     *
     * @param materialSubstitutionReason
     *            Reason for material substitution
     */
    public void setMaterialSubstitutionReason( @Nullable final String materialSubstitutionReason )
    {
        rememberChangedField("MaterialSubstitutionReason", this.materialSubstitutionReason);
        this.materialSubstitutionReason = materialSubstitutionReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @param materialPricingGroup
     *            Material Price Group
     */
    public void setMaterialPricingGroup( @Nullable final String materialPricingGroup )
    {
        rememberChangedField("MaterialPricingGroup", this.materialPricingGroup);
        this.materialPricingGroup = materialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant (Own or External)
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryGroup</b>
     * </p>
     *
     * @param deliveryGroup
     *            Delivery Group (Items are delivered together)
     */
    public void setDeliveryGroup( @Nullable final String deliveryGroup )
    {
        rememberChangedField("DeliveryGroup", this.deliveryGroup);
        this.deliveryGroup = deliveryGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @param deliveryPriority
     *            Delivery Priority
     */
    public void setDeliveryPriority( @Nullable final String deliveryPriority )
    {
        rememberChangedField("DeliveryPriority", this.deliveryPriority);
        this.deliveryPriority = deliveryPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification1</b>
     * </p>
     *
     * @param productTaxClassification1
     *            Tax Classification for Material
     */
    public void setProductTaxClassification1( @Nullable final String productTaxClassification1 )
    {
        rememberChangedField("ProductTaxClassification1", this.productTaxClassification1);
        this.productTaxClassification1 = productTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification2</b>
     * </p>
     *
     * @param productTaxClassification2
     *            Tax Classification for Material
     */
    public void setProductTaxClassification2( @Nullable final String productTaxClassification2 )
    {
        rememberChangedField("ProductTaxClassification2", this.productTaxClassification2);
        this.productTaxClassification2 = productTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification3</b>
     * </p>
     *
     * @param productTaxClassification3
     *            Tax Classification for Material
     */
    public void setProductTaxClassification3( @Nullable final String productTaxClassification3 )
    {
        rememberChangedField("ProductTaxClassification3", this.productTaxClassification3);
        this.productTaxClassification3 = productTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification4</b>
     * </p>
     *
     * @param productTaxClassification4
     *            Tax Classification for Material
     */
    public void setProductTaxClassification4( @Nullable final String productTaxClassification4 )
    {
        rememberChangedField("ProductTaxClassification4", this.productTaxClassification4);
        this.productTaxClassification4 = productTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification5</b>
     * </p>
     *
     * @param productTaxClassification5
     *            Tax Classification for Material
     */
    public void setProductTaxClassification5( @Nullable final String productTaxClassification5 )
    {
        rememberChangedField("ProductTaxClassification5", this.productTaxClassification5);
        this.productTaxClassification5 = productTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification6</b>
     * </p>
     *
     * @param productTaxClassification6
     *            Tax Classification for Material
     */
    public void setProductTaxClassification6( @Nullable final String productTaxClassification6 )
    {
        rememberChangedField("ProductTaxClassification6", this.productTaxClassification6);
        this.productTaxClassification6 = productTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification7</b>
     * </p>
     *
     * @param productTaxClassification7
     *            Tax Classification for Material
     */
    public void setProductTaxClassification7( @Nullable final String productTaxClassification7 )
    {
        rememberChangedField("ProductTaxClassification7", this.productTaxClassification7);
        this.productTaxClassification7 = productTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification8</b>
     * </p>
     *
     * @param productTaxClassification8
     *            Tax Classification for Material
     */
    public void setProductTaxClassification8( @Nullable final String productTaxClassification8 )
    {
        rememberChangedField("ProductTaxClassification8", this.productTaxClassification8);
        this.productTaxClassification8 = productTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>ProductTaxClassification9</b>
     * </p>
     *
     * @param productTaxClassification9
     *            Tax Classification for Material
     */
    public void setProductTaxClassification9( @Nullable final String productTaxClassification9 )
    {
        rememberChangedField("ProductTaxClassification9", this.productTaxClassification9);
        this.productTaxClassification9 = productTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @param referenceSDDocumentItem
     *            Item Number of the Reference Item
     */
    public void setReferenceSDDocumentItem( @Nullable final String referenceSDDocumentItem )
    {
        rememberChangedField("ReferenceSDDocumentItem", this.referenceSDDocumentItem);
        this.referenceSDDocumentItem = referenceSDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     */
    public void setSalesDocumentRjcnReason( @Nullable final String salesDocumentRjcnReason )
    {
        rememberChangedField("SalesDocumentRjcnReason", this.salesDocumentRjcnReason);
        this.salesDocumentRjcnReason = salesDocumentRjcnReason;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderItemSimulation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        result.put("SalesOrderItem", getSalesOrderItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("HigherLevelItem", getHigherLevelItem());
        values.put("HigherLevelItemUsage", getHigherLevelItemUsage());
        values.put("SalesOrderItemCategory", getSalesOrderItemCategory());
        values.put("SalesOrderItemText", getSalesOrderItemText());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("PricingDate", getPricingDate());
        values.put("PricingReferenceMaterial", getPricingReferenceMaterial());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("RequestedQuantityUnit", getRequestedQuantityUnit());
        values.put("RequestedQuantitySAPUnit", getRequestedQuantitySAPUnit());
        values.put("RequestedQuantityISOUnit", getRequestedQuantityISOUnit());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("OrderQuantitySAPUnit", getOrderQuantitySAPUnit());
        values.put("OrderQuantityISOUnit", getOrderQuantityISOUnit());
        values.put("ConfdDelivQtyInOrderQtyUnit", getConfdDelivQtyInOrderQtyUnit());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("ItemWeightSAPUnit", getItemWeightSAPUnit());
        values.put("ItemWeightISOUnit", getItemWeightISOUnit());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("ItemVolumeSAPUnit", getItemVolumeSAPUnit());
        values.put("ItemVolumeISOUnit", getItemVolumeISOUnit());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("NetAmount", getNetAmount());
        values.put("TaxAmount", getTaxAmount());
        values.put("CostAmount", getCostAmount());
        values.put("Subtotal1Amount", getSubtotal1Amount());
        values.put("Subtotal2Amount", getSubtotal2Amount());
        values.put("Subtotal3Amount", getSubtotal3Amount());
        values.put("Subtotal4Amount", getSubtotal4Amount());
        values.put("Subtotal5Amount", getSubtotal5Amount());
        values.put("Subtotal6Amount", getSubtotal6Amount());
        values.put("MaterialSubstitutionReason", getMaterialSubstitutionReason());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialPricingGroup", getMaterialPricingGroup());
        values.put("Batch", getBatch());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("DeliveryGroup", getDeliveryGroup());
        values.put("ShippingPoint", getShippingPoint());
        values.put("ShippingType", getShippingType());
        values.put("DeliveryPriority", getDeliveryPriority());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("ProductTaxClassification1", getProductTaxClassification1());
        values.put("ProductTaxClassification2", getProductTaxClassification2());
        values.put("ProductTaxClassification3", getProductTaxClassification3());
        values.put("ProductTaxClassification4", getProductTaxClassification4());
        values.put("ProductTaxClassification5", getProductTaxClassification5());
        values.put("ProductTaxClassification6", getProductTaxClassification6());
        values.put("ProductTaxClassification7", getProductTaxClassification7());
        values.put("ProductTaxClassification8", getProductTaxClassification8());
        values.put("ProductTaxClassification9", getProductTaxClassification9());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentItem", getReferenceSDDocumentItem());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItem") ) {
                final Object value = values.remove("HigherLevelItem");
                if( (value == null) || (!value.equals(getHigherLevelItem())) ) {
                    setHigherLevelItem(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItemUsage") ) {
                final Object value = values.remove("HigherLevelItemUsage");
                if( (value == null) || (!value.equals(getHigherLevelItemUsage())) ) {
                    setHigherLevelItemUsage(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItemCategory") ) {
                final Object value = values.remove("SalesOrderItemCategory");
                if( (value == null) || (!value.equals(getSalesOrderItemCategory())) ) {
                    setSalesOrderItemCategory(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItemText") ) {
                final Object value = values.remove("SalesOrderItemText");
                if( (value == null) || (!value.equals(getSalesOrderItemText())) ) {
                    setSalesOrderItemText(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("PricingReferenceMaterial") ) {
                final Object value = values.remove("PricingReferenceMaterial");
                if( (value == null) || (!value.equals(getPricingReferenceMaterial())) ) {
                    setPricingReferenceMaterial(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RequestedQuantityUnit") ) {
                final Object value = values.remove("RequestedQuantityUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityUnit())) ) {
                    setRequestedQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantitySAPUnit") ) {
                final Object value = values.remove("RequestedQuantitySAPUnit");
                if( (value == null) || (!value.equals(getRequestedQuantitySAPUnit())) ) {
                    setRequestedQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantityISOUnit") ) {
                final Object value = values.remove("RequestedQuantityISOUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityISOUnit())) ) {
                    setRequestedQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantitySAPUnit") ) {
                final Object value = values.remove("OrderQuantitySAPUnit");
                if( (value == null) || (!value.equals(getOrderQuantitySAPUnit())) ) {
                    setOrderQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityISOUnit") ) {
                final Object value = values.remove("OrderQuantityISOUnit");
                if( (value == null) || (!value.equals(getOrderQuantityISOUnit())) ) {
                    setOrderQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("ConfdDelivQtyInOrderQtyUnit") ) {
                final Object value = values.remove("ConfdDelivQtyInOrderQtyUnit");
                if( (value == null) || (!value.equals(getConfdDelivQtyInOrderQtyUnit())) ) {
                    setConfdDelivQtyInOrderQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightSAPUnit") ) {
                final Object value = values.remove("ItemWeightSAPUnit");
                if( (value == null) || (!value.equals(getItemWeightSAPUnit())) ) {
                    setItemWeightSAPUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightISOUnit") ) {
                final Object value = values.remove("ItemWeightISOUnit");
                if( (value == null) || (!value.equals(getItemWeightISOUnit())) ) {
                    setItemWeightISOUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolumeSAPUnit") ) {
                final Object value = values.remove("ItemVolumeSAPUnit");
                if( (value == null) || (!value.equals(getItemVolumeSAPUnit())) ) {
                    setItemVolumeSAPUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolumeISOUnit") ) {
                final Object value = values.remove("ItemVolumeISOUnit");
                if( (value == null) || (!value.equals(getItemVolumeISOUnit())) ) {
                    setItemVolumeISOUnit(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TaxAmount") ) {
                final Object value = values.remove("TaxAmount");
                if( (value == null) || (!value.equals(getTaxAmount())) ) {
                    setTaxAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CostAmount") ) {
                final Object value = values.remove("CostAmount");
                if( (value == null) || (!value.equals(getCostAmount())) ) {
                    setCostAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal1Amount") ) {
                final Object value = values.remove("Subtotal1Amount");
                if( (value == null) || (!value.equals(getSubtotal1Amount())) ) {
                    setSubtotal1Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal2Amount") ) {
                final Object value = values.remove("Subtotal2Amount");
                if( (value == null) || (!value.equals(getSubtotal2Amount())) ) {
                    setSubtotal2Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal3Amount") ) {
                final Object value = values.remove("Subtotal3Amount");
                if( (value == null) || (!value.equals(getSubtotal3Amount())) ) {
                    setSubtotal3Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal4Amount") ) {
                final Object value = values.remove("Subtotal4Amount");
                if( (value == null) || (!value.equals(getSubtotal4Amount())) ) {
                    setSubtotal4Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal5Amount") ) {
                final Object value = values.remove("Subtotal5Amount");
                if( (value == null) || (!value.equals(getSubtotal5Amount())) ) {
                    setSubtotal5Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Subtotal6Amount") ) {
                final Object value = values.remove("Subtotal6Amount");
                if( (value == null) || (!value.equals(getSubtotal6Amount())) ) {
                    setSubtotal6Amount(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialSubstitutionReason") ) {
                final Object value = values.remove("MaterialSubstitutionReason");
                if( (value == null) || (!value.equals(getMaterialSubstitutionReason())) ) {
                    setMaterialSubstitutionReason(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialPricingGroup") ) {
                final Object value = values.remove("MaterialPricingGroup");
                if( (value == null) || (!value.equals(getMaterialPricingGroup())) ) {
                    setMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("DeliveryGroup") ) {
                final Object value = values.remove("DeliveryGroup");
                if( (value == null) || (!value.equals(getDeliveryGroup())) ) {
                    setDeliveryGroup(((String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("DeliveryPriority") ) {
                final Object value = values.remove("DeliveryPriority");
                if( (value == null) || (!value.equals(getDeliveryPriority())) ) {
                    setDeliveryPriority(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification1") ) {
                final Object value = values.remove("ProductTaxClassification1");
                if( (value == null) || (!value.equals(getProductTaxClassification1())) ) {
                    setProductTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification2") ) {
                final Object value = values.remove("ProductTaxClassification2");
                if( (value == null) || (!value.equals(getProductTaxClassification2())) ) {
                    setProductTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification3") ) {
                final Object value = values.remove("ProductTaxClassification3");
                if( (value == null) || (!value.equals(getProductTaxClassification3())) ) {
                    setProductTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification4") ) {
                final Object value = values.remove("ProductTaxClassification4");
                if( (value == null) || (!value.equals(getProductTaxClassification4())) ) {
                    setProductTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification5") ) {
                final Object value = values.remove("ProductTaxClassification5");
                if( (value == null) || (!value.equals(getProductTaxClassification5())) ) {
                    setProductTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification6") ) {
                final Object value = values.remove("ProductTaxClassification6");
                if( (value == null) || (!value.equals(getProductTaxClassification6())) ) {
                    setProductTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification7") ) {
                final Object value = values.remove("ProductTaxClassification7");
                if( (value == null) || (!value.equals(getProductTaxClassification7())) ) {
                    setProductTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification8") ) {
                final Object value = values.remove("ProductTaxClassification8");
                if( (value == null) || (!value.equals(getProductTaxClassification8())) ) {
                    setProductTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("ProductTaxClassification9") ) {
                final Object value = values.remove("ProductTaxClassification9");
                if( (value == null) || (!value.equals(getProductTaxClassification9())) ) {
                    setProductTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentItem") ) {
                final Object value = values.remove("ReferenceSDDocumentItem");
                if( (value == null) || (!value.equals(getReferenceSDDocumentItem())) ) {
                    setReferenceSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentRjcnReason") ) {
                final Object value = values.remove("SalesDocumentRjcnReason");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason())) ) {
                    setSalesDocumentRjcnReason(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItemPartnerSimln entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SalesOrderItemPartnerSimln();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItmPrcgElmntSimln entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new SalesOrderItmPrcgElmntSimln();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Map ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = new SalesOrderSimulation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ScheduleLine") ) {
                final Object value = (values).remove("to_ScheduleLine");
                if( value instanceof Iterable ) {
                    if( toScheduleLine == null ) {
                        toScheduleLine = Lists.newArrayList();
                    } else {
                        toScheduleLine = Lists.newArrayList(toScheduleLine);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderScheduleLineSimln entity;
                        if( toScheduleLine.size() > i ) {
                            entity = toScheduleLine.get(i);
                        } else {
                            entity = new SalesOrderScheduleLineSimln();
                            toScheduleLine.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrderItemSimulationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderItemSimulationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderItemSimulationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderItemSimulationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderSimulateService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        if( toScheduleLine != null ) {
            (values).put("to_ScheduleLine", toScheduleLine);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderItemPartnerSimln</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItemPartnerSimln</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemPartnerSimln> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SalesOrderItemPartnerSimln.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItemPartnerSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderItemSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItemPartnerSimln</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemPartnerSimln> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SalesOrderItemPartnerSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItemSimulation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SalesOrderItemPartnerSimln</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderItemPartnerSimln>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItemPartnerSimln</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderItemSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItemPartnerSimln</b> entities.
     */
    public void setPartner( @Nonnull final List<SalesOrderItemPartnerSimln> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItemPartnerSimln</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderItemSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItemPartnerSimln</b> entities.
     */
    public void addPartner( SalesOrderItemPartnerSimln... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderItmPrcgElmntSimln</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItmPrcgElmntSimln</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItmPrcgElmntSimln> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", SalesOrderItmPrcgElmntSimln.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItmPrcgElmntSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrderItemSimulation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItmPrcgElmntSimln</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItmPrcgElmntSimln> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>SalesOrderItmPrcgElmntSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItemSimulation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>SalesOrderItmPrcgElmntSimln</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderItmPrcgElmntSimln>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItmPrcgElmntSimln</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrderItemSimulation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItmPrcgElmntSimln</b> entities.
     */
    public void setPricingElement( @Nonnull final List<SalesOrderItmPrcgElmntSimln> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItmPrcgElmntSimln</b> entities. This corresponds to the
     * OData navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrderItemSimulation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItmPrcgElmntSimln</b> entities.
     */
    public void addPricingElement( SalesOrderItmPrcgElmntSimln... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderSimulation</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderSimulation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderSimulation fetchSalesOrder()
    {
        return fetchFieldAsSingle("to_SalesOrder", SalesOrderSimulation.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderSimulation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>SalesOrderItemSimulation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderSimulation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderSimulation getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>SalesOrderSimulation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItemSimulation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>SalesOrderSimulation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderSimulation> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the associated <b>SalesOrderSimulation</b> entity for the loaded navigation property
     * <b>to_SalesOrder</b>.
     *
     * @param value
     *            New <b>SalesOrderSimulation</b> entity.
     */
    public void setSalesOrder( final SalesOrderSimulation value )
    {
        toSalesOrder = value;
    }

    /**
     * Fetches the <b>SalesOrderScheduleLineSimln</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_ScheduleLine</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderScheduleLineSimln</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderScheduleLineSimln> fetchScheduleLine()
    {
        return fetchFieldAsList("to_ScheduleLine", SalesOrderScheduleLineSimln.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderScheduleLineSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>SalesOrderItemSimulation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderScheduleLineSimln</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderScheduleLineSimln> getScheduleLineOrFetch()
    {
        if( toScheduleLine == null ) {
            toScheduleLine = fetchScheduleLine();
        }
        return toScheduleLine;
    }

    /**
     * Retrieval of associated <b>SalesOrderScheduleLineSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderItemSimulation</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ScheduleLine</b> is already loaded, the result will
     *         contain the <b>SalesOrderScheduleLineSimln</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderScheduleLineSimln>> getScheduleLineIfPresent()
    {
        return Option.of(toScheduleLine);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderScheduleLineSimln</b> entities for the loaded navigation property
     * <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>SalesOrderItemSimulation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderScheduleLineSimln</b> entities.
     */
    public void setScheduleLine( @Nonnull final List<SalesOrderScheduleLineSimln> value )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.clear();
        toScheduleLine.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderScheduleLineSimln</b> entities. This corresponds to the
     * OData navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>SalesOrderItemSimulation</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderScheduleLineSimln</b> entities.
     */
    public void addScheduleLine( SalesOrderScheduleLineSimln... entity )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderItemSimulation instances.
     *
     */
    public final static class SalesOrderItemSimulationBuilder
    {

        private List<SalesOrderItemPartnerSimln> toPartner = Lists.newArrayList();
        private List<SalesOrderItmPrcgElmntSimln> toPricingElement = Lists.newArrayList();
        private SalesOrderSimulation toSalesOrder;
        private String salesOrder = null;
        private List<SalesOrderScheduleLineSimln> toScheduleLine = Lists.newArrayList();

        private SalesOrderItemSimulation.SalesOrderItemSimulationBuilder toPartner(
            final List<SalesOrderItemPartnerSimln> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>SalesOrderItemSimulation</b> to multiple
         * <b>SalesOrderItemPartnerSimln</b>.
         *
         * @param value
         *            The SalesOrderItemPartnerSimlns to build this SalesOrderItemSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemSimulation.SalesOrderItemSimulationBuilder partner( SalesOrderItemPartnerSimln... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private SalesOrderItemSimulation.SalesOrderItemSimulationBuilder toPricingElement(
            final List<SalesOrderItmPrcgElmntSimln> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>SalesOrderItemSimulation</b> to multiple
         * <b>SalesOrderItmPrcgElmntSimln</b>.
         *
         * @param value
         *            The SalesOrderItmPrcgElmntSimlns to build this SalesOrderItemSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemSimulation.SalesOrderItemSimulationBuilder pricingElement(
            SalesOrderItmPrcgElmntSimln... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

        private SalesOrderItemSimulation.SalesOrderItemSimulationBuilder toSalesOrder(
            final SalesOrderSimulation value )
        {
            toSalesOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderItemSimulation</b> to single
         * <b>SalesOrderSimulation</b>.
         *
         * @param value
         *            The SalesOrderSimulation to build this SalesOrderItemSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemSimulation.SalesOrderItemSimulationBuilder salesOrder( final SalesOrderSimulation value )
        {
            return toSalesOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrder</b>
         * </p>
         *
         * @param value
         *            The salesOrder to build this SalesOrderItemSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemSimulation.SalesOrderItemSimulationBuilder salesOrder( final String value )
        {
            salesOrder = value;
            return this;
        }

        private SalesOrderItemSimulation.SalesOrderItemSimulationBuilder toScheduleLine(
            final List<SalesOrderScheduleLineSimln> value )
        {
            toScheduleLine.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ScheduleLine</b> for <b>SalesOrderItemSimulation</b> to multiple
         * <b>SalesOrderScheduleLineSimln</b>.
         *
         * @param value
         *            The SalesOrderScheduleLineSimlns to build this SalesOrderItemSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderItemSimulation.SalesOrderItemSimulationBuilder scheduleLine(
            SalesOrderScheduleLineSimln... value )
        {
            return toScheduleLine(Lists.newArrayList(value));
        }

    }

}
