/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.field.SalesOrderScheduleLineSimlnField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.link.SalesOrderScheduleLineSimlnOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.selectable.SalesOrderScheduleLineSimlnSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Order Schedule Line Sim (API)
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderScheduleLineSimlnType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderScheduleLineSimln extends VdmEntity<SalesOrderScheduleLineSimln>
{

    /**
     * Selector for all available fields of SalesOrderScheduleLineSimln.
     *
     */
    public final static SalesOrderScheduleLineSimlnSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Document
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<String> SALES_ORDER =
        new SalesOrderScheduleLineSimlnField<String>("SalesOrder");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @Key
    @SerializedName( "SalesOrderItem" )
    @JsonProperty( "SalesOrderItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderItem" )
    private String salesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderItem</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<String> SALES_ORDER_ITEM =
        new SalesOrderScheduleLineSimlnField<String>("SalesOrderItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Schedule Line Number
     */
    @Key
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<String> SCHEDULE_LINE =
        new SalesOrderScheduleLineSimlnField<String>("ScheduleLine");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @return Requested Delivery Date
     */
    @SerializedName( "RequestedDeliveryDate" )
    @JsonProperty( "RequestedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requestedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryDate</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<LocalDateTime> REQUESTED_DELIVERY_DATE =
        new SalesOrderScheduleLineSimlnField<LocalDateTime>("RequestedDeliveryDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedDeliveryDate</b>
     * </p>
     *
     * @return Confirmed Delivery Date
     */
    @SerializedName( "ConfirmedDeliveryDate" )
    @JsonProperty( "ConfirmedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ConfirmedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime confirmedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>ConfirmedDeliveryDate</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<LocalDateTime> CONFIRMED_DELIVERY_DATE =
        new SalesOrderScheduleLineSimlnField<LocalDateTime>("ConfirmedDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<String> ORDER_QUANTITY_UNIT =
        new SalesOrderScheduleLineSimlnField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantitySAPUnit" )
    @JsonProperty( "OrderQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantitySAPUnit" )
    private String orderQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<String> ORDER_QUANTITY_SAP_UNIT =
        new SalesOrderScheduleLineSimlnField<String>("OrderQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Order Quantity
     */
    @SerializedName( "OrderQuantityISOUnit" )
    @JsonProperty( "OrderQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityISOUnit" )
    private String orderQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<String> ORDER_QUANTITY_ISO_UNIT =
        new SalesOrderScheduleLineSimlnField<String>("OrderQuantityISOUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @return Order Quantity in Sales Units
     */
    @SerializedName( "ScheduleLineOrderQuantity" )
    @JsonProperty( "ScheduleLineOrderQuantity" )
    @Nullable
    @ODataField( odataName = "ScheduleLineOrderQuantity" )
    private BigDecimal scheduleLineOrderQuantity;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLineOrderQuantity</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<BigDecimal> SCHEDULE_LINE_ORDER_QUANTITY =
        new SalesOrderScheduleLineSimlnField<BigDecimal>("ScheduleLineOrderQuantity");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdOrderQtyByMatlAvailCheck</b>
     * </p>
     *
     * @return Confirmed Quantity
     */
    @SerializedName( "ConfdOrderQtyByMatlAvailCheck" )
    @JsonProperty( "ConfdOrderQtyByMatlAvailCheck" )
    @Nullable
    @ODataField( odataName = "ConfdOrderQtyByMatlAvailCheck" )
    private BigDecimal confdOrderQtyByMatlAvailCheck;
    /**
     * Use with available fluent helpers to apply the <b>ConfdOrderQtyByMatlAvailCheck</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<BigDecimal> CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK =
        new SalesOrderScheduleLineSimlnField<BigDecimal>("ConfdOrderQtyByMatlAvailCheck");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpenConfdDelivQtyInOrdQtyUnit</b>
     * </p>
     *
     * @return Open Confirmed Delivery Quantity
     */
    @SerializedName( "OpenConfdDelivQtyInOrdQtyUnit" )
    @JsonProperty( "OpenConfdDelivQtyInOrdQtyUnit" )
    @Nullable
    @ODataField( odataName = "OpenConfdDelivQtyInOrdQtyUnit" )
    private BigDecimal openConfdDelivQtyInOrdQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>OpenConfdDelivQtyInOrdQtyUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<BigDecimal> OPEN_CONFD_DELIV_QTY_IN_ORD_QTY_UNIT =
        new SalesOrderScheduleLineSimlnField<BigDecimal>("OpenConfdDelivQtyInOrdQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CorrectedQtyInOrderQtyUnit</b>
     * </p>
     *
     * @return Corrected quantity in sales unit
     */
    @SerializedName( "CorrectedQtyInOrderQtyUnit" )
    @JsonProperty( "CorrectedQtyInOrderQtyUnit" )
    @Nullable
    @ODataField( odataName = "CorrectedQtyInOrderQtyUnit" )
    private BigDecimal correctedQtyInOrderQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>CorrectedQtyInOrderQtyUnit</b> field to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnField<BigDecimal> CORRECTED_QTY_IN_ORDER_QTY_UNIT =
        new SalesOrderScheduleLineSimlnField<BigDecimal>("CorrectedQtyInOrderQtyUnit");
    /**
     * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderScheduleLineSimln</b> to single
     * <b>SalesOrderSimulation</b>.
     *
     */
    @SerializedName( "to_SalesOrder" )
    @JsonProperty( "to_SalesOrder" )
    @ODataField( odataName = "to_SalesOrder" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderSimulation toSalesOrder;
    /**
     * Navigation property <b>to_SalesOrderItem</b> for <b>SalesOrderScheduleLineSimln</b> to single
     * <b>SalesOrderItemSimulation</b>.
     *
     */
    @SerializedName( "to_SalesOrderItem" )
    @JsonProperty( "to_SalesOrderItem" )
    @ODataField( odataName = "to_SalesOrderItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderItemSimulation toSalesOrderItem;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrder</b> navigation property to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnOneToOneLink<SalesOrderSimulation> TO_SALES_ORDER =
        new SalesOrderScheduleLineSimlnOneToOneLink<SalesOrderSimulation>("to_SalesOrder");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrderItem</b> navigation property to query operations.
     *
     */
    public final static SalesOrderScheduleLineSimlnOneToOneLink<SalesOrderItemSimulation> TO_SALES_ORDER_ITEM =
        new SalesOrderScheduleLineSimlnOneToOneLink<SalesOrderItemSimulation>("to_SalesOrderItem");

    @Nonnull
    @Override
    public Class<SalesOrderScheduleLineSimln> getType()
    {
        return SalesOrderScheduleLineSimln.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Document
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderItem</b>
     * </p>
     *
     * @param salesOrderItem
     *            Sales Document Item
     */
    public void setSalesOrderItem( @Nullable final String salesOrderItem )
    {
        rememberChangedField("SalesOrderItem", this.salesOrderItem);
        this.salesOrderItem = salesOrderItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Schedule Line Number
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @param requestedDeliveryDate
     *            Requested Delivery Date
     */
    public void setRequestedDeliveryDate( @Nullable final LocalDateTime requestedDeliveryDate )
    {
        rememberChangedField("RequestedDeliveryDate", this.requestedDeliveryDate);
        this.requestedDeliveryDate = requestedDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ConfirmedDeliveryDate</b>
     * </p>
     *
     * @param confirmedDeliveryDate
     *            Confirmed Delivery Date
     */
    public void setConfirmedDeliveryDate( @Nullable final LocalDateTime confirmedDeliveryDate )
    {
        rememberChangedField("ConfirmedDeliveryDate", this.confirmedDeliveryDate);
        this.confirmedDeliveryDate = confirmedDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantitySAPUnit</b>
     * </p>
     *
     * @param orderQuantitySAPUnit
     *            SAP Unit Code for Order Quantity
     */
    public void setOrderQuantitySAPUnit( @Nullable final String orderQuantitySAPUnit )
    {
        rememberChangedField("OrderQuantitySAPUnit", this.orderQuantitySAPUnit);
        this.orderQuantitySAPUnit = orderQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityISOUnit</b>
     * </p>
     *
     * @param orderQuantityISOUnit
     *            ISO Unit Code for Order Quantity
     */
    public void setOrderQuantityISOUnit( @Nullable final String orderQuantityISOUnit )
    {
        rememberChangedField("OrderQuantityISOUnit", this.orderQuantityISOUnit);
        this.orderQuantityISOUnit = orderQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLineOrderQuantity</b>
     * </p>
     *
     * @param scheduleLineOrderQuantity
     *            Order Quantity in Sales Units
     */
    public void setScheduleLineOrderQuantity( @Nullable final BigDecimal scheduleLineOrderQuantity )
    {
        rememberChangedField("ScheduleLineOrderQuantity", this.scheduleLineOrderQuantity);
        this.scheduleLineOrderQuantity = scheduleLineOrderQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdOrderQtyByMatlAvailCheck</b>
     * </p>
     *
     * @param confdOrderQtyByMatlAvailCheck
     *            Confirmed Quantity
     */
    public void setConfdOrderQtyByMatlAvailCheck( @Nullable final BigDecimal confdOrderQtyByMatlAvailCheck )
    {
        rememberChangedField("ConfdOrderQtyByMatlAvailCheck", this.confdOrderQtyByMatlAvailCheck);
        this.confdOrderQtyByMatlAvailCheck = confdOrderQtyByMatlAvailCheck;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpenConfdDelivQtyInOrdQtyUnit</b>
     * </p>
     *
     * @param openConfdDelivQtyInOrdQtyUnit
     *            Open Confirmed Delivery Quantity
     */
    public void setOpenConfdDelivQtyInOrdQtyUnit( @Nullable final BigDecimal openConfdDelivQtyInOrdQtyUnit )
    {
        rememberChangedField("OpenConfdDelivQtyInOrdQtyUnit", this.openConfdDelivQtyInOrdQtyUnit);
        this.openConfdDelivQtyInOrdQtyUnit = openConfdDelivQtyInOrdQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CorrectedQtyInOrderQtyUnit</b>
     * </p>
     *
     * @param correctedQtyInOrderQtyUnit
     *            Corrected quantity in sales unit
     */
    public void setCorrectedQtyInOrderQtyUnit( @Nullable final BigDecimal correctedQtyInOrderQtyUnit )
    {
        rememberChangedField("CorrectedQtyInOrderQtyUnit", this.correctedQtyInOrderQtyUnit);
        this.correctedQtyInOrderQtyUnit = correctedQtyInOrderQtyUnit;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderScheduleLineSimln";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        result.put("SalesOrderItem", getSalesOrderItem());
        result.put("ScheduleLine", getScheduleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderItem", getSalesOrderItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("RequestedDeliveryDate", getRequestedDeliveryDate());
        values.put("ConfirmedDeliveryDate", getConfirmedDeliveryDate());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("OrderQuantitySAPUnit", getOrderQuantitySAPUnit());
        values.put("OrderQuantityISOUnit", getOrderQuantityISOUnit());
        values.put("ScheduleLineOrderQuantity", getScheduleLineOrderQuantity());
        values.put("ConfdOrderQtyByMatlAvailCheck", getConfdOrderQtyByMatlAvailCheck());
        values.put("OpenConfdDelivQtyInOrdQtyUnit", getOpenConfdDelivQtyInOrdQtyUnit());
        values.put("CorrectedQtyInOrderQtyUnit", getCorrectedQtyInOrderQtyUnit());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderItem") ) {
                final Object value = values.remove("SalesOrderItem");
                if( (value == null) || (!value.equals(getSalesOrderItem())) ) {
                    setSalesOrderItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("RequestedDeliveryDate") ) {
                final Object value = values.remove("RequestedDeliveryDate");
                if( (value == null) || (!value.equals(getRequestedDeliveryDate())) ) {
                    setRequestedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ConfirmedDeliveryDate") ) {
                final Object value = values.remove("ConfirmedDeliveryDate");
                if( (value == null) || (!value.equals(getConfirmedDeliveryDate())) ) {
                    setConfirmedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantitySAPUnit") ) {
                final Object value = values.remove("OrderQuantitySAPUnit");
                if( (value == null) || (!value.equals(getOrderQuantitySAPUnit())) ) {
                    setOrderQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityISOUnit") ) {
                final Object value = values.remove("OrderQuantityISOUnit");
                if( (value == null) || (!value.equals(getOrderQuantityISOUnit())) ) {
                    setOrderQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("ScheduleLineOrderQuantity") ) {
                final Object value = values.remove("ScheduleLineOrderQuantity");
                if( (value == null) || (!value.equals(getScheduleLineOrderQuantity())) ) {
                    setScheduleLineOrderQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("ConfdOrderQtyByMatlAvailCheck") ) {
                final Object value = values.remove("ConfdOrderQtyByMatlAvailCheck");
                if( (value == null) || (!value.equals(getConfdOrderQtyByMatlAvailCheck())) ) {
                    setConfdOrderQtyByMatlAvailCheck(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpenConfdDelivQtyInOrdQtyUnit") ) {
                final Object value = values.remove("OpenConfdDelivQtyInOrdQtyUnit");
                if( (value == null) || (!value.equals(getOpenConfdDelivQtyInOrdQtyUnit())) ) {
                    setOpenConfdDelivQtyInOrdQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("CorrectedQtyInOrderQtyUnit") ) {
                final Object value = values.remove("CorrectedQtyInOrderQtyUnit");
                if( (value == null) || (!value.equals(getCorrectedQtyInOrderQtyUnit())) ) {
                    setCorrectedQtyInOrderQtyUnit(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesOrder") ) {
                final Object value = (values).remove("to_SalesOrder");
                if( value instanceof Map ) {
                    if( toSalesOrder == null ) {
                        toSalesOrder = new SalesOrderSimulation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrder.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesOrderItem") ) {
                final Object value = (values).remove("to_SalesOrderItem");
                if( value instanceof Map ) {
                    if( toSalesOrderItem == null ) {
                        toSalesOrderItem = new SalesOrderItemSimulation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrderItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SalesOrderScheduleLineSimlnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderScheduleLineSimlnField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderScheduleLineSimlnField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderScheduleLineSimlnField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderSimulateService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesOrder != null ) {
            (values).put("to_SalesOrder", toSalesOrder);
        }
        if( toSalesOrderItem != null ) {
            (values).put("to_SalesOrderItem", toSalesOrderItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderSimulation</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SalesOrder</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderSimulation</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderSimulation fetchSalesOrder()
    {
        return fetchFieldAsSingle("to_SalesOrder", SalesOrderSimulation.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderSimulation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property <b>to_SalesOrder</b> of a queried <b>SalesOrderScheduleLineSimln</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderSimulation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderSimulation getSalesOrderOrFetch()
    {
        if( toSalesOrder == null ) {
            toSalesOrder = fetchSalesOrder();
        }
        return toSalesOrder;
    }

    /**
     * Retrieval of associated <b>SalesOrderSimulation</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_SalesOrder</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderScheduleLineSimln</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrder</b> is already loaded, the result will
     *         contain the <b>SalesOrderSimulation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderSimulation> getSalesOrderIfPresent()
    {
        return Option.of(toSalesOrder);
    }

    /**
     * Overwrites the associated <b>SalesOrderSimulation</b> entity for the loaded navigation property
     * <b>to_SalesOrder</b>.
     *
     * @param value
     *            New <b>SalesOrderSimulation</b> entity.
     */
    public void setSalesOrder( final SalesOrderSimulation value )
    {
        toSalesOrder = value;
    }

    /**
     * Fetches the <b>SalesOrderItemSimulation</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SalesOrderItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderItemSimulation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderItemSimulation fetchSalesOrderItem()
    {
        return fetchFieldAsSingle("to_SalesOrderItem", SalesOrderItemSimulation.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItemSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderItem</b>.
     * <p>
     * If the navigation property <b>to_SalesOrderItem</b> of a queried <b>SalesOrderScheduleLineSimln</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItemSimulation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderItemSimulation getSalesOrderItemOrFetch()
    {
        if( toSalesOrderItem == null ) {
            toSalesOrderItem = fetchSalesOrderItem();
        }
        return toSalesOrderItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderItemSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderItem</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderScheduleLineSimln</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrderItem</b> is already loaded, the result will
     *         contain the <b>SalesOrderItemSimulation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderItemSimulation> getSalesOrderItemIfPresent()
    {
        return Option.of(toSalesOrderItem);
    }

    /**
     * Overwrites the associated <b>SalesOrderItemSimulation</b> entity for the loaded navigation property
     * <b>to_SalesOrderItem</b>.
     *
     * @param value
     *            New <b>SalesOrderItemSimulation</b> entity.
     */
    public void setSalesOrderItem( final SalesOrderItemSimulation value )
    {
        toSalesOrderItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderScheduleLineSimln instances.
     *
     */
    public final static class SalesOrderScheduleLineSimlnBuilder
    {

        private SalesOrderSimulation toSalesOrder;
        private String salesOrder = null;
        private SalesOrderItemSimulation toSalesOrderItem;
        private String salesOrderItem = null;

        private SalesOrderScheduleLineSimln.SalesOrderScheduleLineSimlnBuilder toSalesOrder(
            final SalesOrderSimulation value )
        {
            toSalesOrder = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrder</b> for <b>SalesOrderScheduleLineSimln</b> to single
         * <b>SalesOrderSimulation</b>.
         *
         * @param value
         *            The SalesOrderSimulation to build this SalesOrderScheduleLineSimln with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderScheduleLineSimln.SalesOrderScheduleLineSimlnBuilder salesOrder(
            final SalesOrderSimulation value )
        {
            return toSalesOrder(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrder</b>
         * </p>
         *
         * @param value
         *            The salesOrder to build this SalesOrderScheduleLineSimln with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderScheduleLineSimln.SalesOrderScheduleLineSimlnBuilder salesOrder( final String value )
        {
            salesOrder = value;
            return this;
        }

        private SalesOrderScheduleLineSimln.SalesOrderScheduleLineSimlnBuilder toSalesOrderItem(
            final SalesOrderItemSimulation value )
        {
            toSalesOrderItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrderItem</b> for <b>SalesOrderScheduleLineSimln</b> to single
         * <b>SalesOrderItemSimulation</b>.
         *
         * @param value
         *            The SalesOrderItemSimulation to build this SalesOrderScheduleLineSimln with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderScheduleLineSimln.SalesOrderScheduleLineSimlnBuilder salesOrderItem(
            final SalesOrderItemSimulation value )
        {
            return toSalesOrderItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrderItem</b>
         * </p>
         *
         * @param value
         *            The salesOrderItem to build this SalesOrderScheduleLineSimln with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderScheduleLineSimln.SalesOrderScheduleLineSimlnBuilder salesOrderItem( final String value )
        {
            salesOrderItem = value;
            return this;
        }

    }

}
