/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.field.SalesOrderSimulationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.link.SalesOrderSimulationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.link.SalesOrderSimulationOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.selectable.SalesOrderSimulationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Order Simulation
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderSimulationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderSimulation extends VdmEntity<SalesOrderSimulation>
{

    /**
     * Selector for all available fields of SalesOrderSimulation.
     *
     */
    public final static SalesOrderSimulationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @return Sales Order
     */
    @Key
    @SerializedName( "SalesOrder" )
    @JsonProperty( "SalesOrder" )
    @Nullable
    @ODataField( odataName = "SalesOrder" )
    private String salesOrder;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrder</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SALES_ORDER =
        new SalesOrderSimulationField<String>("SalesOrder");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderType</b>
     * </p>
     *
     * @return Sales Order Type
     */
    @SerializedName( "SalesOrderType" )
    @JsonProperty( "SalesOrderType" )
    @Nullable
    @ODataField( odataName = "SalesOrderType" )
    private String salesOrderType;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderType</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SALES_ORDER_TYPE =
        new SalesOrderSimulationField<String>("SalesOrderType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SALES_ORGANIZATION =
        new SalesOrderSimulationField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> DISTRIBUTION_CHANNEL =
        new SalesOrderSimulationField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> ORGANIZATION_DIVISION =
        new SalesOrderSimulationField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SALES_GROUP =
        new SalesOrderSimulationField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SALES_OFFICE =
        new SalesOrderSimulationField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SALES_DISTRICT =
        new SalesOrderSimulationField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SOLD_TO_PARTY =
        new SalesOrderSimulationField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new SalesOrderSimulationField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderType</b>
     * </p>
     *
     * @return Customer Purchase Order Type
     */
    @SerializedName( "CustomerPurchaseOrderType" )
    @JsonProperty( "CustomerPurchaseOrderType" )
    @Nullable
    @ODataField( odataName = "CustomerPurchaseOrderType" )
    private String customerPurchaseOrderType;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderType</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_PURCHASE_ORDER_TYPE =
        new SalesOrderSimulationField<String>("CustomerPurchaseOrderType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @return Customer Reference Date
     */
    @SerializedName( "CustomerPurchaseOrderDate" )
    @JsonProperty( "CustomerPurchaseOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CustomerPurchaseOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime customerPurchaseOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderDate</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<LocalDateTime> CUSTOMER_PURCHASE_ORDER_DATE =
        new SalesOrderSimulationField<LocalDateTime>("CustomerPurchaseOrderDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderDate</b>
     * </p>
     *
     * @return Document Date (Date Received/Sent)
     */
    @SerializedName( "SalesOrderDate" )
    @JsonProperty( "SalesOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SalesOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime salesOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderDate</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<LocalDateTime> SALES_ORDER_DATE =
        new SalesOrderSimulationField<LocalDateTime>("SalesOrderDate");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> TRANSACTION_CURRENCY =
        new SalesOrderSimulationField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocExternalReference</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "AccountingDocExternalReference" )
    @JsonProperty( "AccountingDocExternalReference" )
    @Nullable
    @ODataField( odataName = "AccountingDocExternalReference" )
    private String accountingDocExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocExternalReference</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> ACCOUNTING_DOC_EXTERNAL_REFERENCE =
        new SalesOrderSimulationField<String>("AccountingDocExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification1</b>
     * </p>
     *
     * @return Alternative Tax Classification
     */
    @SerializedName( "CustomerTaxClassification1" )
    @JsonProperty( "CustomerTaxClassification1" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification1" )
    private String customerTaxClassification1;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification1</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_TAX_CLASSIFICATION1 =
        new SalesOrderSimulationField<String>("CustomerTaxClassification1");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification2</b>
     * </p>
     *
     * @return Tax Classification 2 for Customer
     */
    @SerializedName( "CustomerTaxClassification2" )
    @JsonProperty( "CustomerTaxClassification2" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification2" )
    private String customerTaxClassification2;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification2</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_TAX_CLASSIFICATION2 =
        new SalesOrderSimulationField<String>("CustomerTaxClassification2");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification3</b>
     * </p>
     *
     * @return Tax Classification 3 for Customer
     */
    @SerializedName( "CustomerTaxClassification3" )
    @JsonProperty( "CustomerTaxClassification3" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification3" )
    private String customerTaxClassification3;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification3</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_TAX_CLASSIFICATION3 =
        new SalesOrderSimulationField<String>("CustomerTaxClassification3");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification4</b>
     * </p>
     *
     * @return Tax Classification 4 for Customer
     */
    @SerializedName( "CustomerTaxClassification4" )
    @JsonProperty( "CustomerTaxClassification4" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification4" )
    private String customerTaxClassification4;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification4</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_TAX_CLASSIFICATION4 =
        new SalesOrderSimulationField<String>("CustomerTaxClassification4");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification5</b>
     * </p>
     *
     * @return Tax Classification 5 for Customer
     */
    @SerializedName( "CustomerTaxClassification5" )
    @JsonProperty( "CustomerTaxClassification5" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification5" )
    private String customerTaxClassification5;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification5</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_TAX_CLASSIFICATION5 =
        new SalesOrderSimulationField<String>("CustomerTaxClassification5");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification6</b>
     * </p>
     *
     * @return Tax Classification 6 for Customer
     */
    @SerializedName( "CustomerTaxClassification6" )
    @JsonProperty( "CustomerTaxClassification6" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification6" )
    private String customerTaxClassification6;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification6</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_TAX_CLASSIFICATION6 =
        new SalesOrderSimulationField<String>("CustomerTaxClassification6");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification7</b>
     * </p>
     *
     * @return Tax Classification 7 for Customer
     */
    @SerializedName( "CustomerTaxClassification7" )
    @JsonProperty( "CustomerTaxClassification7" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification7" )
    private String customerTaxClassification7;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification7</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_TAX_CLASSIFICATION7 =
        new SalesOrderSimulationField<String>("CustomerTaxClassification7");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification8</b>
     * </p>
     *
     * @return Tax Classification 8 for Customer
     */
    @SerializedName( "CustomerTaxClassification8" )
    @JsonProperty( "CustomerTaxClassification8" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification8" )
    private String customerTaxClassification8;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification8</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_TAX_CLASSIFICATION8 =
        new SalesOrderSimulationField<String>("CustomerTaxClassification8");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification9</b>
     * </p>
     *
     * @return Tax Classification 9 for Customer
     */
    @SerializedName( "CustomerTaxClassification9" )
    @JsonProperty( "CustomerTaxClassification9" )
    @Nullable
    @ODataField( odataName = "CustomerTaxClassification9" )
    private String customerTaxClassification9;
    /**
     * Use with available fluent helpers to apply the <b>CustomerTaxClassification9</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_TAX_CLASSIFICATION9 =
        new SalesOrderSimulationField<String>("CustomerTaxClassification9");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceListType</b>
     * </p>
     *
     * @return Price List Type
     */
    @SerializedName( "PriceListType" )
    @JsonProperty( "PriceListType" )
    @Nullable
    @ODataField( odataName = "PriceListType" )
    private String priceListType;
    /**
     * Use with available fluent helpers to apply the <b>PriceListType</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> PRICE_LIST_TYPE =
        new SalesOrderSimulationField<String>("PriceListType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPriceGroup</b>
     * </p>
     *
     * @return Customer Price Group
     */
    @SerializedName( "CustomerPriceGroup" )
    @JsonProperty( "CustomerPriceGroup" )
    @Nullable
    @ODataField( odataName = "CustomerPriceGroup" )
    private String customerPriceGroup;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPriceGroup</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_PRICE_GROUP =
        new SalesOrderSimulationField<String>("CustomerPriceGroup");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @return Order Reason (Reason for the Business Transaction)
     */
    @SerializedName( "SDDocumentReason" )
    @JsonProperty( "SDDocumentReason" )
    @Nullable
    @ODataField( odataName = "SDDocumentReason" )
    private String sDDocumentReason;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentReason</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SD_DOCUMENT_REASON =
        new SalesOrderSimulationField<String>("SDDocumentReason");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @return Date for Pricing and Exchange Rate
     */
    @SerializedName( "PricingDate" )
    @JsonProperty( "PricingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PricingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime pricingDate;
    /**
     * Use with available fluent helpers to apply the <b>PricingDate</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<LocalDateTime> PRICING_DATE =
        new SalesOrderSimulationField<LocalDateTime>("PricingDate");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SDPricingProcedure</b>
     * </p>
     *
     * @return Pricing Procedure in Pricing
     */
    @SerializedName( "SDPricingProcedure" )
    @JsonProperty( "SDPricingProcedure" )
    @Nullable
    @ODataField( odataName = "SDPricingProcedure" )
    private String sDPricingProcedure;
    /**
     * Use with available fluent helpers to apply the <b>SDPricingProcedure</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SD_PRICING_PROCEDURE =
        new SalesOrderSimulationField<String>("SDPricingProcedure");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @return Requested Delivery Date
     */
    @SerializedName( "RequestedDeliveryDate" )
    @JsonProperty( "RequestedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requestedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryDate</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<LocalDateTime> REQUESTED_DELIVERY_DATE =
        new SalesOrderSimulationField<LocalDateTime>("RequestedDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SHIPPING_CONDITION =
        new SalesOrderSimulationField<String>("ShippingCondition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompleteDeliveryIsDefined</b>
     * </p>
     *
     * @return Complete Delivery Defined for Each Sales Order?
     */
    @SerializedName( "CompleteDeliveryIsDefined" )
    @JsonProperty( "CompleteDeliveryIsDefined" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CompleteDeliveryIsDefined" )
    private Boolean completeDeliveryIsDefined;
    /**
     * Use with available fluent helpers to apply the <b>CompleteDeliveryIsDefined</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<Boolean> COMPLETE_DELIVERY_IS_DEFINED =
        new SalesOrderSimulationField<Boolean>("CompleteDeliveryIsDefined");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> SHIPPING_TYPE =
        new SalesOrderSimulationField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> INCOTERMS_CLASSIFICATION =
        new SalesOrderSimulationField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> INCOTERMS_TRANSFER_LOCATION =
        new SalesOrderSimulationField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> INCOTERMS_LOCATION1 =
        new SalesOrderSimulationField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> INCOTERMS_LOCATION2 =
        new SalesOrderSimulationField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> INCOTERMS_VERSION =
        new SalesOrderSimulationField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> REFERENCE_SD_DOCUMENT =
        new SalesOrderSimulationField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @return Terms of Payment Key
     */
    @SerializedName( "CustomerPaymentTerms" )
    @JsonProperty( "CustomerPaymentTerms" )
    @Nullable
    @ODataField( odataName = "CustomerPaymentTerms" )
    private String customerPaymentTerms;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPaymentTerms</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> CUSTOMER_PAYMENT_TERMS =
        new SalesOrderSimulationField<String>("CustomerPaymentTerms");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @return Payment Method
     */
    @SerializedName( "PaymentMethod" )
    @JsonProperty( "PaymentMethod" )
    @Nullable
    @ODataField( odataName = "PaymentMethod" )
    private String paymentMethod;
    /**
     * Use with available fluent helpers to apply the <b>PaymentMethod</b> field to query operations.
     *
     */
    public final static SalesOrderSimulationField<String> PAYMENT_METHOD =
        new SalesOrderSimulationField<String>("PaymentMethod");
    /**
     * Navigation property <b>to_Credit</b> for <b>SalesOrderSimulation</b> to single <b>SalesOrderCreditSimulation</b>.
     *
     */
    @SerializedName( "to_Credit" )
    @JsonProperty( "to_Credit" )
    @ODataField( odataName = "to_Credit" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderCreditSimulation toCredit;
    /**
     * Navigation property <b>to_Item</b> for <b>SalesOrderSimulation</b> to multiple <b>SalesOrderItemSimulation</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderItemSimulation> toItem;
    /**
     * Navigation property <b>to_Partner</b> for <b>SalesOrderSimulation</b> to multiple
     * <b>SalesOrderPartnerSimulation</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderPartnerSimulation> toPartner;
    /**
     * Navigation property <b>to_Pricing</b> for <b>SalesOrderSimulation</b> to single
     * <b>SalesOrderPricingSimulation</b>.
     *
     */
    @SerializedName( "to_Pricing" )
    @JsonProperty( "to_Pricing" )
    @ODataField( odataName = "to_Pricing" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderPricingSimulation toPricing;
    /**
     * Navigation property <b>to_PricingElement</b> for <b>SalesOrderSimulation</b> to multiple
     * <b>SalesOrderPrcgElmntSimln</b>.
     *
     */
    @SerializedName( "to_PricingElement" )
    @JsonProperty( "to_PricingElement" )
    @ODataField( odataName = "to_PricingElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderPrcgElmntSimln> toPricingElement;
    /**
     * Use with available fluent helpers to apply the <b>to_Credit</b> navigation property to query operations.
     *
     */
    public final static SalesOrderSimulationOneToOneLink<SalesOrderCreditSimulation> TO_CREDIT =
        new SalesOrderSimulationOneToOneLink<SalesOrderCreditSimulation>("to_Credit");
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static SalesOrderSimulationLink<SalesOrderItemSimulation> TO_ITEM =
        new SalesOrderSimulationLink<SalesOrderItemSimulation>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static SalesOrderSimulationLink<SalesOrderPartnerSimulation> TO_PARTNER =
        new SalesOrderSimulationLink<SalesOrderPartnerSimulation>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_Pricing</b> navigation property to query operations.
     *
     */
    public final static SalesOrderSimulationOneToOneLink<SalesOrderPricingSimulation> TO_PRICING =
        new SalesOrderSimulationOneToOneLink<SalesOrderPricingSimulation>("to_Pricing");
    /**
     * Use with available fluent helpers to apply the <b>to_PricingElement</b> navigation property to query operations.
     *
     */
    public final static SalesOrderSimulationLink<SalesOrderPrcgElmntSimln> TO_PRICING_ELEMENT =
        new SalesOrderSimulationLink<SalesOrderPrcgElmntSimln>("to_PricingElement");

    @Nonnull
    @Override
    public Class<SalesOrderSimulation> getType()
    {
        return SalesOrderSimulation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrder</b>
     * </p>
     *
     * @param salesOrder
     *            Sales Order
     */
    public void setSalesOrder( @Nullable final String salesOrder )
    {
        rememberChangedField("SalesOrder", this.salesOrder);
        this.salesOrder = salesOrder;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderType</b>
     * </p>
     *
     * @param salesOrderType
     *            Sales Order Type
     */
    public void setSalesOrderType( @Nullable final String salesOrderType )
    {
        rememberChangedField("SalesOrderType", this.salesOrderType);
        this.salesOrderType = salesOrderType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderType</b>
     * </p>
     *
     * @param customerPurchaseOrderType
     *            Customer Purchase Order Type
     */
    public void setCustomerPurchaseOrderType( @Nullable final String customerPurchaseOrderType )
    {
        rememberChangedField("CustomerPurchaseOrderType", this.customerPurchaseOrderType);
        this.customerPurchaseOrderType = customerPurchaseOrderType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @param customerPurchaseOrderDate
     *            Customer Reference Date
     */
    public void setCustomerPurchaseOrderDate( @Nullable final LocalDateTime customerPurchaseOrderDate )
    {
        rememberChangedField("CustomerPurchaseOrderDate", this.customerPurchaseOrderDate);
        this.customerPurchaseOrderDate = customerPurchaseOrderDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderDate</b>
     * </p>
     *
     * @param salesOrderDate
     *            Document Date (Date Received/Sent)
     */
    public void setSalesOrderDate( @Nullable final LocalDateTime salesOrderDate )
    {
        rememberChangedField("SalesOrderDate", this.salesOrderDate);
        this.salesOrderDate = salesOrderDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocExternalReference</b>
     * </p>
     *
     * @param accountingDocExternalReference
     *            Reference Document Number
     */
    public void setAccountingDocExternalReference( @Nullable final String accountingDocExternalReference )
    {
        rememberChangedField("AccountingDocExternalReference", this.accountingDocExternalReference);
        this.accountingDocExternalReference = accountingDocExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification1</b>
     * </p>
     *
     * @param customerTaxClassification1
     *            Alternative Tax Classification
     */
    public void setCustomerTaxClassification1( @Nullable final String customerTaxClassification1 )
    {
        rememberChangedField("CustomerTaxClassification1", this.customerTaxClassification1);
        this.customerTaxClassification1 = customerTaxClassification1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification2</b>
     * </p>
     *
     * @param customerTaxClassification2
     *            Tax Classification 2 for Customer
     */
    public void setCustomerTaxClassification2( @Nullable final String customerTaxClassification2 )
    {
        rememberChangedField("CustomerTaxClassification2", this.customerTaxClassification2);
        this.customerTaxClassification2 = customerTaxClassification2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification3</b>
     * </p>
     *
     * @param customerTaxClassification3
     *            Tax Classification 3 for Customer
     */
    public void setCustomerTaxClassification3( @Nullable final String customerTaxClassification3 )
    {
        rememberChangedField("CustomerTaxClassification3", this.customerTaxClassification3);
        this.customerTaxClassification3 = customerTaxClassification3;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification4</b>
     * </p>
     *
     * @param customerTaxClassification4
     *            Tax Classification 4 for Customer
     */
    public void setCustomerTaxClassification4( @Nullable final String customerTaxClassification4 )
    {
        rememberChangedField("CustomerTaxClassification4", this.customerTaxClassification4);
        this.customerTaxClassification4 = customerTaxClassification4;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification5</b>
     * </p>
     *
     * @param customerTaxClassification5
     *            Tax Classification 5 for Customer
     */
    public void setCustomerTaxClassification5( @Nullable final String customerTaxClassification5 )
    {
        rememberChangedField("CustomerTaxClassification5", this.customerTaxClassification5);
        this.customerTaxClassification5 = customerTaxClassification5;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification6</b>
     * </p>
     *
     * @param customerTaxClassification6
     *            Tax Classification 6 for Customer
     */
    public void setCustomerTaxClassification6( @Nullable final String customerTaxClassification6 )
    {
        rememberChangedField("CustomerTaxClassification6", this.customerTaxClassification6);
        this.customerTaxClassification6 = customerTaxClassification6;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification7</b>
     * </p>
     *
     * @param customerTaxClassification7
     *            Tax Classification 7 for Customer
     */
    public void setCustomerTaxClassification7( @Nullable final String customerTaxClassification7 )
    {
        rememberChangedField("CustomerTaxClassification7", this.customerTaxClassification7);
        this.customerTaxClassification7 = customerTaxClassification7;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification8</b>
     * </p>
     *
     * @param customerTaxClassification8
     *            Tax Classification 8 for Customer
     */
    public void setCustomerTaxClassification8( @Nullable final String customerTaxClassification8 )
    {
        rememberChangedField("CustomerTaxClassification8", this.customerTaxClassification8);
        this.customerTaxClassification8 = customerTaxClassification8;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CustomerTaxClassification9</b>
     * </p>
     *
     * @param customerTaxClassification9
     *            Tax Classification 9 for Customer
     */
    public void setCustomerTaxClassification9( @Nullable final String customerTaxClassification9 )
    {
        rememberChangedField("CustomerTaxClassification9", this.customerTaxClassification9);
        this.customerTaxClassification9 = customerTaxClassification9;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PriceListType</b>
     * </p>
     *
     * @param priceListType
     *            Price List Type
     */
    public void setPriceListType( @Nullable final String priceListType )
    {
        rememberChangedField("PriceListType", this.priceListType);
        this.priceListType = priceListType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPriceGroup</b>
     * </p>
     *
     * @param customerPriceGroup
     *            Customer Price Group
     */
    public void setCustomerPriceGroup( @Nullable final String customerPriceGroup )
    {
        rememberChangedField("CustomerPriceGroup", this.customerPriceGroup);
        this.customerPriceGroup = customerPriceGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @param sDDocumentReason
     *            Order Reason (Reason for the Business Transaction)
     */
    public void setSDDocumentReason( @Nullable final String sDDocumentReason )
    {
        rememberChangedField("SDDocumentReason", this.sDDocumentReason);
        this.sDDocumentReason = sDDocumentReason;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PricingDate</b>
     * </p>
     *
     * @param pricingDate
     *            Date for Pricing and Exchange Rate
     */
    public void setPricingDate( @Nullable final LocalDateTime pricingDate )
    {
        rememberChangedField("PricingDate", this.pricingDate);
        this.pricingDate = pricingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SDPricingProcedure</b>
     * </p>
     *
     * @param sDPricingProcedure
     *            Pricing Procedure in Pricing
     */
    public void setSDPricingProcedure( @Nullable final String sDPricingProcedure )
    {
        rememberChangedField("SDPricingProcedure", this.sDPricingProcedure);
        this.sDPricingProcedure = sDPricingProcedure;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @param requestedDeliveryDate
     *            Requested Delivery Date
     */
    public void setRequestedDeliveryDate( @Nullable final LocalDateTime requestedDeliveryDate )
    {
        rememberChangedField("RequestedDeliveryDate", this.requestedDeliveryDate);
        this.requestedDeliveryDate = requestedDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompleteDeliveryIsDefined</b>
     * </p>
     *
     * @param completeDeliveryIsDefined
     *            Complete Delivery Defined for Each Sales Order?
     */
    public void setCompleteDeliveryIsDefined( @Nullable final Boolean completeDeliveryIsDefined )
    {
        rememberChangedField("CompleteDeliveryIsDefined", this.completeDeliveryIsDefined);
        this.completeDeliveryIsDefined = completeDeliveryIsDefined;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPaymentTerms</b>
     * </p>
     *
     * @param customerPaymentTerms
     *            Terms of Payment Key
     */
    public void setCustomerPaymentTerms( @Nullable final String customerPaymentTerms )
    {
        rememberChangedField("CustomerPaymentTerms", this.customerPaymentTerms);
        this.customerPaymentTerms = customerPaymentTerms;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PaymentMethod</b>
     * </p>
     *
     * @param paymentMethod
     *            Payment Method
     */
    public void setPaymentMethod( @Nullable final String paymentMethod )
    {
        rememberChangedField("PaymentMethod", this.paymentMethod);
        this.paymentMethod = paymentMethod;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderSimulation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrder", getSalesOrder());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrder", getSalesOrder());
        values.put("SalesOrderType", getSalesOrderType());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("SalesGroup", getSalesGroup());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("SoldToParty", getSoldToParty());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("CustomerPurchaseOrderType", getCustomerPurchaseOrderType());
        values.put("CustomerPurchaseOrderDate", getCustomerPurchaseOrderDate());
        values.put("SalesOrderDate", getSalesOrderDate());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("AccountingDocExternalReference", getAccountingDocExternalReference());
        values.put("CustomerTaxClassification1", getCustomerTaxClassification1());
        values.put("CustomerTaxClassification2", getCustomerTaxClassification2());
        values.put("CustomerTaxClassification3", getCustomerTaxClassification3());
        values.put("CustomerTaxClassification4", getCustomerTaxClassification4());
        values.put("CustomerTaxClassification5", getCustomerTaxClassification5());
        values.put("CustomerTaxClassification6", getCustomerTaxClassification6());
        values.put("CustomerTaxClassification7", getCustomerTaxClassification7());
        values.put("CustomerTaxClassification8", getCustomerTaxClassification8());
        values.put("CustomerTaxClassification9", getCustomerTaxClassification9());
        values.put("PriceListType", getPriceListType());
        values.put("CustomerPriceGroup", getCustomerPriceGroup());
        values.put("SDDocumentReason", getSDDocumentReason());
        values.put("PricingDate", getPricingDate());
        values.put("SDPricingProcedure", getSDPricingProcedure());
        values.put("RequestedDeliveryDate", getRequestedDeliveryDate());
        values.put("ShippingCondition", getShippingCondition());
        values.put("CompleteDeliveryIsDefined", getCompleteDeliveryIsDefined());
        values.put("ShippingType", getShippingType());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("CustomerPaymentTerms", getCustomerPaymentTerms());
        values.put("PaymentMethod", getPaymentMethod());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrder") ) {
                final Object value = values.remove("SalesOrder");
                if( (value == null) || (!value.equals(getSalesOrder())) ) {
                    setSalesOrder(((String) value));
                }
            }
            if( values.containsKey("SalesOrderType") ) {
                final Object value = values.remove("SalesOrderType");
                if( (value == null) || (!value.equals(getSalesOrderType())) ) {
                    setSalesOrderType(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderType") ) {
                final Object value = values.remove("CustomerPurchaseOrderType");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderType())) ) {
                    setCustomerPurchaseOrderType(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderDate") ) {
                final Object value = values.remove("CustomerPurchaseOrderDate");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderDate())) ) {
                    setCustomerPurchaseOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SalesOrderDate") ) {
                final Object value = values.remove("SalesOrderDate");
                if( (value == null) || (!value.equals(getSalesOrderDate())) ) {
                    setSalesOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("AccountingDocExternalReference") ) {
                final Object value = values.remove("AccountingDocExternalReference");
                if( (value == null) || (!value.equals(getAccountingDocExternalReference())) ) {
                    setAccountingDocExternalReference(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification1") ) {
                final Object value = values.remove("CustomerTaxClassification1");
                if( (value == null) || (!value.equals(getCustomerTaxClassification1())) ) {
                    setCustomerTaxClassification1(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification2") ) {
                final Object value = values.remove("CustomerTaxClassification2");
                if( (value == null) || (!value.equals(getCustomerTaxClassification2())) ) {
                    setCustomerTaxClassification2(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification3") ) {
                final Object value = values.remove("CustomerTaxClassification3");
                if( (value == null) || (!value.equals(getCustomerTaxClassification3())) ) {
                    setCustomerTaxClassification3(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification4") ) {
                final Object value = values.remove("CustomerTaxClassification4");
                if( (value == null) || (!value.equals(getCustomerTaxClassification4())) ) {
                    setCustomerTaxClassification4(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification5") ) {
                final Object value = values.remove("CustomerTaxClassification5");
                if( (value == null) || (!value.equals(getCustomerTaxClassification5())) ) {
                    setCustomerTaxClassification5(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification6") ) {
                final Object value = values.remove("CustomerTaxClassification6");
                if( (value == null) || (!value.equals(getCustomerTaxClassification6())) ) {
                    setCustomerTaxClassification6(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification7") ) {
                final Object value = values.remove("CustomerTaxClassification7");
                if( (value == null) || (!value.equals(getCustomerTaxClassification7())) ) {
                    setCustomerTaxClassification7(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification8") ) {
                final Object value = values.remove("CustomerTaxClassification8");
                if( (value == null) || (!value.equals(getCustomerTaxClassification8())) ) {
                    setCustomerTaxClassification8(((String) value));
                }
            }
            if( values.containsKey("CustomerTaxClassification9") ) {
                final Object value = values.remove("CustomerTaxClassification9");
                if( (value == null) || (!value.equals(getCustomerTaxClassification9())) ) {
                    setCustomerTaxClassification9(((String) value));
                }
            }
            if( values.containsKey("PriceListType") ) {
                final Object value = values.remove("PriceListType");
                if( (value == null) || (!value.equals(getPriceListType())) ) {
                    setPriceListType(((String) value));
                }
            }
            if( values.containsKey("CustomerPriceGroup") ) {
                final Object value = values.remove("CustomerPriceGroup");
                if( (value == null) || (!value.equals(getCustomerPriceGroup())) ) {
                    setCustomerPriceGroup(((String) value));
                }
            }
            if( values.containsKey("SDDocumentReason") ) {
                final Object value = values.remove("SDDocumentReason");
                if( (value == null) || (!value.equals(getSDDocumentReason())) ) {
                    setSDDocumentReason(((String) value));
                }
            }
            if( values.containsKey("PricingDate") ) {
                final Object value = values.remove("PricingDate");
                if( (value == null) || (!value.equals(getPricingDate())) ) {
                    setPricingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SDPricingProcedure") ) {
                final Object value = values.remove("SDPricingProcedure");
                if( (value == null) || (!value.equals(getSDPricingProcedure())) ) {
                    setSDPricingProcedure(((String) value));
                }
            }
            if( values.containsKey("RequestedDeliveryDate") ) {
                final Object value = values.remove("RequestedDeliveryDate");
                if( (value == null) || (!value.equals(getRequestedDeliveryDate())) ) {
                    setRequestedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("CompleteDeliveryIsDefined") ) {
                final Object value = values.remove("CompleteDeliveryIsDefined");
                if( (value == null) || (!value.equals(getCompleteDeliveryIsDefined())) ) {
                    setCompleteDeliveryIsDefined(((Boolean) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("CustomerPaymentTerms") ) {
                final Object value = values.remove("CustomerPaymentTerms");
                if( (value == null) || (!value.equals(getCustomerPaymentTerms())) ) {
                    setCustomerPaymentTerms(((String) value));
                }
            }
            if( values.containsKey("PaymentMethod") ) {
                final Object value = values.remove("PaymentMethod");
                if( (value == null) || (!value.equals(getPaymentMethod())) ) {
                    setPaymentMethod(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Credit") ) {
                final Object value = (values).remove("to_Credit");
                if( value instanceof Map ) {
                    if( toCredit == null ) {
                        toCredit = new SalesOrderCreditSimulation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCredit.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderItemSimulation entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new SalesOrderItemSimulation();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderPartnerSimulation entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SalesOrderPartnerSimulation();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Pricing") ) {
                final Object value = (values).remove("to_Pricing");
                if( value instanceof Map ) {
                    if( toPricing == null ) {
                        toPricing = new SalesOrderPricingSimulation();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toPricing.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_PricingElement") ) {
                final Object value = (values).remove("to_PricingElement");
                if( value instanceof Iterable ) {
                    if( toPricingElement == null ) {
                        toPricingElement = Lists.newArrayList();
                    } else {
                        toPricingElement = Lists.newArrayList(toPricingElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderPrcgElmntSimln entity;
                        if( toPricingElement.size() > i ) {
                            entity = toPricingElement.get(i);
                        } else {
                            entity = new SalesOrderPrcgElmntSimln();
                            toPricingElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrderSimulationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderSimulationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderSimulationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderSimulationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderSimulateService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCredit != null ) {
            (values).put("to_Credit", toCredit);
        }
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toPricing != null ) {
            (values).put("to_Pricing", toPricing);
        }
        if( toPricingElement != null ) {
            (values).put("to_PricingElement", toPricingElement);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderCreditSimulation</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Credit</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderCreditSimulation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderCreditSimulation fetchCredit()
    {
        return fetchFieldAsSingle("to_Credit", SalesOrderCreditSimulation.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderCreditSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Credit</b>.
     * <p>
     * If the navigation property <b>to_Credit</b> of a queried <b>SalesOrderSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderCreditSimulation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderCreditSimulation getCreditOrFetch()
    {
        if( toCredit == null ) {
            toCredit = fetchCredit();
        }
        return toCredit;
    }

    /**
     * Retrieval of associated <b>SalesOrderCreditSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Credit</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderSimulation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Credit</b> is already loaded, the result will contain
     *         the <b>SalesOrderCreditSimulation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderCreditSimulation> getCreditIfPresent()
    {
        return Option.of(toCredit);
    }

    /**
     * Overwrites the associated <b>SalesOrderCreditSimulation</b> entity for the loaded navigation property
     * <b>to_Credit</b>.
     *
     * @param value
     *            New <b>SalesOrderCreditSimulation</b> entity.
     */
    public void setCredit( final SalesOrderCreditSimulation value )
    {
        toCredit = value;
    }

    /**
     * Fetches the <b>SalesOrderItemSimulation</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderItemSimulation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemSimulation> fetchItem()
    {
        return fetchFieldAsList("to_Item", SalesOrderItemSimulation.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderItemSimulation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SalesOrderSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderItemSimulation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderItemSimulation> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderItemSimulation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderSimulation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>SalesOrderItemSimulation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderItemSimulation>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderItemSimulation</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SalesOrderSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderItemSimulation</b> entities.
     */
    public void setItem( @Nonnull final List<SalesOrderItemSimulation> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderItemSimulation</b> entities. This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SalesOrderSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderItemSimulation</b> entities.
     */
    public void addItem( SalesOrderItemSimulation... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderPartnerSimulation</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderPartnerSimulation</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderPartnerSimulation> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SalesOrderPartnerSimulation.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderPartnerSimulation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderPartnerSimulation</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderPartnerSimulation> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SalesOrderPartnerSimulation</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderSimulation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SalesOrderPartnerSimulation</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderPartnerSimulation>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderPartnerSimulation</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderPartnerSimulation</b> entities.
     */
    public void setPartner( @Nonnull final List<SalesOrderPartnerSimulation> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderPartnerSimulation</b> entities. This corresponds to the
     * OData navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderPartnerSimulation</b> entities.
     */
    public void addPartner( SalesOrderPartnerSimulation... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderPricingSimulation</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Pricing</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderPricingSimulation</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderPricingSimulation fetchPricing()
    {
        return fetchFieldAsSingle("to_Pricing", SalesOrderPricingSimulation.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderPricingSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Pricing</b>.
     * <p>
     * If the navigation property <b>to_Pricing</b> of a queried <b>SalesOrderSimulation</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderPricingSimulation</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderPricingSimulation getPricingOrFetch()
    {
        if( toPricing == null ) {
            toPricing = fetchPricing();
        }
        return toPricing;
    }

    /**
     * Retrieval of associated <b>SalesOrderPricingSimulation</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Pricing</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderSimulation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Pricing</b> is already loaded, the result will contain
     *         the <b>SalesOrderPricingSimulation</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderPricingSimulation> getPricingIfPresent()
    {
        return Option.of(toPricing);
    }

    /**
     * Overwrites the associated <b>SalesOrderPricingSimulation</b> entity for the loaded navigation property
     * <b>to_Pricing</b>.
     *
     * @param value
     *            New <b>SalesOrderPricingSimulation</b> entity.
     */
    public void setPricing( final SalesOrderPricingSimulation value )
    {
        toPricing = value;
    }

    /**
     * Fetches the <b>SalesOrderPrcgElmntSimln</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_PricingElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderPrcgElmntSimln</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderPrcgElmntSimln> fetchPricingElement()
    {
        return fetchFieldAsList("to_PricingElement", SalesOrderPrcgElmntSimln.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderPrcgElmntSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrderSimulation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderPrcgElmntSimln</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderPrcgElmntSimln> getPricingElementOrFetch()
    {
        if( toPricingElement == null ) {
            toPricingElement = fetchPricingElement();
        }
        return toPricingElement;
    }

    /**
     * Retrieval of associated <b>SalesOrderPrcgElmntSimln</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderSimulation</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_PricingElement</b> is already loaded, the result will
     *         contain the <b>SalesOrderPrcgElmntSimln</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderPrcgElmntSimln>> getPricingElementIfPresent()
    {
        return Option.of(toPricingElement);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderPrcgElmntSimln</b> entities for the loaded navigation property
     * <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrderSimulation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderPrcgElmntSimln</b> entities.
     */
    public void setPricingElement( @Nonnull final List<SalesOrderPrcgElmntSimln> value )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.clear();
        toPricingElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderPrcgElmntSimln</b> entities. This corresponds to the OData
     * navigation property <b>to_PricingElement</b>.
     * <p>
     * If the navigation property <b>to_PricingElement</b> of a queried <b>SalesOrderSimulation</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderPrcgElmntSimln</b> entities.
     */
    public void addPricingElement( SalesOrderPrcgElmntSimln... entity )
    {
        if( toPricingElement == null ) {
            toPricingElement = Lists.newArrayList();
        }
        toPricingElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderSimulation instances.
     *
     */
    public final static class SalesOrderSimulationBuilder
    {

        private SalesOrderCreditSimulation toCredit;
        private List<SalesOrderItemSimulation> toItem = Lists.newArrayList();
        private List<SalesOrderPartnerSimulation> toPartner = Lists.newArrayList();
        private SalesOrderPricingSimulation toPricing;
        private List<SalesOrderPrcgElmntSimln> toPricingElement = Lists.newArrayList();

        private SalesOrderSimulation.SalesOrderSimulationBuilder toCredit( final SalesOrderCreditSimulation value )
        {
            toCredit = value;
            return this;
        }

        /**
         * Navigation property <b>to_Credit</b> for <b>SalesOrderSimulation</b> to single
         * <b>SalesOrderCreditSimulation</b>.
         *
         * @param value
         *            The SalesOrderCreditSimulation to build this SalesOrderSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderSimulation.SalesOrderSimulationBuilder credit( final SalesOrderCreditSimulation value )
        {
            return toCredit(value);
        }

        private SalesOrderSimulation.SalesOrderSimulationBuilder toItem( final List<SalesOrderItemSimulation> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>SalesOrderSimulation</b> to multiple
         * <b>SalesOrderItemSimulation</b>.
         *
         * @param value
         *            The SalesOrderItemSimulations to build this SalesOrderSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderSimulation.SalesOrderSimulationBuilder item( SalesOrderItemSimulation... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private SalesOrderSimulation.SalesOrderSimulationBuilder toPartner(
            final List<SalesOrderPartnerSimulation> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>SalesOrderSimulation</b> to multiple
         * <b>SalesOrderPartnerSimulation</b>.
         *
         * @param value
         *            The SalesOrderPartnerSimulations to build this SalesOrderSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderSimulation.SalesOrderSimulationBuilder partner( SalesOrderPartnerSimulation... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private SalesOrderSimulation.SalesOrderSimulationBuilder toPricing( final SalesOrderPricingSimulation value )
        {
            toPricing = value;
            return this;
        }

        /**
         * Navigation property <b>to_Pricing</b> for <b>SalesOrderSimulation</b> to single
         * <b>SalesOrderPricingSimulation</b>.
         *
         * @param value
         *            The SalesOrderPricingSimulation to build this SalesOrderSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderSimulation.SalesOrderSimulationBuilder pricing( final SalesOrderPricingSimulation value )
        {
            return toPricing(value);
        }

        private SalesOrderSimulation.SalesOrderSimulationBuilder toPricingElement(
            final List<SalesOrderPrcgElmntSimln> value )
        {
            toPricingElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_PricingElement</b> for <b>SalesOrderSimulation</b> to multiple
         * <b>SalesOrderPrcgElmntSimln</b>.
         *
         * @param value
         *            The SalesOrderPrcgElmntSimlns to build this SalesOrderSimulation with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderSimulation.SalesOrderSimulationBuilder pricingElement( SalesOrderPrcgElmntSimln... value )
        {
            return toPricingElement(Lists.newArrayList(value));
        }

    }

}
