/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderSimulation;

/**
 * Implementation of the {@link SalesOrderSimulateServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderSimulateService SalesOrderSimulateService}.
 *
 */
public class DefaultSalesOrderSimulateServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesOrderSimulateServiceBatch, SalesOrderSimulateServiceBatchChangeSet>
    implements
    SalesOrderSimulateServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderSimulateService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesOrderSimulateServiceBatchChangeSet(
        @Nonnull final DefaultSalesOrderSimulateServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderSimulateService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesOrderSimulateServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesOrderSimulateServiceBatchChangeSet createSalesOrderSimulation(
        @Nonnull final SalesOrderSimulation salesOrderSimulation )
    {
        return addRequestCreate(service::createSalesOrderSimulation, salesOrderSimulation);
    }

}
