/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderCreditSimulation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderCreditSimulation
 * SalesOrderCreditSimulation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.field.SalesOrderCreditSimulationField
 * SalesOrderCreditSimulationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.link.SalesOrderCreditSimulationLink
 * SalesOrderCreditSimulationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderCreditSimulation#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderCreditSimulation#TOTAL_CREDIT_CHECK_STATUS
 * TOTAL_CREDIT_CHECK_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderCreditSimulation#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * </ul>
 *
 */
public interface SalesOrderCreditSimulationSelectable extends EntitySelectable<SalesOrderCreditSimulation>
{

}
