/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln
 * SalesOrderItemPartnerSimln}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.field.SalesOrderItemPartnerSimlnField
 * SalesOrderItemPartnerSimlnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.link.SalesOrderItemPartnerSimlnLink
 * SalesOrderItemPartnerSimlnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln#PARTNER_FUNCTION
 * PARTNER_FUNCTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln#CUSTOMER
 * CUSTOMER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln#PERSONNEL
 * PERSONNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln#CONTACT_PERSON
 * CONTACT_PERSON}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderItemPartnerSimln#TO_SALES_ORDER_ITEM
 * TO_SALES_ORDER_ITEM}</li>
 * </ul>
 *
 */
public interface SalesOrderItemPartnerSimlnSelectable extends EntitySelectable<SalesOrderItemPartnerSimln>
{

}
