/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderPricingSimulation;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderPricingSimulation
 * SalesOrderPricingSimulation}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.field.SalesOrderPricingSimulationField
 * SalesOrderPricingSimulationField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.link.SalesOrderPricingSimulationLink
 * SalesOrderPricingSimulationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderPricingSimulation#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderPricingSimulation#TOTAL_NET_AMOUNT
 * TOTAL_NET_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderPricingSimulation#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderPricingSimulation#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * </ul>
 *
 */
public interface SalesOrderPricingSimulationSelectable extends EntitySelectable<SalesOrderPricingSimulation>
{

}
