/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln
 * SalesOrderScheduleLineSimln}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.field.SalesOrderScheduleLineSimlnField
 * SalesOrderScheduleLineSimlnField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.link.SalesOrderScheduleLineSimlnLink
 * SalesOrderScheduleLineSimlnLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#SALES_ORDER
 * SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#SALES_ORDER_ITEM
 * SALES_ORDER_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#SCHEDULE_LINE
 * SCHEDULE_LINE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#REQUESTED_DELIVERY_DATE
 * REQUESTED_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#CONFIRMED_DELIVERY_DATE
 * CONFIRMED_DELIVERY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#ORDER_QUANTITY_UNIT
 * ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#ORDER_QUANTITY_SAP_UNIT
 * ORDER_QUANTITY_SAP_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#ORDER_QUANTITY_ISO_UNIT
 * ORDER_QUANTITY_ISO_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#SCHEDULE_LINE_ORDER_QUANTITY
 * SCHEDULE_LINE_ORDER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK
 * CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#OPEN_CONFD_DELIV_QTY_IN_ORD_QTY_UNIT
 * OPEN_CONFD_DELIV_QTY_IN_ORD_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#CORRECTED_QTY_IN_ORDER_QTY_UNIT
 * CORRECTED_QTY_IN_ORDER_QTY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#TO_SALES_ORDER
 * TO_SALES_ORDER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesordersimulate.SalesOrderScheduleLineSimln#TO_SALES_ORDER_ITEM
 * TO_SALES_ORDER_ITEM}</li>
 * </ul>
 *
 */
public interface SalesOrderScheduleLineSimlnSelectable extends EntitySelectable<SalesOrderScheduleLineSimln>
{

}
