/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.field.SalesOrderWithoutChargeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.link.SalesOrderWithoutChargeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable.SalesOrderWithoutChargeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Order Without Charge Header
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderWithoutChargeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderWithoutCharge extends VdmEntity<SalesOrderWithoutCharge>
{

    /**
     * Selector for all available fields of SalesOrderWithoutCharge.
     *
     */
    public final static SalesOrderWithoutChargeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
     * </p>
     *
     * @return Sales Order Without Charge
     */
    @Key
    @SerializedName( "SalesOrderWithoutCharge" )
    @JsonProperty( "SalesOrderWithoutCharge" )
    @Nullable
    @ODataField( odataName = "SalesOrderWithoutCharge" )
    private String salesOrderWithoutCharge;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutCharge</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> SALES_ORDER_WITHOUT_CHARGE =
        new SalesOrderWithoutChargeField<String>("SalesOrderWithoutCharge");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeType</b>
     * </p>
     *
     * @return Sales Document Type
     */
    @SerializedName( "SalesOrderWithoutChargeType" )
    @JsonProperty( "SalesOrderWithoutChargeType" )
    @Nullable
    @ODataField( odataName = "SalesOrderWithoutChargeType" )
    private String salesOrderWithoutChargeType;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutChargeType</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> SALES_ORDER_WITHOUT_CHARGE_TYPE =
        new SalesOrderWithoutChargeField<String>("SalesOrderWithoutChargeType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> SALES_ORGANIZATION =
        new SalesOrderWithoutChargeField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @return Distribution Channel
     */
    @SerializedName( "DistributionChannel" )
    @JsonProperty( "DistributionChannel" )
    @Nullable
    @ODataField( odataName = "DistributionChannel" )
    private String distributionChannel;
    /**
     * Use with available fluent helpers to apply the <b>DistributionChannel</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> DISTRIBUTION_CHANNEL =
        new SalesOrderWithoutChargeField<String>("DistributionChannel");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @return Division
     */
    @SerializedName( "OrganizationDivision" )
    @JsonProperty( "OrganizationDivision" )
    @Nullable
    @ODataField( odataName = "OrganizationDivision" )
    private String organizationDivision;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationDivision</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> ORGANIZATION_DIVISION =
        new SalesOrderWithoutChargeField<String>("OrganizationDivision");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @return Sales Group
     */
    @SerializedName( "SalesGroup" )
    @JsonProperty( "SalesGroup" )
    @Nullable
    @ODataField( odataName = "SalesGroup" )
    private String salesGroup;
    /**
     * Use with available fluent helpers to apply the <b>SalesGroup</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> SALES_GROUP =
        new SalesOrderWithoutChargeField<String>("SalesGroup");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @return Sales Office
     */
    @SerializedName( "SalesOffice" )
    @JsonProperty( "SalesOffice" )
    @Nullable
    @ODataField( odataName = "SalesOffice" )
    private String salesOffice;
    /**
     * Use with available fluent helpers to apply the <b>SalesOffice</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> SALES_OFFICE =
        new SalesOrderWithoutChargeField<String>("SalesOffice");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @return Sales District
     */
    @SerializedName( "SalesDistrict" )
    @JsonProperty( "SalesDistrict" )
    @Nullable
    @ODataField( odataName = "SalesDistrict" )
    private String salesDistrict;
    /**
     * Use with available fluent helpers to apply the <b>SalesDistrict</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> SALES_DISTRICT =
        new SalesOrderWithoutChargeField<String>("SalesDistrict");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @return Sold-to Party
     */
    @SerializedName( "SoldToParty" )
    @JsonProperty( "SoldToParty" )
    @Nullable
    @ODataField( odataName = "SoldToParty" )
    private String soldToParty;
    /**
     * Use with available fluent helpers to apply the <b>SoldToParty</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> SOLD_TO_PARTY =
        new SalesOrderWithoutChargeField<String>("SoldToParty");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<LocalDateTime> CREATION_DATE =
        new SalesOrderWithoutChargeField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> CREATED_BY_USER =
        new SalesOrderWithoutChargeField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<LocalDateTime> LAST_CHANGE_DATE =
        new SalesOrderWithoutChargeField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "LastChangeDateTime" )
    @JsonProperty( "LastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime lastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDateTime</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<ZonedDateTime> LAST_CHANGE_DATE_TIME =
        new SalesOrderWithoutChargeField<ZonedDateTime>("LastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new SalesOrderWithoutChargeField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderType</b>
     * </p>
     *
     * @return Customer Purchase Order Type
     */
    @SerializedName( "CustomerPurchaseOrderType" )
    @JsonProperty( "CustomerPurchaseOrderType" )
    @Nullable
    @ODataField( odataName = "CustomerPurchaseOrderType" )
    private String customerPurchaseOrderType;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderType</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> CUSTOMER_PURCHASE_ORDER_TYPE =
        new SalesOrderWithoutChargeField<String>("CustomerPurchaseOrderType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @return Customer Reference Date
     */
    @SerializedName( "CustomerPurchaseOrderDate" )
    @JsonProperty( "CustomerPurchaseOrderDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CustomerPurchaseOrderDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime customerPurchaseOrderDate;
    /**
     * Use with available fluent helpers to apply the <b>CustomerPurchaseOrderDate</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<LocalDateTime> CUSTOMER_PURCHASE_ORDER_DATE =
        new SalesOrderWithoutChargeField<LocalDateTime>("CustomerPurchaseOrderDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeDate</b>
     * </p>
     *
     * @return Document Date (Date Received/Sent)
     */
    @SerializedName( "SalesOrderWithoutChargeDate" )
    @JsonProperty( "SalesOrderWithoutChargeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SalesOrderWithoutChargeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime salesOrderWithoutChargeDate;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutChargeDate</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<LocalDateTime> SALES_ORDER_WITHOUT_CHARGE_DATE =
        new SalesOrderWithoutChargeField<LocalDateTime>("SalesOrderWithoutChargeDate");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @return Net Value of the Sales Order in Document Currency
     */
    @SerializedName( "TotalNetAmount" )
    @JsonProperty( "TotalNetAmount" )
    @Nullable
    @ODataField( odataName = "TotalNetAmount" )
    private BigDecimal totalNetAmount;
    /**
     * Use with available fluent helpers to apply the <b>TotalNetAmount</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<BigDecimal> TOTAL_NET_AMOUNT =
        new SalesOrderWithoutChargeField<BigDecimal>("TotalNetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> TRANSACTION_CURRENCY =
        new SalesOrderWithoutChargeField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @return Order Reason (Reason for the Business Transaction)
     */
    @SerializedName( "SDDocumentReason" )
    @JsonProperty( "SDDocumentReason" )
    @Nullable
    @ODataField( odataName = "SDDocumentReason" )
    private String sDDocumentReason;
    /**
     * Use with available fluent helpers to apply the <b>SDDocumentReason</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> SD_DOCUMENT_REASON =
        new SalesOrderWithoutChargeField<String>("SDDocumentReason");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @return Requested Delivery Date
     */
    @SerializedName( "RequestedDeliveryDate" )
    @JsonProperty( "RequestedDeliveryDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RequestedDeliveryDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime requestedDeliveryDate;
    /**
     * Use with available fluent helpers to apply the <b>RequestedDeliveryDate</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<LocalDateTime> REQUESTED_DELIVERY_DATE =
        new SalesOrderWithoutChargeField<LocalDateTime>("RequestedDeliveryDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDateTypeRule</b>
     * </p>
     *
     * @return Delivery Date Rule
     */
    @SerializedName( "DeliveryDateTypeRule" )
    @JsonProperty( "DeliveryDateTypeRule" )
    @Nullable
    @ODataField( odataName = "DeliveryDateTypeRule" )
    private String deliveryDateTypeRule;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDateTypeRule</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> DELIVERY_DATE_TYPE_RULE =
        new SalesOrderWithoutChargeField<String>("DeliveryDateTypeRule");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @return Shipping Conditions
     */
    @SerializedName( "ShippingCondition" )
    @JsonProperty( "ShippingCondition" )
    @Nullable
    @ODataField( odataName = "ShippingCondition" )
    private String shippingCondition;
    /**
     * Use with available fluent helpers to apply the <b>ShippingCondition</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> SHIPPING_CONDITION =
        new SalesOrderWithoutChargeField<String>("ShippingCondition");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompleteDeliveryIsDefined</b>
     * </p>
     *
     * @return Complete Delivery Defined for Each Sales Order?
     */
    @SerializedName( "CompleteDeliveryIsDefined" )
    @JsonProperty( "CompleteDeliveryIsDefined" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CompleteDeliveryIsDefined" )
    private Boolean completeDeliveryIsDefined;
    /**
     * Use with available fluent helpers to apply the <b>CompleteDeliveryIsDefined</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<Boolean> COMPLETE_DELIVERY_IS_DEFINED =
        new SalesOrderWithoutChargeField<Boolean>("CompleteDeliveryIsDefined");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> SHIPPING_TYPE =
        new SalesOrderWithoutChargeField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryBlockReason</b>
     * </p>
     *
     * @return Delivery Block (Document Header)
     */
    @SerializedName( "DeliveryBlockReason" )
    @JsonProperty( "DeliveryBlockReason" )
    @Nullable
    @ODataField( odataName = "DeliveryBlockReason" )
    private String deliveryBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryBlockReason</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> DELIVERY_BLOCK_REASON =
        new SalesOrderWithoutChargeField<String>("DeliveryBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillingBlockReason</b>
     * </p>
     *
     * @return Billing Block in SD Document
     */
    @SerializedName( "HeaderBillingBlockReason" )
    @JsonProperty( "HeaderBillingBlockReason" )
    @Nullable
    @ODataField( odataName = "HeaderBillingBlockReason" )
    private String headerBillingBlockReason;
    /**
     * Use with available fluent helpers to apply the <b>HeaderBillingBlockReason</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> HEADER_BILLING_BLOCK_REASON =
        new SalesOrderWithoutChargeField<String>("HeaderBillingBlockReason");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> INCOTERMS_CLASSIFICATION =
        new SalesOrderWithoutChargeField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> INCOTERMS_TRANSFER_LOCATION =
        new SalesOrderWithoutChargeField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> INCOTERMS_LOCATION1 =
        new SalesOrderWithoutChargeField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> INCOTERMS_LOCATION2 =
        new SalesOrderWithoutChargeField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @return Incoterms Version
     */
    @SerializedName( "IncotermsVersion" )
    @JsonProperty( "IncotermsVersion" )
    @Nullable
    @ODataField( odataName = "IncotermsVersion" )
    private String incotermsVersion;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsVersion</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> INCOTERMS_VERSION =
        new SalesOrderWithoutChargeField<String>("IncotermsVersion");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> COST_CENTER =
        new SalesOrderWithoutChargeField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> REFERENCE_SD_DOCUMENT =
        new SalesOrderWithoutChargeField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocExternalReference</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "AccountingDocExternalReference" )
    @JsonProperty( "AccountingDocExternalReference" )
    @Nullable
    @ODataField( odataName = "AccountingDocExternalReference" )
    private String accountingDocExternalReference;
    /**
     * Use with available fluent helpers to apply the <b>AccountingDocExternalReference</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> ACCOUNTING_DOC_EXTERNAL_REFERENCE =
        new SalesOrderWithoutChargeField<String>("AccountingDocExternalReference");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @return Document Category of Preceding SD Document
     */
    @SerializedName( "ReferenceSDDocumentCategory" )
    @JsonProperty( "ReferenceSDDocumentCategory" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentCategory" )
    private String referenceSDDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentCategory</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> REFERENCE_SD_DOCUMENT_CATEGORY =
        new SalesOrderWithoutChargeField<String>("ReferenceSDDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Header/All Items)
     */
    @SerializedName( "OverallSDProcessStatus" )
    @JsonProperty( "OverallSDProcessStatus" )
    @Nullable
    @ODataField( odataName = "OverallSDProcessStatus" )
    private String overallSDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDProcessStatus</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> OVERALL_SD_PROCESS_STATUS =
        new SalesOrderWithoutChargeField<String>("OverallSDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallTotalDeliveryStatus</b>
     * </p>
     *
     * @return Overall Delivery Status (All Items)
     */
    @SerializedName( "OverallTotalDeliveryStatus" )
    @JsonProperty( "OverallTotalDeliveryStatus" )
    @Nullable
    @ODataField( odataName = "OverallTotalDeliveryStatus" )
    private String overallTotalDeliveryStatus;
    /**
     * Use with available fluent helpers to apply the <b>OverallTotalDeliveryStatus</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> OVERALL_TOTAL_DELIVERY_STATUS =
        new SalesOrderWithoutChargeField<String>("OverallTotalDeliveryStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDDocumentRejectionSts</b>
     * </p>
     *
     * @return Rejection Status (All Items)
     */
    @SerializedName( "OverallSDDocumentRejectionSts" )
    @JsonProperty( "OverallSDDocumentRejectionSts" )
    @Nullable
    @ODataField( odataName = "OverallSDDocumentRejectionSts" )
    private String overallSDDocumentRejectionSts;
    /**
     * Use with available fluent helpers to apply the <b>OverallSDDocumentRejectionSts</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeField<String> OVERALL_SD_DOCUMENT_REJECTION_STS =
        new SalesOrderWithoutChargeField<String>("OverallSDDocumentRejectionSts");
    /**
     * Navigation property <b>to_Item</b> for <b>SalesOrderWithoutCharge</b> to multiple
     * <b>SalesOrderWithoutChargeItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrderWithoutChargeItem> toItem;
    /**
     * Navigation property <b>to_Partner</b> for <b>SalesOrderWithoutCharge</b> to multiple
     * <b>SlsOrdWthoutChrgPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsOrdWthoutChrgPartner> toPartner;
    /**
     * Navigation property <b>to_Text</b> for <b>SalesOrderWithoutCharge</b> to multiple <b>SlsOrdWthoutChrgText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsOrdWthoutChrgText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static SalesOrderWithoutChargeLink<SalesOrderWithoutChargeItem> TO_ITEM =
        new SalesOrderWithoutChargeLink<SalesOrderWithoutChargeItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static SalesOrderWithoutChargeLink<SlsOrdWthoutChrgPartner> TO_PARTNER =
        new SalesOrderWithoutChargeLink<SlsOrdWthoutChrgPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static SalesOrderWithoutChargeLink<SlsOrdWthoutChrgText> TO_TEXT =
        new SalesOrderWithoutChargeLink<SlsOrdWthoutChrgText>("to_Text");

    @Nonnull
    @Override
    public Class<SalesOrderWithoutCharge> getType()
    {
        return SalesOrderWithoutCharge.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
     * </p>
     *
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     */
    public void setSalesOrderWithoutCharge( @Nullable final String salesOrderWithoutCharge )
    {
        rememberChangedField("SalesOrderWithoutCharge", this.salesOrderWithoutCharge);
        this.salesOrderWithoutCharge = salesOrderWithoutCharge;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeType</b>
     * </p>
     *
     * @param salesOrderWithoutChargeType
     *            Sales Document Type
     */
    public void setSalesOrderWithoutChargeType( @Nullable final String salesOrderWithoutChargeType )
    {
        rememberChangedField("SalesOrderWithoutChargeType", this.salesOrderWithoutChargeType);
        this.salesOrderWithoutChargeType = salesOrderWithoutChargeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DistributionChannel</b>
     * </p>
     *
     * @param distributionChannel
     *            Distribution Channel
     */
    public void setDistributionChannel( @Nullable final String distributionChannel )
    {
        rememberChangedField("DistributionChannel", this.distributionChannel);
        this.distributionChannel = distributionChannel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationDivision</b>
     * </p>
     *
     * @param organizationDivision
     *            Division
     */
    public void setOrganizationDivision( @Nullable final String organizationDivision )
    {
        rememberChangedField("OrganizationDivision", this.organizationDivision);
        this.organizationDivision = organizationDivision;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SalesGroup</b>
     * </p>
     *
     * @param salesGroup
     *            Sales Group
     */
    public void setSalesGroup( @Nullable final String salesGroup )
    {
        rememberChangedField("SalesGroup", this.salesGroup);
        this.salesGroup = salesGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOffice</b>
     * </p>
     *
     * @param salesOffice
     *            Sales Office
     */
    public void setSalesOffice( @Nullable final String salesOffice )
    {
        rememberChangedField("SalesOffice", this.salesOffice);
        this.salesOffice = salesOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesDistrict</b>
     * </p>
     *
     * @param salesDistrict
     *            Sales District
     */
    public void setSalesDistrict( @Nullable final String salesDistrict )
    {
        rememberChangedField("SalesDistrict", this.salesDistrict);
        this.salesDistrict = salesDistrict;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SoldToParty</b>
     * </p>
     *
     * @param soldToParty
     *            Sold-to Party
     */
    public void setSoldToParty( @Nullable final String soldToParty )
    {
        rememberChangedField("SoldToParty", this.soldToParty);
        this.soldToParty = soldToParty;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Last Changed On
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 7
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDateTime</b>
     * </p>
     *
     * @param lastChangeDateTime
     *            Last Changed On
     */
    public void setLastChangeDateTime( @Nullable final ZonedDateTime lastChangeDateTime )
    {
        rememberChangedField("LastChangeDateTime", this.lastChangeDateTime);
        this.lastChangeDateTime = lastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderType</b>
     * </p>
     *
     * @param customerPurchaseOrderType
     *            Customer Purchase Order Type
     */
    public void setCustomerPurchaseOrderType( @Nullable final String customerPurchaseOrderType )
    {
        rememberChangedField("CustomerPurchaseOrderType", this.customerPurchaseOrderType);
        this.customerPurchaseOrderType = customerPurchaseOrderType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CustomerPurchaseOrderDate</b>
     * </p>
     *
     * @param customerPurchaseOrderDate
     *            Customer Reference Date
     */
    public void setCustomerPurchaseOrderDate( @Nullable final LocalDateTime customerPurchaseOrderDate )
    {
        rememberChangedField("CustomerPurchaseOrderDate", this.customerPurchaseOrderDate);
        this.customerPurchaseOrderDate = customerPurchaseOrderDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeDate</b>
     * </p>
     *
     * @param salesOrderWithoutChargeDate
     *            Document Date (Date Received/Sent)
     */
    public void setSalesOrderWithoutChargeDate( @Nullable final LocalDateTime salesOrderWithoutChargeDate )
    {
        rememberChangedField("SalesOrderWithoutChargeDate", this.salesOrderWithoutChargeDate);
        this.salesOrderWithoutChargeDate = salesOrderWithoutChargeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>TotalNetAmount</b>
     * </p>
     *
     * @param totalNetAmount
     *            Net Value of the Sales Order in Document Currency
     */
    public void setTotalNetAmount( @Nullable final BigDecimal totalNetAmount )
    {
        rememberChangedField("TotalNetAmount", this.totalNetAmount);
        this.totalNetAmount = totalNetAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SDDocumentReason</b>
     * </p>
     *
     * @param sDDocumentReason
     *            Order Reason (Reason for the Business Transaction)
     */
    public void setSDDocumentReason( @Nullable final String sDDocumentReason )
    {
        rememberChangedField("SDDocumentReason", this.sDDocumentReason);
        this.sDDocumentReason = sDDocumentReason;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RequestedDeliveryDate</b>
     * </p>
     *
     * @param requestedDeliveryDate
     *            Requested Delivery Date
     */
    public void setRequestedDeliveryDate( @Nullable final LocalDateTime requestedDeliveryDate )
    {
        rememberChangedField("RequestedDeliveryDate", this.requestedDeliveryDate);
        this.requestedDeliveryDate = requestedDeliveryDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDateTypeRule</b>
     * </p>
     *
     * @param deliveryDateTypeRule
     *            Delivery Date Rule
     */
    public void setDeliveryDateTypeRule( @Nullable final String deliveryDateTypeRule )
    {
        rememberChangedField("DeliveryDateTypeRule", this.deliveryDateTypeRule);
        this.deliveryDateTypeRule = deliveryDateTypeRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingCondition</b>
     * </p>
     *
     * @param shippingCondition
     *            Shipping Conditions
     */
    public void setShippingCondition( @Nullable final String shippingCondition )
    {
        rememberChangedField("ShippingCondition", this.shippingCondition);
        this.shippingCondition = shippingCondition;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CompleteDeliveryIsDefined</b>
     * </p>
     *
     * @param completeDeliveryIsDefined
     *            Complete Delivery Defined for Each Sales Order?
     */
    public void setCompleteDeliveryIsDefined( @Nullable final Boolean completeDeliveryIsDefined )
    {
        rememberChangedField("CompleteDeliveryIsDefined", this.completeDeliveryIsDefined);
        this.completeDeliveryIsDefined = completeDeliveryIsDefined;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryBlockReason</b>
     * </p>
     *
     * @param deliveryBlockReason
     *            Delivery Block (Document Header)
     */
    public void setDeliveryBlockReason( @Nullable final String deliveryBlockReason )
    {
        rememberChangedField("DeliveryBlockReason", this.deliveryBlockReason);
        this.deliveryBlockReason = deliveryBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>HeaderBillingBlockReason</b>
     * </p>
     *
     * @param headerBillingBlockReason
     *            Billing Block in SD Document
     */
    public void setHeaderBillingBlockReason( @Nullable final String headerBillingBlockReason )
    {
        rememberChangedField("HeaderBillingBlockReason", this.headerBillingBlockReason);
        this.headerBillingBlockReason = headerBillingBlockReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsVersion</b>
     * </p>
     *
     * @param incotermsVersion
     *            Incoterms Version
     */
    public void setIncotermsVersion( @Nullable final String incotermsVersion )
    {
        rememberChangedField("IncotermsVersion", this.incotermsVersion);
        this.incotermsVersion = incotermsVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>AccountingDocExternalReference</b>
     * </p>
     *
     * @param accountingDocExternalReference
     *            Reference Document Number
     */
    public void setAccountingDocExternalReference( @Nullable final String accountingDocExternalReference )
    {
        rememberChangedField("AccountingDocExternalReference", this.accountingDocExternalReference);
        this.accountingDocExternalReference = accountingDocExternalReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentCategory</b>
     * </p>
     *
     * @param referenceSDDocumentCategory
     *            Document Category of Preceding SD Document
     */
    public void setReferenceSDDocumentCategory( @Nullable final String referenceSDDocumentCategory )
    {
        rememberChangedField("ReferenceSDDocumentCategory", this.referenceSDDocumentCategory);
        this.referenceSDDocumentCategory = referenceSDDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDProcessStatus</b>
     * </p>
     *
     * @param overallSDProcessStatus
     *            Overall Processing Status (Header/All Items)
     */
    public void setOverallSDProcessStatus( @Nullable final String overallSDProcessStatus )
    {
        rememberChangedField("OverallSDProcessStatus", this.overallSDProcessStatus);
        this.overallSDProcessStatus = overallSDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallTotalDeliveryStatus</b>
     * </p>
     *
     * @param overallTotalDeliveryStatus
     *            Overall Delivery Status (All Items)
     */
    public void setOverallTotalDeliveryStatus( @Nullable final String overallTotalDeliveryStatus )
    {
        rememberChangedField("OverallTotalDeliveryStatus", this.overallTotalDeliveryStatus);
        this.overallTotalDeliveryStatus = overallTotalDeliveryStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>OverallSDDocumentRejectionSts</b>
     * </p>
     *
     * @param overallSDDocumentRejectionSts
     *            Rejection Status (All Items)
     */
    public void setOverallSDDocumentRejectionSts( @Nullable final String overallSDDocumentRejectionSts )
    {
        rememberChangedField("OverallSDDocumentRejectionSts", this.overallSDDocumentRejectionSts);
        this.overallSDDocumentRejectionSts = overallSDDocumentRejectionSts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderWithoutCharge";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrderWithoutCharge", getSalesOrderWithoutCharge());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrderWithoutCharge", getSalesOrderWithoutCharge());
        values.put("SalesOrderWithoutChargeType", getSalesOrderWithoutChargeType());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("DistributionChannel", getDistributionChannel());
        values.put("OrganizationDivision", getOrganizationDivision());
        values.put("SalesGroup", getSalesGroup());
        values.put("SalesOffice", getSalesOffice());
        values.put("SalesDistrict", getSalesDistrict());
        values.put("SoldToParty", getSoldToParty());
        values.put("CreationDate", getCreationDate());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("LastChangeDateTime", getLastChangeDateTime());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("CustomerPurchaseOrderType", getCustomerPurchaseOrderType());
        values.put("CustomerPurchaseOrderDate", getCustomerPurchaseOrderDate());
        values.put("SalesOrderWithoutChargeDate", getSalesOrderWithoutChargeDate());
        values.put("TotalNetAmount", getTotalNetAmount());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("SDDocumentReason", getSDDocumentReason());
        values.put("RequestedDeliveryDate", getRequestedDeliveryDate());
        values.put("DeliveryDateTypeRule", getDeliveryDateTypeRule());
        values.put("ShippingCondition", getShippingCondition());
        values.put("CompleteDeliveryIsDefined", getCompleteDeliveryIsDefined());
        values.put("ShippingType", getShippingType());
        values.put("DeliveryBlockReason", getDeliveryBlockReason());
        values.put("HeaderBillingBlockReason", getHeaderBillingBlockReason());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("IncotermsVersion", getIncotermsVersion());
        values.put("CostCenter", getCostCenter());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("AccountingDocExternalReference", getAccountingDocExternalReference());
        values.put("ReferenceSDDocumentCategory", getReferenceSDDocumentCategory());
        values.put("OverallSDProcessStatus", getOverallSDProcessStatus());
        values.put("OverallTotalDeliveryStatus", getOverallTotalDeliveryStatus());
        values.put("OverallSDDocumentRejectionSts", getOverallSDDocumentRejectionSts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrderWithoutCharge") ) {
                final Object value = values.remove("SalesOrderWithoutCharge");
                if( (value == null) || (!value.equals(getSalesOrderWithoutCharge())) ) {
                    setSalesOrderWithoutCharge(((String) value));
                }
            }
            if( values.containsKey("SalesOrderWithoutChargeType") ) {
                final Object value = values.remove("SalesOrderWithoutChargeType");
                if( (value == null) || (!value.equals(getSalesOrderWithoutChargeType())) ) {
                    setSalesOrderWithoutChargeType(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("DistributionChannel") ) {
                final Object value = values.remove("DistributionChannel");
                if( (value == null) || (!value.equals(getDistributionChannel())) ) {
                    setDistributionChannel(((String) value));
                }
            }
            if( values.containsKey("OrganizationDivision") ) {
                final Object value = values.remove("OrganizationDivision");
                if( (value == null) || (!value.equals(getOrganizationDivision())) ) {
                    setOrganizationDivision(((String) value));
                }
            }
            if( values.containsKey("SalesGroup") ) {
                final Object value = values.remove("SalesGroup");
                if( (value == null) || (!value.equals(getSalesGroup())) ) {
                    setSalesGroup(((String) value));
                }
            }
            if( values.containsKey("SalesOffice") ) {
                final Object value = values.remove("SalesOffice");
                if( (value == null) || (!value.equals(getSalesOffice())) ) {
                    setSalesOffice(((String) value));
                }
            }
            if( values.containsKey("SalesDistrict") ) {
                final Object value = values.remove("SalesDistrict");
                if( (value == null) || (!value.equals(getSalesDistrict())) ) {
                    setSalesDistrict(((String) value));
                }
            }
            if( values.containsKey("SoldToParty") ) {
                final Object value = values.remove("SoldToParty");
                if( (value == null) || (!value.equals(getSoldToParty())) ) {
                    setSoldToParty(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangeDateTime") ) {
                final Object value = values.remove("LastChangeDateTime");
                if( (value == null) || (!value.equals(getLastChangeDateTime())) ) {
                    setLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderType") ) {
                final Object value = values.remove("CustomerPurchaseOrderType");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderType())) ) {
                    setCustomerPurchaseOrderType(((String) value));
                }
            }
            if( values.containsKey("CustomerPurchaseOrderDate") ) {
                final Object value = values.remove("CustomerPurchaseOrderDate");
                if( (value == null) || (!value.equals(getCustomerPurchaseOrderDate())) ) {
                    setCustomerPurchaseOrderDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SalesOrderWithoutChargeDate") ) {
                final Object value = values.remove("SalesOrderWithoutChargeDate");
                if( (value == null) || (!value.equals(getSalesOrderWithoutChargeDate())) ) {
                    setSalesOrderWithoutChargeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TotalNetAmount") ) {
                final Object value = values.remove("TotalNetAmount");
                if( (value == null) || (!value.equals(getTotalNetAmount())) ) {
                    setTotalNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("SDDocumentReason") ) {
                final Object value = values.remove("SDDocumentReason");
                if( (value == null) || (!value.equals(getSDDocumentReason())) ) {
                    setSDDocumentReason(((String) value));
                }
            }
            if( values.containsKey("RequestedDeliveryDate") ) {
                final Object value = values.remove("RequestedDeliveryDate");
                if( (value == null) || (!value.equals(getRequestedDeliveryDate())) ) {
                    setRequestedDeliveryDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DeliveryDateTypeRule") ) {
                final Object value = values.remove("DeliveryDateTypeRule");
                if( (value == null) || (!value.equals(getDeliveryDateTypeRule())) ) {
                    setDeliveryDateTypeRule(((String) value));
                }
            }
            if( values.containsKey("ShippingCondition") ) {
                final Object value = values.remove("ShippingCondition");
                if( (value == null) || (!value.equals(getShippingCondition())) ) {
                    setShippingCondition(((String) value));
                }
            }
            if( values.containsKey("CompleteDeliveryIsDefined") ) {
                final Object value = values.remove("CompleteDeliveryIsDefined");
                if( (value == null) || (!value.equals(getCompleteDeliveryIsDefined())) ) {
                    setCompleteDeliveryIsDefined(((Boolean) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("DeliveryBlockReason") ) {
                final Object value = values.remove("DeliveryBlockReason");
                if( (value == null) || (!value.equals(getDeliveryBlockReason())) ) {
                    setDeliveryBlockReason(((String) value));
                }
            }
            if( values.containsKey("HeaderBillingBlockReason") ) {
                final Object value = values.remove("HeaderBillingBlockReason");
                if( (value == null) || (!value.equals(getHeaderBillingBlockReason())) ) {
                    setHeaderBillingBlockReason(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("IncotermsVersion") ) {
                final Object value = values.remove("IncotermsVersion");
                if( (value == null) || (!value.equals(getIncotermsVersion())) ) {
                    setIncotermsVersion(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("AccountingDocExternalReference") ) {
                final Object value = values.remove("AccountingDocExternalReference");
                if( (value == null) || (!value.equals(getAccountingDocExternalReference())) ) {
                    setAccountingDocExternalReference(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentCategory") ) {
                final Object value = values.remove("ReferenceSDDocumentCategory");
                if( (value == null) || (!value.equals(getReferenceSDDocumentCategory())) ) {
                    setReferenceSDDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("OverallSDProcessStatus") ) {
                final Object value = values.remove("OverallSDProcessStatus");
                if( (value == null) || (!value.equals(getOverallSDProcessStatus())) ) {
                    setOverallSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("OverallTotalDeliveryStatus") ) {
                final Object value = values.remove("OverallTotalDeliveryStatus");
                if( (value == null) || (!value.equals(getOverallTotalDeliveryStatus())) ) {
                    setOverallTotalDeliveryStatus(((String) value));
                }
            }
            if( values.containsKey("OverallSDDocumentRejectionSts") ) {
                final Object value = values.remove("OverallSDDocumentRejectionSts");
                if( (value == null) || (!value.equals(getOverallSDDocumentRejectionSts())) ) {
                    setOverallSDDocumentRejectionSts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Iterable ) {
                    if( toItem == null ) {
                        toItem = Lists.newArrayList();
                    } else {
                        toItem = Lists.newArrayList(toItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrderWithoutChargeItem entity;
                        if( toItem.size() > i ) {
                            entity = toItem.get(i);
                        } else {
                            entity = new SalesOrderWithoutChargeItem();
                            toItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsOrdWthoutChrgPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SlsOrdWthoutChrgPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsOrdWthoutChrgText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new SlsOrdWthoutChrgText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrderWithoutChargeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderWithoutChargeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderWithoutChargeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderWithoutChargeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderWithoutChargeItem</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrderWithoutChargeItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderWithoutChargeItem> fetchItem()
    {
        return fetchFieldAsList("to_Item", SalesOrderWithoutChargeItem.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutChargeItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SalesOrderWithoutCharge</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderWithoutChargeItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrderWithoutChargeItem> getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutChargeItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderWithoutCharge</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>SalesOrderWithoutChargeItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrderWithoutChargeItem>> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the list of associated <b>SalesOrderWithoutChargeItem</b> entities for the loaded navigation property
     * <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SalesOrderWithoutCharge</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrderWithoutChargeItem</b> entities.
     */
    public void setItem( @Nonnull final List<SalesOrderWithoutChargeItem> value )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.clear();
        toItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrderWithoutChargeItem</b> entities. This corresponds to the
     * OData navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SalesOrderWithoutCharge</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrderWithoutChargeItem</b> entities.
     */
    public void addItem( SalesOrderWithoutChargeItem... entity )
    {
        if( toItem == null ) {
            toItem = Lists.newArrayList();
        }
        toItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SlsOrdWthoutChrgPartner</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsOrdWthoutChrgPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdWthoutChrgPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SlsOrdWthoutChrgPartner.class);
    }

    /**
     * Retrieval of associated <b>SlsOrdWthoutChrgPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderWithoutCharge</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsOrdWthoutChrgPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdWthoutChrgPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SlsOrdWthoutChrgPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderWithoutCharge</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SlsOrdWthoutChrgPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsOrdWthoutChrgPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SlsOrdWthoutChrgPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderWithoutCharge</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsOrdWthoutChrgPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SlsOrdWthoutChrgPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsOrdWthoutChrgPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderWithoutCharge</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsOrdWthoutChrgPartner</b> entities.
     */
    public void addPartner( SlsOrdWthoutChrgPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SlsOrdWthoutChrgText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsOrdWthoutChrgText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdWthoutChrgText> fetchText()
    {
        return fetchFieldAsList("to_Text", SlsOrdWthoutChrgText.class);
    }

    /**
     * Retrieval of associated <b>SlsOrdWthoutChrgText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrderWithoutCharge</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsOrdWthoutChrgText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdWthoutChrgText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>SlsOrdWthoutChrgText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderWithoutCharge</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>SlsOrdWthoutChrgText</b> entities. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<List<SlsOrdWthoutChrgText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>SlsOrdWthoutChrgText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrderWithoutCharge</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsOrdWthoutChrgText</b> entities.
     */
    public void setText( @Nonnull final List<SlsOrdWthoutChrgText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsOrdWthoutChrgText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrderWithoutCharge</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsOrdWthoutChrgText</b> entities.
     */
    public void addText( SlsOrdWthoutChrgText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderWithoutCharge instances.
     *
     */
    public final static class SalesOrderWithoutChargeBuilder
    {

        private List<SalesOrderWithoutChargeItem> toItem = Lists.newArrayList();
        private List<SlsOrdWthoutChrgPartner> toPartner = Lists.newArrayList();
        private List<SlsOrdWthoutChrgText> toText = Lists.newArrayList();

        private SalesOrderWithoutCharge.SalesOrderWithoutChargeBuilder toItem(
            final List<SalesOrderWithoutChargeItem> value )
        {
            toItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>SalesOrderWithoutCharge</b> to multiple
         * <b>SalesOrderWithoutChargeItem</b>.
         *
         * @param value
         *            The SalesOrderWithoutChargeItems to build this SalesOrderWithoutCharge with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderWithoutCharge.SalesOrderWithoutChargeBuilder item( SalesOrderWithoutChargeItem... value )
        {
            return toItem(Lists.newArrayList(value));
        }

        private SalesOrderWithoutCharge.SalesOrderWithoutChargeBuilder toPartner(
            final List<SlsOrdWthoutChrgPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>SalesOrderWithoutCharge</b> to multiple
         * <b>SlsOrdWthoutChrgPartner</b>.
         *
         * @param value
         *            The SlsOrdWthoutChrgPartners to build this SalesOrderWithoutCharge with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderWithoutCharge.SalesOrderWithoutChargeBuilder partner( SlsOrdWthoutChrgPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private SalesOrderWithoutCharge.SalesOrderWithoutChargeBuilder toText( final List<SlsOrdWthoutChrgText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>SalesOrderWithoutCharge</b> to multiple
         * <b>SlsOrdWthoutChrgText</b>.
         *
         * @param value
         *            The SlsOrdWthoutChrgTexts to build this SalesOrderWithoutCharge with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderWithoutCharge.SalesOrderWithoutChargeBuilder text( SlsOrdWthoutChrgText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
