/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.field.SalesOrderWithoutChargeItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.link.SalesOrderWithoutChargeItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.link.SalesOrderWithoutChargeItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable.SalesOrderWithoutChargeItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Sales Order Without Charge Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SalesOrderWithoutChargeItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrderWithoutChargeItem extends VdmEntity<SalesOrderWithoutChargeItem>
{

    /**
     * Selector for all available fields of SalesOrderWithoutChargeItem.
     *
     */
    public final static SalesOrderWithoutChargeItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
     * </p>
     *
     * @return Sales Order Without Charge
     */
    @Key
    @SerializedName( "SalesOrderWithoutCharge" )
    @JsonProperty( "SalesOrderWithoutCharge" )
    @Nullable
    @ODataField( odataName = "SalesOrderWithoutCharge" )
    private String salesOrderWithoutCharge;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutCharge</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> SALES_ORDER_WITHOUT_CHARGE =
        new SalesOrderWithoutChargeItemField<String>("SalesOrderWithoutCharge");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeItem</b>
     * </p>
     *
     * @return Sales Order Without Charge Item
     */
    @Key
    @SerializedName( "SalesOrderWithoutChargeItem" )
    @JsonProperty( "SalesOrderWithoutChargeItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderWithoutChargeItem" )
    private String salesOrderWithoutChargeItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutChargeItem</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> SALES_ORDER_WITHOUT_CHARGE_ITEM =
        new SalesOrderWithoutChargeItemField<String>("SalesOrderWithoutChargeItem");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @return Higher-Level Item in Bill of Material Structures
     */
    @SerializedName( "HigherLevelItem" )
    @JsonProperty( "HigherLevelItem" )
    @Nullable
    @ODataField( odataName = "HigherLevelItem" )
    private String higherLevelItem;
    /**
     * Use with available fluent helpers to apply the <b>HigherLevelItem</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> HIGHER_LEVEL_ITEM =
        new SalesOrderWithoutChargeItemField<String>("HigherLevelItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SlsOrdWthoutChrgItemCategory</b>
     * </p>
     *
     * @return Sales Document Item Category
     */
    @SerializedName( "SlsOrdWthoutChrgItemCategory" )
    @JsonProperty( "SlsOrdWthoutChrgItemCategory" )
    @Nullable
    @ODataField( odataName = "SlsOrdWthoutChrgItemCategory" )
    private String slsOrdWthoutChrgItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SlsOrdWthoutChrgItemCategory</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> SLS_ORD_WTHOUT_CHRG_ITEM_CATEGORY =
        new SalesOrderWithoutChargeItemField<String>("SlsOrdWthoutChrgItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWthoutChrgItemText</b>
     * </p>
     *
     * @return Short Text for Sales Order Item
     */
    @SerializedName( "SalesOrderWthoutChrgItemText" )
    @JsonProperty( "SalesOrderWthoutChrgItemText" )
    @Nullable
    @ODataField( odataName = "SalesOrderWthoutChrgItemText" )
    private String salesOrderWthoutChrgItemText;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWthoutChrgItemText</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> SALES_ORDER_WTHOUT_CHRG_ITEM_TEXT =
        new SalesOrderWithoutChargeItemField<String>("SalesOrderWthoutChrgItemText");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @return Customer Reference
     */
    @SerializedName( "PurchaseOrderByCustomer" )
    @JsonProperty( "PurchaseOrderByCustomer" )
    @Nullable
    @ODataField( odataName = "PurchaseOrderByCustomer" )
    private String purchaseOrderByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>PurchaseOrderByCustomer</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> PURCHASE_ORDER_BY_CUSTOMER =
        new SalesOrderWithoutChargeItemField<String>("PurchaseOrderByCustomer");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> MATERIAL =
        new SalesOrderWithoutChargeItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @return Material Number Used by Customer
     */
    @SerializedName( "MaterialByCustomer" )
    @JsonProperty( "MaterialByCustomer" )
    @Nullable
    @ODataField( odataName = "MaterialByCustomer" )
    private String materialByCustomer;
    /**
     * Use with available fluent helpers to apply the <b>MaterialByCustomer</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> MATERIAL_BY_CUSTOMER =
        new SalesOrderWithoutChargeItemField<String>("MaterialByCustomer");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @return Requested Quantity
     */
    @SerializedName( "RequestedQuantity" )
    @JsonProperty( "RequestedQuantity" )
    @Nullable
    @ODataField( odataName = "RequestedQuantity" )
    private BigDecimal requestedQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantity</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<BigDecimal> REQUESTED_QUANTITY =
        new SalesOrderWithoutChargeItemField<BigDecimal>("RequestedQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @return Unit of the Requested Quantity
     */
    @SerializedName( "RequestedQuantityUnit" )
    @JsonProperty( "RequestedQuantityUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityUnit" )
    private String requestedQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityUnit</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> REQUESTED_QUANTITY_UNIT =
        new SalesOrderWithoutChargeItemField<String>("RequestedQuantityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantitySAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Requested Quantity
     */
    @SerializedName( "RequestedQuantitySAPUnit" )
    @JsonProperty( "RequestedQuantitySAPUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantitySAPUnit" )
    private String requestedQuantitySAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantitySAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> REQUESTED_QUANTITY_SAP_UNIT =
        new SalesOrderWithoutChargeItemField<String>("RequestedQuantitySAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Requested Quantity
     */
    @SerializedName( "RequestedQuantityISOUnit" )
    @JsonProperty( "RequestedQuantityISOUnit" )
    @Nullable
    @ODataField( odataName = "RequestedQuantityISOUnit" )
    private String requestedQuantityISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>RequestedQuantityISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> REQUESTED_QUANTITY_ISO_UNIT =
        new SalesOrderWithoutChargeItemField<String>("RequestedQuantityISOUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @return Gross Weight of the Item
     */
    @SerializedName( "ItemGrossWeight" )
    @JsonProperty( "ItemGrossWeight" )
    @Nullable
    @ODataField( odataName = "ItemGrossWeight" )
    private BigDecimal itemGrossWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemGrossWeight</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<BigDecimal> ITEM_GROSS_WEIGHT =
        new SalesOrderWithoutChargeItemField<BigDecimal>("ItemGrossWeight");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @return Net Weight of the Item
     */
    @SerializedName( "ItemNetWeight" )
    @JsonProperty( "ItemNetWeight" )
    @Nullable
    @ODataField( odataName = "ItemNetWeight" )
    private BigDecimal itemNetWeight;
    /**
     * Use with available fluent helpers to apply the <b>ItemNetWeight</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<BigDecimal> ITEM_NET_WEIGHT =
        new SalesOrderWithoutChargeItemField<BigDecimal>("ItemNetWeight");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @return Unit of Weight
     */
    @SerializedName( "ItemWeightUnit" )
    @JsonProperty( "ItemWeightUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightUnit" )
    private String itemWeightUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightUnit</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> ITEM_WEIGHT_UNIT =
        new SalesOrderWithoutChargeItemField<String>("ItemWeightUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightSAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Item Weight
     */
    @SerializedName( "ItemWeightSAPUnit" )
    @JsonProperty( "ItemWeightSAPUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightSAPUnit" )
    private String itemWeightSAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightSAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> ITEM_WEIGHT_SAP_UNIT =
        new SalesOrderWithoutChargeItemField<String>("ItemWeightSAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Item Weight
     */
    @SerializedName( "ItemWeightISOUnit" )
    @JsonProperty( "ItemWeightISOUnit" )
    @Nullable
    @ODataField( odataName = "ItemWeightISOUnit" )
    private String itemWeightISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemWeightISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> ITEM_WEIGHT_ISO_UNIT =
        new SalesOrderWithoutChargeItemField<String>("ItemWeightISOUnit");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @return Volume of the item
     */
    @SerializedName( "ItemVolume" )
    @JsonProperty( "ItemVolume" )
    @Nullable
    @ODataField( odataName = "ItemVolume" )
    private BigDecimal itemVolume;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolume</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<BigDecimal> ITEM_VOLUME =
        new SalesOrderWithoutChargeItemField<BigDecimal>("ItemVolume");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @return Volume Unit
     */
    @SerializedName( "ItemVolumeUnit" )
    @JsonProperty( "ItemVolumeUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeUnit" )
    private String itemVolumeUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeUnit</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> ITEM_VOLUME_UNIT =
        new SalesOrderWithoutChargeItemField<String>("ItemVolumeUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeSAPUnit</b>
     * </p>
     *
     * @return SAP Unit Code for Item Volume
     */
    @SerializedName( "ItemVolumeSAPUnit" )
    @JsonProperty( "ItemVolumeSAPUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeSAPUnit" )
    private String itemVolumeSAPUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeSAPUnit</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> ITEM_VOLUME_SAP_UNIT =
        new SalesOrderWithoutChargeItemField<String>("ItemVolumeSAPUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeISOUnit</b>
     * </p>
     *
     * @return ISO Unit Code for Item Volume
     */
    @SerializedName( "ItemVolumeISOUnit" )
    @JsonProperty( "ItemVolumeISOUnit" )
    @Nullable
    @ODataField( odataName = "ItemVolumeISOUnit" )
    private String itemVolumeISOUnit;
    /**
     * Use with available fluent helpers to apply the <b>ItemVolumeISOUnit</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> ITEM_VOLUME_ISO_UNIT =
        new SalesOrderWithoutChargeItemField<String>("ItemVolumeISOUnit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return SD Document Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> TRANSACTION_CURRENCY =
        new SalesOrderWithoutChargeItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @return Net Value of the Order Item in Document Currency
     */
    @SerializedName( "NetAmount" )
    @JsonProperty( "NetAmount" )
    @Nullable
    @ODataField( odataName = "NetAmount" )
    private BigDecimal netAmount;
    /**
     * Use with available fluent helpers to apply the <b>NetAmount</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<BigDecimal> NET_AMOUNT =
        new SalesOrderWithoutChargeItemField<BigDecimal>("NetAmount");
    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Material Group
     */
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> MATERIAL_GROUP =
        new SalesOrderWithoutChargeItemField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @return Material Price Group
     */
    @SerializedName( "MaterialPricingGroup" )
    @JsonProperty( "MaterialPricingGroup" )
    @Nullable
    @ODataField( odataName = "MaterialPricingGroup" )
    private String materialPricingGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialPricingGroup</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> MATERIAL_PRICING_GROUP =
        new SalesOrderWithoutChargeItemField<String>("MaterialPricingGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @return Batch Number
     */
    @SerializedName( "Batch" )
    @JsonProperty( "Batch" )
    @Nullable
    @ODataField( odataName = "Batch" )
    private String batch;
    /**
     * Use with available fluent helpers to apply the <b>Batch</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> BATCH =
        new SalesOrderWithoutChargeItemField<String>("Batch");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant (Own or External)
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> PLANT =
        new SalesOrderWithoutChargeItemField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> STORAGE_LOCATION =
        new SalesOrderWithoutChargeItemField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @return Shipping Point / Receiving Point
     */
    @SerializedName( "ShippingPoint" )
    @JsonProperty( "ShippingPoint" )
    @Nullable
    @ODataField( odataName = "ShippingPoint" )
    private String shippingPoint;
    /**
     * Use with available fluent helpers to apply the <b>ShippingPoint</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> SHIPPING_POINT =
        new SalesOrderWithoutChargeItemField<String>("ShippingPoint");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @return Shipping Type
     */
    @SerializedName( "ShippingType" )
    @JsonProperty( "ShippingType" )
    @Nullable
    @ODataField( odataName = "ShippingType" )
    private String shippingType;
    /**
     * Use with available fluent helpers to apply the <b>ShippingType</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> SHIPPING_TYPE =
        new SalesOrderWithoutChargeItemField<String>("ShippingType");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @return Delivery Priority
     */
    @SerializedName( "DeliveryPriority" )
    @JsonProperty( "DeliveryPriority" )
    @Nullable
    @ODataField( odataName = "DeliveryPriority" )
    private String deliveryPriority;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryPriority</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> DELIVERY_PRIORITY =
        new SalesOrderWithoutChargeItemField<String>("DeliveryPriority");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDateTypeRule</b>
     * </p>
     *
     * @return Delivery Date Rule
     */
    @SerializedName( "DeliveryDateTypeRule" )
    @JsonProperty( "DeliveryDateTypeRule" )
    @Nullable
    @ODataField( odataName = "DeliveryDateTypeRule" )
    private String deliveryDateTypeRule;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryDateTypeRule</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> DELIVERY_DATE_TYPE_RULE =
        new SalesOrderWithoutChargeItemField<String>("DeliveryDateTypeRule");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @return Incoterms (Part 1)
     */
    @SerializedName( "IncotermsClassification" )
    @JsonProperty( "IncotermsClassification" )
    @Nullable
    @ODataField( odataName = "IncotermsClassification" )
    private String incotermsClassification;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsClassification</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> INCOTERMS_CLASSIFICATION =
        new SalesOrderWithoutChargeItemField<String>("IncotermsClassification");
    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @return Incoterms (Part 2)
     */
    @SerializedName( "IncotermsTransferLocation" )
    @JsonProperty( "IncotermsTransferLocation" )
    @Nullable
    @ODataField( odataName = "IncotermsTransferLocation" )
    private String incotermsTransferLocation;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsTransferLocation</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> INCOTERMS_TRANSFER_LOCATION =
        new SalesOrderWithoutChargeItemField<String>("IncotermsTransferLocation");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @return Incoterms Location 1
     */
    @SerializedName( "IncotermsLocation1" )
    @JsonProperty( "IncotermsLocation1" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation1" )
    private String incotermsLocation1;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation1</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> INCOTERMS_LOCATION1 =
        new SalesOrderWithoutChargeItemField<String>("IncotermsLocation1");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @return Incoterms Location 2
     */
    @SerializedName( "IncotermsLocation2" )
    @JsonProperty( "IncotermsLocation2" )
    @Nullable
    @ODataField( odataName = "IncotermsLocation2" )
    private String incotermsLocation2;
    /**
     * Use with available fluent helpers to apply the <b>IncotermsLocation2</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> INCOTERMS_LOCATION2 =
        new SalesOrderWithoutChargeItemField<String>("IncotermsLocation2");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @return Reason for Rejection of Sales Documents
     */
    @SerializedName( "SalesDocumentRjcnReason" )
    @JsonProperty( "SalesDocumentRjcnReason" )
    @Nullable
    @ODataField( odataName = "SalesDocumentRjcnReason" )
    private String salesDocumentRjcnReason;
    /**
     * Use with available fluent helpers to apply the <b>SalesDocumentRjcnReason</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> SALES_DOCUMENT_RJCN_REASON =
        new SalesOrderWithoutChargeItemField<String>("SalesDocumentRjcnReason");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> WBS_ELEMENT =
        new SalesOrderWithoutChargeItemField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> PROFIT_CENTER =
        new SalesOrderWithoutChargeItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @return Document Number of Reference Document
     */
    @SerializedName( "ReferenceSDDocument" )
    @JsonProperty( "ReferenceSDDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocument" )
    private String referenceSDDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocument</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> REFERENCE_SD_DOCUMENT =
        new SalesOrderWithoutChargeItemField<String>("ReferenceSDDocument");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @return Item Number of the Reference Item
     */
    @SerializedName( "ReferenceSDDocumentItem" )
    @JsonProperty( "ReferenceSDDocumentItem" )
    @Nullable
    @ODataField( odataName = "ReferenceSDDocumentItem" )
    private String referenceSDDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceSDDocumentItem</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> REFERENCE_SD_DOCUMENT_ITEM =
        new SalesOrderWithoutChargeItemField<String>("ReferenceSDDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @return Overall Processing Status (Item)
     */
    @SerializedName( "SDProcessStatus" )
    @JsonProperty( "SDProcessStatus" )
    @Nullable
    @ODataField( odataName = "SDProcessStatus" )
    private String sDProcessStatus;
    /**
     * Use with available fluent helpers to apply the <b>SDProcessStatus</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> SD_PROCESS_STATUS =
        new SalesOrderWithoutChargeItemField<String>("SDProcessStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryStatus</b>
     * </p>
     *
     * @return Delivery Status (Item)
     */
    @SerializedName( "DeliveryStatus" )
    @JsonProperty( "DeliveryStatus" )
    @Nullable
    @ODataField( odataName = "DeliveryStatus" )
    private String deliveryStatus;
    /**
     * Use with available fluent helpers to apply the <b>DeliveryStatus</b> field to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemField<String> DELIVERY_STATUS =
        new SalesOrderWithoutChargeItemField<String>("DeliveryStatus");
    /**
     * Navigation property <b>to_Partner</b> for <b>SalesOrderWithoutChargeItem</b> to multiple
     * <b>SlsOrdWthoutChrgItmPartner</b>.
     *
     */
    @SerializedName( "to_Partner" )
    @JsonProperty( "to_Partner" )
    @ODataField( odataName = "to_Partner" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsOrdWthoutChrgItmPartner> toPartner;
    /**
     * Navigation property <b>to_SalesOrderWithoutCharge</b> for <b>SalesOrderWithoutChargeItem</b> to single
     * <b>SalesOrderWithoutCharge</b>.
     *
     */
    @SerializedName( "to_SalesOrderWithoutCharge" )
    @JsonProperty( "to_SalesOrderWithoutCharge" )
    @ODataField( odataName = "to_SalesOrderWithoutCharge" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderWithoutCharge toSalesOrderWithoutCharge;
    /**
     * Navigation property <b>to_ScheduleLine</b> for <b>SalesOrderWithoutChargeItem</b> to multiple
     * <b>SlsOrdWthoutChrgSchedLine</b>.
     *
     */
    @SerializedName( "to_ScheduleLine" )
    @JsonProperty( "to_ScheduleLine" )
    @ODataField( odataName = "to_ScheduleLine" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsOrdWthoutChrgSchedLine> toScheduleLine;
    /**
     * Navigation property <b>to_Text</b> for <b>SalesOrderWithoutChargeItem</b> to multiple
     * <b>SlsOrdWthoutChrgItmText</b>.
     *
     */
    @SerializedName( "to_Text" )
    @JsonProperty( "to_Text" )
    @ODataField( odataName = "to_Text" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SlsOrdWthoutChrgItmText> toText;
    /**
     * Use with available fluent helpers to apply the <b>to_Partner</b> navigation property to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemLink<SlsOrdWthoutChrgItmPartner> TO_PARTNER =
        new SalesOrderWithoutChargeItemLink<SlsOrdWthoutChrgItmPartner>("to_Partner");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrderWithoutCharge</b> navigation property to query
     * operations.
     *
     */
    public final static SalesOrderWithoutChargeItemOneToOneLink<SalesOrderWithoutCharge> TO_SALES_ORDER_WITHOUT_CHARGE =
        new SalesOrderWithoutChargeItemOneToOneLink<SalesOrderWithoutCharge>("to_SalesOrderWithoutCharge");
    /**
     * Use with available fluent helpers to apply the <b>to_ScheduleLine</b> navigation property to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemLink<SlsOrdWthoutChrgSchedLine> TO_SCHEDULE_LINE =
        new SalesOrderWithoutChargeItemLink<SlsOrdWthoutChrgSchedLine>("to_ScheduleLine");
    /**
     * Use with available fluent helpers to apply the <b>to_Text</b> navigation property to query operations.
     *
     */
    public final static SalesOrderWithoutChargeItemLink<SlsOrdWthoutChrgItmText> TO_TEXT =
        new SalesOrderWithoutChargeItemLink<SlsOrdWthoutChrgItmText>("to_Text");

    @Nonnull
    @Override
    public Class<SalesOrderWithoutChargeItem> getType()
    {
        return SalesOrderWithoutChargeItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
     * </p>
     *
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     */
    public void setSalesOrderWithoutCharge( @Nullable final String salesOrderWithoutCharge )
    {
        rememberChangedField("SalesOrderWithoutCharge", this.salesOrderWithoutCharge);
        this.salesOrderWithoutCharge = salesOrderWithoutCharge;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeItem</b>
     * </p>
     *
     * @param salesOrderWithoutChargeItem
     *            Sales Order Without Charge Item
     */
    public void setSalesOrderWithoutChargeItem( @Nullable final String salesOrderWithoutChargeItem )
    {
        rememberChangedField("SalesOrderWithoutChargeItem", this.salesOrderWithoutChargeItem);
        this.salesOrderWithoutChargeItem = salesOrderWithoutChargeItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HigherLevelItem</b>
     * </p>
     *
     * @param higherLevelItem
     *            Higher-Level Item in Bill of Material Structures
     */
    public void setHigherLevelItem( @Nullable final String higherLevelItem )
    {
        rememberChangedField("HigherLevelItem", this.higherLevelItem);
        this.higherLevelItem = higherLevelItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SlsOrdWthoutChrgItemCategory</b>
     * </p>
     *
     * @param slsOrdWthoutChrgItemCategory
     *            Sales Document Item Category
     */
    public void setSlsOrdWthoutChrgItemCategory( @Nullable final String slsOrdWthoutChrgItemCategory )
    {
        rememberChangedField("SlsOrdWthoutChrgItemCategory", this.slsOrdWthoutChrgItemCategory);
        this.slsOrdWthoutChrgItemCategory = slsOrdWthoutChrgItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWthoutChrgItemText</b>
     * </p>
     *
     * @param salesOrderWthoutChrgItemText
     *            Short Text for Sales Order Item
     */
    public void setSalesOrderWthoutChrgItemText( @Nullable final String salesOrderWthoutChrgItemText )
    {
        rememberChangedField("SalesOrderWthoutChrgItemText", this.salesOrderWthoutChrgItemText);
        this.salesOrderWthoutChrgItemText = salesOrderWthoutChrgItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>PurchaseOrderByCustomer</b>
     * </p>
     *
     * @param purchaseOrderByCustomer
     *            Customer Reference
     */
    public void setPurchaseOrderByCustomer( @Nullable final String purchaseOrderByCustomer )
    {
        rememberChangedField("PurchaseOrderByCustomer", this.purchaseOrderByCustomer);
        this.purchaseOrderByCustomer = purchaseOrderByCustomer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 35
     * <p>
     * Original property name from the Odata EDM: <b>MaterialByCustomer</b>
     * </p>
     *
     * @param materialByCustomer
     *            Material Number Used by Customer
     */
    public void setMaterialByCustomer( @Nullable final String materialByCustomer )
    {
        rememberChangedField("MaterialByCustomer", this.materialByCustomer);
        this.materialByCustomer = materialByCustomer;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantity</b>
     * </p>
     *
     * @param requestedQuantity
     *            Requested Quantity
     */
    public void setRequestedQuantity( @Nullable final BigDecimal requestedQuantity )
    {
        rememberChangedField("RequestedQuantity", this.requestedQuantity);
        this.requestedQuantity = requestedQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityUnit</b>
     * </p>
     *
     * @param requestedQuantityUnit
     *            Unit of the Requested Quantity
     */
    public void setRequestedQuantityUnit( @Nullable final String requestedQuantityUnit )
    {
        rememberChangedField("RequestedQuantityUnit", this.requestedQuantityUnit);
        this.requestedQuantityUnit = requestedQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantitySAPUnit</b>
     * </p>
     *
     * @param requestedQuantitySAPUnit
     *            SAP Unit Code for Requested Quantity
     */
    public void setRequestedQuantitySAPUnit( @Nullable final String requestedQuantitySAPUnit )
    {
        rememberChangedField("RequestedQuantitySAPUnit", this.requestedQuantitySAPUnit);
        this.requestedQuantitySAPUnit = requestedQuantitySAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RequestedQuantityISOUnit</b>
     * </p>
     *
     * @param requestedQuantityISOUnit
     *            ISO Unit Code for Requested Quantity
     */
    public void setRequestedQuantityISOUnit( @Nullable final String requestedQuantityISOUnit )
    {
        rememberChangedField("RequestedQuantityISOUnit", this.requestedQuantityISOUnit);
        this.requestedQuantityISOUnit = requestedQuantityISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemGrossWeight</b>
     * </p>
     *
     * @param itemGrossWeight
     *            Gross Weight of the Item
     */
    public void setItemGrossWeight( @Nullable final BigDecimal itemGrossWeight )
    {
        rememberChangedField("ItemGrossWeight", this.itemGrossWeight);
        this.itemGrossWeight = itemGrossWeight;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemNetWeight</b>
     * </p>
     *
     * @param itemNetWeight
     *            Net Weight of the Item
     */
    public void setItemNetWeight( @Nullable final BigDecimal itemNetWeight )
    {
        rememberChangedField("ItemNetWeight", this.itemNetWeight);
        this.itemNetWeight = itemNetWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightUnit</b>
     * </p>
     *
     * @param itemWeightUnit
     *            Unit of Weight
     */
    public void setItemWeightUnit( @Nullable final String itemWeightUnit )
    {
        rememberChangedField("ItemWeightUnit", this.itemWeightUnit);
        this.itemWeightUnit = itemWeightUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightSAPUnit</b>
     * </p>
     *
     * @param itemWeightSAPUnit
     *            SAP Unit Code for Item Weight
     */
    public void setItemWeightSAPUnit( @Nullable final String itemWeightSAPUnit )
    {
        rememberChangedField("ItemWeightSAPUnit", this.itemWeightSAPUnit);
        this.itemWeightSAPUnit = itemWeightSAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemWeightISOUnit</b>
     * </p>
     *
     * @param itemWeightISOUnit
     *            ISO Unit Code for Item Weight
     */
    public void setItemWeightISOUnit( @Nullable final String itemWeightISOUnit )
    {
        rememberChangedField("ItemWeightISOUnit", this.itemWeightISOUnit);
        this.itemWeightISOUnit = itemWeightISOUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolume</b>
     * </p>
     *
     * @param itemVolume
     *            Volume of the item
     */
    public void setItemVolume( @Nullable final BigDecimal itemVolume )
    {
        rememberChangedField("ItemVolume", this.itemVolume);
        this.itemVolume = itemVolume;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeUnit</b>
     * </p>
     *
     * @param itemVolumeUnit
     *            Volume Unit
     */
    public void setItemVolumeUnit( @Nullable final String itemVolumeUnit )
    {
        rememberChangedField("ItemVolumeUnit", this.itemVolumeUnit);
        this.itemVolumeUnit = itemVolumeUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeSAPUnit</b>
     * </p>
     *
     * @param itemVolumeSAPUnit
     *            SAP Unit Code for Item Volume
     */
    public void setItemVolumeSAPUnit( @Nullable final String itemVolumeSAPUnit )
    {
        rememberChangedField("ItemVolumeSAPUnit", this.itemVolumeSAPUnit);
        this.itemVolumeSAPUnit = itemVolumeSAPUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ItemVolumeISOUnit</b>
     * </p>
     *
     * @param itemVolumeISOUnit
     *            ISO Unit Code for Item Volume
     */
    public void setItemVolumeISOUnit( @Nullable final String itemVolumeISOUnit )
    {
        rememberChangedField("ItemVolumeISOUnit", this.itemVolumeISOUnit);
        this.itemVolumeISOUnit = itemVolumeISOUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            SD Document Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 16, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>NetAmount</b>
     * </p>
     *
     * @param netAmount
     *            Net Value of the Order Item in Document Currency
     */
    public void setNetAmount( @Nullable final BigDecimal netAmount )
    {
        rememberChangedField("NetAmount", this.netAmount);
        this.netAmount = netAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Material Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>MaterialPricingGroup</b>
     * </p>
     *
     * @param materialPricingGroup
     *            Material Price Group
     */
    public void setMaterialPricingGroup( @Nullable final String materialPricingGroup )
    {
        rememberChangedField("MaterialPricingGroup", this.materialPricingGroup);
        this.materialPricingGroup = materialPricingGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Batch</b>
     * </p>
     *
     * @param batch
     *            Batch Number
     */
    public void setBatch( @Nullable final String batch )
    {
        rememberChangedField("Batch", this.batch);
        this.batch = batch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant (Own or External)
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ShippingPoint</b>
     * </p>
     *
     * @param shippingPoint
     *            Shipping Point / Receiving Point
     */
    public void setShippingPoint( @Nullable final String shippingPoint )
    {
        rememberChangedField("ShippingPoint", this.shippingPoint);
        this.shippingPoint = shippingPoint;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ShippingType</b>
     * </p>
     *
     * @param shippingType
     *            Shipping Type
     */
    public void setShippingType( @Nullable final String shippingType )
    {
        rememberChangedField("ShippingType", this.shippingType);
        this.shippingType = shippingType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryPriority</b>
     * </p>
     *
     * @param deliveryPriority
     *            Delivery Priority
     */
    public void setDeliveryPriority( @Nullable final String deliveryPriority )
    {
        rememberChangedField("DeliveryPriority", this.deliveryPriority);
        this.deliveryPriority = deliveryPriority;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryDateTypeRule</b>
     * </p>
     *
     * @param deliveryDateTypeRule
     *            Delivery Date Rule
     */
    public void setDeliveryDateTypeRule( @Nullable final String deliveryDateTypeRule )
    {
        rememberChangedField("DeliveryDateTypeRule", this.deliveryDateTypeRule);
        this.deliveryDateTypeRule = deliveryDateTypeRule;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsClassification</b>
     * </p>
     *
     * @param incotermsClassification
     *            Incoterms (Part 1)
     */
    public void setIncotermsClassification( @Nullable final String incotermsClassification )
    {
        rememberChangedField("IncotermsClassification", this.incotermsClassification);
        this.incotermsClassification = incotermsClassification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 28
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsTransferLocation</b>
     * </p>
     *
     * @param incotermsTransferLocation
     *            Incoterms (Part 2)
     */
    public void setIncotermsTransferLocation( @Nullable final String incotermsTransferLocation )
    {
        rememberChangedField("IncotermsTransferLocation", this.incotermsTransferLocation);
        this.incotermsTransferLocation = incotermsTransferLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation1</b>
     * </p>
     *
     * @param incotermsLocation1
     *            Incoterms Location 1
     */
    public void setIncotermsLocation1( @Nullable final String incotermsLocation1 )
    {
        rememberChangedField("IncotermsLocation1", this.incotermsLocation1);
        this.incotermsLocation1 = incotermsLocation1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>IncotermsLocation2</b>
     * </p>
     *
     * @param incotermsLocation2
     *            Incoterms Location 2
     */
    public void setIncotermsLocation2( @Nullable final String incotermsLocation2 )
    {
        rememberChangedField("IncotermsLocation2", this.incotermsLocation2);
        this.incotermsLocation2 = incotermsLocation2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>SalesDocumentRjcnReason</b>
     * </p>
     *
     * @param salesDocumentRjcnReason
     *            Reason for Rejection of Sales Documents
     */
    public void setSalesDocumentRjcnReason( @Nullable final String salesDocumentRjcnReason )
    {
        rememberChangedField("SalesDocumentRjcnReason", this.salesDocumentRjcnReason);
        this.salesDocumentRjcnReason = salesDocumentRjcnReason;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocument</b>
     * </p>
     *
     * @param referenceSDDocument
     *            Document Number of Reference Document
     */
    public void setReferenceSDDocument( @Nullable final String referenceSDDocument )
    {
        rememberChangedField("ReferenceSDDocument", this.referenceSDDocument);
        this.referenceSDDocument = referenceSDDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceSDDocumentItem</b>
     * </p>
     *
     * @param referenceSDDocumentItem
     *            Item Number of the Reference Item
     */
    public void setReferenceSDDocumentItem( @Nullable final String referenceSDDocumentItem )
    {
        rememberChangedField("ReferenceSDDocumentItem", this.referenceSDDocumentItem);
        this.referenceSDDocumentItem = referenceSDDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>SDProcessStatus</b>
     * </p>
     *
     * @param sDProcessStatus
     *            Overall Processing Status (Item)
     */
    public void setSDProcessStatus( @Nullable final String sDProcessStatus )
    {
        rememberChangedField("SDProcessStatus", this.sDProcessStatus);
        this.sDProcessStatus = sDProcessStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>DeliveryStatus</b>
     * </p>
     *
     * @param deliveryStatus
     *            Delivery Status (Item)
     */
    public void setDeliveryStatus( @Nullable final String deliveryStatus )
    {
        rememberChangedField("DeliveryStatus", this.deliveryStatus);
        this.deliveryStatus = deliveryStatus;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SalesOrderWithoutChargeItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrderWithoutCharge", getSalesOrderWithoutCharge());
        result.put("SalesOrderWithoutChargeItem", getSalesOrderWithoutChargeItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrderWithoutCharge", getSalesOrderWithoutCharge());
        values.put("SalesOrderWithoutChargeItem", getSalesOrderWithoutChargeItem());
        values.put("HigherLevelItem", getHigherLevelItem());
        values.put("SlsOrdWthoutChrgItemCategory", getSlsOrdWthoutChrgItemCategory());
        values.put("SalesOrderWthoutChrgItemText", getSalesOrderWthoutChrgItemText());
        values.put("PurchaseOrderByCustomer", getPurchaseOrderByCustomer());
        values.put("Material", getMaterial());
        values.put("MaterialByCustomer", getMaterialByCustomer());
        values.put("RequestedQuantity", getRequestedQuantity());
        values.put("RequestedQuantityUnit", getRequestedQuantityUnit());
        values.put("RequestedQuantitySAPUnit", getRequestedQuantitySAPUnit());
        values.put("RequestedQuantityISOUnit", getRequestedQuantityISOUnit());
        values.put("ItemGrossWeight", getItemGrossWeight());
        values.put("ItemNetWeight", getItemNetWeight());
        values.put("ItemWeightUnit", getItemWeightUnit());
        values.put("ItemWeightSAPUnit", getItemWeightSAPUnit());
        values.put("ItemWeightISOUnit", getItemWeightISOUnit());
        values.put("ItemVolume", getItemVolume());
        values.put("ItemVolumeUnit", getItemVolumeUnit());
        values.put("ItemVolumeSAPUnit", getItemVolumeSAPUnit());
        values.put("ItemVolumeISOUnit", getItemVolumeISOUnit());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("NetAmount", getNetAmount());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialPricingGroup", getMaterialPricingGroup());
        values.put("Batch", getBatch());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("ShippingPoint", getShippingPoint());
        values.put("ShippingType", getShippingType());
        values.put("DeliveryPriority", getDeliveryPriority());
        values.put("DeliveryDateTypeRule", getDeliveryDateTypeRule());
        values.put("IncotermsClassification", getIncotermsClassification());
        values.put("IncotermsTransferLocation", getIncotermsTransferLocation());
        values.put("IncotermsLocation1", getIncotermsLocation1());
        values.put("IncotermsLocation2", getIncotermsLocation2());
        values.put("SalesDocumentRjcnReason", getSalesDocumentRjcnReason());
        values.put("WBSElement", getWBSElement());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ReferenceSDDocument", getReferenceSDDocument());
        values.put("ReferenceSDDocumentItem", getReferenceSDDocumentItem());
        values.put("SDProcessStatus", getSDProcessStatus());
        values.put("DeliveryStatus", getDeliveryStatus());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrderWithoutCharge") ) {
                final Object value = values.remove("SalesOrderWithoutCharge");
                if( (value == null) || (!value.equals(getSalesOrderWithoutCharge())) ) {
                    setSalesOrderWithoutCharge(((String) value));
                }
            }
            if( values.containsKey("SalesOrderWithoutChargeItem") ) {
                final Object value = values.remove("SalesOrderWithoutChargeItem");
                if( (value == null) || (!value.equals(getSalesOrderWithoutChargeItem())) ) {
                    setSalesOrderWithoutChargeItem(((String) value));
                }
            }
            if( values.containsKey("HigherLevelItem") ) {
                final Object value = values.remove("HigherLevelItem");
                if( (value == null) || (!value.equals(getHigherLevelItem())) ) {
                    setHigherLevelItem(((String) value));
                }
            }
            if( values.containsKey("SlsOrdWthoutChrgItemCategory") ) {
                final Object value = values.remove("SlsOrdWthoutChrgItemCategory");
                if( (value == null) || (!value.equals(getSlsOrdWthoutChrgItemCategory())) ) {
                    setSlsOrdWthoutChrgItemCategory(((String) value));
                }
            }
            if( values.containsKey("SalesOrderWthoutChrgItemText") ) {
                final Object value = values.remove("SalesOrderWthoutChrgItemText");
                if( (value == null) || (!value.equals(getSalesOrderWthoutChrgItemText())) ) {
                    setSalesOrderWthoutChrgItemText(((String) value));
                }
            }
            if( values.containsKey("PurchaseOrderByCustomer") ) {
                final Object value = values.remove("PurchaseOrderByCustomer");
                if( (value == null) || (!value.equals(getPurchaseOrderByCustomer())) ) {
                    setPurchaseOrderByCustomer(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("MaterialByCustomer") ) {
                final Object value = values.remove("MaterialByCustomer");
                if( (value == null) || (!value.equals(getMaterialByCustomer())) ) {
                    setMaterialByCustomer(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantity") ) {
                final Object value = values.remove("RequestedQuantity");
                if( (value == null) || (!value.equals(getRequestedQuantity())) ) {
                    setRequestedQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RequestedQuantityUnit") ) {
                final Object value = values.remove("RequestedQuantityUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityUnit())) ) {
                    setRequestedQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantitySAPUnit") ) {
                final Object value = values.remove("RequestedQuantitySAPUnit");
                if( (value == null) || (!value.equals(getRequestedQuantitySAPUnit())) ) {
                    setRequestedQuantitySAPUnit(((String) value));
                }
            }
            if( values.containsKey("RequestedQuantityISOUnit") ) {
                final Object value = values.remove("RequestedQuantityISOUnit");
                if( (value == null) || (!value.equals(getRequestedQuantityISOUnit())) ) {
                    setRequestedQuantityISOUnit(((String) value));
                }
            }
            if( values.containsKey("ItemGrossWeight") ) {
                final Object value = values.remove("ItemGrossWeight");
                if( (value == null) || (!value.equals(getItemGrossWeight())) ) {
                    setItemGrossWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemNetWeight") ) {
                final Object value = values.remove("ItemNetWeight");
                if( (value == null) || (!value.equals(getItemNetWeight())) ) {
                    setItemNetWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemWeightUnit") ) {
                final Object value = values.remove("ItemWeightUnit");
                if( (value == null) || (!value.equals(getItemWeightUnit())) ) {
                    setItemWeightUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightSAPUnit") ) {
                final Object value = values.remove("ItemWeightSAPUnit");
                if( (value == null) || (!value.equals(getItemWeightSAPUnit())) ) {
                    setItemWeightSAPUnit(((String) value));
                }
            }
            if( values.containsKey("ItemWeightISOUnit") ) {
                final Object value = values.remove("ItemWeightISOUnit");
                if( (value == null) || (!value.equals(getItemWeightISOUnit())) ) {
                    setItemWeightISOUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolume") ) {
                final Object value = values.remove("ItemVolume");
                if( (value == null) || (!value.equals(getItemVolume())) ) {
                    setItemVolume(((BigDecimal) value));
                }
            }
            if( values.containsKey("ItemVolumeUnit") ) {
                final Object value = values.remove("ItemVolumeUnit");
                if( (value == null) || (!value.equals(getItemVolumeUnit())) ) {
                    setItemVolumeUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolumeSAPUnit") ) {
                final Object value = values.remove("ItemVolumeSAPUnit");
                if( (value == null) || (!value.equals(getItemVolumeSAPUnit())) ) {
                    setItemVolumeSAPUnit(((String) value));
                }
            }
            if( values.containsKey("ItemVolumeISOUnit") ) {
                final Object value = values.remove("ItemVolumeISOUnit");
                if( (value == null) || (!value.equals(getItemVolumeISOUnit())) ) {
                    setItemVolumeISOUnit(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("NetAmount") ) {
                final Object value = values.remove("NetAmount");
                if( (value == null) || (!value.equals(getNetAmount())) ) {
                    setNetAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialPricingGroup") ) {
                final Object value = values.remove("MaterialPricingGroup");
                if( (value == null) || (!value.equals(getMaterialPricingGroup())) ) {
                    setMaterialPricingGroup(((String) value));
                }
            }
            if( values.containsKey("Batch") ) {
                final Object value = values.remove("Batch");
                if( (value == null) || (!value.equals(getBatch())) ) {
                    setBatch(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("ShippingPoint") ) {
                final Object value = values.remove("ShippingPoint");
                if( (value == null) || (!value.equals(getShippingPoint())) ) {
                    setShippingPoint(((String) value));
                }
            }
            if( values.containsKey("ShippingType") ) {
                final Object value = values.remove("ShippingType");
                if( (value == null) || (!value.equals(getShippingType())) ) {
                    setShippingType(((String) value));
                }
            }
            if( values.containsKey("DeliveryPriority") ) {
                final Object value = values.remove("DeliveryPriority");
                if( (value == null) || (!value.equals(getDeliveryPriority())) ) {
                    setDeliveryPriority(((String) value));
                }
            }
            if( values.containsKey("DeliveryDateTypeRule") ) {
                final Object value = values.remove("DeliveryDateTypeRule");
                if( (value == null) || (!value.equals(getDeliveryDateTypeRule())) ) {
                    setDeliveryDateTypeRule(((String) value));
                }
            }
            if( values.containsKey("IncotermsClassification") ) {
                final Object value = values.remove("IncotermsClassification");
                if( (value == null) || (!value.equals(getIncotermsClassification())) ) {
                    setIncotermsClassification(((String) value));
                }
            }
            if( values.containsKey("IncotermsTransferLocation") ) {
                final Object value = values.remove("IncotermsTransferLocation");
                if( (value == null) || (!value.equals(getIncotermsTransferLocation())) ) {
                    setIncotermsTransferLocation(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation1") ) {
                final Object value = values.remove("IncotermsLocation1");
                if( (value == null) || (!value.equals(getIncotermsLocation1())) ) {
                    setIncotermsLocation1(((String) value));
                }
            }
            if( values.containsKey("IncotermsLocation2") ) {
                final Object value = values.remove("IncotermsLocation2");
                if( (value == null) || (!value.equals(getIncotermsLocation2())) ) {
                    setIncotermsLocation2(((String) value));
                }
            }
            if( values.containsKey("SalesDocumentRjcnReason") ) {
                final Object value = values.remove("SalesDocumentRjcnReason");
                if( (value == null) || (!value.equals(getSalesDocumentRjcnReason())) ) {
                    setSalesDocumentRjcnReason(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocument") ) {
                final Object value = values.remove("ReferenceSDDocument");
                if( (value == null) || (!value.equals(getReferenceSDDocument())) ) {
                    setReferenceSDDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceSDDocumentItem") ) {
                final Object value = values.remove("ReferenceSDDocumentItem");
                if( (value == null) || (!value.equals(getReferenceSDDocumentItem())) ) {
                    setReferenceSDDocumentItem(((String) value));
                }
            }
            if( values.containsKey("SDProcessStatus") ) {
                final Object value = values.remove("SDProcessStatus");
                if( (value == null) || (!value.equals(getSDProcessStatus())) ) {
                    setSDProcessStatus(((String) value));
                }
            }
            if( values.containsKey("DeliveryStatus") ) {
                final Object value = values.remove("DeliveryStatus");
                if( (value == null) || (!value.equals(getDeliveryStatus())) ) {
                    setDeliveryStatus(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Partner") ) {
                final Object value = (values).remove("to_Partner");
                if( value instanceof Iterable ) {
                    if( toPartner == null ) {
                        toPartner = Lists.newArrayList();
                    } else {
                        toPartner = Lists.newArrayList(toPartner);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsOrdWthoutChrgItmPartner entity;
                        if( toPartner.size() > i ) {
                            entity = toPartner.get(i);
                        } else {
                            entity = new SlsOrdWthoutChrgItmPartner();
                            toPartner.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_SalesOrderWithoutCharge") ) {
                final Object value = (values).remove("to_SalesOrderWithoutCharge");
                if( value instanceof Map ) {
                    if( toSalesOrderWithoutCharge == null ) {
                        toSalesOrderWithoutCharge = new SalesOrderWithoutCharge();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrderWithoutCharge.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ScheduleLine") ) {
                final Object value = (values).remove("to_ScheduleLine");
                if( value instanceof Iterable ) {
                    if( toScheduleLine == null ) {
                        toScheduleLine = Lists.newArrayList();
                    } else {
                        toScheduleLine = Lists.newArrayList(toScheduleLine);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsOrdWthoutChrgSchedLine entity;
                        if( toScheduleLine.size() > i ) {
                            entity = toScheduleLine.get(i);
                        } else {
                            entity = new SlsOrdWthoutChrgSchedLine();
                            toScheduleLine.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Text") ) {
                final Object value = (values).remove("to_Text");
                if( value instanceof Iterable ) {
                    if( toText == null ) {
                        toText = Lists.newArrayList();
                    } else {
                        toText = Lists.newArrayList(toText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SlsOrdWthoutChrgItmText entity;
                        if( toText.size() > i ) {
                            entity = toText.get(i);
                        } else {
                            entity = new SlsOrdWthoutChrgItmText();
                            toText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SalesOrderWithoutChargeItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SalesOrderWithoutChargeItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrderWithoutChargeItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrderWithoutChargeItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toPartner != null ) {
            (values).put("to_Partner", toPartner);
        }
        if( toSalesOrderWithoutCharge != null ) {
            (values).put("to_SalesOrderWithoutCharge", toSalesOrderWithoutCharge);
        }
        if( toScheduleLine != null ) {
            (values).put("to_ScheduleLine", toScheduleLine);
        }
        if( toText != null ) {
            (values).put("to_Text", toText);
        }
        return values;
    }

    /**
     * Fetches the <b>SlsOrdWthoutChrgItmPartner</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Partner</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsOrdWthoutChrgItmPartner</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdWthoutChrgItmPartner> fetchPartner()
    {
        return fetchFieldAsList("to_Partner", SlsOrdWthoutChrgItmPartner.class);
    }

    /**
     * Retrieval of associated <b>SlsOrdWthoutChrgItmPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderWithoutChargeItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsOrdWthoutChrgItmPartner</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdWthoutChrgItmPartner> getPartnerOrFetch()
    {
        if( toPartner == null ) {
            toPartner = fetchPartner();
        }
        return toPartner;
    }

    /**
     * Retrieval of associated <b>SlsOrdWthoutChrgItmPartner</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderWithoutChargeItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Partner</b> is already loaded, the result will contain
     *         the <b>SlsOrdWthoutChrgItmPartner</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsOrdWthoutChrgItmPartner>> getPartnerIfPresent()
    {
        return Option.of(toPartner);
    }

    /**
     * Overwrites the list of associated <b>SlsOrdWthoutChrgItmPartner</b> entities for the loaded navigation property
     * <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderWithoutChargeItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsOrdWthoutChrgItmPartner</b> entities.
     */
    public void setPartner( @Nonnull final List<SlsOrdWthoutChrgItmPartner> value )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.clear();
        toPartner.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsOrdWthoutChrgItmPartner</b> entities. This corresponds to the OData
     * navigation property <b>to_Partner</b>.
     * <p>
     * If the navigation property <b>to_Partner</b> of a queried <b>SalesOrderWithoutChargeItem</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsOrdWthoutChrgItmPartner</b> entities.
     */
    public void addPartner( SlsOrdWthoutChrgItmPartner... entity )
    {
        if( toPartner == null ) {
            toPartner = Lists.newArrayList();
        }
        toPartner.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrderWithoutCharge</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderWithoutCharge</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutCharge fetchSalesOrderWithoutCharge()
    {
        return fetchFieldAsSingle("to_SalesOrderWithoutCharge", SalesOrderWithoutCharge.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutCharge</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * If the navigation property <b>to_SalesOrderWithoutCharge</b> of a queried <b>SalesOrderWithoutChargeItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderWithoutCharge</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutCharge getSalesOrderWithoutChargeOrFetch()
    {
        if( toSalesOrderWithoutCharge == null ) {
            toSalesOrderWithoutCharge = fetchSalesOrderWithoutCharge();
        }
        return toSalesOrderWithoutCharge;
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutCharge</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderWithoutChargeItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrderWithoutCharge</b> is already loaded, the
     *         result will contain the <b>SalesOrderWithoutCharge</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderWithoutCharge> getSalesOrderWithoutChargeIfPresent()
    {
        return Option.of(toSalesOrderWithoutCharge);
    }

    /**
     * Overwrites the associated <b>SalesOrderWithoutCharge</b> entity for the loaded navigation property
     * <b>to_SalesOrderWithoutCharge</b>.
     *
     * @param value
     *            New <b>SalesOrderWithoutCharge</b> entity.
     */
    public void setSalesOrderWithoutCharge( final SalesOrderWithoutCharge value )
    {
        toSalesOrderWithoutCharge = value;
    }

    /**
     * Fetches the <b>SlsOrdWthoutChrgSchedLine</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ScheduleLine</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsOrdWthoutChrgSchedLine</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdWthoutChrgSchedLine> fetchScheduleLine()
    {
        return fetchFieldAsList("to_ScheduleLine", SlsOrdWthoutChrgSchedLine.class);
    }

    /**
     * Retrieval of associated <b>SlsOrdWthoutChrgSchedLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>SalesOrderWithoutChargeItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsOrdWthoutChrgSchedLine</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdWthoutChrgSchedLine> getScheduleLineOrFetch()
    {
        if( toScheduleLine == null ) {
            toScheduleLine = fetchScheduleLine();
        }
        return toScheduleLine;
    }

    /**
     * Retrieval of associated <b>SlsOrdWthoutChrgSchedLine</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderWithoutChargeItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ScheduleLine</b> is already loaded, the result will
     *         contain the <b>SlsOrdWthoutChrgSchedLine</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsOrdWthoutChrgSchedLine>> getScheduleLineIfPresent()
    {
        return Option.of(toScheduleLine);
    }

    /**
     * Overwrites the list of associated <b>SlsOrdWthoutChrgSchedLine</b> entities for the loaded navigation property
     * <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>SalesOrderWithoutChargeItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsOrdWthoutChrgSchedLine</b> entities.
     */
    public void setScheduleLine( @Nonnull final List<SlsOrdWthoutChrgSchedLine> value )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.clear();
        toScheduleLine.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsOrdWthoutChrgSchedLine</b> entities. This corresponds to the OData
     * navigation property <b>to_ScheduleLine</b>.
     * <p>
     * If the navigation property <b>to_ScheduleLine</b> of a queried <b>SalesOrderWithoutChargeItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsOrdWthoutChrgSchedLine</b> entities.
     */
    public void addScheduleLine( SlsOrdWthoutChrgSchedLine... entity )
    {
        if( toScheduleLine == null ) {
            toScheduleLine = Lists.newArrayList();
        }
        toScheduleLine.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SlsOrdWthoutChrgItmText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Text</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SlsOrdWthoutChrgItmText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdWthoutChrgItmText> fetchText()
    {
        return fetchFieldAsList("to_Text", SlsOrdWthoutChrgItmText.class);
    }

    /**
     * Retrieval of associated <b>SlsOrdWthoutChrgItmText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrderWithoutChargeItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SlsOrdWthoutChrgItmText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SlsOrdWthoutChrgItmText> getTextOrFetch()
    {
        if( toText == null ) {
            toText = fetchText();
        }
        return toText;
    }

    /**
     * Retrieval of associated <b>SlsOrdWthoutChrgItmText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrderWithoutChargeItem</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Text</b> is already loaded, the result will contain the
     *         <b>SlsOrdWthoutChrgItmText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SlsOrdWthoutChrgItmText>> getTextIfPresent()
    {
        return Option.of(toText);
    }

    /**
     * Overwrites the list of associated <b>SlsOrdWthoutChrgItmText</b> entities for the loaded navigation property
     * <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrderWithoutChargeItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SlsOrdWthoutChrgItmText</b> entities.
     */
    public void setText( @Nonnull final List<SlsOrdWthoutChrgItmText> value )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.clear();
        toText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SlsOrdWthoutChrgItmText</b> entities. This corresponds to the OData
     * navigation property <b>to_Text</b>.
     * <p>
     * If the navigation property <b>to_Text</b> of a queried <b>SalesOrderWithoutChargeItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SlsOrdWthoutChrgItmText</b> entities.
     */
    public void addText( SlsOrdWthoutChrgItmText... entity )
    {
        if( toText == null ) {
            toText = Lists.newArrayList();
        }
        toText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesOrderWithoutChargeItem instances.
     *
     */
    public final static class SalesOrderWithoutChargeItemBuilder
    {

        private List<SlsOrdWthoutChrgItmPartner> toPartner = Lists.newArrayList();
        private SalesOrderWithoutCharge toSalesOrderWithoutCharge;
        private String salesOrderWithoutCharge = null;
        private List<SlsOrdWthoutChrgSchedLine> toScheduleLine = Lists.newArrayList();
        private List<SlsOrdWthoutChrgItmText> toText = Lists.newArrayList();

        private SalesOrderWithoutChargeItem.SalesOrderWithoutChargeItemBuilder toPartner(
            final List<SlsOrdWthoutChrgItmPartner> value )
        {
            toPartner.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Partner</b> for <b>SalesOrderWithoutChargeItem</b> to multiple
         * <b>SlsOrdWthoutChrgItmPartner</b>.
         *
         * @param value
         *            The SlsOrdWthoutChrgItmPartners to build this SalesOrderWithoutChargeItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderWithoutChargeItem.SalesOrderWithoutChargeItemBuilder partner(
            SlsOrdWthoutChrgItmPartner... value )
        {
            return toPartner(Lists.newArrayList(value));
        }

        private SalesOrderWithoutChargeItem.SalesOrderWithoutChargeItemBuilder toSalesOrderWithoutCharge(
            final SalesOrderWithoutCharge value )
        {
            toSalesOrderWithoutCharge = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrderWithoutCharge</b> for <b>SalesOrderWithoutChargeItem</b> to single
         * <b>SalesOrderWithoutCharge</b>.
         *
         * @param value
         *            The SalesOrderWithoutCharge to build this SalesOrderWithoutChargeItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderWithoutChargeItem.SalesOrderWithoutChargeItemBuilder salesOrderWithoutCharge(
            final SalesOrderWithoutCharge value )
        {
            return toSalesOrderWithoutCharge(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
         * </p>
         *
         * @param value
         *            The salesOrderWithoutCharge to build this SalesOrderWithoutChargeItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderWithoutChargeItem.SalesOrderWithoutChargeItemBuilder salesOrderWithoutCharge(
            final String value )
        {
            salesOrderWithoutCharge = value;
            return this;
        }

        private SalesOrderWithoutChargeItem.SalesOrderWithoutChargeItemBuilder toScheduleLine(
            final List<SlsOrdWthoutChrgSchedLine> value )
        {
            toScheduleLine.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ScheduleLine</b> for <b>SalesOrderWithoutChargeItem</b> to multiple
         * <b>SlsOrdWthoutChrgSchedLine</b>.
         *
         * @param value
         *            The SlsOrdWthoutChrgSchedLines to build this SalesOrderWithoutChargeItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderWithoutChargeItem.SalesOrderWithoutChargeItemBuilder scheduleLine(
            SlsOrdWthoutChrgSchedLine... value )
        {
            return toScheduleLine(Lists.newArrayList(value));
        }

        private SalesOrderWithoutChargeItem.SalesOrderWithoutChargeItemBuilder toText(
            final List<SlsOrdWthoutChrgItmText> value )
        {
            toText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Text</b> for <b>SalesOrderWithoutChargeItem</b> to multiple
         * <b>SlsOrdWthoutChrgItmText</b>.
         *
         * @param value
         *            The SlsOrdWthoutChrgItmTexts to build this SalesOrderWithoutChargeItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrderWithoutChargeItem.SalesOrderWithoutChargeItemBuilder text( SlsOrdWthoutChrgItmText... value )
        {
            return toText(Lists.newArrayList(value));
        }

    }

}
