/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.field.SlsOrdWthoutChrgItmPartnerField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.link.SlsOrdWthoutChrgItmPartnerOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable.SlsOrdWthoutChrgItmPartnerSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Partner
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsOrdWthoutChrgItmPartnerType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsOrdWthoutChrgItmPartner extends VdmEntity<SlsOrdWthoutChrgItmPartner>
{

    /**
     * Selector for all available fields of SlsOrdWthoutChrgItmPartner.
     *
     */
    public final static SlsOrdWthoutChrgItmPartnerSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
     * </p>
     *
     * @return Sales Order Without Charge
     */
    @Key
    @SerializedName( "SalesOrderWithoutCharge" )
    @JsonProperty( "SalesOrderWithoutCharge" )
    @Nullable
    @ODataField( odataName = "SalesOrderWithoutCharge" )
    private String salesOrderWithoutCharge;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutCharge</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmPartnerField<String> SALES_ORDER_WITHOUT_CHARGE =
        new SlsOrdWthoutChrgItmPartnerField<String>("SalesOrderWithoutCharge");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeItem</b>
     * </p>
     *
     * @return Sales Order Without Charge Item
     */
    @Key
    @SerializedName( "SalesOrderWithoutChargeItem" )
    @JsonProperty( "SalesOrderWithoutChargeItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderWithoutChargeItem" )
    private String salesOrderWithoutChargeItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutChargeItem</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmPartnerField<String> SALES_ORDER_WITHOUT_CHARGE_ITEM =
        new SlsOrdWthoutChrgItmPartnerField<String>("SalesOrderWithoutChargeItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @return Partner Function
     */
    @Key
    @SerializedName( "PartnerFunction" )
    @JsonProperty( "PartnerFunction" )
    @Nullable
    @ODataField( odataName = "PartnerFunction" )
    private String partnerFunction;
    /**
     * Use with available fluent helpers to apply the <b>PartnerFunction</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmPartnerField<String> PARTNER_FUNCTION =
        new SlsOrdWthoutChrgItmPartnerField<String>("PartnerFunction");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Customer Number
     */
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmPartnerField<String> CUSTOMER =
        new SlsOrdWthoutChrgItmPartnerField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmPartnerField<String> SUPPLIER =
        new SlsOrdWthoutChrgItmPartnerField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "Personnel" )
    @JsonProperty( "Personnel" )
    @Nullable
    @ODataField( odataName = "Personnel" )
    private String personnel;
    /**
     * Use with available fluent helpers to apply the <b>Personnel</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmPartnerField<String> PERSONNEL =
        new SlsOrdWthoutChrgItmPartnerField<String>("Personnel");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @return Number of Contact Person
     */
    @SerializedName( "ContactPerson" )
    @JsonProperty( "ContactPerson" )
    @Nullable
    @ODataField( odataName = "ContactPerson" )
    private String contactPerson;
    /**
     * Use with available fluent helpers to apply the <b>ContactPerson</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmPartnerField<String> CONTACT_PERSON =
        new SlsOrdWthoutChrgItmPartnerField<String>("ContactPerson");
    /**
     * Navigation property <b>to_Item</b> for <b>SlsOrdWthoutChrgItmPartner</b> to single
     * <b>SalesOrderWithoutChargeItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderWithoutChargeItem toItem;
    /**
     * Navigation property <b>to_SalesOrderWithoutCharge</b> for <b>SlsOrdWthoutChrgItmPartner</b> to single
     * <b>SalesOrderWithoutCharge</b>.
     *
     */
    @SerializedName( "to_SalesOrderWithoutCharge" )
    @JsonProperty( "to_SalesOrderWithoutCharge" )
    @ODataField( odataName = "to_SalesOrderWithoutCharge" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderWithoutCharge toSalesOrderWithoutCharge;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmPartnerOneToOneLink<SalesOrderWithoutChargeItem> TO_ITEM =
        new SlsOrdWthoutChrgItmPartnerOneToOneLink<SalesOrderWithoutChargeItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrderWithoutCharge</b> navigation property to query
     * operations.
     *
     */
    public final static SlsOrdWthoutChrgItmPartnerOneToOneLink<SalesOrderWithoutCharge> TO_SALES_ORDER_WITHOUT_CHARGE =
        new SlsOrdWthoutChrgItmPartnerOneToOneLink<SalesOrderWithoutCharge>("to_SalesOrderWithoutCharge");

    @Nonnull
    @Override
    public Class<SlsOrdWthoutChrgItmPartner> getType()
    {
        return SlsOrdWthoutChrgItmPartner.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
     * </p>
     *
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     */
    public void setSalesOrderWithoutCharge( @Nullable final String salesOrderWithoutCharge )
    {
        rememberChangedField("SalesOrderWithoutCharge", this.salesOrderWithoutCharge);
        this.salesOrderWithoutCharge = salesOrderWithoutCharge;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeItem</b>
     * </p>
     *
     * @param salesOrderWithoutChargeItem
     *            Sales Order Without Charge Item
     */
    public void setSalesOrderWithoutChargeItem( @Nullable final String salesOrderWithoutChargeItem )
    {
        rememberChangedField("SalesOrderWithoutChargeItem", this.salesOrderWithoutChargeItem);
        this.salesOrderWithoutChargeItem = salesOrderWithoutChargeItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PartnerFunction</b>
     * </p>
     *
     * @param partnerFunction
     *            Partner Function
     */
    public void setPartnerFunction( @Nullable final String partnerFunction )
    {
        rememberChangedField("PartnerFunction", this.partnerFunction);
        this.partnerFunction = partnerFunction;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Customer Number
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>Personnel</b>
     * </p>
     *
     * @param personnel
     *            Personnel Number
     */
    public void setPersonnel( @Nullable final String personnel )
    {
        rememberChangedField("Personnel", this.personnel);
        this.personnel = personnel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ContactPerson</b>
     * </p>
     *
     * @param contactPerson
     *            Number of Contact Person
     */
    public void setContactPerson( @Nullable final String contactPerson )
    {
        rememberChangedField("ContactPerson", this.contactPerson);
        this.contactPerson = contactPerson;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsOrdWthoutChrgItmPartner";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrderWithoutCharge", getSalesOrderWithoutCharge());
        result.put("SalesOrderWithoutChargeItem", getSalesOrderWithoutChargeItem());
        result.put("PartnerFunction", getPartnerFunction());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrderWithoutCharge", getSalesOrderWithoutCharge());
        values.put("SalesOrderWithoutChargeItem", getSalesOrderWithoutChargeItem());
        values.put("PartnerFunction", getPartnerFunction());
        values.put("Customer", getCustomer());
        values.put("Supplier", getSupplier());
        values.put("Personnel", getPersonnel());
        values.put("ContactPerson", getContactPerson());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrderWithoutCharge") ) {
                final Object value = values.remove("SalesOrderWithoutCharge");
                if( (value == null) || (!value.equals(getSalesOrderWithoutCharge())) ) {
                    setSalesOrderWithoutCharge(((String) value));
                }
            }
            if( values.containsKey("SalesOrderWithoutChargeItem") ) {
                final Object value = values.remove("SalesOrderWithoutChargeItem");
                if( (value == null) || (!value.equals(getSalesOrderWithoutChargeItem())) ) {
                    setSalesOrderWithoutChargeItem(((String) value));
                }
            }
            if( values.containsKey("PartnerFunction") ) {
                final Object value = values.remove("PartnerFunction");
                if( (value == null) || (!value.equals(getPartnerFunction())) ) {
                    setPartnerFunction(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Personnel") ) {
                final Object value = values.remove("Personnel");
                if( (value == null) || (!value.equals(getPersonnel())) ) {
                    setPersonnel(((String) value));
                }
            }
            if( values.containsKey("ContactPerson") ) {
                final Object value = values.remove("ContactPerson");
                if( (value == null) || (!value.equals(getContactPerson())) ) {
                    setContactPerson(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Map ) {
                    if( toItem == null ) {
                        toItem = new SalesOrderWithoutChargeItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesOrderWithoutCharge") ) {
                final Object value = (values).remove("to_SalesOrderWithoutCharge");
                if( value instanceof Map ) {
                    if( toSalesOrderWithoutCharge == null ) {
                        toSalesOrderWithoutCharge = new SalesOrderWithoutCharge();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrderWithoutCharge.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SlsOrdWthoutChrgItmPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SlsOrdWthoutChrgItmPartnerField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsOrdWthoutChrgItmPartnerField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsOrdWthoutChrgItmPartnerField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toSalesOrderWithoutCharge != null ) {
            (values).put("to_SalesOrderWithoutCharge", toSalesOrderWithoutCharge);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderWithoutChargeItem</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderWithoutChargeItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutChargeItem fetchItem()
    {
        return fetchFieldAsSingle("to_Item", SalesOrderWithoutChargeItem.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutChargeItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SlsOrdWthoutChrgItmPartner</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderWithoutChargeItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutChargeItem getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutChargeItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>SlsOrdWthoutChrgItmPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>SalesOrderWithoutChargeItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderWithoutChargeItem> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the associated <b>SalesOrderWithoutChargeItem</b> entity for the loaded navigation property
     * <b>to_Item</b>.
     *
     * @param value
     *            New <b>SalesOrderWithoutChargeItem</b> entity.
     */
    public void setItem( final SalesOrderWithoutChargeItem value )
    {
        toItem = value;
    }

    /**
     * Fetches the <b>SalesOrderWithoutCharge</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderWithoutCharge</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutCharge fetchSalesOrderWithoutCharge()
    {
        return fetchFieldAsSingle("to_SalesOrderWithoutCharge", SalesOrderWithoutCharge.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutCharge</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * If the navigation property <b>to_SalesOrderWithoutCharge</b> of a queried <b>SlsOrdWthoutChrgItmPartner</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderWithoutCharge</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutCharge getSalesOrderWithoutChargeOrFetch()
    {
        if( toSalesOrderWithoutCharge == null ) {
            toSalesOrderWithoutCharge = fetchSalesOrderWithoutCharge();
        }
        return toSalesOrderWithoutCharge;
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutCharge</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * If the navigation property for an entity <b>SlsOrdWthoutChrgItmPartner</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrderWithoutCharge</b> is already loaded, the
     *         result will contain the <b>SalesOrderWithoutCharge</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderWithoutCharge> getSalesOrderWithoutChargeIfPresent()
    {
        return Option.of(toSalesOrderWithoutCharge);
    }

    /**
     * Overwrites the associated <b>SalesOrderWithoutCharge</b> entity for the loaded navigation property
     * <b>to_SalesOrderWithoutCharge</b>.
     *
     * @param value
     *            New <b>SalesOrderWithoutCharge</b> entity.
     */
    public void setSalesOrderWithoutCharge( final SalesOrderWithoutCharge value )
    {
        toSalesOrderWithoutCharge = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsOrdWthoutChrgItmPartner instances.
     *
     */
    public final static class SlsOrdWthoutChrgItmPartnerBuilder
    {

        private SalesOrderWithoutChargeItem toItem;
        private SalesOrderWithoutCharge toSalesOrderWithoutCharge;
        private String salesOrderWithoutCharge = null;

        private SlsOrdWthoutChrgItmPartner.SlsOrdWthoutChrgItmPartnerBuilder toItem(
            final SalesOrderWithoutChargeItem value )
        {
            toItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>SlsOrdWthoutChrgItmPartner</b> to single
         * <b>SalesOrderWithoutChargeItem</b>.
         *
         * @param value
         *            The SalesOrderWithoutChargeItem to build this SlsOrdWthoutChrgItmPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdWthoutChrgItmPartner.SlsOrdWthoutChrgItmPartnerBuilder item(
            final SalesOrderWithoutChargeItem value )
        {
            return toItem(value);
        }

        private SlsOrdWthoutChrgItmPartner.SlsOrdWthoutChrgItmPartnerBuilder toSalesOrderWithoutCharge(
            final SalesOrderWithoutCharge value )
        {
            toSalesOrderWithoutCharge = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrderWithoutCharge</b> for <b>SlsOrdWthoutChrgItmPartner</b> to single
         * <b>SalesOrderWithoutCharge</b>.
         *
         * @param value
         *            The SalesOrderWithoutCharge to build this SlsOrdWthoutChrgItmPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdWthoutChrgItmPartner.SlsOrdWthoutChrgItmPartnerBuilder salesOrderWithoutCharge(
            final SalesOrderWithoutCharge value )
        {
            return toSalesOrderWithoutCharge(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
         * </p>
         *
         * @param value
         *            The salesOrderWithoutCharge to build this SlsOrdWthoutChrgItmPartner with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdWthoutChrgItmPartner.SlsOrdWthoutChrgItmPartnerBuilder salesOrderWithoutCharge(
            final String value )
        {
            salesOrderWithoutCharge = value;
            return this;
        }

    }

}
