/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.field.SlsOrdWthoutChrgItmTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.link.SlsOrdWthoutChrgItmTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable.SlsOrdWthoutChrgItmTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsOrdWthoutChrgItmTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsOrdWthoutChrgItmText extends VdmEntity<SlsOrdWthoutChrgItmText>
{

    /**
     * Selector for all available fields of SlsOrdWthoutChrgItmText.
     *
     */
    public final static SlsOrdWthoutChrgItmTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
     * </p>
     *
     * @return Sales Order Without Charge
     */
    @Key
    @SerializedName( "SalesOrderWithoutCharge" )
    @JsonProperty( "SalesOrderWithoutCharge" )
    @Nullable
    @ODataField( odataName = "SalesOrderWithoutCharge" )
    private String salesOrderWithoutCharge;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutCharge</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmTextField<String> SALES_ORDER_WITHOUT_CHARGE =
        new SlsOrdWthoutChrgItmTextField<String>("SalesOrderWithoutCharge");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeItem</b>
     * </p>
     *
     * @return Sales Order Without Charge Item
     */
    @Key
    @SerializedName( "SalesOrderWithoutChargeItem" )
    @JsonProperty( "SalesOrderWithoutChargeItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderWithoutChargeItem" )
    private String salesOrderWithoutChargeItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutChargeItem</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmTextField<String> SALES_ORDER_WITHOUT_CHARGE_ITEM =
        new SlsOrdWthoutChrgItmTextField<String>("SalesOrderWithoutChargeItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmTextField<String> LANGUAGE =
        new SlsOrdWthoutChrgItmTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @return Text ID
     */
    @Key
    @SerializedName( "LongTextID" )
    @JsonProperty( "LongTextID" )
    @Nullable
    @ODataField( odataName = "LongTextID" )
    private String longTextID;
    /**
     * Use with available fluent helpers to apply the <b>LongTextID</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmTextField<String> LONG_TEXT_ID =
        new SlsOrdWthoutChrgItmTextField<String>("LongTextID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @return String
     */
    @SerializedName( "LongText" )
    @JsonProperty( "LongText" )
    @Nullable
    @ODataField( odataName = "LongText" )
    private String longText;
    /**
     * Use with available fluent helpers to apply the <b>LongText</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgItmTextField<String> LONG_TEXT =
        new SlsOrdWthoutChrgItmTextField<String>("LongText");
    /**
     * Navigation property <b>to_SalesOrderWithoutCharge</b> for <b>SlsOrdWthoutChrgItmText</b> to single
     * <b>SalesOrderWithoutCharge</b>.
     *
     */
    @SerializedName( "to_SalesOrderWithoutCharge" )
    @JsonProperty( "to_SalesOrderWithoutCharge" )
    @ODataField( odataName = "to_SalesOrderWithoutCharge" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderWithoutCharge toSalesOrderWithoutCharge;
    /**
     * Navigation property <b>to_SalesOrderWithoutChargeItem</b> for <b>SlsOrdWthoutChrgItmText</b> to single
     * <b>SalesOrderWithoutChargeItem</b>.
     *
     */
    @SerializedName( "to_SalesOrderWithoutChargeItem" )
    @JsonProperty( "to_SalesOrderWithoutChargeItem" )
    @ODataField( odataName = "to_SalesOrderWithoutChargeItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderWithoutChargeItem toSalesOrderWithoutChargeItem;
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrderWithoutCharge</b> navigation property to query
     * operations.
     *
     */
    public final static SlsOrdWthoutChrgItmTextOneToOneLink<SalesOrderWithoutCharge> TO_SALES_ORDER_WITHOUT_CHARGE =
        new SlsOrdWthoutChrgItmTextOneToOneLink<SalesOrderWithoutCharge>("to_SalesOrderWithoutCharge");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrderWithoutChargeItem</b> navigation property to query
     * operations.
     *
     */
    public final static SlsOrdWthoutChrgItmTextOneToOneLink<SalesOrderWithoutChargeItem> TO_SALES_ORDER_WITHOUT_CHARGE_ITEM =
        new SlsOrdWthoutChrgItmTextOneToOneLink<SalesOrderWithoutChargeItem>("to_SalesOrderWithoutChargeItem");

    @Nonnull
    @Override
    public Class<SlsOrdWthoutChrgItmText> getType()
    {
        return SlsOrdWthoutChrgItmText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
     * </p>
     *
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     */
    public void setSalesOrderWithoutCharge( @Nullable final String salesOrderWithoutCharge )
    {
        rememberChangedField("SalesOrderWithoutCharge", this.salesOrderWithoutCharge);
        this.salesOrderWithoutCharge = salesOrderWithoutCharge;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeItem</b>
     * </p>
     *
     * @param salesOrderWithoutChargeItem
     *            Sales Order Without Charge Item
     */
    public void setSalesOrderWithoutChargeItem( @Nullable final String salesOrderWithoutChargeItem )
    {
        rememberChangedField("SalesOrderWithoutChargeItem", this.salesOrderWithoutChargeItem);
        this.salesOrderWithoutChargeItem = salesOrderWithoutChargeItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>LongTextID</b>
     * </p>
     *
     * @param longTextID
     *            Text ID
     */
    public void setLongTextID( @Nullable final String longTextID )
    {
        rememberChangedField("LongTextID", this.longTextID);
        this.longTextID = longTextID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>LongText</b>
     * </p>
     *
     * @param longText
     *            String
     */
    public void setLongText( @Nullable final String longText )
    {
        rememberChangedField("LongText", this.longText);
        this.longText = longText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsOrdWthoutChrgItmText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrderWithoutCharge", getSalesOrderWithoutCharge());
        result.put("SalesOrderWithoutChargeItem", getSalesOrderWithoutChargeItem());
        result.put("Language", getLanguage());
        result.put("LongTextID", getLongTextID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrderWithoutCharge", getSalesOrderWithoutCharge());
        values.put("SalesOrderWithoutChargeItem", getSalesOrderWithoutChargeItem());
        values.put("Language", getLanguage());
        values.put("LongTextID", getLongTextID());
        values.put("LongText", getLongText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrderWithoutCharge") ) {
                final Object value = values.remove("SalesOrderWithoutCharge");
                if( (value == null) || (!value.equals(getSalesOrderWithoutCharge())) ) {
                    setSalesOrderWithoutCharge(((String) value));
                }
            }
            if( values.containsKey("SalesOrderWithoutChargeItem") ) {
                final Object value = values.remove("SalesOrderWithoutChargeItem");
                if( (value == null) || (!value.equals(getSalesOrderWithoutChargeItem())) ) {
                    setSalesOrderWithoutChargeItem(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("LongTextID") ) {
                final Object value = values.remove("LongTextID");
                if( (value == null) || (!value.equals(getLongTextID())) ) {
                    setLongTextID(((String) value));
                }
            }
            if( values.containsKey("LongText") ) {
                final Object value = values.remove("LongText");
                if( (value == null) || (!value.equals(getLongText())) ) {
                    setLongText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SalesOrderWithoutCharge") ) {
                final Object value = (values).remove("to_SalesOrderWithoutCharge");
                if( value instanceof Map ) {
                    if( toSalesOrderWithoutCharge == null ) {
                        toSalesOrderWithoutCharge = new SalesOrderWithoutCharge();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrderWithoutCharge.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesOrderWithoutChargeItem") ) {
                final Object value = (values).remove("to_SalesOrderWithoutChargeItem");
                if( value instanceof Map ) {
                    if( toSalesOrderWithoutChargeItem == null ) {
                        toSalesOrderWithoutChargeItem = new SalesOrderWithoutChargeItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrderWithoutChargeItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SlsOrdWthoutChrgItmTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SlsOrdWthoutChrgItmTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsOrdWthoutChrgItmTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsOrdWthoutChrgItmTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSalesOrderWithoutCharge != null ) {
            (values).put("to_SalesOrderWithoutCharge", toSalesOrderWithoutCharge);
        }
        if( toSalesOrderWithoutChargeItem != null ) {
            (values).put("to_SalesOrderWithoutChargeItem", toSalesOrderWithoutChargeItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderWithoutCharge</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderWithoutCharge</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutCharge fetchSalesOrderWithoutCharge()
    {
        return fetchFieldAsSingle("to_SalesOrderWithoutCharge", SalesOrderWithoutCharge.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutCharge</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * If the navigation property <b>to_SalesOrderWithoutCharge</b> of a queried <b>SlsOrdWthoutChrgItmText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderWithoutCharge</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutCharge getSalesOrderWithoutChargeOrFetch()
    {
        if( toSalesOrderWithoutCharge == null ) {
            toSalesOrderWithoutCharge = fetchSalesOrderWithoutCharge();
        }
        return toSalesOrderWithoutCharge;
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutCharge</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * If the navigation property for an entity <b>SlsOrdWthoutChrgItmText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrderWithoutCharge</b> is already loaded, the
     *         result will contain the <b>SalesOrderWithoutCharge</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderWithoutCharge> getSalesOrderWithoutChargeIfPresent()
    {
        return Option.of(toSalesOrderWithoutCharge);
    }

    /**
     * Overwrites the associated <b>SalesOrderWithoutCharge</b> entity for the loaded navigation property
     * <b>to_SalesOrderWithoutCharge</b>.
     *
     * @param value
     *            New <b>SalesOrderWithoutCharge</b> entity.
     */
    public void setSalesOrderWithoutCharge( final SalesOrderWithoutCharge value )
    {
        toSalesOrderWithoutCharge = value;
    }

    /**
     * Fetches the <b>SalesOrderWithoutChargeItem</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_SalesOrderWithoutChargeItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderWithoutChargeItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutChargeItem fetchSalesOrderWithoutChargeItem()
    {
        return fetchFieldAsSingle("to_SalesOrderWithoutChargeItem", SalesOrderWithoutChargeItem.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutChargeItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderWithoutChargeItem</b>.
     * <p>
     * If the navigation property <b>to_SalesOrderWithoutChargeItem</b> of a queried <b>SlsOrdWthoutChrgItmText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderWithoutChargeItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutChargeItem getSalesOrderWithoutChargeItemOrFetch()
    {
        if( toSalesOrderWithoutChargeItem == null ) {
            toSalesOrderWithoutChargeItem = fetchSalesOrderWithoutChargeItem();
        }
        return toSalesOrderWithoutChargeItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutChargeItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderWithoutChargeItem</b>.
     * <p>
     * If the navigation property for an entity <b>SlsOrdWthoutChrgItmText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrderWithoutChargeItem</b> is already loaded, the
     *         result will contain the <b>SalesOrderWithoutChargeItem</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderWithoutChargeItem> getSalesOrderWithoutChargeItemIfPresent()
    {
        return Option.of(toSalesOrderWithoutChargeItem);
    }

    /**
     * Overwrites the associated <b>SalesOrderWithoutChargeItem</b> entity for the loaded navigation property
     * <b>to_SalesOrderWithoutChargeItem</b>.
     *
     * @param value
     *            New <b>SalesOrderWithoutChargeItem</b> entity.
     */
    public void setSalesOrderWithoutChargeItem( final SalesOrderWithoutChargeItem value )
    {
        toSalesOrderWithoutChargeItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsOrdWthoutChrgItmText instances.
     *
     */
    public final static class SlsOrdWthoutChrgItmTextBuilder
    {

        private SalesOrderWithoutCharge toSalesOrderWithoutCharge;
        private String salesOrderWithoutCharge = null;
        private SalesOrderWithoutChargeItem toSalesOrderWithoutChargeItem;
        private String salesOrderWithoutChargeItem = null;

        private SlsOrdWthoutChrgItmText.SlsOrdWthoutChrgItmTextBuilder toSalesOrderWithoutCharge(
            final SalesOrderWithoutCharge value )
        {
            toSalesOrderWithoutCharge = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrderWithoutCharge</b> for <b>SlsOrdWthoutChrgItmText</b> to single
         * <b>SalesOrderWithoutCharge</b>.
         *
         * @param value
         *            The SalesOrderWithoutCharge to build this SlsOrdWthoutChrgItmText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdWthoutChrgItmText.SlsOrdWthoutChrgItmTextBuilder salesOrderWithoutCharge(
            final SalesOrderWithoutCharge value )
        {
            return toSalesOrderWithoutCharge(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
         * </p>
         *
         * @param value
         *            The salesOrderWithoutCharge to build this SlsOrdWthoutChrgItmText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdWthoutChrgItmText.SlsOrdWthoutChrgItmTextBuilder salesOrderWithoutCharge( final String value )
        {
            salesOrderWithoutCharge = value;
            return this;
        }

        private SlsOrdWthoutChrgItmText.SlsOrdWthoutChrgItmTextBuilder toSalesOrderWithoutChargeItem(
            final SalesOrderWithoutChargeItem value )
        {
            toSalesOrderWithoutChargeItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrderWithoutChargeItem</b> for <b>SlsOrdWthoutChrgItmText</b> to single
         * <b>SalesOrderWithoutChargeItem</b>.
         *
         * @param value
         *            The SalesOrderWithoutChargeItem to build this SlsOrdWthoutChrgItmText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdWthoutChrgItmText.SlsOrdWthoutChrgItmTextBuilder salesOrderWithoutChargeItem(
            final SalesOrderWithoutChargeItem value )
        {
            return toSalesOrderWithoutChargeItem(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 6
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeItem</b>
         * </p>
         *
         * @param value
         *            The salesOrderWithoutChargeItem to build this SlsOrdWthoutChrgItmText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdWthoutChrgItmText.SlsOrdWthoutChrgItmTextBuilder salesOrderWithoutChargeItem( final String value )
        {
            salesOrderWithoutChargeItem = value;
            return this;
        }

    }

}
