/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable.SlsOrdWthoutChrgPartnerSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
 * SlsOrdWthoutChrgPartner} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SlsOrdWthoutChrgPartnerByKeyFluentHelper
    extends
    FluentHelperByKey<SlsOrdWthoutChrgPartnerByKeyFluentHelper, SlsOrdWthoutChrgPartner, SlsOrdWthoutChrgPartnerSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     * SlsOrdWthoutChrgPartner} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SlsOrdWthoutChrgPartner}
     * @param partnerFunction
     *            Partner Function
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SlsOrdWthoutChrgPartner}
     * @param salesOrderWithoutCharge
     *            Sales Order Without Charge
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public SlsOrdWthoutChrgPartnerByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesOrderWithoutCharge,
        final String partnerFunction )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesOrderWithoutCharge", salesOrderWithoutCharge);
        this.key.put("PartnerFunction", partnerFunction);
    }

    @Override
    @Nonnull
    protected Class<SlsOrdWthoutChrgPartner> getEntityClass()
    {
        return SlsOrdWthoutChrgPartner.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
