/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge;

import java.math.BigDecimal;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.field.SlsOrdWthoutChrgSchedLineField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.link.SlsOrdWthoutChrgSchedLineOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable.SlsOrdWthoutChrgSchedLineSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Item Schedule Line
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SlsOrdWthoutChrgSchedLineType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SlsOrdWthoutChrgSchedLine extends VdmEntity<SlsOrdWthoutChrgSchedLine>
{

    /**
     * Selector for all available fields of SlsOrdWthoutChrgSchedLine.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
     * </p>
     *
     * @return Sales Document
     */
    @Key
    @SerializedName( "SalesOrderWithoutCharge" )
    @JsonProperty( "SalesOrderWithoutCharge" )
    @Nullable
    @ODataField( odataName = "SalesOrderWithoutCharge" )
    private String salesOrderWithoutCharge;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutCharge</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineField<String> SALES_ORDER_WITHOUT_CHARGE =
        new SlsOrdWthoutChrgSchedLineField<String>("SalesOrderWithoutCharge");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeItem</b>
     * </p>
     *
     * @return Sales Document Item
     */
    @Key
    @SerializedName( "SalesOrderWithoutChargeItem" )
    @JsonProperty( "SalesOrderWithoutChargeItem" )
    @Nullable
    @ODataField( odataName = "SalesOrderWithoutChargeItem" )
    private String salesOrderWithoutChargeItem;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrderWithoutChargeItem</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineField<String> SALES_ORDER_WITHOUT_CHARGE_ITEM =
        new SlsOrdWthoutChrgSchedLineField<String>("SalesOrderWithoutChargeItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @return Schedule Line Number
     */
    @Key
    @SerializedName( "ScheduleLine" )
    @JsonProperty( "ScheduleLine" )
    @Nullable
    @ODataField( odataName = "ScheduleLine" )
    private String scheduleLine;
    /**
     * Use with available fluent helpers to apply the <b>ScheduleLine</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineField<String> SCHEDULE_LINE =
        new SlsOrdWthoutChrgSchedLineField<String>("ScheduleLine");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @return Sales Unit
     */
    @SerializedName( "OrderQuantityUnit" )
    @JsonProperty( "OrderQuantityUnit" )
    @Nullable
    @ODataField( odataName = "OrderQuantityUnit" )
    private String orderQuantityUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrderQuantityUnit</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineField<String> ORDER_QUANTITY_UNIT =
        new SlsOrdWthoutChrgSchedLineField<String>("OrderQuantityUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdOrderQtyByMatlAvailCheck</b>
     * </p>
     *
     * @return Confirmed Quantity
     */
    @SerializedName( "ConfdOrderQtyByMatlAvailCheck" )
    @JsonProperty( "ConfdOrderQtyByMatlAvailCheck" )
    @Nullable
    @ODataField( odataName = "ConfdOrderQtyByMatlAvailCheck" )
    private BigDecimal confdOrderQtyByMatlAvailCheck;
    /**
     * Use with available fluent helpers to apply the <b>ConfdOrderQtyByMatlAvailCheck</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineField<BigDecimal> CONFD_ORDER_QTY_BY_MATL_AVAIL_CHECK =
        new SlsOrdWthoutChrgSchedLineField<BigDecimal>("ConfdOrderQtyByMatlAvailCheck");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveredQtyInOrderQtyUnit</b>
     * </p>
     *
     * @return Delivered Quantity
     */
    @SerializedName( "DeliveredQtyInOrderQtyUnit" )
    @JsonProperty( "DeliveredQtyInOrderQtyUnit" )
    @Nullable
    @ODataField( odataName = "DeliveredQtyInOrderQtyUnit" )
    private BigDecimal deliveredQtyInOrderQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>DeliveredQtyInOrderQtyUnit</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineField<BigDecimal> DELIVERED_QTY_IN_ORDER_QTY_UNIT =
        new SlsOrdWthoutChrgSchedLineField<BigDecimal>("DeliveredQtyInOrderQtyUnit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpenConfdDelivQtyInOrdQtyUnit</b>
     * </p>
     *
     * @return Open Confirmed Delivery Quantity
     */
    @SerializedName( "OpenConfdDelivQtyInOrdQtyUnit" )
    @JsonProperty( "OpenConfdDelivQtyInOrdQtyUnit" )
    @Nullable
    @ODataField( odataName = "OpenConfdDelivQtyInOrdQtyUnit" )
    private BigDecimal openConfdDelivQtyInOrdQtyUnit;
    /**
     * Use with available fluent helpers to apply the <b>OpenConfdDelivQtyInOrdQtyUnit</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineField<BigDecimal> OPEN_CONFD_DELIV_QTY_IN_ORD_QTY_UNIT =
        new SlsOrdWthoutChrgSchedLineField<BigDecimal>("OpenConfdDelivQtyInOrdQtyUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DelivBlockReasonForSchedLine</b>
     * </p>
     *
     * @return Schedule Line Blocked for Delivery
     */
    @SerializedName( "DelivBlockReasonForSchedLine" )
    @JsonProperty( "DelivBlockReasonForSchedLine" )
    @Nullable
    @ODataField( odataName = "DelivBlockReasonForSchedLine" )
    private String delivBlockReasonForSchedLine;
    /**
     * Use with available fluent helpers to apply the <b>DelivBlockReasonForSchedLine</b> field to query operations.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineField<String> DELIV_BLOCK_REASON_FOR_SCHED_LINE =
        new SlsOrdWthoutChrgSchedLineField<String>("DelivBlockReasonForSchedLine");
    /**
     * Navigation property <b>to_Item</b> for <b>SlsOrdWthoutChrgSchedLine</b> to single
     * <b>SalesOrderWithoutChargeItem</b>.
     *
     */
    @SerializedName( "to_Item" )
    @JsonProperty( "to_Item" )
    @ODataField( odataName = "to_Item" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderWithoutChargeItem toItem;
    /**
     * Navigation property <b>to_SalesOrderWithoutCharge</b> for <b>SlsOrdWthoutChrgSchedLine</b> to single
     * <b>SalesOrderWithoutCharge</b>.
     *
     */
    @SerializedName( "to_SalesOrderWithoutCharge" )
    @JsonProperty( "to_SalesOrderWithoutCharge" )
    @ODataField( odataName = "to_SalesOrderWithoutCharge" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrderWithoutCharge toSalesOrderWithoutCharge;
    /**
     * Use with available fluent helpers to apply the <b>to_Item</b> navigation property to query operations.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineOneToOneLink<SalesOrderWithoutChargeItem> TO_ITEM =
        new SlsOrdWthoutChrgSchedLineOneToOneLink<SalesOrderWithoutChargeItem>("to_Item");
    /**
     * Use with available fluent helpers to apply the <b>to_SalesOrderWithoutCharge</b> navigation property to query
     * operations.
     *
     */
    public final static SlsOrdWthoutChrgSchedLineOneToOneLink<SalesOrderWithoutCharge> TO_SALES_ORDER_WITHOUT_CHARGE =
        new SlsOrdWthoutChrgSchedLineOneToOneLink<SalesOrderWithoutCharge>("to_SalesOrderWithoutCharge");

    @Nonnull
    @Override
    public Class<SlsOrdWthoutChrgSchedLine> getType()
    {
        return SlsOrdWthoutChrgSchedLine.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
     * </p>
     *
     * @param salesOrderWithoutCharge
     *            Sales Document
     */
    public void setSalesOrderWithoutCharge( @Nullable final String salesOrderWithoutCharge )
    {
        rememberChangedField("SalesOrderWithoutCharge", this.salesOrderWithoutCharge);
        this.salesOrderWithoutCharge = salesOrderWithoutCharge;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrderWithoutChargeItem</b>
     * </p>
     *
     * @param salesOrderWithoutChargeItem
     *            Sales Document Item
     */
    public void setSalesOrderWithoutChargeItem( @Nullable final String salesOrderWithoutChargeItem )
    {
        rememberChangedField("SalesOrderWithoutChargeItem", this.salesOrderWithoutChargeItem);
        this.salesOrderWithoutChargeItem = salesOrderWithoutChargeItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ScheduleLine</b>
     * </p>
     *
     * @param scheduleLine
     *            Schedule Line Number
     */
    public void setScheduleLine( @Nullable final String scheduleLine )
    {
        rememberChangedField("ScheduleLine", this.scheduleLine);
        this.scheduleLine = scheduleLine;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>OrderQuantityUnit</b>
     * </p>
     *
     * @param orderQuantityUnit
     *            Sales Unit
     */
    public void setOrderQuantityUnit( @Nullable final String orderQuantityUnit )
    {
        rememberChangedField("OrderQuantityUnit", this.orderQuantityUnit);
        this.orderQuantityUnit = orderQuantityUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>ConfdOrderQtyByMatlAvailCheck</b>
     * </p>
     *
     * @param confdOrderQtyByMatlAvailCheck
     *            Confirmed Quantity
     */
    public void setConfdOrderQtyByMatlAvailCheck( @Nullable final BigDecimal confdOrderQtyByMatlAvailCheck )
    {
        rememberChangedField("ConfdOrderQtyByMatlAvailCheck", this.confdOrderQtyByMatlAvailCheck);
        this.confdOrderQtyByMatlAvailCheck = confdOrderQtyByMatlAvailCheck;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>DeliveredQtyInOrderQtyUnit</b>
     * </p>
     *
     * @param deliveredQtyInOrderQtyUnit
     *            Delivered Quantity
     */
    public void setDeliveredQtyInOrderQtyUnit( @Nullable final BigDecimal deliveredQtyInOrderQtyUnit )
    {
        rememberChangedField("DeliveredQtyInOrderQtyUnit", this.deliveredQtyInOrderQtyUnit);
        this.deliveredQtyInOrderQtyUnit = deliveredQtyInOrderQtyUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>OpenConfdDelivQtyInOrdQtyUnit</b>
     * </p>
     *
     * @param openConfdDelivQtyInOrdQtyUnit
     *            Open Confirmed Delivery Quantity
     */
    public void setOpenConfdDelivQtyInOrdQtyUnit( @Nullable final BigDecimal openConfdDelivQtyInOrdQtyUnit )
    {
        rememberChangedField("OpenConfdDelivQtyInOrdQtyUnit", this.openConfdDelivQtyInOrdQtyUnit);
        this.openConfdDelivQtyInOrdQtyUnit = openConfdDelivQtyInOrdQtyUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DelivBlockReasonForSchedLine</b>
     * </p>
     *
     * @param delivBlockReasonForSchedLine
     *            Schedule Line Blocked for Delivery
     */
    public void setDelivBlockReasonForSchedLine( @Nullable final String delivBlockReasonForSchedLine )
    {
        rememberChangedField("DelivBlockReasonForSchedLine", this.delivBlockReasonForSchedLine);
        this.delivBlockReasonForSchedLine = delivBlockReasonForSchedLine;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SlsOrdWthoutChrgSchedLine";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrderWithoutCharge", getSalesOrderWithoutCharge());
        result.put("SalesOrderWithoutChargeItem", getSalesOrderWithoutChargeItem());
        result.put("ScheduleLine", getScheduleLine());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrderWithoutCharge", getSalesOrderWithoutCharge());
        values.put("SalesOrderWithoutChargeItem", getSalesOrderWithoutChargeItem());
        values.put("ScheduleLine", getScheduleLine());
        values.put("OrderQuantityUnit", getOrderQuantityUnit());
        values.put("ConfdOrderQtyByMatlAvailCheck", getConfdOrderQtyByMatlAvailCheck());
        values.put("DeliveredQtyInOrderQtyUnit", getDeliveredQtyInOrderQtyUnit());
        values.put("OpenConfdDelivQtyInOrdQtyUnit", getOpenConfdDelivQtyInOrdQtyUnit());
        values.put("DelivBlockReasonForSchedLine", getDelivBlockReasonForSchedLine());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrderWithoutCharge") ) {
                final Object value = values.remove("SalesOrderWithoutCharge");
                if( (value == null) || (!value.equals(getSalesOrderWithoutCharge())) ) {
                    setSalesOrderWithoutCharge(((String) value));
                }
            }
            if( values.containsKey("SalesOrderWithoutChargeItem") ) {
                final Object value = values.remove("SalesOrderWithoutChargeItem");
                if( (value == null) || (!value.equals(getSalesOrderWithoutChargeItem())) ) {
                    setSalesOrderWithoutChargeItem(((String) value));
                }
            }
            if( values.containsKey("ScheduleLine") ) {
                final Object value = values.remove("ScheduleLine");
                if( (value == null) || (!value.equals(getScheduleLine())) ) {
                    setScheduleLine(((String) value));
                }
            }
            if( values.containsKey("OrderQuantityUnit") ) {
                final Object value = values.remove("OrderQuantityUnit");
                if( (value == null) || (!value.equals(getOrderQuantityUnit())) ) {
                    setOrderQuantityUnit(((String) value));
                }
            }
            if( values.containsKey("ConfdOrderQtyByMatlAvailCheck") ) {
                final Object value = values.remove("ConfdOrderQtyByMatlAvailCheck");
                if( (value == null) || (!value.equals(getConfdOrderQtyByMatlAvailCheck())) ) {
                    setConfdOrderQtyByMatlAvailCheck(((BigDecimal) value));
                }
            }
            if( values.containsKey("DeliveredQtyInOrderQtyUnit") ) {
                final Object value = values.remove("DeliveredQtyInOrderQtyUnit");
                if( (value == null) || (!value.equals(getDeliveredQtyInOrderQtyUnit())) ) {
                    setDeliveredQtyInOrderQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("OpenConfdDelivQtyInOrdQtyUnit") ) {
                final Object value = values.remove("OpenConfdDelivQtyInOrdQtyUnit");
                if( (value == null) || (!value.equals(getOpenConfdDelivQtyInOrdQtyUnit())) ) {
                    setOpenConfdDelivQtyInOrdQtyUnit(((BigDecimal) value));
                }
            }
            if( values.containsKey("DelivBlockReasonForSchedLine") ) {
                final Object value = values.remove("DelivBlockReasonForSchedLine");
                if( (value == null) || (!value.equals(getDelivBlockReasonForSchedLine())) ) {
                    setDelivBlockReasonForSchedLine(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Item") ) {
                final Object value = (values).remove("to_Item");
                if( value instanceof Map ) {
                    if( toItem == null ) {
                        toItem = new SalesOrderWithoutChargeItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toItem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_SalesOrderWithoutCharge") ) {
                final Object value = (values).remove("to_SalesOrderWithoutCharge");
                if( value instanceof Map ) {
                    if( toSalesOrderWithoutCharge == null ) {
                        toSalesOrderWithoutCharge = new SalesOrderWithoutCharge();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toSalesOrderWithoutCharge.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SlsOrdWthoutChrgSchedLineField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SlsOrdWthoutChrgSchedLineField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SlsOrdWthoutChrgSchedLineField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SlsOrdWthoutChrgSchedLineField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toItem != null ) {
            (values).put("to_Item", toItem);
        }
        if( toSalesOrderWithoutCharge != null ) {
            (values).put("to_SalesOrderWithoutCharge", toSalesOrderWithoutCharge);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrderWithoutChargeItem</b> entity (one to one) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Item</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderWithoutChargeItem</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutChargeItem fetchItem()
    {
        return fetchFieldAsSingle("to_Item", SalesOrderWithoutChargeItem.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutChargeItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property <b>to_Item</b> of a queried <b>SlsOrdWthoutChrgSchedLine</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderWithoutChargeItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutChargeItem getItemOrFetch()
    {
        if( toItem == null ) {
            toItem = fetchItem();
        }
        return toItem;
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutChargeItem</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_Item</b>.
     * <p>
     * If the navigation property for an entity <b>SlsOrdWthoutChrgSchedLine</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Item</b> is already loaded, the result will contain the
     *         <b>SalesOrderWithoutChargeItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderWithoutChargeItem> getItemIfPresent()
    {
        return Option.of(toItem);
    }

    /**
     * Overwrites the associated <b>SalesOrderWithoutChargeItem</b> entity for the loaded navigation property
     * <b>to_Item</b>.
     *
     * @param value
     *            New <b>SalesOrderWithoutChargeItem</b> entity.
     */
    public void setItem( final SalesOrderWithoutChargeItem value )
    {
        toItem = value;
    }

    /**
     * Fetches the <b>SalesOrderWithoutCharge</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrderWithoutCharge</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutCharge fetchSalesOrderWithoutCharge()
    {
        return fetchFieldAsSingle("to_SalesOrderWithoutCharge", SalesOrderWithoutCharge.class);
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutCharge</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * If the navigation property <b>to_SalesOrderWithoutCharge</b> of a queried <b>SlsOrdWthoutChrgSchedLine</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrderWithoutCharge</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrderWithoutCharge getSalesOrderWithoutChargeOrFetch()
    {
        if( toSalesOrderWithoutCharge == null ) {
            toSalesOrderWithoutCharge = fetchSalesOrderWithoutCharge();
        }
        return toSalesOrderWithoutCharge;
    }

    /**
     * Retrieval of associated <b>SalesOrderWithoutCharge</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_SalesOrderWithoutCharge</b>.
     * <p>
     * If the navigation property for an entity <b>SlsOrdWthoutChrgSchedLine</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SalesOrderWithoutCharge</b> is already loaded, the
     *         result will contain the <b>SalesOrderWithoutCharge</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrderWithoutCharge> getSalesOrderWithoutChargeIfPresent()
    {
        return Option.of(toSalesOrderWithoutCharge);
    }

    /**
     * Overwrites the associated <b>SalesOrderWithoutCharge</b> entity for the loaded navigation property
     * <b>to_SalesOrderWithoutCharge</b>.
     *
     * @param value
     *            New <b>SalesOrderWithoutCharge</b> entity.
     */
    public void setSalesOrderWithoutCharge( final SalesOrderWithoutCharge value )
    {
        toSalesOrderWithoutCharge = value;
    }

    /**
     * Helper class to allow for fluent creation of SlsOrdWthoutChrgSchedLine instances.
     *
     */
    public final static class SlsOrdWthoutChrgSchedLineBuilder
    {

        private SalesOrderWithoutChargeItem toItem;
        private SalesOrderWithoutCharge toSalesOrderWithoutCharge;
        private String salesOrderWithoutCharge = null;

        private SlsOrdWthoutChrgSchedLine.SlsOrdWthoutChrgSchedLineBuilder toItem(
            final SalesOrderWithoutChargeItem value )
        {
            toItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_Item</b> for <b>SlsOrdWthoutChrgSchedLine</b> to single
         * <b>SalesOrderWithoutChargeItem</b>.
         *
         * @param value
         *            The SalesOrderWithoutChargeItem to build this SlsOrdWthoutChrgSchedLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdWthoutChrgSchedLine.SlsOrdWthoutChrgSchedLineBuilder item(
            final SalesOrderWithoutChargeItem value )
        {
            return toItem(value);
        }

        private SlsOrdWthoutChrgSchedLine.SlsOrdWthoutChrgSchedLineBuilder toSalesOrderWithoutCharge(
            final SalesOrderWithoutCharge value )
        {
            toSalesOrderWithoutCharge = value;
            return this;
        }

        /**
         * Navigation property <b>to_SalesOrderWithoutCharge</b> for <b>SlsOrdWthoutChrgSchedLine</b> to single
         * <b>SalesOrderWithoutCharge</b>.
         *
         * @param value
         *            The SalesOrderWithoutCharge to build this SlsOrdWthoutChrgSchedLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdWthoutChrgSchedLine.SlsOrdWthoutChrgSchedLineBuilder salesOrderWithoutCharge(
            final SalesOrderWithoutCharge value )
        {
            return toSalesOrderWithoutCharge(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>SalesOrderWithoutCharge</b>
         * </p>
         *
         * @param value
         *            The salesOrderWithoutCharge to build this SlsOrdWthoutChrgSchedLine with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SlsOrdWthoutChrgSchedLine.SlsOrdWthoutChrgSchedLineBuilder salesOrderWithoutCharge( final String value )
        {
            salesOrderWithoutCharge = value;
            return this;
        }

    }

}
