/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.selectable.SlsOrdWthoutChrgSchedLineSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLine
 * SlsOrdWthoutChrgSchedLine} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class SlsOrdWthoutChrgSchedLineByKeyFluentHelper
    extends
    FluentHelperByKey<SlsOrdWthoutChrgSchedLineByKeyFluentHelper, SlsOrdWthoutChrgSchedLine, SlsOrdWthoutChrgSchedLineSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgSchedLine
     * SlsOrdWthoutChrgSchedLine} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SlsOrdWthoutChrgSchedLine}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SlsOrdWthoutChrgSchedLine}
     * @param salesOrderWithoutChargeItem
     *            Sales Document Item
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     * @param scheduleLine
     *            Schedule Line Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param salesOrderWithoutCharge
     *            Sales Document
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public SlsOrdWthoutChrgSchedLineByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesOrderWithoutCharge,
        final String salesOrderWithoutChargeItem,
        final String scheduleLine )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesOrderWithoutCharge", salesOrderWithoutCharge);
        this.key.put("SalesOrderWithoutChargeItem", salesOrderWithoutChargeItem);
        this.key.put("ScheduleLine", scheduleLine);
    }

    @Override
    @Nonnull
    protected Class<SlsOrdWthoutChrgSchedLine> getEntityClass()
    {
        return SlsOrdWthoutChrgSchedLine.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
