/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link SalesOrderWithoutChargeServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService
 * SalesOrderWithoutChargeService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultSalesOrderWithoutChargeServiceBatch
    extends
    BatchFluentHelperBasic<SalesOrderWithoutChargeServiceBatch, SalesOrderWithoutChargeServiceBatchChangeSet>
    implements
    SalesOrderWithoutChargeServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultSalesOrderWithoutChargeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesOrderWithoutChargeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultSalesOrderWithoutChargeServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultSalesOrderWithoutChargeServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultSalesOrderWithoutChargeServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultSalesOrderWithoutChargeServiceBatchChangeSet(this, service);
    }

}
