/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText;

/**
 * Implementation of the {@link SalesOrderWithoutChargeServiceBatchChangeSet} interface, enabling you to combine
 * multiple operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService
 * SalesOrderWithoutChargeService}.
 *
 */
public class DefaultSalesOrderWithoutChargeServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<SalesOrderWithoutChargeServiceBatch, SalesOrderWithoutChargeServiceBatchChangeSet>
    implements
    SalesOrderWithoutChargeServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService service;

    @SuppressWarnings( "deprecation" )
    DefaultSalesOrderWithoutChargeServiceBatchChangeSet(
        @Nonnull final DefaultSalesOrderWithoutChargeServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultSalesOrderWithoutChargeServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet createSalesOrderWithoutCharge(
        @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge )
    {
        return addRequestCreate(service::createSalesOrderWithoutCharge, salesOrderWithoutCharge);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet updateSalesOrderWithoutCharge(
        @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge )
    {
        return addRequestUpdate(service::updateSalesOrderWithoutCharge, salesOrderWithoutCharge);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet deleteSalesOrderWithoutCharge(
        @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge )
    {
        return addRequestDelete(service::deleteSalesOrderWithoutCharge, salesOrderWithoutCharge);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet createSalesOrderWithoutChargeItem(
        @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem )
    {
        return addRequestCreate(service::createSalesOrderWithoutChargeItem, salesOrderWithoutChargeItem);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet updateSalesOrderWithoutChargeItem(
        @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem )
    {
        return addRequestUpdate(service::updateSalesOrderWithoutChargeItem, salesOrderWithoutChargeItem);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet deleteSalesOrderWithoutChargeItem(
        @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem )
    {
        return addRequestDelete(service::deleteSalesOrderWithoutChargeItem, salesOrderWithoutChargeItem);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet updateSlsOrdWthoutChrgItmPartner(
        @Nonnull final SlsOrdWthoutChrgItmPartner slsOrdWthoutChrgItmPartner )
    {
        return addRequestUpdate(service::updateSlsOrdWthoutChrgItmPartner, slsOrdWthoutChrgItmPartner);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet deleteSlsOrdWthoutChrgItmPartner(
        @Nonnull final SlsOrdWthoutChrgItmPartner slsOrdWthoutChrgItmPartner )
    {
        return addRequestDelete(service::deleteSlsOrdWthoutChrgItmPartner, slsOrdWthoutChrgItmPartner);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet updateSlsOrdWthoutChrgItmText(
        @Nonnull final SlsOrdWthoutChrgItmText slsOrdWthoutChrgItmText )
    {
        return addRequestUpdate(service::updateSlsOrdWthoutChrgItmText, slsOrdWthoutChrgItmText);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet deleteSlsOrdWthoutChrgItmText(
        @Nonnull final SlsOrdWthoutChrgItmText slsOrdWthoutChrgItmText )
    {
        return addRequestDelete(service::deleteSlsOrdWthoutChrgItmText, slsOrdWthoutChrgItmText);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet updateSlsOrdWthoutChrgPartner(
        @Nonnull final SlsOrdWthoutChrgPartner slsOrdWthoutChrgPartner )
    {
        return addRequestUpdate(service::updateSlsOrdWthoutChrgPartner, slsOrdWthoutChrgPartner);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet deleteSlsOrdWthoutChrgPartner(
        @Nonnull final SlsOrdWthoutChrgPartner slsOrdWthoutChrgPartner )
    {
        return addRequestDelete(service::deleteSlsOrdWthoutChrgPartner, slsOrdWthoutChrgPartner);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet updateSlsOrdWthoutChrgText(
        @Nonnull final SlsOrdWthoutChrgText slsOrdWthoutChrgText )
    {
        return addRequestUpdate(service::updateSlsOrdWthoutChrgText, slsOrdWthoutChrgText);
    }

    @Nonnull
    @Override
    public SalesOrderWithoutChargeServiceBatchChangeSet deleteSlsOrdWthoutChrgText(
        @Nonnull final SlsOrdWthoutChrgText slsOrdWthoutChrgText )
    {
        return addRequestDelete(service::deleteSlsOrdWthoutChrgText, slsOrdWthoutChrgText);
    }

}
