/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.SalesOrderWithoutChargeService
 * SalesOrderWithoutChargeService}.
 *
 */
public interface SalesOrderWithoutChargeServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<SalesOrderWithoutChargeServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<SalesOrderWithoutChargeServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     * SalesOrderWithoutCharge} entity and save it to the S/4HANA system.
     *
     * @param salesOrderWithoutCharge
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *            SalesOrderWithoutCharge} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        createSalesOrderWithoutCharge( @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     * SalesOrderWithoutCharge} entity and save it to the S/4HANA system.
     *
     * @param salesOrderWithoutCharge
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *            SalesOrderWithoutCharge} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        updateSalesOrderWithoutCharge( @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     * SalesOrderWithoutCharge} entity in the S/4HANA system.
     *
     * @param salesOrderWithoutCharge
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutCharge
     *            SalesOrderWithoutCharge} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        deleteSalesOrderWithoutCharge( @Nonnull final SalesOrderWithoutCharge salesOrderWithoutCharge );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     * SalesOrderWithoutChargeItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderWithoutChargeItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *            SalesOrderWithoutChargeItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        createSalesOrderWithoutChargeItem( @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     * SalesOrderWithoutChargeItem} entity and save it to the S/4HANA system.
     *
     * @param salesOrderWithoutChargeItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *            SalesOrderWithoutChargeItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        updateSalesOrderWithoutChargeItem( @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     * SalesOrderWithoutChargeItem} entity in the S/4HANA system.
     *
     * @param salesOrderWithoutChargeItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SalesOrderWithoutChargeItem
     *            SalesOrderWithoutChargeItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        deleteSalesOrderWithoutChargeItem( @Nonnull final SalesOrderWithoutChargeItem salesOrderWithoutChargeItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     * SlsOrdWthoutChrgItmPartner} entity and save it to the S/4HANA system.
     *
     * @param slsOrdWthoutChrgItmPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     *            SlsOrdWthoutChrgItmPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        updateSlsOrdWthoutChrgItmPartner( @Nonnull final SlsOrdWthoutChrgItmPartner slsOrdWthoutChrgItmPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     * SlsOrdWthoutChrgItmPartner} entity in the S/4HANA system.
     *
     * @param slsOrdWthoutChrgItmPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmPartner
     *            SlsOrdWthoutChrgItmPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        deleteSlsOrdWthoutChrgItmPartner( @Nonnull final SlsOrdWthoutChrgItmPartner slsOrdWthoutChrgItmPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     * SlsOrdWthoutChrgItmText} entity and save it to the S/4HANA system.
     *
     * @param slsOrdWthoutChrgItmText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     *            SlsOrdWthoutChrgItmText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        updateSlsOrdWthoutChrgItmText( @Nonnull final SlsOrdWthoutChrgItmText slsOrdWthoutChrgItmText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     * SlsOrdWthoutChrgItmText} entity in the S/4HANA system.
     *
     * @param slsOrdWthoutChrgItmText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgItmText
     *            SlsOrdWthoutChrgItmText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        deleteSlsOrdWthoutChrgItmText( @Nonnull final SlsOrdWthoutChrgItmText slsOrdWthoutChrgItmText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     * SlsOrdWthoutChrgPartner} entity and save it to the S/4HANA system.
     *
     * @param slsOrdWthoutChrgPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     *            SlsOrdWthoutChrgPartner} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        updateSlsOrdWthoutChrgPartner( @Nonnull final SlsOrdWthoutChrgPartner slsOrdWthoutChrgPartner );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     * SlsOrdWthoutChrgPartner} entity in the S/4HANA system.
     *
     * @param slsOrdWthoutChrgPartner
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgPartner
     *            SlsOrdWthoutChrgPartner} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        deleteSlsOrdWthoutChrgPartner( @Nonnull final SlsOrdWthoutChrgPartner slsOrdWthoutChrgPartner );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     * SlsOrdWthoutChrgText} entity and save it to the S/4HANA system.
     *
     * @param slsOrdWthoutChrgText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     *            SlsOrdWthoutChrgText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        updateSlsOrdWthoutChrgText( @Nonnull final SlsOrdWthoutChrgText slsOrdWthoutChrgText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     * SlsOrdWthoutChrgText} entity in the S/4HANA system.
     *
     * @param slsOrdWthoutChrgText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.salesorderwithoutcharge.SlsOrdWthoutChrgText
     *            SlsOrdWthoutChrgText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    SalesOrderWithoutChargeServiceBatchChangeSet
        deleteSlsOrdWthoutChrgText( @Nonnull final SlsOrdWthoutChrgText slsOrdWthoutChrgText );

}
